/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.metrics;

import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import wvlet.airframe.metrics.ElapsedTime;
import wvlet.airframe.metrics.ElapsedTime$;
import wvlet.airframe.surface.SurfaceFactory$;
import wvlet.airframe.surface.Zero$;

public final class ElapsedTime$
implements Serializable {
    public static ElapsedTime$ MODULE$;
    private final Pattern PATTERN;

    static {
        new ElapsedTime$();
    }

    public List<TimeUnit> units() {
        return new .colon.colon((Object)TimeUnit.NANOSECONDS, (List)new .colon.colon((Object)TimeUnit.MICROSECONDS, (List)new .colon.colon((Object)TimeUnit.MILLISECONDS, (List)new .colon.colon((Object)TimeUnit.SECONDS, (List)new .colon.colon((Object)TimeUnit.MINUTES, (List)new .colon.colon((Object)TimeUnit.HOURS, (List)new .colon.colon((Object)TimeUnit.DAYS, (List)Nil$.MODULE$)))))));
    }

    private Pattern PATTERN() {
        return this.PATTERN;
    }

    public ElapsedTime nanosSince(long start) {
        return this.succinctNanos(System.nanoTime() - start);
    }

    public ElapsedTime succinctNanos(long nanos) {
        return this.succinctDuration(nanos, TimeUnit.NANOSECONDS);
    }

    public ElapsedTime succinctDuration(double value, TimeUnit unit) {
        return new ElapsedTime(value, unit).convertToMostSuccinctTimeUnit();
    }

    public ElapsedTime succinctMillis(long milliSeconds) {
        return new ElapsedTime(milliSeconds, TimeUnit.MILLISECONDS).convertToMostSuccinctTimeUnit();
    }

    public ElapsedTime apply(String elapsedTimeStr) {
        return this.parse(elapsedTimeStr);
    }

    public ElapsedTime parse(String s) {
        Matcher m = this.PATTERN().matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException(new StringBuilder(31).append(s).append(" is not a valid duration string").toString());
        }
        double value = new StringOps(Predef$.MODULE$.augmentString(m.group(1))).toDouble();
        String unitString = m.group(2);
        return new ElapsedTime(value, this.valueOfTimeUnit(unitString));
    }

    public double millisPerTimeUnit(TimeUnit timeUnit) {
        TimeUnit timeUnit2 = timeUnit;
        if (((Object)((Object)TimeUnit.NANOSECONDS)).equals((Object)timeUnit2)) {
            return 1.0E-6;
        }
        if (((Object)((Object)TimeUnit.MICROSECONDS)).equals((Object)timeUnit2)) {
            return 0.001;
        }
        if (((Object)((Object)TimeUnit.MILLISECONDS)).equals((Object)timeUnit2)) {
            return 1.0;
        }
        if (((Object)((Object)TimeUnit.SECONDS)).equals((Object)timeUnit2)) {
            return 1000.0;
        }
        if (((Object)((Object)TimeUnit.MINUTES)).equals((Object)timeUnit2)) {
            return 60000.0;
        }
        if (((Object)((Object)TimeUnit.HOURS)).equals((Object)timeUnit2)) {
            return 3600000.0;
        }
        if (((Object)((Object)TimeUnit.DAYS)).equals((Object)timeUnit2)) {
            return 8.64E7;
        }
        throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported time unit ").append((Object)timeUnit).toString());
    }

    public String timeUnitToString(TimeUnit timeUnit) {
        TimeUnit timeUnit2 = timeUnit;
        if (((Object)((Object)TimeUnit.NANOSECONDS)).equals((Object)timeUnit2)) {
            return "ns";
        }
        if (((Object)((Object)TimeUnit.MICROSECONDS)).equals((Object)timeUnit2)) {
            return "us";
        }
        if (((Object)((Object)TimeUnit.MILLISECONDS)).equals((Object)timeUnit2)) {
            return "ms";
        }
        if (((Object)((Object)TimeUnit.SECONDS)).equals((Object)timeUnit2)) {
            return "s";
        }
        if (((Object)((Object)TimeUnit.MINUTES)).equals((Object)timeUnit2)) {
            return "m";
        }
        if (((Object)((Object)TimeUnit.HOURS)).equals((Object)timeUnit2)) {
            return "h";
        }
        if (((Object)((Object)TimeUnit.DAYS)).equals((Object)timeUnit2)) {
            return "d";
        }
        throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported time unit ").append((Object)timeUnit).toString());
    }

    public TimeUnit valueOfTimeUnit(String timeUnitString) {
        String string = timeUnitString;
        if ("ns".equals(string)) {
            return TimeUnit.NANOSECONDS;
        }
        if ("us".equals(string)) {
            return TimeUnit.MICROSECONDS;
        }
        if ("ms".equals(string)) {
            return TimeUnit.MILLISECONDS;
        }
        if ("s".equals(string)) {
            return TimeUnit.SECONDS;
        }
        if ("m".equals(string)) {
            return TimeUnit.MINUTES;
        }
        if ("h".equals(string)) {
            return TimeUnit.HOURS;
        }
        if ("d".equals(string)) {
            return TimeUnit.DAYS;
        }
        throw new IllegalArgumentException(new StringBuilder(19).append("Unknown time unit: ").append(timeUnitString).toString());
    }

    public ElapsedTime apply(double value, TimeUnit unit) {
        return new ElapsedTime(value, unit);
    }

    public Option<Tuple2<Object, TimeUnit>> unapply(ElapsedTime x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)x$0.value()), (Object)x$0.unit()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ElapsedTime$() {
        MODULE$ = this;
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Wvlet_airframe_metrics_ElapsedTime$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("wvlet.airframe.metrics.ElapsedTime").asType().toTypeConstructor();
            }

            public Wvlet_airframe_metrics_ElapsedTime$$typecreator1$1() {
            }
        }
        Zero$.MODULE$.register(SurfaceFactory$.MODULE$.of((TypeTags.WeakTypeTag)((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Wvlet_airframe_metrics_ElapsedTime$$typecreator1$1())), (Object)this.succinctMillis(0L));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Wvlet_airframe_metrics_ElapsedTime$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.util.concurrent.TimeUnit").asType().toTypeConstructor();
            }

            public Wvlet_airframe_metrics_ElapsedTime$$typecreator2$1() {
            }
        }
        Zero$.MODULE$.register(SurfaceFactory$.MODULE$.of((TypeTags.WeakTypeTag)((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Wvlet_airframe_metrics_ElapsedTime$$typecreator2$1())), (Object)TimeUnit.NANOSECONDS);
        this.PATTERN = Pattern.compile("^\\s*(\\d+(?:\\.\\d+)?)\\s*([a-zA-Z]+)\\s*$");
    }
}

