/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.msgpack.spi;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt;
import scala.runtime.RichLong$;
import scala.runtime.RichShort;
import wvlet.airframe.msgpack.spi.Code$;
import wvlet.airframe.msgpack.spi.ErrorCode$INVALID_EXT_FORMAT$;
import wvlet.airframe.msgpack.spi.ErrorCode$INVALID_TYPE$;
import wvlet.airframe.msgpack.spi.ErrorCode$NEVER_USED_FORMAT$;
import wvlet.airframe.msgpack.spi.ExtTypeHeader;
import wvlet.airframe.msgpack.spi.MessageException;
import wvlet.airframe.msgpack.spi.MessageException$;
import wvlet.airframe.msgpack.spi.MessageFormat;
import wvlet.airframe.msgpack.spi.MessageFormat$;
import wvlet.airframe.msgpack.spi.MessageFormat$ARRAY16$;
import wvlet.airframe.msgpack.spi.MessageFormat$ARRAY32$;
import wvlet.airframe.msgpack.spi.MessageFormat$BIN16$;
import wvlet.airframe.msgpack.spi.MessageFormat$BIN32$;
import wvlet.airframe.msgpack.spi.MessageFormat$BIN8$;
import wvlet.airframe.msgpack.spi.MessageFormat$BOOLEAN$;
import wvlet.airframe.msgpack.spi.MessageFormat$EXT16$;
import wvlet.airframe.msgpack.spi.MessageFormat$EXT32$;
import wvlet.airframe.msgpack.spi.MessageFormat$EXT8$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXARRAY$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXEXT1$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXEXT16$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXEXT2$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXEXT4$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXEXT8$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXMAP$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXSTR$;
import wvlet.airframe.msgpack.spi.MessageFormat$FLOAT32$;
import wvlet.airframe.msgpack.spi.MessageFormat$FLOAT64$;
import wvlet.airframe.msgpack.spi.MessageFormat$INT16$;
import wvlet.airframe.msgpack.spi.MessageFormat$INT32$;
import wvlet.airframe.msgpack.spi.MessageFormat$INT64$;
import wvlet.airframe.msgpack.spi.MessageFormat$INT8$;
import wvlet.airframe.msgpack.spi.MessageFormat$MAP16$;
import wvlet.airframe.msgpack.spi.MessageFormat$MAP32$;
import wvlet.airframe.msgpack.spi.MessageFormat$NEGFIXINT$;
import wvlet.airframe.msgpack.spi.MessageFormat$NEVER_USED$;
import wvlet.airframe.msgpack.spi.MessageFormat$NIL$;
import wvlet.airframe.msgpack.spi.MessageFormat$POSFIXINT$;
import wvlet.airframe.msgpack.spi.MessageFormat$STR16$;
import wvlet.airframe.msgpack.spi.MessageFormat$STR32$;
import wvlet.airframe.msgpack.spi.MessageFormat$STR8$;
import wvlet.airframe.msgpack.spi.MessageFormat$UINT16$;
import wvlet.airframe.msgpack.spi.MessageFormat$UINT32$;
import wvlet.airframe.msgpack.spi.MessageFormat$UINT64$;
import wvlet.airframe.msgpack.spi.MessageFormat$UINT8$;
import wvlet.airframe.msgpack.spi.ReadBuffer;
import wvlet.airframe.msgpack.spi.ReadCursor;
import wvlet.airframe.msgpack.spi.TooLargeMessageException;
import wvlet.airframe.msgpack.spi.Value;
import wvlet.airframe.msgpack.spi.Value$NilValue$;
import wvlet.airframe.msgpack.spi.ValueType;
import wvlet.airframe.msgpack.spi.ValueType$ARRAY$;
import wvlet.airframe.msgpack.spi.ValueType$BINARY$;
import wvlet.airframe.msgpack.spi.ValueType$BOOLEAN$;
import wvlet.airframe.msgpack.spi.ValueType$EXTENSION$;
import wvlet.airframe.msgpack.spi.ValueType$FLOAT$;
import wvlet.airframe.msgpack.spi.ValueType$INTEGER$;
import wvlet.airframe.msgpack.spi.ValueType$MAP$;
import wvlet.airframe.msgpack.spi.ValueType$NIL$;
import wvlet.airframe.msgpack.spi.ValueType$STRING$;
import wvlet.airframe.msgpack.spi.WriteBuffer;

public final class OffsetUnpacker$ {
    public static OffsetUnpacker$ MODULE$;
    private final String EMPTY_STRING;

    static {
        new OffsetUnpacker$();
    }

    public MessageFormat peekNextFormat(ReadCursor cursor) {
        byte b = cursor.peekByte();
        MessageFormat mf = MessageFormat$.MODULE$.of(b);
        return mf;
    }

    public void skipValue(ReadCursor cursor, int skipCount) {
        for (int count = skipCount; count > 0; --count) {
            byte b = cursor.readByte();
            MessageFormat mf = MessageFormat$.MODULE$.of(b);
            MessageFormat messageFormat = mf;
            if (MessageFormat$POSFIXINT$.MODULE$.equals(messageFormat) ? true : (MessageFormat$NEGFIXINT$.MODULE$.equals(messageFormat) ? true : (MessageFormat$BOOLEAN$.MODULE$.equals(messageFormat) ? true : MessageFormat$NIL$.MODULE$.equals(messageFormat)))) {
                continue;
            }
            if (MessageFormat$FIXMAP$.MODULE$.equals(messageFormat)) {
                int mapLen = b & 0xF;
                count += mapLen * 2;
                continue;
            }
            if (MessageFormat$FIXARRAY$.MODULE$.equals(messageFormat)) {
                int arrayLen = b & 0xF;
                count += arrayLen;
                continue;
            }
            if (MessageFormat$FIXSTR$.MODULE$.equals(messageFormat)) {
                int strLen = b & 0x1F;
                this.skipPayload(cursor, strLen);
                continue;
            }
            if (MessageFormat$INT8$.MODULE$.equals(messageFormat) ? true : MessageFormat$UINT8$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, 1);
                continue;
            }
            if (MessageFormat$INT16$.MODULE$.equals(messageFormat) ? true : MessageFormat$UINT16$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, 2);
                continue;
            }
            if (MessageFormat$INT32$.MODULE$.equals(messageFormat) ? true : (MessageFormat$UINT32$.MODULE$.equals(messageFormat) ? true : MessageFormat$FLOAT32$.MODULE$.equals(messageFormat))) {
                this.skipPayload(cursor, 4);
                continue;
            }
            if (MessageFormat$INT64$.MODULE$.equals(messageFormat) ? true : (MessageFormat$UINT64$.MODULE$.equals(messageFormat) ? true : MessageFormat$FLOAT64$.MODULE$.equals(messageFormat))) {
                this.skipPayload(cursor, 8);
                continue;
            }
            if (MessageFormat$BIN8$.MODULE$.equals(messageFormat) ? true : MessageFormat$STR8$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, this.readNextLength8(cursor));
                continue;
            }
            if (MessageFormat$BIN16$.MODULE$.equals(messageFormat) ? true : MessageFormat$STR16$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, this.readNextLength16(cursor));
                continue;
            }
            if (MessageFormat$BIN32$.MODULE$.equals(messageFormat) ? true : MessageFormat$STR32$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, this.readNextLength32(cursor));
                continue;
            }
            if (MessageFormat$FIXEXT1$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, 2);
                continue;
            }
            if (MessageFormat$FIXEXT2$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, 3);
                continue;
            }
            if (MessageFormat$FIXEXT4$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, 5);
                continue;
            }
            if (MessageFormat$FIXEXT8$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, 9);
                continue;
            }
            if (MessageFormat$FIXEXT16$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, 17);
                continue;
            }
            if (MessageFormat$EXT8$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, this.readNextLength8(cursor) + 1);
                continue;
            }
            if (MessageFormat$EXT16$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, this.readNextLength16(cursor) + 1);
                continue;
            }
            if (MessageFormat$EXT32$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, this.readNextLength32(cursor) + 1);
                continue;
            }
            if (MessageFormat$ARRAY16$.MODULE$.equals(messageFormat)) {
                count += this.readNextLength16(cursor);
                continue;
            }
            if (MessageFormat$ARRAY32$.MODULE$.equals(messageFormat)) {
                count += this.readNextLength32(cursor);
                continue;
            }
            if (MessageFormat$MAP16$.MODULE$.equals(messageFormat)) {
                count += this.readNextLength16(cursor) * 2;
                continue;
            }
            if (MessageFormat$MAP32$.MODULE$.equals(messageFormat)) {
                count += this.readNextLength32(cursor) * 2;
                continue;
            }
            if (MessageFormat$NEVER_USED$.MODULE$.equals(messageFormat)) {
                throw new MessageException(ErrorCode$NEVER_USED_FORMAT$.MODULE$, "Found 0xC1 (NEVER_USED) byte while skipping a value", MessageException$.MODULE$.$lessinit$greater$default$3());
            }
            throw new MatchError((Object)messageFormat);
        }
    }

    public int skipValue$default$2() {
        return 1;
    }

    public void skipPayload(ReadCursor cursor, int numBytes) {
        cursor.skipBytes(numBytes);
    }

    public Value unpackValue(ReadCursor cursor) {
        byte b = cursor.peekByte();
        MessageFormat mf = MessageFormat$.MODULE$.of(b);
        ValueType valueType = mf.valueType();
        if (ValueType$NIL$.MODULE$.equals(valueType)) {
            cursor.skipBytes(1);
            return Value$NilValue$.MODULE$;
        }
        if (ValueType$BOOLEAN$.MODULE$.equals(valueType)) {
            return new Value.BooleanValue(this.unpackBoolean(cursor));
        }
        if (ValueType$INTEGER$.MODULE$.equals(valueType)) {
            MessageFormat messageFormat = mf;
            if (MessageFormat$UINT64$.MODULE$.equals(messageFormat)) {
                return new Value.BigIntegerValue(this.unpackBigInteger(cursor));
            }
            return new Value.LongValue(this.unpackLong(cursor));
        }
        if (ValueType$FLOAT$.MODULE$.equals(valueType)) {
            return new Value.DoubleValue(this.unpackDouble(cursor));
        }
        if (ValueType$STRING$.MODULE$.equals(valueType)) {
            return new Value.StringValue(this.unpackString(cursor));
        }
        if (ValueType$BINARY$.MODULE$.equals(valueType)) {
            int binaryLength = this.unpackBinaryHeader(cursor);
            byte[] data = this.readPayload(cursor, binaryLength);
            return new Value.BinaryValue(data);
        }
        if (ValueType$EXTENSION$.MODULE$.equals(valueType)) {
            ExtTypeHeader extHeader = this.unpackExtTypeHeader(cursor);
            return this.unpackExt(extHeader, cursor);
        }
        if (ValueType$ARRAY$.MODULE$.equals(valueType)) {
            int arrayLength = this.unpackArrayHeader(cursor);
            Builder arr = package$.MODULE$.IndexedSeq().newBuilder();
            arr.sizeHint(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                arr.$plus$eq((Object)this.unpackValue(cursor));
            }
            return new Value.ArrayValue((IndexedSeq<Value>)((IndexedSeq)arr.result()));
        }
        if (ValueType$MAP$.MODULE$.equals(valueType)) {
            boolean readLen = false;
            int mapLength = this.unpackMapHeader(cursor);
            Builder map = ListMap$.MODULE$.newBuilder();
            map.sizeHint(mapLength);
            for (int i = 0; i < mapLength; ++i) {
                Value key = this.unpackValue(cursor);
                Value value = this.unpackValue(cursor);
                map.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
            }
            return new Value.MapValue((Map<Value, Value>)((Map)map.result()));
        }
        throw new MatchError((Object)valueType);
    }

    public Value unpackExt(ExtTypeHeader extHeader, ReadCursor cursor) {
        if (extHeader.extType() == Code$.MODULE$.EXT_TIMESTAMP()) {
            Instant instant = this.unpackTimestamp(extHeader, cursor);
            return new Value.TimestampValue(instant);
        }
        byte[] extData = this.readPayload(cursor, extHeader.byteLength());
        return new Value.ExtensionValue(extHeader.extType(), extData);
    }

    public void unpackNil(ReadCursor cursor) {
        byte by = cursor.readByte();
        if (Code$.MODULE$.NIL() == by) {
            return;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$NIL$.MODULE$, by);
    }

    public boolean tryUnpackNil(ReadCursor cursor) {
        byte by = cursor.readByte();
        if (Code$.MODULE$.NIL() == by) {
            return true;
        }
        cursor.reverseCursor();
        return false;
    }

    public boolean unpackBoolean(ReadCursor cursor) {
        byte by = cursor.readByte();
        if (Code$.MODULE$.FALSE() == by) {
            return false;
        }
        if (Code$.MODULE$.TRUE() == by) {
            return true;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$BOOLEAN$.MODULE$, by);
    }

    public byte unpackByte(ReadCursor cursor) {
        byte b = cursor.readByte();
        byte by = b;
        if (Code$.MODULE$.isFixInt(by)) {
            return by;
        }
        if (Code$.MODULE$.UINT8() == by) {
            byte u8 = cursor.readByte();
            if (u8 < 0) {
                throw MessageException$.MODULE$.overflowU8(u8);
            }
            return u8;
        }
        if (Code$.MODULE$.UINT16() == by) {
            short u16 = cursor.readShort();
            if (u16 < 0 || !new RichShort(Predef$.MODULE$.shortWrapper(u16)).isValidByte()) {
                throw MessageException$.MODULE$.overflowU16(u16);
            }
            return (byte)u16;
        }
        if (Code$.MODULE$.UINT32() == by) {
            int u32 = cursor.readInt();
            if (u32 < 0 || !new RichInt(Predef$.MODULE$.intWrapper(u32)).isValidByte()) {
                throw MessageException$.MODULE$.overflowU32(u32);
            }
            return (byte)u32;
        }
        if (Code$.MODULE$.UINT64() == by) {
            long u64 = cursor.readLong();
            if (u64 < 0L || !RichLong$.MODULE$.isValidByte$extension(Predef$.MODULE$.longWrapper(u64))) {
                throw MessageException$.MODULE$.overflowU64(u64);
            }
            return (byte)u64;
        }
        if (Code$.MODULE$.INT8() == by) {
            byte i8 = cursor.readByte();
            return i8;
        }
        if (Code$.MODULE$.INT16() == by) {
            short i16 = cursor.readShort();
            if (!new RichShort(Predef$.MODULE$.shortWrapper(i16)).isValidByte()) {
                throw MessageException$.MODULE$.overflowI16(i16);
            }
            return (byte)i16;
        }
        if (Code$.MODULE$.INT32() == by) {
            int i32 = cursor.readInt();
            if (!new RichInt(Predef$.MODULE$.intWrapper(i32)).isValidByte()) {
                throw MessageException$.MODULE$.overflowI32(i32);
            }
            return (byte)i32;
        }
        if (Code$.MODULE$.INT64() == by) {
            long i64 = cursor.readLong();
            if (!RichLong$.MODULE$.isValidByte$extension(Predef$.MODULE$.longWrapper(i64))) {
                throw MessageException$.MODULE$.overflowI64(i64);
            }
            return (byte)i64;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$INTEGER$.MODULE$, b);
    }

    public short unpackShort(ReadCursor cursor) {
        byte b = cursor.readByte();
        byte by = b;
        if (Code$.MODULE$.isFixInt(by)) {
            return by;
        }
        if (Code$.MODULE$.UINT8() == by) {
            byte u8 = cursor.readByte();
            return (short)(u8 & 0xFF);
        }
        if (Code$.MODULE$.UINT16() == by) {
            short u16 = cursor.readShort();
            if (u16 < 0) {
                throw MessageException$.MODULE$.overflowU16(u16);
            }
            return u16;
        }
        if (Code$.MODULE$.UINT32() == by) {
            int u32 = cursor.readInt();
            if (u32 < 0 || !new RichInt(Predef$.MODULE$.intWrapper(u32)).isValidShort()) {
                throw MessageException$.MODULE$.overflowU32(u32);
            }
            return (short)u32;
        }
        if (Code$.MODULE$.UINT64() == by) {
            long u64 = cursor.readLong();
            if (u64 < 0L || !RichLong$.MODULE$.isValidShort$extension(Predef$.MODULE$.longWrapper(u64))) {
                throw MessageException$.MODULE$.overflowU64(u64);
            }
            return (short)u64;
        }
        if (Code$.MODULE$.INT8() == by) {
            byte i8 = cursor.readByte();
            return i8;
        }
        if (Code$.MODULE$.INT16() == by) {
            short i16 = cursor.readShort();
            return i16;
        }
        if (Code$.MODULE$.INT32() == by) {
            int i32 = cursor.readInt();
            if (!new RichInt(Predef$.MODULE$.intWrapper(i32)).isValidShort()) {
                throw MessageException$.MODULE$.overflowI32(i32);
            }
            return (short)i32;
        }
        if (Code$.MODULE$.INT64() == by) {
            long i64 = cursor.readLong();
            if (!RichLong$.MODULE$.isValidShort$extension(Predef$.MODULE$.longWrapper(i64))) {
                throw MessageException$.MODULE$.overflowI64(i64);
            }
            return (short)i64;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$INTEGER$.MODULE$, b);
    }

    public int unpackInt(ReadCursor cursor) {
        byte b = cursor.readByte();
        byte by = b;
        if (Code$.MODULE$.isFixInt(by)) {
            return by;
        }
        if (Code$.MODULE$.UINT8() == by) {
            byte u8 = cursor.readByte();
            return u8 & 0xFF;
        }
        if (Code$.MODULE$.UINT16() == by) {
            short u16 = cursor.readShort();
            return u16 & 0xFFFF;
        }
        if (Code$.MODULE$.UINT32() == by) {
            int u32 = cursor.readInt();
            if (u32 < 0) {
                throw MessageException$.MODULE$.overflowU32(u32);
            }
            return u32;
        }
        if (Code$.MODULE$.UINT64() == by) {
            long u64 = cursor.readLong();
            if (u64 < 0L || !RichLong$.MODULE$.isValidInt$extension(Predef$.MODULE$.longWrapper(u64))) {
                throw MessageException$.MODULE$.overflowU64(u64);
            }
            return (int)u64;
        }
        if (Code$.MODULE$.INT8() == by) {
            byte i8 = cursor.readByte();
            return i8;
        }
        if (Code$.MODULE$.INT16() == by) {
            short i16 = cursor.readShort();
            return i16;
        }
        if (Code$.MODULE$.INT32() == by) {
            int i32 = cursor.readInt();
            return i32;
        }
        if (Code$.MODULE$.INT64() == by) {
            long i64 = cursor.readLong();
            if (!RichLong$.MODULE$.isValidInt$extension(Predef$.MODULE$.longWrapper(i64))) {
                throw MessageException$.MODULE$.overflowI64(i64);
            }
            return (int)i64;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$INTEGER$.MODULE$, b);
    }

    public long unpackLong(ReadCursor cursor) {
        byte b = cursor.readByte();
        byte by = b;
        if (Code$.MODULE$.isFixInt(by)) {
            return by;
        }
        if (Code$.MODULE$.UINT8() == by) {
            byte u8 = cursor.readByte();
            return u8 & 0xFF;
        }
        if (Code$.MODULE$.UINT16() == by) {
            short u16 = cursor.readShort();
            return u16 & 0xFFFF;
        }
        if (Code$.MODULE$.UINT32() == by) {
            int u32 = cursor.readInt();
            if (u32 < 0) {
                return (long)(u32 & Integer.MAX_VALUE) + 0x80000000L;
            }
            return u32;
        }
        if (Code$.MODULE$.UINT64() == by) {
            long u64 = cursor.readLong();
            if (u64 < 0L) {
                throw MessageException$.MODULE$.overflowU64(u64);
            }
            return u64;
        }
        if (Code$.MODULE$.INT8() == by) {
            byte i8 = cursor.readByte();
            return i8;
        }
        if (Code$.MODULE$.INT16() == by) {
            short i16 = cursor.readShort();
            return i16;
        }
        if (Code$.MODULE$.INT32() == by) {
            int i32 = cursor.readInt();
            return i32;
        }
        if (Code$.MODULE$.INT64() == by) {
            long i64 = cursor.readLong();
            return i64;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$INTEGER$.MODULE$, b);
    }

    public BigInteger unpackBigInteger(ReadCursor cursor) {
        byte b = cursor.readByte();
        byte by = b;
        if (Code$.MODULE$.isFixInt(by)) {
            return BigInteger.valueOf(by);
        }
        if (Code$.MODULE$.UINT8() == by) {
            byte u8 = cursor.readByte();
            return BigInteger.valueOf(u8 & 0xFF);
        }
        if (Code$.MODULE$.UINT16() == by) {
            short u16 = cursor.readShort();
            return BigInteger.valueOf(u16 & 0xFFFF);
        }
        if (Code$.MODULE$.UINT32() == by) {
            int u32 = cursor.readInt();
            if (u32 < 0) {
                return BigInteger.valueOf((long)(u32 & Integer.MAX_VALUE) + 0x80000000L);
            }
            return BigInteger.valueOf(u32);
        }
        if (Code$.MODULE$.UINT64() == by) {
            long u64 = cursor.readLong();
            if (u64 < 0L) {
                return BigInteger.valueOf(u64 + Long.MAX_VALUE + 1L).setBit(63);
            }
            return BigInteger.valueOf(u64);
        }
        if (Code$.MODULE$.INT8() == by) {
            byte i8 = cursor.readByte();
            return BigInteger.valueOf(i8);
        }
        if (Code$.MODULE$.INT16() == by) {
            short i16 = cursor.readShort();
            return BigInteger.valueOf(i16);
        }
        if (Code$.MODULE$.INT32() == by) {
            int i32 = cursor.readInt();
            return BigInteger.valueOf(i32);
        }
        if (Code$.MODULE$.INT64() == by) {
            long i64 = cursor.readLong();
            return BigInteger.valueOf(i64);
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$INTEGER$.MODULE$, b);
    }

    public float unpackFloat(ReadCursor cursor) {
        byte by = cursor.readByte();
        if (Code$.MODULE$.FLOAT32() == by) {
            float f = cursor.readFloat();
            return f;
        }
        if (Code$.MODULE$.FLOAT64() == by) {
            double d = cursor.readDouble();
            return (float)d;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$FLOAT$.MODULE$, by);
    }

    public double unpackDouble(ReadCursor cursor) {
        byte by = cursor.readByte();
        if (Code$.MODULE$.FLOAT32() == by) {
            float f = cursor.readFloat();
            return f;
        }
        if (Code$.MODULE$.FLOAT64() == by) {
            double d = cursor.readDouble();
            return d;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$FLOAT$.MODULE$, by);
    }

    private int readNextLength8(ReadCursor cursor) {
        byte u8 = cursor.readByte();
        return u8 & 0xFF;
    }

    private int readNextLength16(ReadCursor cursor) {
        short u16 = cursor.readShort();
        return u16 & 0xFFFF;
    }

    private int readNextLength32(ReadCursor cursor) {
        int u32 = cursor.readInt();
        if (u32 < 0) {
            cursor.reverseCursor();
            throw MessageException$.MODULE$.overflowU32Size(u32);
        }
        return u32;
    }

    private int tryReadStringHeader(byte b, ReadCursor cursor) {
        byte by = b;
        if (Code$.MODULE$.STR8() == by) {
            return this.readNextLength8(cursor);
        }
        if (Code$.MODULE$.STR16() == by) {
            return this.readNextLength16(cursor);
        }
        if (Code$.MODULE$.STR32() == by) {
            return this.readNextLength32(cursor);
        }
        return -1;
    }

    private int tryReadBinaryHeader(byte b, ReadCursor cursor) {
        byte by = b;
        if (Code$.MODULE$.BIN8() == by) {
            return this.readNextLength8(cursor);
        }
        if (Code$.MODULE$.BIN16() == by) {
            return this.readNextLength16(cursor);
        }
        if (Code$.MODULE$.BIN32() == by) {
            return this.readNextLength32(cursor);
        }
        return -1;
    }

    public int unpackRawStringHeader(ReadCursor cursor) {
        byte b = cursor.readByte();
        if (Code$.MODULE$.isFixedRaw(b)) {
            return b & 0x1F;
        }
        int slen = this.tryReadStringHeader(b, cursor);
        if (slen >= 0) {
            return slen;
        }
        int blen = this.tryReadBinaryHeader(b, cursor);
        if (blen >= 0) {
            return blen;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$STRING$.MODULE$, b);
    }

    public int unpackBinaryHeader(ReadCursor cursor) {
        byte b = cursor.readByte();
        if (Code$.MODULE$.isFixedRaw(b)) {
            return b & 0x1F;
        }
        int blen = this.tryReadBinaryHeader(b, cursor);
        if (blen >= 0) {
            return blen;
        }
        int slen = this.tryReadStringHeader(b, cursor);
        if (slen >= 0) {
            return slen;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$BINARY$.MODULE$, b);
    }

    public String unpackString(ReadCursor cursor) {
        int len = this.unpackRawStringHeader(cursor);
        int headerLen = cursor.lastReadLength();
        if (len == 0) {
            return this.EMPTY_STRING();
        }
        if (len >= Integer.MAX_VALUE) {
            cursor.reverseCursor();
            throw new TooLargeMessageException(len);
        }
        byte[] str = cursor.readBytes(len);
        return new String(str, 0, str.length, StandardCharsets.UTF_8);
    }

    public int unpackArrayHeader(ReadCursor cursor) {
        byte b = cursor.readByte();
        byte by = b;
        if (Code$.MODULE$.isFixedArray(by)) {
            return by & 0xF;
        }
        if (Code$.MODULE$.ARRAY16() == by) {
            int len = this.readNextLength16(cursor);
            return len;
        }
        if (Code$.MODULE$.ARRAY32() == by) {
            int len = this.readNextLength32(cursor);
            return len;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$ARRAY$.MODULE$, b);
    }

    public int unpackMapHeader(ReadCursor cursor) {
        byte b = cursor.readByte();
        byte by = b;
        if (Code$.MODULE$.isFixedMap(by)) {
            return by & 0xF;
        }
        if (Code$.MODULE$.MAP16() == by) {
            int len = this.readNextLength16(cursor);
            return len;
        }
        if (Code$.MODULE$.MAP32() == by) {
            int len = this.readNextLength32(cursor);
            return len;
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$MAP$.MODULE$, b);
    }

    public ExtTypeHeader unpackExtTypeHeader(ReadCursor cursor) {
        byte by = cursor.readByte();
        if (Code$.MODULE$.FIXEXT1() == by) {
            byte tpe = cursor.readByte();
            return new ExtTypeHeader(tpe, 1);
        }
        if (Code$.MODULE$.FIXEXT2() == by) {
            byte tpe = cursor.readByte();
            return new ExtTypeHeader(tpe, 2);
        }
        if (Code$.MODULE$.FIXEXT4() == by) {
            byte tpe = cursor.readByte();
            return new ExtTypeHeader(tpe, 4);
        }
        if (Code$.MODULE$.FIXEXT8() == by) {
            byte tpe = cursor.readByte();
            return new ExtTypeHeader(tpe, 8);
        }
        if (Code$.MODULE$.FIXEXT16() == by) {
            byte tpe = cursor.readByte();
            return new ExtTypeHeader(tpe, 16);
        }
        if (Code$.MODULE$.EXT8() == by) {
            byte u8 = cursor.readByte();
            int len = u8 & 0xFF;
            byte tpe = cursor.readByte();
            return new ExtTypeHeader(tpe, len);
        }
        if (Code$.MODULE$.EXT16() == by) {
            short u16 = cursor.readShort();
            int len = u16 & 0xFFFF;
            byte tpe = cursor.readByte();
            return new ExtTypeHeader(tpe, len);
        }
        if (Code$.MODULE$.EXT32() == by) {
            int u32 = cursor.readInt();
            if (u32 < 0) {
                cursor.reverseCursor();
                throw MessageException$.MODULE$.overflowU32Size(u32);
            }
            byte tpe = cursor.readByte();
            return new ExtTypeHeader(tpe, u32);
        }
        cursor.reverseCursor();
        throw this.unexpected(ValueType$EXTENSION$.MODULE$, by);
    }

    public Instant unpackTimestamp(ReadCursor cursor) {
        ExtTypeHeader extTypeHeader = this.unpackExtTypeHeader(cursor);
        Instant instant = this.unpackTimestamp(extTypeHeader, cursor);
        return instant;
    }

    public Instant unpackTimestamp(ExtTypeHeader extTypeHeader, ReadCursor cursor) {
        Instant instant;
        if (extTypeHeader.extType() != Code$.MODULE$.EXT_TIMESTAMP()) {
            cursor.reverseCursor();
            throw this.unexpected(ValueType$EXTENSION$.MODULE$, extTypeHeader.extType());
        }
        int n = extTypeHeader.byteLength();
        switch (n) {
            case 4: {
                long u32 = (long)cursor.readInt() & 0xFFFFFFFFL;
                instant = Instant.ofEpochSecond(u32);
                break;
            }
            case 8: {
                long d64 = cursor.readLong();
                long sec = d64 & 0x3FFFFFFFFL;
                int nsec = (int)(d64 >>> 34);
                instant = Instant.ofEpochSecond(sec, nsec);
                break;
            }
            case 12: {
                long nsecU32 = (long)cursor.readInt() & 0xFFFFFFFFL;
                long sec = cursor.readLong();
                instant = Instant.ofEpochSecond(sec, nsecU32);
                break;
            }
            default: {
                cursor.reverseCursor();
                throw new MessageException(ErrorCode$INVALID_EXT_FORMAT$.MODULE$, new StringBuilder(66).append("Timestamp type expects 4, 8, or 12 bytes of payload but got ").append(n).append(" bytes").toString(), MessageException$.MODULE$.$lessinit$greater$default$3());
            }
        }
        Instant instant2 = instant;
        return instant2;
    }

    public byte[] readPayload(ReadCursor cursor, int length) {
        byte[] data = cursor.readBytes(length);
        return data;
    }

    public void readPayload(ReadCursor cursor, int length, byte[] dest, int destOffset) {
        cursor.readBytes(length, dest, destOffset);
    }

    public ReadBuffer readPayload(ReadCursor cursor, int length, WriteBuffer dest, int destIndex) {
        cursor.readBytes(length, dest, destIndex);
        return dest.slice(destIndex, length);
    }

    private String EMPTY_STRING() {
        return this.EMPTY_STRING;
    }

    public Nothing$ unexpected(ValueType expectedCode, byte actual) {
        MessageFormat f;
        MessageFormat messageFormat = f = MessageFormat$.MODULE$.of(actual);
        MessageFormat$NEVER_USED$ messageFormat$NEVER_USED$ = MessageFormat$NEVER_USED$.MODULE$;
        if (!(messageFormat != null ? !messageFormat.equals(messageFormat$NEVER_USED$) : messageFormat$NEVER_USED$ != null)) {
            throw new MessageException(ErrorCode$NEVER_USED_FORMAT$.MODULE$, new StringBuilder(43).append("Expected ").append(expectedCode).append(", but found 0xC1 (NEVER_USED) byte").toString(), MessageException$.MODULE$.$lessinit$greater$default$3());
        }
        String name = f.valueType().name();
        String typeName = new StringBuilder(0).append(name.substring(0, 1)).append(name.substring(1).toLowerCase()).toString();
        ValueType arg$macro$1 = expectedCode;
        String arg$macro$2 = typeName;
        byte arg$macro$3 = actual;
        throw new MessageException(ErrorCode$INVALID_TYPE$.MODULE$, new StringOps("Expected %s, but got %s (%02x)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, BoxesRunTime.boxToByte((byte)arg$macro$3)})), MessageException$.MODULE$.$lessinit$greater$default$3());
    }

    private OffsetUnpacker$() {
        MODULE$ = this;
        this.EMPTY_STRING = "";
    }
}

