/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.ulid;

import java.nio.ByteBuffer;
import java.util.UUID;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.Random;
import scala.util.Random$;
import wvlet.airframe.ulid.CrockfordBase32$;
import wvlet.airframe.ulid.ULID;
import wvlet.airframe.ulid.compat$;

public final class ULID$ {
    public static ULID$ MODULE$;
    private final ULID MaxValue;
    private final long MinTime;
    private final long MaxTime;
    private ULID.ULIDGenerator _generator;

    static {
        new ULID$();
    }

    public ULID MaxValue() {
        return this.MaxValue;
    }

    public long MinTime() {
        return this.MinTime;
    }

    public long MaxTime() {
        return this.MaxTime;
    }

    private ULID.ULIDGenerator _generator() {
        return this._generator;
    }

    private void _generator_$eq(ULID.ULIDGenerator x$1) {
        this._generator = x$1;
    }

    public ULID.ULIDGenerator defaultULIDGenerator() {
        Random random = compat$.MODULE$.random();
        Function0 & java.io.Serializable & Serializable randGen = (Function0 & java.io.Serializable & Serializable)() -> {
            byte[] r = new byte[10];
            random.nextBytes(r);
            return r;
        };
        return new ULID.ULIDGenerator((Function0<byte[]>)randGen);
    }

    public ULID.ULIDGenerator nonSecureRandomULIDGenerator() {
        Function0 & java.io.Serializable & Serializable randGen = (Function0 & java.io.Serializable & Serializable)() -> {
            byte[] r = new byte[10];
            Random$.MODULE$.nextBytes(r);
            return r;
        };
        return new ULID.ULIDGenerator((Function0<byte[]>)randGen);
    }

    public void setDefaultULIDGenerator(ULID.ULIDGenerator newGenerator) {
        Predef$.MODULE$.require(newGenerator != null, (Function0 & java.io.Serializable & Serializable)() -> "ULIDGenerator is null");
        this._generator_$eq(newGenerator);
    }

    public void useNonSecureRandomULIDGenerator() {
        this.setDefaultULIDGenerator(this.nonSecureRandomULIDGenerator());
    }

    public void useDefaultULIDGenerator() {
        this.setDefaultULIDGenerator(this.defaultULIDGenerator());
    }

    public ULID newULID() {
        return this._generator().newULID();
    }

    public String newULIDString() {
        return this._generator().newULIDString();
    }

    public ULID ofMillis(long unixTimeMillis) {
        return this.apply(this._generator().newULIDFromMillis(unixTimeMillis));
    }

    public ULID apply(String ulidString) {
        return this.fromString(ulidString);
    }

    public ULID fromString(String ulid) {
        Predef$.MODULE$.require(ulid != null, (Function0 & java.io.Serializable & Serializable)() -> "The input ULID string was null");
        Predef$.MODULE$.require(ulid.length() == 26, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(41).append("ULID must have 26 characters: ").append(ulid).append(" (length: ").append(ulid.length()).append(")").toString());
        Predef$.MODULE$.require(CrockfordBase32$.MODULE$.isValidBase32(ulid), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(37).append("Invalid Base32 character is found in ").append(ulid).toString());
        return new ULID(ulid);
    }

    public ULID of(long unixTimeMillis, long randHi, long randLow) {
        if (unixTimeMillis < 0L || unixTimeMillis > this.MaxTime()) {
            long arg$macro$1 = this.MaxTime();
            long arg$macro$2 = unixTimeMillis;
            throw new IllegalArgumentException(new StringOps("unixtime must be between 0 to %,d: %,d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1), BoxesRunTime.boxToLong((long)arg$macro$2)})));
        }
        long hi = unixTimeMillis << 16 | randHi & 0xFFFFL;
        long low = randLow;
        return new ULID(CrockfordBase32$.MODULE$.encode128bits(hi, low));
    }

    public ULID fromBytes(byte[] bytes) {
        return this.fromBytes(bytes, 0);
    }

    public ULID fromBytes(byte[] bytes, int offset) {
        int i;
        Predef$.MODULE$.require(offset + 16 <= bytes.length, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(35).append("ULID needs 16 bytes. offset:").append(offset).append(", size:").append(bytes.length).toString());
        long hi = 0L;
        for (i = 0; i < 8; ++i) {
            hi <<= 8;
            hi |= (long)bytes[offset + i] & 0xFFL;
        }
        long low = 0L;
        while (i < 16) {
            low <<= 8;
            low |= (long)bytes[offset + i] & 0xFFL;
            ++i;
        }
        return new ULID(CrockfordBase32$.MODULE$.encode128bits(hi, low));
    }

    public ULID fromUUID(UUID uuid) {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        return this.fromBytes(buffer.array());
    }

    public Option<ULID> unapply(String ulidString) {
        if (this.isValid(ulidString)) {
            return new Some((Object)new ULID(ulidString));
        }
        return None$.MODULE$;
    }

    public boolean isValid(String ulid) {
        return ulid.length() == 26 && CrockfordBase32$.MODULE$.isValidBase32(ulid);
    }

    private ULID$() {
        MODULE$ = this;
        this.MaxValue = this.apply("7ZZZZZZZZZZZZZZZZZZZZZZZZZ");
        this.MinTime = 0L;
        this.MaxTime = (0L ^ 0xFFFFFFFFFFFFFFFFL) >>> 16;
        this._generator = this.defaultULIDGenerator();
    }
}

