/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log;

import java.io.File;
import java.io.FileReader;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.concurrent.Map;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import wvlet.log.ConsoleLogHandler;
import wvlet.log.LogFormatter;
import wvlet.log.LogFormatter$SourceCodeLogFormatter$;
import wvlet.log.LogLevel;
import wvlet.log.LogLevel$;
import wvlet.log.LogLevelScanner;
import wvlet.log.LogLevelScanner$;
import wvlet.log.LogLevelScannerConfig;
import wvlet.log.Logger;
import wvlet.log.io.IOUtil$;

public final class Logger$
implements Serializable {
    public static final Logger$ MODULE$;
    private Map<String, Logger> loggerCache;
    private Logger rootLogger;
    private final Seq<String> DEFAULT_LOGLEVEL_FILE_CANDIDATES;
    private LogLevelScanner logLevelScanner;
    private volatile byte bitmap$0;

    static {
        new Logger$();
    }

    private Map loggerCache$lzycompute() {
        Logger$ logger$ = this;
        synchronized (logger$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.loggerCache = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.loggerCache;
        }
    }

    private Logger rootLogger$lzycompute() {
        Logger$ logger$ = this;
        synchronized (logger$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String x$2 = "";
                Seq x$3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConsoleLogHandler[]{new ConsoleLogHandler(LogFormatter$SourceCodeLogFormatter$.MODULE$)}));
                Option<LogLevel> x$4 = this.initLogger$default$2();
                boolean x$5 = this.initLogger$default$4();
                this.rootLogger = this.initLogger(x$2, x$4, (Seq<Handler>)x$3, x$5);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.rootLogger;
        }
    }

    private LogLevelScanner logLevelScanner$lzycompute() {
        Logger$ logger$ = this;
        synchronized (logger$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.logLevelScanner = new LogLevelScanner();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.logLevelScanner;
        }
    }

    private Map<String, Logger> loggerCache() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.loggerCache$lzycompute() : this.loggerCache;
    }

    public Logger rootLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.rootLogger$lzycompute() : this.rootLogger;
    }

    public Logger initLogger(String name, Option<LogLevel> level, Seq<Handler> handlers, boolean useParents) {
        Logger logger = this.apply(name);
        logger.clearHandlers();
        level.foreach((Function1)new Serializable(logger){
            public static final long serialVersionUID = 0L;
            private final Logger logger$1;

            public final void apply(LogLevel l) {
                this.logger$1.setLogLevel(l);
            }
            {
                this.logger$1 = logger$1;
            }
        });
        handlers.foreach((Function1)new Serializable(logger){
            public static final long serialVersionUID = 0L;
            private final Logger logger$1;

            public final void apply(Handler h) {
                this.logger$1.addHandler(h);
            }
            {
                this.logger$1 = logger$1;
            }
        });
        logger.setUseParentHandlers(useParents);
        return logger;
    }

    public Option<LogLevel> initLogger$default$2() {
        return None$.MODULE$;
    }

    public Seq<Handler> initLogger$default$3() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public boolean initLogger$default$4() {
        return true;
    }

    public <A> Logger of(ClassTag<A> evidence$1) {
        return this.apply(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass().getName());
    }

    public Logger apply(String loggerName) {
        return (Logger)this.loggerCache().getOrElseUpdate((Object)loggerName, (Function0)new Serializable(loggerName){
            public static final long serialVersionUID = 0L;
            private final String loggerName$1;

            public final Logger apply() {
                return new Logger(java.util.logging.Logger.getLogger(this.loggerName$1));
            }
            {
                this.loggerName$1 = loggerName$1;
            }
        });
    }

    public LogLevel getDefaultLogLevel() {
        return this.rootLogger().getLogLevel();
    }

    public void setDefaultLogLevel(LogLevel level) {
        this.rootLogger().setLogLevel(level);
    }

    public void setDefaultFormatter(LogFormatter formatter) {
        this.rootLogger().resetHandler(new ConsoleLogHandler(formatter));
    }

    public void resetDefaultLogLevel() {
        this.rootLogger().resetLogLevel();
    }

    public void setLogLevels(File file) {
        Properties logLevels = new Properties();
        IOUtil$.MODULE$.withResource(new FileReader(file), new Serializable(logLevels){
            public static final long serialVersionUID = 0L;
            private final Properties logLevels$1;

            public final void apply(FileReader in) {
                this.logLevels$1.load(in);
            }
            {
                this.logLevels$1 = logLevels$1;
            }
        });
        this.setLogLevels(logLevels);
    }

    public void setLogLevels(Properties logLevels) {
        ((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(logLevels).asScala()).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                Tuple2<String, String> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, String> x$1) {
                Tuple2<String, String> tuple2;
                block2: {
                    Option<LogLevel> option;
                    block5: {
                        block4: {
                            String level;
                            String loggerName;
                            block3: {
                                tuple2 = x$1;
                                if (tuple2 == null) break block2;
                                loggerName = (String)tuple2._1();
                                level = (String)tuple2._2();
                                option = LogLevel$.MODULE$.unapply(level);
                                if (!(option instanceof Some)) break block3;
                                Some some = (Some)option;
                                LogLevel lv = (LogLevel)some.x();
                                Logger$.MODULE$.apply(loggerName).setLogLevel(lv);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            if (!None$.MODULE$.equals(option)) break block5;
                            Console$.MODULE$.err().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown loglevel ", " is specified for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{level, loggerName})));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(option);
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public Seq<String> DEFAULT_LOGLEVEL_FILE_CANDIDATES() {
        return this.DEFAULT_LOGLEVEL_FILE_CANDIDATES;
    }

    public void scanLogLevels() {
        this.scanLogLevels(this.DEFAULT_LOGLEVEL_FILE_CANDIDATES());
    }

    public void scanLogLevels(Seq<String> loglevelFileCandidates) {
        LogLevelScanner$.MODULE$.scan(loglevelFileCandidates, (Option<Object>)None$.MODULE$);
    }

    public void scheduleLogLevelScan() {
        this.scheduleLogLevelScan(new LogLevelScannerConfig(this.DEFAULT_LOGLEVEL_FILE_CANDIDATES(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.MINUTES)));
    }

    public LogLevelScanner logLevelScanner() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.logLevelScanner$lzycompute() : this.logLevelScanner;
    }

    public void scheduleLogLevelScan(LogLevelScannerConfig config) {
        this.logLevelScanner().setConfig(config);
        this.logLevelScanner().start();
    }

    public void stopScheduledLogLevelScan() {
        this.logLevelScanner().stop();
    }

    public String getSuccinctLoggerName(Class<?> cl) {
        Class<?>[] interfaces;
        String name = cl.getName().contains("$anon$") ? ((interfaces = cl.getInterfaces()) != null && interfaces.length > 0 ? interfaces[0].getName() : cl.getName()) : cl.getName();
        return name.endsWith("$") ? name.substring(0, name.length() - 1) : name;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Logger$() {
        MODULE$ = this;
        this.DEFAULT_LOGLEVEL_FILE_CANDIDATES = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log-test.properties", "log.properties"}));
    }
}

