/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class IOUtil$ {
    public static final IOUtil$ MODULE$;

    static {
        new IOUtil$();
    }

    public <Resource extends AutoCloseable, U> U withResource(Resource resource, Function1<Resource, U> body) {
        try {
            return (U)body.apply(resource);
        }
        finally {
            resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public <U> U withTempFile(String name, String dir, String suffix, Function1<File, U> body) {
        Object object;
        File f = File.createTempFile(name, suffix, new File(dir));
        try {
            object = body.apply((Object)f);
            f.delete();
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.delete();
            throw throwable;
        }
        return (U)object;
    }

    public <U> String withTempFile$default$2() {
        return "target";
    }

    public <U> String withTempFile$default$3() {
        return ".tmp";
    }

    public int unusedPort() {
        return BoxesRunTime.unboxToInt(this.withResource((AutoCloseable)new ServerSocket(0), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(ServerSocket socket) {
                return socket.getLocalPort();
            }
        }));
    }

    public Option<File> findPath(String path) {
        return this.findPath(new File(path));
    }

    public Option<File> findPath(File path) {
        File defaultPath;
        return path.exists() ? new Some((Object)path) : ((defaultPath = new File(new File(System.getProperty("prog.home", "")), path.getPath())).exists() ? new Some((Object)defaultPath) : None$.MODULE$);
    }

    public String readAsString(String resourcePath) {
        Predef$.MODULE$.require(resourcePath != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"resourcePath is null"})).s((Seq)Nil$.MODULE$);
            }
        });
        Option<File> file = this.findPath(new File(resourcePath));
        if (file.isEmpty()) {
            throw new FileNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resourcePath})));
        }
        return this.readAsString(new FileInputStream((File)file.get()));
    }

    public String readAsString(InputStream in) {
        return (String)this.readFully(in, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(byte[] data) {
                return new String(data, StandardCharsets.UTF_8);
            }
        });
    }

    public <U> U readFully(InputStream in, Function1<byte[], U> f) {
        byte[] byteArray = (byte[])this.withResource((AutoCloseable)new ByteArrayOutputStream(), (Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final InputStream in$1;

            public final byte[] apply(ByteArrayOutputStream b) {
                byte[] buf = new byte[8192];
                IOUtil$.MODULE$.withResource(this.in$1, new Serializable(this, buf, b){
                    public static final long serialVersionUID = 0L;
                    private final byte[] buf$1;
                    private final ByteArrayOutputStream b$1;

                    public final void apply(InputStream src) {
                        int readBytes = 0;
                        while ((readBytes = src.read(this.buf$1)) != -1) {
                            this.b$1.write(this.buf$1, 0, readBytes);
                        }
                    }
                    {
                        this.buf$1 = buf$1;
                        this.b$1 = b$1;
                    }
                });
                return b.toByteArray();
            }
            {
                this.in$1 = in$1;
            }
        });
        return (U)f.apply((Object)byteArray);
    }

    private IOUtil$() {
        MODULE$ = this;
    }
}

