/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import wvlet.log.io.Resource;
import wvlet.log.io.Resource$;
import wvlet.log.io.Resource$$anonfun$findClasses$1$;

public final class Resource$ {
    public static final Resource$ MODULE$;

    static {
        new Resource$();
    }

    /*
     * WARNING - void declaration
     */
    public <U> U open(Class<?> referenceClass, String resourceFileName, Function1<BufferedInputStream, U> body) {
        Object object;
        Option<URL> u = this.find(referenceClass, resourceFileName);
        if (u.isEmpty()) {
            throw scala.sys.package$.MODULE$.error(new StringOps(Predef$.MODULE$.augmentString("Resource %s (in %s) not found")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resourceFileName, referenceClass.getSimpleName()})));
        }
        BufferedInputStream s = new BufferedInputStream(((URL)u.get()).openStream());
        try {
            object = body.apply((Object)s);
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.close();
            throw throwable;
        }
        s.close();
        return (U)object;
    }

    private String packagePath(Class<?> referenceClass) {
        return this.packagePath(referenceClass.getPackage());
    }

    private String packagePath(Package basePackage) {
        return this.packagePath(basePackage.getName());
    }

    private String packagePath(String packageName) {
        String packageAsPath = packageName.replaceAll("\\.", "/");
        return packageAsPath.endsWith("/") ? packageAsPath : new StringBuilder().append((Object)packageAsPath).append((Object)"/").toString();
    }

    private Stream<URLClassLoader> classLoaders(ClassLoader cl) {
        return this.wvlet$log$io$Resource$$stream$1(cl);
    }

    private Stream<ClassLoader> classLoaders() {
        return this.classLoaders(Thread.currentThread().getContextClassLoader());
    }

    private String resolveResourcePath(String packageName, String resourceFileName) {
        String path = this.packagePath(packageName);
        return this.prependSlash(new StringBuilder().append((Object)path).append((Object)resourceFileName).toString());
    }

    private String prependSlash(String name) {
        return name.startsWith("/") ? name : new StringBuilder().append((Object)"/").append((Object)name).toString();
    }

    public Option<URL> find(Class<?> referenceClass, String resourceFileName) {
        return this.find(this.packagePath(referenceClass), resourceFileName);
    }

    public Option<URL> find(String absoluteResourcePath) {
        return this.find("", absoluteResourcePath.startsWith("/") ? absoluteResourcePath.substring(1) : absoluteResourcePath);
    }

    public Option<URL> find(String packageName, String resourceFileName) {
        String resourcePath = this.resolveResourcePath(packageName, resourceFileName);
        Option r = ((TraversableOnce)this.classLoaders().map((Function1)new Serializable(resourcePath){
            public static final long serialVersionUID = 0L;
            private final String resourcePath$1;

            public final URL apply(ClassLoader x$2) {
                return x$2.getResource(this.resourcePath$1);
            }
            {
                this.resourcePath$1 = resourcePath$1;
            }
        }, Stream$.MODULE$.canBuildFrom())).collectFirst((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends URL, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                Object object = A12 != null ? (A1 = A12) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(URL x1) {
                URL uRL = x1;
                boolean bl = uRL != null;
                return bl;
            }
        });
        return r.orElse((Function0)new Serializable(resourcePath){
            public static final long serialVersionUID = 0L;
            private final String resourcePath$1;

            public final Option<URL> apply() {
                return Option$.MODULE$.apply((Object)Resource$.MODULE$.getClass().getResource(this.resourcePath$1));
            }
            {
                this.resourcePath$1 = resourcePath$1;
            }
        });
    }

    private String extractLogicalName(String packagePath, String resourcePath) {
        String p = packagePath.endsWith("/") ? packagePath : new StringBuilder().append((Object)packagePath).append((Object)"/").toString();
        int pos = resourcePath.indexOf(p);
        if (pos < 0) {
            return null;
        }
        String logicalName = resourcePath.substring(pos + p.length());
        return logicalName;
    }

    public Seq<Resource.VirtualFile> wvlet$log$io$Resource$$collectFileResources(String resourceURLString, String packagePath, Function1<String, Object> resourceFilter) {
        String logicalName = this.extractLogicalName(packagePath, resourceURLString);
        if (logicalName == null) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"packagePath=").append((Object)packagePath).append((Object)", resourceURL=").append((Object)resourceURLString).toString());
        }
        Builder b = Seq$.MODULE$.newBuilder();
        File file = new File(new URL(resourceURLString).toURI());
        Object object = BoxesRunTime.unboxToBoolean((Object)resourceFilter.apply((Object)file.getPath())) ? b.$plus$eq((Object)new Resource.SystemFile(file, logicalName)) : BoxedUnit.UNIT;
        if (file.isDirectory()) {
            Predef$.MODULE$.refArrayOps((Object[])file.listFiles()).foreach((Function1)new Serializable(resourceURLString, packagePath, resourceFilter, b){
                public static final long serialVersionUID = 0L;
                private final String resourceURLString$1;
                private final String packagePath$1;
                private final Function1 resourceFilter$1;
                private final Builder b$1;

                public final Builder<Resource.VirtualFile, Seq<Resource.VirtualFile>> apply(File childFile) {
                    String childResourceURL = new StringBuilder().append((Object)this.resourceURLString$1).append((Object)(this.resourceURLString$1.endsWith("/") ? "" : "/")).append((Object)childFile.getName()).toString();
                    return (Builder)this.b$1.$plus$plus$eq(Resource$.MODULE$.wvlet$log$io$Resource$$collectFileResources(childResourceURL, this.packagePath$1, (Function1<String, Object>)this.resourceFilter$1));
                }
                {
                    this.resourceURLString$1 = resourceURLString$1;
                    this.packagePath$1 = packagePath$1;
                    this.resourceFilter$1 = resourceFilter$1;
                    this.b$1 = b$1;
                }
            });
        }
        return (Seq)b.result();
    }

    public Seq<Resource.VirtualFile> wvlet$log$io$Resource$$listResources(URL resourceURL, String packageName, Function1<String, Object> resourceFilter) {
        block8: {
            Builder fileList;
            block7: {
                Growable growable;
                String protocol;
                String pkgPath;
                block6: {
                    pkgPath = this.packagePath(packageName);
                    fileList = Seq$.MODULE$.newBuilder();
                    if (resourceURL == null) {
                        return (Seq)Seq$.MODULE$.empty();
                    }
                    String string = protocol = resourceURL.getProtocol();
                    String string2 = "file";
                    if (string != null ? !string.equals(string2) : string2 != null) break block6;
                    String resourceURLString = resourceURL.toString();
                    growable = fileList.$plus$plus$eq(this.wvlet$log$io$Resource$$collectFileResources(resourceURLString, pkgPath, resourceFilter));
                    break block7;
                }
                String string = protocol;
                String string3 = "jar";
                if (string != null ? !string.equals(string3) : string3 != null) break block8;
                String path = resourceURL.getPath();
                int pos = path.indexOf("!");
                if (pos < 0) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"invalid resource URL: ").append((Object)resourceURL).toString());
                }
                String jarPath = path.substring(0, pos).replaceAll("%20", " ");
                String filePath = path.substring(0, pos).replaceAll("%20", " ").replace("file:", "");
                String jarURLString = new StringBuilder().append((Object)"jar:").append((Object)jarPath).toString();
                JarFile jf = new JarFile(filePath);
                Enumeration<JarEntry> entryEnum = jf.entries();
                while (entryEnum.hasMoreElements()) {
                    JarEntry jarEntry = entryEnum.nextElement();
                    String physicalURL = new StringBuilder().append((Object)jarURLString).append((Object)"!/").append((Object)jarEntry.getName()).toString();
                    URL jarFileURL = new URL(physicalURL);
                    String logicalName = this.extractLogicalName(pkgPath, jarEntry.getName());
                    Object object = logicalName != null && BoxesRunTime.unboxToBoolean((Object)resourceFilter.apply((Object)logicalName)) ? fileList.$plus$eq((Object)new Resource.FileInJar(jarFileURL, logicalName, jarEntry.isDirectory())) : BoxedUnit.UNIT;
                }
                growable = BoxedUnit.UNIT;
            }
            return (Seq)fileList.result();
        }
        throw new UnsupportedOperationException(new StringBuilder().append((Object)"resources other than file or jar are not supported: ").append((Object)resourceURL).toString());
    }

    public Seq<Resource.VirtualFile> listResources(String packageName) {
        return this.listResources(packageName, (Function1<String, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String f) {
                return true;
            }
        }, this.listResources$default$3());
    }

    public Seq<Resource.VirtualFile> listResources(String packageName, Function1<String, Object> resourceFilter, ClassLoader classLoader) {
        Builder b = Seq$.MODULE$.newBuilder();
        this.findResourceURLs(classLoader, packageName).foreach((Function1)new Serializable(packageName, resourceFilter, b){
            public static final long serialVersionUID = 0L;
            private final String packageName$1;
            private final Function1 resourceFilter$2;
            private final Builder b$2;

            public final Builder<Resource.VirtualFile, Seq<Resource.VirtualFile>> apply(URL u) {
                return (Builder)this.b$2.$plus$plus$eq(Resource$.MODULE$.wvlet$log$io$Resource$$listResources(u, this.packageName$1, (Function1<String, Object>)this.resourceFilter$2));
            }
            {
                this.packageName$1 = packageName$1;
                this.resourceFilter$2 = resourceFilter$2;
                this.b$2 = b$2;
            }
        });
        return (Seq)b.result();
    }

    public ClassLoader listResources$default$3() {
        return Thread.currentThread().getContextClassLoader();
    }

    public Seq<URL> findResourceURLs(ClassLoader cl, String name) {
        String path = this.packagePath(name);
        Builder b = Seq$.MODULE$.newBuilder();
        this.classLoaders(cl).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(URLClassLoader check$ifrefutable$1) {
                URLClassLoader uRLClassLoader = check$ifrefutable$1;
                boolean bl = uRLClassLoader != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(path, b){
            public static final long serialVersionUID = 0L;
            private final String path$1;
            private final Builder b$3;

            public final void apply(URLClassLoader c) {
                Enumeration<URL> e = c.findResources(this.path$1);
                while (e.hasMoreElements()) {
                    this.b$3.$plus$eq((Object)e.nextElement());
                }
            }
            {
                this.path$1 = path$1;
                this.b$3 = b$3;
            }
        });
        return (Seq)b.result();
    }

    public <A> Seq<Class<A>> findClasses(String packageName, Class<A> toSearch, ClassLoader classLoader) {
        Seq<Resource.VirtualFile> classFileList = this.listResources(packageName, (Function1<String, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String f) {
                return f.endsWith(".class");
            }
        }, classLoader);
        Builder b = Seq$.MODULE$.newBuilder();
        classFileList.foreach((Function1)new Serializable(packageName, toSearch, classLoader, b){
            public static final long serialVersionUID = 0L;
            public final String packageName$2;
            public final Class toSearch$1;
            public final ClassLoader classLoader$1;
            public final Builder b$4;

            public final void apply(Resource.VirtualFile vf) {
                Resource$.MODULE$.wvlet$log$io$Resource$$componentName$1(vf.logicalPath()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.findClasses.1 $outer;

                    public final void apply(String cn) {
                        String className = new StringBuilder().append((Object)this.$outer.packageName$2).append((Object)".").append((Object)cn).toString();
                        Resource$.MODULE$.wvlet$log$io$Resource$$findClass$1(className, this.$outer.classLoader$1).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$findClasses$1$$anonfun$apply$1 $outer;

                            public final Object apply(Class<?> cl) {
                                return !Modifier.isAbstract(cl.getModifiers()) && this.$outer.wvlet$log$io$Resource$$anonfun$$anonfun$$$outer().toSearch$1.isAssignableFrom(cl) ? this.$outer.wvlet$log$io$Resource$$anonfun$$anonfun$$$outer().b$4.$plus$eq(cl) : BoxedUnit.UNIT;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.findClasses.1 wvlet$log$io$Resource$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.packageName$2 = packageName$2;
                this.toSearch$1 = toSearch$1;
                this.classLoader$1 = classLoader$1;
                this.b$4 = b$4;
            }
        });
        return (Seq)b.result();
    }

    public <A> Seq<Class<A>> findClasses(Package searchPath, Class<A> toSearch, ClassLoader classLoader) {
        return this.findClasses(searchPath.getName(), toSearch, classLoader);
    }

    public <A> ClassLoader findClasses$default$3() {
        return Thread.currentThread().getContextClassLoader();
    }

    public final Stream wvlet$log$io$Resource$$stream$1(ClassLoader c) {
        while (true) {
            block5: {
                Stream stream2;
                block4: {
                    URLClassLoader uRLClassLoader;
                    ClassLoader classLoader;
                    block3: {
                        if ((classLoader = c) != null) break block3;
                        stream2 = package$.MODULE$.Stream().empty();
                        break block4;
                    }
                    if (!(classLoader instanceof URLClassLoader)) break block5;
                    URLClassLoader uRLClassLoader2 = uRLClassLoader = (URLClassLoader)classLoader;
                    stream2 = Stream$.MODULE$.consWrapper((Function0)new Serializable(c){
                        public static final long serialVersionUID = 0L;
                        private final ClassLoader c$1;

                        public final Stream<URLClassLoader> apply() {
                            return Resource$.MODULE$.wvlet$log$io$Resource$$stream$1(this.c$1.getParent());
                        }
                        {
                            this.c$1 = c$1;
                        }
                    }).$hash$colon$colon((Object)uRLClassLoader2);
                }
                return stream2;
            }
            c = c.getParent();
        }
    }

    public final Option wvlet$log$io$Resource$$componentName$1(String path) {
        int dot = path.lastIndexOf(".");
        return dot <= 0 ? None$.MODULE$ : new Some((Object)path.substring(0, dot).replaceAll("/", "."));
    }

    public final Option wvlet$log$io$Resource$$findClass$1(String name, ClassLoader classLoader$1) {
        Some some;
        try {
            some = new Some(Class.forName(name, false, classLoader$1));
        }
        catch (ClassNotFoundException classNotFoundException) {
            some = None$.MODULE$;
        }
        return some;
    }

    private Resource$() {
        MODULE$ = this;
    }
}

