/*
 * XML 2 Java Binding (X2JB) - the excellent Java tool.
 * Copyright 2009, by Richard Opalka.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not see the FSF site:
 * http://www.fsf.org/ and search for the LGPL License document there.
 */
package com.x2jb.bind.provider;

import org.x2jb.bind.Binding;
import org.x2jb.bind.spi.provider.BindingDefinition;

/**
 * Binding implementation for Java 5 annotations.
 *
 * @author <a href="mailto:richard_opalka@yahoo.com">Richard Opalka</a>
 */
final class AnnotationBindingImpl implements BindingDefinition
{

    /**
     * Annotation we're delegating all method calls to.
     */
    private Binding binding;

    /**
     * Constructor.
     * @param b binding
     */
    AnnotationBindingImpl( final Binding b )
    {
        this.binding = b;
    }

    /**
     * @see org.x2jb.bind.spi.provider.BindingDefinition#getNodeName() 
     * @return Local name of the node
     */
    public String getNodeName()
    {
        return this.binding.nodeName();
    }

    /**
     * @see org.x2jb.bind.spi.provider.BindingDefinition#getNodeNamespace() 
     * @return Namespace of the node
     */
    public String getNodeNamespace()
    {
        return this.binding.nodeNamespace();
    }

    /**
     * @see org.x2jb.bind.spi.provider.BindingDefinition#isElementNode() 
     * @return <b>true</b> if node have to be element and <b>false</b> for attribute
     */
    public boolean isElementNode()
    {
        return this.binding.isElementNode();
    }

    /**
     * @see org.x2jb.bind.spi.provider.BindingDefinition#isNodeUnique() 
     * @return <b>true</b> if node have to be unique in context node, <b>false</b> otherwise
     */
    public boolean isNodeUnique()
    {
        return this.binding.isNodeUnique();
    }

    /**
     * @see org.x2jb.bind.spi.provider.BindingDefinition#isNodeMandatory() 
     * @return <b>true</b> if node is mandatory, <b>false</b> otherwise
     */
    public boolean isNodeMandatory()
    {
        return this.binding.isNodeMandatory();
    }

    /**
     * @see org.x2jb.bind.spi.provider.BindingDefinition#getTypeHandler() 
     * @return Handler class name or <code>empty string</code> forcing built-in handler to be used
     */
    public String getTypeHandler()
    {
        return this.binding.typeHandler();
    }

    /**
     * @see org.x2jb.bind.spi.provider.BindingDefinition#getDefaultValue() 
     * @return default value to be set if node is not present.
     */
    public String getDefaultValue()
    {
        return this.binding.defaultValue();
    }

}
