/*
 * XML 2 Java Binding (X2JB) - the excellent Java tool.
 * Copyright 2009, by Richard Opalka.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not see the FSF site:
 * http://www.fsf.org/ and search for the LGPL License document there.
 */
package org.x2jb.bind;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Defines mapping of methods to XML elements and attributes.
 * Users using Java 5 or higher can use this annotation for binding definitions.
 * Remember this annotation is not part of <b>XML 2 Java Binding</b> core jar.
 * The annotation is located in <b>XML 2 Java Binding</b> annotation provider jar archive.
 *
 * @author <a href="mailto:richard_opalka@yahoo.com">Richard Opalka</a>
 */
@Retention( RetentionPolicy.RUNTIME )
@Target( { ElementType.METHOD } )
public @interface Binding
{

    /**
     * @see org.x2jb.bind.spi.provider.BindingDefinition#getNodeName()
     */
    String nodeName();

    /**
     * @see org.x2jb.bind.spi.provider.BindingDefinition#getNodeNamespace()
     */
    String nodeNamespace() default "";

    /**
     * @see org.x2jb.bind.spi.provider.BindingDefinition#isElementNode()
     */
    boolean isElementNode() default true;

    /**
     * @see org.x2jb.bind.spi.provider.BindingDefinition#isNodeUnique()
     */
    boolean isNodeUnique() default true;

    /**
     * @see org.x2jb.bind.spi.provider.BindingDefinition#isNodeMandatory()
     */
    boolean isNodeMandatory() default true;

    /**
     * @see org.x2jb.bind.spi.provider.BindingDefinition#getTypeHandler()
     */
    String typeHandler() default "";

    /**
     * @see org.x2jb.bind.spi.provider.BindingDefinition#getDefaultValue()
     */
    String defaultValue() default "";

}
