/*
 * XML 2 Java Binding (X2JB) - the excellent Java tool.
 * Copyright 2009, by Richard Opalka.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not see the FSF site:
 * http://www.fsf.org/ and search for the LGPL License document there.
 */
package com.x2jb.bind.handler;

import org.x2jb.bind.BindingException;

/**
 * Boolean wrapper handler.
 *
 * @author <a href="mailto:richard_opalka@yahoo.com">Richard Opalka</a>
 */
public class BooleanHandler extends AbstractHandler
{

    /**
     * Value 'true'.
     */
    private static String trueString = "true";

    /**
     * Value 'false'.
     */
    private static String falseString = "false";

    /**
     * Value 'yes'.
     */
    private static String yesString = "yes";

    /**
     * Value 'no'.
     */
    private static String noString = "no";

    /**
     * Value '1'.
     */
    private static String oneString = "1";

    /**
     * Value '0'.
     */
    private static String zeroString = "0";

    /**
     * Constructor.
     */
    public BooleanHandler()
    {
        super();
    }

    /**
     * Constructs instance.
     *
     * @param value string representation
     * @return Object value
     */
    protected final Object create( final String value )
    {
        final String lowerCasedValue = value.toLowerCase();

        // positive values
        if ( this.isTrueString( lowerCasedValue ) )
        {
            return Boolean.TRUE;
        }

        // negative values
        if ( this.isFalseString( lowerCasedValue ) )
        {
            return Boolean.FALSE;
        }

        throw new BindingException( "Incorrect value '" + value + "'" );
    }

    /**
     * Returns true if string equals to "1", "yes" or "true".
     *
     * @param s string to validate
     * @return true if matches, false otherwise
     */
    private boolean isTrueString( final String s )
    {
        if
        (
            s.equals( BooleanHandler.trueString ) ||
            s.equals( BooleanHandler.yesString ) ||
            s.equals( BooleanHandler.oneString )
        )
        {
            return true;
        }

        return false;
    }

    /**
     * Returns true if string equals to "0", "no" or "false".
     *
     * @param s string to validate
     * @return true if matches, false otherwise
     */
    private boolean isFalseString( final String s )
    {
        if
        (
            s.equals( BooleanHandler.falseString ) ||
            s.equals( BooleanHandler.noString ) ||
            s.equals( BooleanHandler.zeroString )
        )
        {
            return true;
        }

        return false;
    }

}
