/*
 * XML 2 Java Binding (X2JB) - the excellent Java tool.
 * Copyright 2009, by Richard Opalka.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not see the FSF site:
 * http://www.fsf.org/ and search for the LGPL License document there.
 */
package com.x2jb.bind.handler;

import org.w3c.dom.Element;

/**
 * Element handler.
 *
 * @author <a href="mailto:richard_opalka@yahoo.com">Richard Opalka</a>
 */
public class ElementHandler implements org.x2jb.bind.spi.handler.ElementHandler
{

    /**
     * Constructor.
     */
    public ElementHandler()
    {
        super();
    }

    /**
     * Binds element value to target class.
     *
     * @param e element to bind
     * @param clazz target class
     * @return bound value
     */
    public final Object bind( final Element e, final Class< ? > clazz )
    {
        return e;
    }

    /**
     * Returns default element handler value (<b>null</b> in this case).
     *
     * @param defaultValue default value
     * @param clazz class
     * @return default value
     */
    public final Object getDefault( final String defaultValue, final Class< ? > clazz )
    {
        return null;
    }

}
