/*
 * Decompiled with CFR 0.152.
 */
package org.xacml4j.v20;

import com.google.common.base.Supplier;
import com.google.common.io.Closeables;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import org.junit.Assert;
import org.oasis.xacml.v20.jaxb.context.ResponseType;
import org.oasis.xacml.v20.jaxb.context.ResultType;
import org.oasis.xacml.v20.jaxb.context.StatusType;
import org.oasis.xacml.v20.jaxb.policy.AttributeAssignmentType;
import org.oasis.xacml.v20.jaxb.policy.ObligationType;
import org.oasis.xacml.v20.jaxb.policy.ObligationsType;
import org.xacml4j.v30.RequestContext;
import org.xacml4j.v30.marshal.jaxb.JAXBContextUtil;
import org.xacml4j.v30.marshal.jaxb.Xacml20RequestContextUnmarshaller;

public class Xacml20TestUtility {
    private static final JAXBContext context = JAXBContextUtil.getInstance();
    private static final Xacml20RequestContextUnmarshaller requestUnmarshaller = new Xacml20RequestContextUnmarshaller();

    private Xacml20TestUtility() {
    }

    public static void assertResponse(ResponseType a, ResponseType b) {
        Assert.assertEquals((long)a.getResult().size(), (long)b.getResult().size());
        List ar = a.getResult();
        List br = b.getResult();
        for (int i = 0; i < ar.size(); ++i) {
            Xacml20TestUtility.assertResults((ResultType)ar.get(i), (ResultType)br.get(i));
        }
    }

    public static void assertResults(ResultType a, ResultType b) {
        Assert.assertEquals((Object)a.getDecision(), (Object)b.getDecision());
        Assert.assertEquals((Object)a.getResourceId(), (Object)b.getResourceId());
        Xacml20TestUtility.assertStatus(a.getStatus(), b.getStatus());
        Xacml20TestUtility.assertObligations(a.getObligations(), b.getObligations());
    }

    public static void assertStatus(StatusType a, StatusType b) {
        Assert.assertEquals((Object)a.getStatusCode().getValue(), (Object)b.getStatusCode().getValue());
    }

    public static void assertObligations(ObligationsType a, ObligationsType b) {
        if (a == null && b == null) {
            return;
        }
        List oa = a.getObligation();
        List ob = a.getObligation();
        Assert.assertEquals((long)oa.size(), (long)ob.size());
        Map<String, ObligationType> aMap = Xacml20TestUtility.toObligationMap(oa);
        Map<String, ObligationType> bMap = Xacml20TestUtility.toObligationMap(ob);
        Assert.assertTrue((boolean)aMap.keySet().containsAll(bMap.keySet()));
        Assert.assertTrue((boolean)bMap.keySet().containsAll(aMap.keySet()));
        for (String obligationId : aMap.keySet()) {
            ObligationType obligationA = aMap.get(obligationId);
            ObligationType obligationB = bMap.get(obligationId);
            Xacml20TestUtility.assertObligation(obligationA, obligationB);
        }
    }

    public static void assertObligation(ObligationType a, ObligationType b) {
        List aAttr = a.getAttributeAssignment();
        List bAttr = b.getAttributeAssignment();
        Assert.assertEquals((long)aAttr.size(), (long)bAttr.size());
        Map<String, AttributeAssignmentType> aMap = Xacml20TestUtility.toAttributeAssignmentMap(aAttr);
        Map<String, AttributeAssignmentType> bMap = Xacml20TestUtility.toAttributeAssignmentMap(bAttr);
        Assert.assertTrue((boolean)aMap.keySet().containsAll(bMap.keySet()));
        Assert.assertTrue((boolean)bMap.keySet().containsAll(aMap.keySet()));
        for (String attributeId : aMap.keySet()) {
            AttributeAssignmentType attrA = aMap.get(attributeId);
            AttributeAssignmentType attrB = bMap.get(attributeId);
            Xacml20TestUtility.assertAttributeAssignment(attrA, attrB);
        }
    }

    public static void assertAttributeAssignment(AttributeAssignmentType a, AttributeAssignmentType b) {
        Assert.assertEquals((Object)a.getAttributeId(), (Object)b.getAttributeId());
        Assert.assertEquals((Object)a.getDataType(), (Object)b.getDataType());
        Assert.assertEquals((Object)a.getContent(), (Object)b.getContent());
    }

    private static Map<String, ObligationType> toObligationMap(List<ObligationType> obligations) {
        LinkedHashMap<String, ObligationType> map = new LinkedHashMap<String, ObligationType>();
        for (ObligationType o : obligations) {
            map.put(o.getObligationId(), o);
        }
        return map;
    }

    private static Map<String, AttributeAssignmentType> toAttributeAssignmentMap(List<AttributeAssignmentType> attributes) {
        LinkedHashMap<String, AttributeAssignmentType> map = new LinkedHashMap<String, AttributeAssignmentType>();
        for (AttributeAssignmentType a : attributes) {
            map.put(a.getAttributeId(), a);
        }
        return map;
    }

    public static ResponseType getResponse(String resourcePath) throws Exception {
        ResponseType responseType;
        InputStream in = null;
        try {
            in = (InputStream)Xacml20TestUtility.getClasspathResource(resourcePath).get();
            Assert.assertNotNull((Object)in);
            responseType = (ResponseType)((JAXBElement)context.createUnmarshaller().unmarshal(in)).getValue();
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(in);
            throw throwable;
        }
        Closeables.closeQuietly((InputStream)in);
        return responseType;
    }

    public static RequestContext getRequest(String resourcePath) throws Exception {
        RequestContext requestContext;
        InputStream in = null;
        try {
            in = (InputStream)Xacml20TestUtility.getClasspathResource(resourcePath).get();
            requestContext = (RequestContext)requestUnmarshaller.unmarshal((Object)in);
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(in);
            throw throwable;
        }
        Closeables.closeQuietly((InputStream)in);
        return requestContext;
    }

    public static Supplier<InputStream> getClasspathResource(final String resourcePath) {
        return new Supplier<InputStream>(){

            public InputStream get() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return cl.getResourceAsStream(resourcePath);
            }
        };
    }
}

