/*
 * Decompiled with CFR 0.152.
 */
package org.xacml4j.v30;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.io.Closeables;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xacml4j.v30.Advice;
import org.xacml4j.v30.Category;
import org.xacml4j.v30.CompositeDecisionRule;
import org.xacml4j.v30.CompositeDecisionRuleIDReference;
import org.xacml4j.v30.Obligation;
import org.xacml4j.v30.RequestContext;
import org.xacml4j.v30.ResponseContext;
import org.xacml4j.v30.Result;
import org.xacml4j.v30.Version;
import org.xacml4j.v30.marshal.jaxb.Xacml20RequestContextUnmarshaller;
import org.xacml4j.v30.marshal.jaxb.Xacml20ResponseContextUnmarshaller;
import org.xacml4j.v30.marshal.jaxb.Xacml30RequestContextUnmarshaller;
import org.xacml4j.v30.marshal.jaxb.Xacml30ResponseContextUnmarshaller;
import org.xacml4j.v30.pdp.PolicyDecisionPoint;
import org.xacml4j.v30.pdp.PolicyDecisionPointBuilder;
import org.xacml4j.v30.spi.combine.DecisionCombiningAlgorithmProviderBuilder;
import org.xacml4j.v30.spi.function.FunctionProviderBuilder;
import org.xacml4j.v30.spi.pip.PolicyInformationPointBuilder;
import org.xacml4j.v30.spi.repository.InMemoryPolicyRepository;
import org.xacml4j.v30.spi.repository.PolicyRepository;

public class XacmlPolicyTestSupport {
    protected final Logger log = LoggerFactory.getLogger(XacmlPolicyTestSupport.class);
    private Xacml30RequestContextUnmarshaller requestUnmarshaller;
    private Xacml30ResponseContextUnmarshaller responseUnmarshaller;
    private Xacml20ResponseContextUnmarshaller xacml20ResponseUnmarshaller;
    private Xacml20RequestContextUnmarshaller xacml20RequestUnmarshaller;

    @Before
    public void setup() throws Exception {
        this.requestUnmarshaller = new Xacml30RequestContextUnmarshaller();
        this.responseUnmarshaller = new Xacml30ResponseContextUnmarshaller();
        this.xacml20ResponseUnmarshaller = new Xacml20ResponseContextUnmarshaller();
        this.xacml20RequestUnmarshaller = new Xacml20RequestContextUnmarshaller();
    }

    protected Builder builder(String rootPolicyId, String rootPolicyVersion) {
        Builder pdpBuilder = new Builder("testPDP", "testPIP", "testRepositoryId");
        pdpBuilder.rootPolicy(rootPolicyId, rootPolicyVersion);
        pdpBuilder.defaultResolvers();
        pdpBuilder.defaultFunctions();
        pdpBuilder.defaultDecisionAlgorithms();
        return pdpBuilder;
    }

    protected void verifyXacml30Response(PolicyDecisionPoint pdp, RequestContext request, ResponseContext expectedResponse) throws Exception {
        ResponseContext resp = pdp.decide(request);
        this.log.debug("Expected XACML 3.0 response=\"{}\"", (Object)expectedResponse);
        this.log.debug("Received XACML 3.0 response=\"{}\"", (Object)resp);
        XacmlPolicyTestSupport.assertResponse(expectedResponse, resp);
    }

    protected void verifyXacml30Response(PolicyDecisionPoint pdp, String xacmlRequestResource, String expectedXacmlResponseResource) throws Exception {
        RequestContext req = this.getXacml30Request(xacmlRequestResource);
        ResponseContext expectedResponse = this.getXacml30Response(expectedXacmlResponseResource);
        this.verifyXacml30Response(pdp, req, expectedResponse);
    }

    protected void verifyXacml20Response(PolicyDecisionPoint pdp, String xacmlRequestResource, String expectedXacmlResponseResource) throws Exception {
        RequestContext req = this.getXacml20Request(xacmlRequestResource);
        Assert.assertNotNull((String)xacmlRequestResource, (Object)req);
        ResponseContext expectedResponse = this.getXacml20Response(expectedXacmlResponseResource);
        Assert.assertNotNull((String)expectedXacmlResponseResource, (Object)expectedResponse);
        ResponseContext resp = pdp.decide(req);
        this.log.debug("Expected XACML 2.0 response=\"{}\"", (Object)expectedResponse);
        this.log.debug("Received XACML 2.0 response=\"{}\"", (Object)resp);
        XacmlPolicyTestSupport.assertResponse(expectedResponse, resp);
    }

    protected Supplier<InputStream> getResource(final String resourcePath, final ClassLoader cl) {
        return new Supplier<InputStream>(){

            public InputStream get() {
                XacmlPolicyTestSupport.this.log.debug("Loading resource \"{}\"", (Object)resourcePath);
                InputStream in = cl.getResourceAsStream(resourcePath);
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Failed to load resource from path=\"%s\"", resourcePath));
                }
                return in;
            }
        };
    }

    protected Supplier<InputStream> getResource(String resourcePath) {
        return this.getResource(resourcePath, Thread.currentThread().getContextClassLoader());
    }

    protected Supplier<InputStream> getPolicy(String path) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Loading policy from path=\"{}\"", (Object)path);
        }
        return this.getResource(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseContext getXacml30Response(String resourcePath) throws Exception {
        ResponseContext responseContext;
        InputStream in = null;
        try {
            in = (InputStream)this.getResource(resourcePath).get();
            responseContext = (ResponseContext)this.responseUnmarshaller.unmarshal((Object)in);
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(in);
            throw throwable;
        }
        Closeables.closeQuietly((InputStream)in);
        return responseContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseContext getXacml20Response(String resourcePath) throws Exception {
        ResponseContext responseContext;
        InputStream in = null;
        try {
            in = (InputStream)this.getResource(resourcePath).get();
            responseContext = (ResponseContext)this.xacml20ResponseUnmarshaller.unmarshal((Object)in);
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(in);
            throw throwable;
        }
        Closeables.closeQuietly((InputStream)in);
        return responseContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RequestContext getXacml20Request(String path) throws Exception {
        RequestContext requestContext;
        InputStream in = null;
        try {
            in = (InputStream)this.getResource(path).get();
            requestContext = (RequestContext)this.xacml20RequestUnmarshaller.unmarshal((Object)in);
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(in);
            throw throwable;
        }
        Closeables.closeQuietly((InputStream)in);
        return requestContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RequestContext getXacml30Request(String path) throws Exception {
        RequestContext requestContext;
        InputStream in = null;
        try {
            in = (InputStream)this.getResource(path).get();
            requestContext = (RequestContext)this.requestUnmarshaller.unmarshal((Object)in);
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(in);
            throw throwable;
        }
        Closeables.closeQuietly((InputStream)in);
        return requestContext;
    }

    public static void assertResponse(ResponseContext resp1, ResponseContext resp2) {
        Assert.assertEquals((long)resp1.getResults().size(), (long)resp2.getResults().size());
        Iterator r1It = resp1.getResults().iterator();
        Iterator r2It = resp2.getResults().iterator();
        while (r1It.hasNext()) {
            Result r1 = (Result)r1It.next();
            Result r2 = (Result)r2It.next();
            XacmlPolicyTestSupport.assertResult(r1, r2);
        }
    }

    private static void assertResult(Result r1, Result r2) {
        Assert.assertEquals((Object)r1.getDecision(), (Object)r2.getDecision());
        Assert.assertEquals((Object)r1.getStatus(), (Object)r2.getStatus());
        XacmlPolicyTestSupport.assertObligations(r1.getObligations(), r2.getObligations());
        XacmlPolicyTestSupport.assertAssociatedAdvices(r1.getAssociatedAdvice(), r2.getAssociatedAdvice());
        XacmlPolicyTestSupport.assertAttributes(r1.getIncludeInResultAttributes(), r2.getIncludeInResultAttributes());
        XacmlPolicyTestSupport.assertPolicyIdentifiers(r1.getPolicyIdentifiers(), r2.getPolicyIdentifiers());
    }

    private static void assertObligations(Collection<Obligation> o1, Collection<Obligation> o2) {
        XacmlPolicyTestSupport.assertArrayEquals(o1, o2, new Matcher<Obligation>(){

            @Override
            public boolean matches(Obligation o1, Obligation o2) {
                return o1.getId().equals(o2.getId());
            }
        });
    }

    private static void assertAssociatedAdvices(Collection<Advice> a1, Collection<Advice> a2) {
        XacmlPolicyTestSupport.assertArrayEquals(a1, a2, new Matcher<Advice>(){

            @Override
            public boolean matches(Advice o1, Advice o2) {
                return o1.getId().equals(o2.getId());
            }
        });
    }

    private static void assertAttributes(Collection<Category> a1, Collection<Category> a2) {
        XacmlPolicyTestSupport.assertArrayEquals(a1, a2, new Matcher<Category>(){

            @Override
            public boolean matches(Category o1, Category o2) {
                return o1.getId().equals(o2.getId()) && o1.getCategoryId().equals(o2.getCategoryId());
            }
        });
    }

    private static void assertPolicyIdentifiers(Collection<CompositeDecisionRuleIDReference> p1, Collection<CompositeDecisionRuleIDReference> p2) {
        XacmlPolicyTestSupport.assertArrayEquals(p1, p2, new Matcher<CompositeDecisionRuleIDReference>(){

            @Override
            public boolean matches(CompositeDecisionRuleIDReference o1, CompositeDecisionRuleIDReference o2) {
                return o1.getId().equals(o2.getId());
            }
        });
    }

    protected static <T> void assertArrayEquals(Collection<T> a1, Collection<T> a2, Matcher<T> matcher) {
        Assert.assertEquals((long)a1.size(), (long)a2.size());
        for (T o : a1) {
            Assert.assertEquals(o, XacmlPolicyTestSupport.findMatchingObject(a2, o, matcher));
        }
    }

    private static <T> T findMatchingObject(Collection<T> collection, T object, Matcher<T> matcher) {
        for (T o : collection) {
            if (!matcher.matches(o, object)) continue;
            return o;
        }
        return null;
    }

    public class Builder {
        private String rootPolicyId;
        private String rootPolicyVersion;
        private String pdpId;
        private String repositoryId;
        private FunctionProviderBuilder functionProviderBuilder;
        private PolicyInformationPointBuilder pipBuilder;
        private DecisionCombiningAlgorithmProviderBuilder decisionAlgoProviderBuilder;
        private Collection<Object> policies;

        public Builder(String pdpId, String pipId, String repositoryId) {
            Preconditions.checkNotNull((Object)pdpId);
            Preconditions.checkNotNull((Object)pipId);
            Preconditions.checkNotNull((Object)repositoryId);
            this.functionProviderBuilder = FunctionProviderBuilder.builder();
            this.decisionAlgoProviderBuilder = DecisionCombiningAlgorithmProviderBuilder.builder();
            this.pipBuilder = PolicyInformationPointBuilder.builder((String)pipId);
            this.policies = new ArrayList<Object>();
            this.repositoryId = repositoryId;
            this.pdpId = pdpId;
        }

        public Builder rootPolicy(String policyId, String version) {
            this.rootPolicyId = policyId;
            this.rootPolicyVersion = version;
            return this;
        }

        public Builder defaultDecisionAlgorithms() {
            this.decisionAlgoProviderBuilder.withDefaultAlgorithms();
            return this;
        }

        public Builder defaultResolvers() {
            this.pipBuilder.defaultResolvers();
            return this;
        }

        public Builder defaultFunctions() {
            this.functionProviderBuilder.defaultFunctions();
            return this;
        }

        public Builder functionProvider(Object provider) {
            this.functionProviderBuilder.fromInstance(provider);
            return this;
        }

        public Builder functionProvider(Class<?> clazz) {
            this.functionProviderBuilder.fromClass(clazz);
            return this;
        }

        public Builder decisionAlgorithmProvider(Object provider) {
            this.decisionAlgoProviderBuilder.withAlgorithmProvider(provider);
            return this;
        }

        public Builder policy(Supplier<InputStream> stream) {
            this.policies.add(stream);
            return this;
        }

        public Builder policies(Supplier<InputStream> ... policies) {
            Collections.addAll(this.policies, policies);
            return this;
        }

        public Builder policy(CompositeDecisionRule policy) {
            this.policies.add(policy);
            return this;
        }

        public Builder policies(CompositeDecisionRule ... policies) {
            Collections.addAll(this.policies, policies);
            return this;
        }

        public Builder policyFromClasspath(String path) {
            this.policies.add(XacmlPolicyTestSupport.this.getPolicy(path));
            return this;
        }

        public Builder resolver(Object resolver) {
            this.pipBuilder.resolverFromInstance(resolver);
            return this;
        }

        public Builder resolver(String policyId, Object resolver) {
            this.pipBuilder.resolverFromInstance(resolver);
            return this;
        }

        public PolicyDecisionPoint build() throws Exception {
            InMemoryPolicyRepository repository = new InMemoryPolicyRepository(this.repositoryId, this.functionProviderBuilder.build(), this.decisionAlgoProviderBuilder.create());
            for (Object policy : this.policies) {
                if (policy instanceof Supplier) {
                    repository.importPolicy((Supplier)policy);
                    continue;
                }
                if (policy instanceof CompositeDecisionRule) {
                    repository.add((CompositeDecisionRule)policy);
                    continue;
                }
                throw new UnsupportedOperationException(String.format("Unable to interpret policy represented by '%s'. There are 'Supplier<InputStream>' or 'CompositeDecisionRule' supported only.", policy.getClass()));
            }
            return PolicyDecisionPointBuilder.builder((String)this.pdpId).pip(this.pipBuilder.build()).policyRepository((PolicyRepository)repository).defaultRequestHandlers().rootPolicy(repository.get(this.rootPolicyId, Version.parse((String)this.rootPolicyVersion))).build();
        }
    }

    private static interface Matcher<T> {
        public boolean matches(T var1, T var2);
    }
}

