/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.asn1;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1BitString;
import org.xbib.asn1.ASN1Boolean;
import org.xbib.asn1.ASN1Enumerated;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1External;
import org.xbib.asn1.ASN1GeneralString;
import org.xbib.asn1.ASN1GeneralizedTime;
import org.xbib.asn1.ASN1GraphicString;
import org.xbib.asn1.ASN1IA5String;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.ASN1Null;
import org.xbib.asn1.ASN1NumericString;
import org.xbib.asn1.ASN1ObjectDescriptor;
import org.xbib.asn1.ASN1ObjectIdentifier;
import org.xbib.asn1.ASN1OctetString;
import org.xbib.asn1.ASN1PrintableString;
import org.xbib.asn1.ASN1Sequence;
import org.xbib.asn1.ASN1Set;
import org.xbib.asn1.ASN1T61String;
import org.xbib.asn1.ASN1UTCTime;
import org.xbib.asn1.ASN1VideotexString;
import org.xbib.asn1.ASN1VisibleString;
import org.xbib.asn1.BEREncoding;

public class ASN1Decoder {
    private ASN1Decoder() {
    }

    public static ASN1Any toASN1(BEREncoding ber) throws ASN1Exception {
        if (ber.tagTypeGet() == 0) {
            switch (ber.tagGet()) {
                case 1: {
                    return new ASN1Boolean(ber, true);
                }
                case 2: {
                    return new ASN1Integer(ber, true);
                }
                case 3: {
                    return new ASN1BitString(ber, true);
                }
                case 4: {
                    return new ASN1OctetString(ber, true);
                }
                case 5: {
                    return new ASN1Null(ber, true);
                }
                case 6: {
                    return new ASN1ObjectIdentifier(ber, true);
                }
                case 7: {
                    return new ASN1ObjectDescriptor(ber, true);
                }
                case 8: {
                    return new ASN1External(ber, true);
                }
                case 10: {
                    return new ASN1Enumerated(ber, true);
                }
                case 16: {
                    return new ASN1Sequence(ber, true);
                }
                case 17: {
                    return new ASN1Set(ber, true);
                }
                case 18: {
                    return new ASN1NumericString(ber, true);
                }
                case 19: {
                    return new ASN1PrintableString(ber, true);
                }
                case 20: {
                    return new ASN1T61String(ber, true);
                }
                case 21: {
                    return new ASN1VideotexString(ber, true);
                }
                case 22: {
                    return new ASN1IA5String(ber, true);
                }
                case 23: {
                    return new ASN1UTCTime(ber, true);
                }
                case 24: {
                    return new ASN1GeneralizedTime(ber, true);
                }
                case 25: {
                    return new ASN1GraphicString(ber, true);
                }
                case 26: {
                    return new ASN1VisibleString(ber, true);
                }
                case 27: {
                    return new ASN1GeneralString(ber, true);
                }
            }
        }
        return new ASN1Any(ber, true);
    }
}

