/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.asn1;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BEREncoding;
import org.xbib.asn1.BERPrimitive;

public final class ASN1Enumerated
extends ASN1Any {
    public static final int ENUMERATED_TAG = 10;
    private int value;

    public ASN1Enumerated(int number) {
        this.value = number;
    }

    public ASN1Enumerated(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    @Override
    public void berDecode(BEREncoding berEncoding, boolean checkTag) throws ASN1EncodingException {
        if (checkTag && (berEncoding.tagGet() != 10 || berEncoding.tagTypeGet() != 0)) {
            throw new ASN1EncodingException("bad BER: tag=" + berEncoding.tagGet() + " expected " + 10 + "\n");
        }
        if (!(berEncoding instanceof BERPrimitive)) {
            throw new ASN1EncodingException("bad form, constructed");
        }
        BERPrimitive ber = (BERPrimitive)berEncoding;
        int[] encoding = ber.peek();
        if (encoding.length < 1) {
            throw new ASN1EncodingException("invalid encoding, length = " + encoding.length);
        }
        this.value = (byte)encoding[0];
        for (int x = 1; x < encoding.length; ++x) {
            this.value <<= 8;
            this.value |= encoding[x] & 0xFF;
        }
    }

    @Override
    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 10);
    }

    @Override
    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        boolean needPad;
        int length = 0;
        int shifted = this.value;
        if (this.value < 0) {
            shifted = ~this.value;
        }
        do {
            needPad = (shifted & 0x80) == 128;
            ++length;
        } while ((shifted >>= 8) != 0);
        if (needPad) {
            ++length;
        }
        int[] encoding = new int[length];
        int index = 0;
        while (0 < length) {
            encoding[index++] = this.value >> 8 * (length - 1) & 0xFF;
            --length;
        }
        return new BERPrimitive(tagType, tag, encoding);
    }

    public ASN1Enumerated set(int newVal) {
        this.value = newVal;
        return this;
    }

    public int get() {
        return this.value;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }
}

