/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.asn1;

import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1VisibleString;
import org.xbib.asn1.BEREncoding;

public final class ASN1GeneralizedTime
extends ASN1VisibleString {
    public static final int GENERALIZED_TIME_TAG = 24;

    public ASN1GeneralizedTime(String value) {
        super(value);
    }

    public ASN1GeneralizedTime(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, false);
        if (checkTag && (ber.tagGet() != 24 || ber.tagTypeGet() != 0)) {
            throw new ASN1EncodingException("bad BER: tag=" + ber.tagGet() + " expected " + 24 + "\n");
        }
    }

    @Override
    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 24);
    }
}

