/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.asn1;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1Decoder;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.asn1.BERPrimitive;

public final class ASN1Set
extends ASN1Any {
    public static final int SET_TAG = 17;
    private ASN1Any[] elements;

    public ASN1Set(ASN1Any[] elementArray) {
        this.elements = elementArray;
    }

    public ASN1Set(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    @Override
    public void berDecode(BEREncoding berEncoding, boolean checkTag) throws ASN1Exception {
        if (checkTag && (berEncoding.tagGet() != 17 || berEncoding.tagTypeGet() != 0)) {
            throw new ASN1EncodingException("bad BER: tag=" + berEncoding.tagGet() + " expected " + 17 + "\n");
        }
        if (berEncoding instanceof BERPrimitive) {
            throw new ASN1EncodingException("bad form, primitive");
        }
        BERConstructed ber = (BERConstructed)berEncoding;
        int len = ber.numberComponents();
        this.elements = new ASN1Any[len];
        for (int x = 0; x < len; ++x) {
            this.elements[x] = ASN1Decoder.toASN1(ber.elementAt(x));
        }
    }

    @Override
    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 17);
    }

    @Override
    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int len = this.elements.length;
        BEREncoding[] encodings = new BEREncoding[len];
        for (int index = 0; index < len; ++index) {
            encodings[index] = this.elements[index].berEncode();
        }
        return new BERConstructed(tagType, tag, encodings);
    }

    public void set(ASN1Any[] elementArray) {
        this.elements = elementArray;
    }

    public ASN1Any[] get() {
        return this.elements;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder("{");
        for (int index = 0; index < this.elements.length; ++index) {
            if (index != 0) {
                str.append(", ");
            }
            str.append(this.elements[index].toString());
        }
        str.append('}');
        return new String(str);
    }
}

