/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.asn1;

import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1VisibleString;
import org.xbib.asn1.BEREncoding;

public final class ASN1UTCTime
extends ASN1VisibleString {
    public static final int UTC_TIME_TAG = 23;

    public ASN1UTCTime(String value) {
        super(value);
    }

    public ASN1UTCTime(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, false);
        if (checkTag && (ber.tagGet() != 23 || ber.tagTypeGet() != 0)) {
            throw new ASN1EncodingException("ASN.1 UTCTime: bad BER: tag=" + ber.tagGet() + " expected " + 23 + "\n");
        }
    }

    @Override
    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 23);
    }
}

