/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.asn1;

import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1OctetString;
import org.xbib.asn1.BEREncoding;

public class ASN1VisibleString
extends ASN1OctetString {
    public static final int TAG = 26;

    public ASN1VisibleString(String value) {
        super(value);
    }

    public ASN1VisibleString(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, false);
        if (checkTag && (ber.tagGet() != 26 || ber.tagTypeGet() != 0)) {
            throw new ASN1EncodingException("bad BER: tag=" + ber.tagGet() + " expected " + 26 + "\n");
        }
    }

    @Override
    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 26);
    }
}

