/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.asn1;

import java.io.IOException;
import java.io.OutputStream;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BEREncoding;

public class BERConstructed
extends BEREncoding {
    private BEREncoding[] contentElements;

    public BERConstructed(int asn1Class, int tag, BEREncoding[] elements) throws ASN1Exception {
        int contentLength = 0;
        for (BEREncoding element : elements) {
            contentLength += element.iTotalLength;
        }
        this.init(asn1Class, true, tag, contentLength);
        this.contentElements = elements;
    }

    @Override
    public void output(OutputStream dest) throws IOException {
        this.outputHead(dest);
        for (BEREncoding contentElement : this.contentElements) {
            contentElement.output(dest);
        }
    }

    public int numberComponents() {
        return this.contentElements.length;
    }

    public BEREncoding elementAt(int index) {
        return this.contentElements[index];
    }

    public String toString() {
        StringBuilder str = new StringBuilder("[");
        switch (this.iTagType) {
            case 0: {
                str.append("UNIVERSAL ");
                break;
            }
            case 64: {
                str.append("APPLICATION ");
                break;
            }
            case 128: {
                str.append("CONTEXT SPECIFIC ");
                break;
            }
            case 192: {
                str.append("PRIVATE ");
                break;
            }
        }
        str.append(String.valueOf(this.iTag)).append("]{");
        for (int x = 0; x < this.contentElements.length; ++x) {
            if (x != 0) {
                str.append(',');
            }
            str.append(this.contentElements[x].toString());
        }
        str.append('}');
        return new String(str);
    }

    @Override
    protected int iEncodingGet(int offset, byte[] data) {
        int i = this.iGetHead(offset, data);
        for (BEREncoding contentElement : this.contentElements) {
            i = contentElement.iEncodingGet(i, data);
        }
        return i;
    }
}

