/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BERPrimitive;

public abstract class BEREncoding {
    private static final String ERROR = "Unexpected end in BER encoding";
    public static final int UNIVERSAL_TAG = 0;
    public static final int APPLICATION_TAG = 64;
    public static final int CONTEXT_SPECIFIC_TAG = 128;
    public static final int PRIVATE_TAG = 192;
    private static final int MAX_BER_SIZE = 262144;
    protected int iTagType;
    protected int iTag;
    protected int iTotalLength;
    private int[] identifierEncoding;
    private int[] lengthEncoding;

    public static BEREncoding input(InputStream inputStream) throws IOException {
        int[] numBytesRead = new int[]{0};
        return BEREncoding.doInput(inputStream, numBytesRead);
    }

    protected static BEREncoding doInput(InputStream inputStream, int[] numBytesRead) throws IOException {
        int length;
        int tag;
        int octet = inputStream.read();
        if (octet < 0) {
            return null;
        }
        numBytesRead[0] = numBytesRead[0] + 1;
        int tagType = octet & 0xC0;
        boolean isCons = false;
        if ((octet & 0x20) != 0) {
            isCons = true;
        }
        if ((tag = octet & 0x1F) == 31) {
            tag = 0;
            do {
                if ((octet = inputStream.read()) < 0) {
                    throw new ASN1EncodingException(ERROR);
                }
                numBytesRead[0] = numBytesRead[0] + 1;
                tag <<= 7;
                tag |= octet & 0x7F;
            } while ((octet & 0x80) != 0);
        }
        if ((octet = inputStream.read()) < 0) {
            throw new ASN1EncodingException(ERROR);
        }
        numBytesRead[0] = numBytesRead[0] + 1;
        if ((octet & 0x80) != 0) {
            if ((octet & 0x7F) == 0) {
                length = -1;
                if (!isCons) {
                    throw new ASN1EncodingException("BER encoding corrupted primitive");
                }
            } else {
                if (4 < (octet & 0x7F)) {
                    throw new ASN1EncodingException("BER encoding too long");
                }
                length = 0;
                for (int numBytes = octet & 0x7F; 0 < numBytes; --numBytes) {
                    octet = inputStream.read();
                    if (octet < 0) {
                        throw new ASN1EncodingException(ERROR);
                    }
                    numBytesRead[0] = numBytesRead[0] + 1;
                    length <<= 8;
                    length |= octet & 0xFF;
                }
                if (length < 0 || 262144 < length) {
                    throw new ASN1EncodingException("BER encoding too long");
                }
            }
        } else {
            length = octet & 0x7F;
        }
        if (!isCons) {
            int[] contents = new int[length];
            for (int x = 0; x < length; ++x) {
                octet = inputStream.read();
                if (octet < 0) {
                    throw new ASN1EncodingException(ERROR);
                }
                numBytesRead[0] = numBytesRead[0] + 1;
                contents[x] = octet;
            }
            return new BERPrimitive(tagType, tag, contents);
        }
        ArrayList<BEREncoding> chunks = new ArrayList<BEREncoding>();
        if (0 <= length) {
            int currentRead;
            for (int totalRead = 0; totalRead < length; totalRead += numBytesRead[0] - currentRead) {
                currentRead = numBytesRead[0];
                BEREncoding chunk = BEREncoding.doInput(inputStream, numBytesRead);
                if (chunk == null) {
                    throw new ASN1EncodingException(ERROR);
                }
                chunks.add(chunk);
            }
        } else {
            while (true) {
                BEREncoding chunk;
                if ((chunk = BEREncoding.doInput(inputStream, numBytesRead)) == null) {
                    throw new ASN1EncodingException(ERROR);
                }
                if (chunk.iTag == 0 && chunk.iTagType == 0 && chunk.iTotalLength == 2) break;
                chunks.add(chunk);
            }
        }
        int numElements = chunks.size();
        BEREncoding[] parts = new BEREncoding[numElements];
        for (int x = 0; x < numElements; ++x) {
            parts[x] = (BEREncoding)chunks.get(x);
        }
        return new BERConstructed(tagType, tag, parts);
    }

    public abstract void output(OutputStream var1) throws IOException;

    public byte[] encodingGet() {
        byte[] result = new byte[this.iTotalLength];
        this.iEncodingGet(0, result);
        return result;
    }

    public int tagTypeGet() {
        return this.iTagType;
    }

    public int tagGet() {
        return this.iTag;
    }

    public int totalLength() {
        return this.iTotalLength;
    }

    protected void init(int tagType, boolean isConstructed, int tag, int length) throws ASN1Exception {
        this.makeIdentifier(tagType, isConstructed, tag);
        this.makeLength(length);
        this.iTotalLength = this.identifierEncoding.length + this.lengthEncoding.length + length;
    }

    protected void outputBytes(int[] data, OutputStream dest) throws IOException {
        for (int aData : data) {
            dest.write(aData);
        }
    }

    protected void outputHead(OutputStream dest) throws IOException {
        this.outputBytes(this.identifierEncoding, dest);
        this.outputBytes(this.lengthEncoding, dest);
    }

    protected int iGetHead(int offset, byte[] data) {
        for (int anIdentifierEncoding : this.identifierEncoding) {
            data[offset++] = (byte)anIdentifierEncoding;
        }
        for (int aLengthEncoding : this.lengthEncoding) {
            data[offset++] = (byte)aLengthEncoding;
        }
        return offset;
    }

    protected abstract int iEncodingGet(int var1, byte[] var2);

    private void makeIdentifier(int tagType, boolean isConstructed, int tag) throws ASN1Exception {
        if ((tagType & 0xFFFFFF3F) != 0) {
            throw new ASN1Exception("Invalid ASN.1 tag type");
        }
        if (tag < 0) {
            throw new ASN1Exception("ASN.1 tag value is negative");
        }
        int b = this.iTagType = tagType & 0xC0;
        if (isConstructed) {
            b |= 0x20;
        }
        this.iTag = tag;
        if (tag <= 30) {
            this.identifierEncoding = new int[1];
            this.identifierEncoding[0] = b |= tag & 0x1F;
        } else {
            b |= 0x1F;
            int numberBytes = 1;
            int tmpTag = tag;
            do {
                ++numberBytes;
            } while ((tmpTag >>= 7) != 0);
            this.identifierEncoding = new int[numberBytes];
            this.identifierEncoding[0] = b;
            int index = 0;
            for (int digit = numberBytes - 2; 0 <= digit; --digit) {
                this.identifierEncoding[++index] = tag >> digit * 7 & 0x7F;
                if (digit == 0) continue;
                int n = index;
                this.identifierEncoding[n] = this.identifierEncoding[n] | 0x80;
            }
        }
    }

    private void makeLength(int length) {
        if (length < 0) {
            this.lengthEncoding = new int[1];
            this.lengthEncoding[0] = 128;
        } else if (length < 128) {
            this.lengthEncoding = new int[1];
            this.lengthEncoding[0] = length;
        } else {
            int count = 0;
            for (int shifted = length; shifted != 0; shifted >>= 8) {
                ++count;
            }
            this.lengthEncoding = new int[count + 1];
            this.lengthEncoding[0] = count | 0x80;
            int index = 0;
            while (0 < count) {
                int digit = length >> --count * 8 & 0xFF;
                this.lengthEncoding[++index] = digit;
            }
        }
    }
}

