/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.asn1;

import java.io.IOException;
import java.io.OutputStream;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BEREncoding;

public class BERPrimitive
extends BEREncoding {
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private int[] contentsOctets;

    BERPrimitive(int asn1Class, int tag, int[] contents) throws ASN1Exception {
        this.init(asn1Class, false, tag, contents.length);
        this.contentsOctets = contents;
    }

    int[] peek() {
        return this.contentsOctets;
    }

    @Override
    public void output(OutputStream dest) throws IOException {
        this.outputHead(dest);
        this.outputBytes(this.contentsOctets, dest);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("[");
        switch (this.iTagType) {
            case 0: {
                str.append("UNIVERSAL ");
                break;
            }
            case 64: {
                str.append("APPLICATION ");
                break;
            }
            case 128: {
                str.append("CONTEXT SPECIFIC ");
                break;
            }
            case 192: {
                str.append("PRIVATE ");
                break;
            }
        }
        str.append(String.valueOf(this.iTag)).append("] '");
        for (int octet : this.contentsOctets) {
            str.append(hex[octet >> 4 & 0xF]);
            str.append(hex[octet & 0xF]);
        }
        str.append("'H");
        return str.toString();
    }

    @Override
    protected int iEncodingGet(int offset, byte[] data) {
        int i = this.iGetHead(offset, data);
        for (int contentsOctet : this.contentsOctets) {
            data[i++] = (byte)contentsOctet;
        }
        return i;
    }
}

