/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joda.convert.FromString;
import org.joda.convert.JDKStringConverter;
import org.joda.convert.MethodConstructorStringConverter;
import org.joda.convert.MethodsStringConverter;
import org.joda.convert.StringConverter;
import org.joda.convert.ToString;

public final class StringConvert {
    public static final StringConvert INSTANCE = new StringConvert();
    private final ConcurrentMap<Class<?>, StringConverter<?>> registered = new ConcurrentHashMap();

    public StringConvert() {
        this(true);
    }

    public StringConvert(boolean includeJdkConverters) {
        if (includeJdkConverters) {
            for (JDKStringConverter conv : JDKStringConverter.values()) {
                this.registered.put(conv.getType(), conv);
            }
            this.registered.put(Boolean.TYPE, JDKStringConverter.BOOLEAN);
            this.registered.put(Byte.TYPE, JDKStringConverter.BYTE);
            this.registered.put(Short.TYPE, JDKStringConverter.SHORT);
            this.registered.put(Integer.TYPE, JDKStringConverter.INTEGER);
            this.registered.put(Long.TYPE, JDKStringConverter.LONG);
            this.registered.put(Float.TYPE, JDKStringConverter.FLOAT);
            this.registered.put(Double.TYPE, JDKStringConverter.DOUBLE);
            this.registered.put(Character.TYPE, JDKStringConverter.CHARACTER);
            this.tryRegister("javax.time.Instant", "parse");
            this.tryRegister("javax.time.Duration", "parse");
            this.tryRegister("javax.time.calendar.LocalDate", "parse");
            this.tryRegister("javax.time.calendar.LocalTime", "parse");
            this.tryRegister("javax.time.calendar.LocalDateTime", "parse");
            this.tryRegister("javax.time.calendar.OffsetDate", "parse");
            this.tryRegister("javax.time.calendar.OffsetTime", "parse");
            this.tryRegister("javax.time.calendar.OffsetDateTime", "parse");
            this.tryRegister("javax.time.calendar.ZonedDateTime", "parse");
            this.tryRegister("javax.time.calendar.Year", "parse");
            this.tryRegister("javax.time.calendar.YearMonth", "parse");
            this.tryRegister("javax.time.calendar.MonthDay", "parse");
            this.tryRegister("javax.time.calendar.Period", "parse");
            this.tryRegister("javax.time.calendar.ZoneOffset", "of");
            this.tryRegister("javax.time.calendar.ZoneId", "of");
            this.tryRegister("javax.time.calendar.TimeZone", "of");
        }
    }

    private void tryRegister(String className, String fromStringMethodName) {
        try {
            Class<?> cls = this.getClass().getClassLoader().loadClass(className);
            this.registerMethods(cls, "toString", fromStringMethodName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <T> String convertToString(T object) {
        if (object == null) {
            return null;
        }
        Class<?> cls = object.getClass();
        StringConverter<?> conv = this.findConverter(cls);
        return conv.convertToString(object);
    }

    public <T> String convertToString(Class<T> cls, T object) {
        if (object == null) {
            return null;
        }
        StringConverter<T> conv = this.findConverter(cls);
        return conv.convertToString(object);
    }

    public <T> T convertFromString(Class<T> cls, String str) {
        if (str == null) {
            return null;
        }
        StringConverter<T> conv = this.findConverter(cls);
        return conv.convertFromString(cls, str);
    }

    public <T> StringConverter<T> findConverter(Class<T> cls) {
        if (cls == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        StringConverter conv = (StringConverter)this.registered.get(cls);
        if (conv == null) {
            if (cls == Object.class) {
                throw new IllegalStateException("No registered converter found: " + cls);
            }
            for (Class<T> loopCls = cls.getSuperclass(); loopCls != null && conv == null; loopCls = loopCls.getSuperclass()) {
                conv = (StringConverter)this.registered.get(loopCls);
            }
            if (conv == null && (conv = this.findAnnotationConverter(cls)) == null) {
                throw new IllegalStateException("No registered converter found: " + cls);
            }
            this.registered.putIfAbsent(cls, conv);
        }
        return conv;
    }

    private <T> StringConverter<T> findAnnotationConverter(Class<T> cls) {
        Method toString = this.findToStringMethod(cls);
        if (toString == null) {
            return null;
        }
        Constructor<T> con = this.findFromStringConstructor(cls);
        Method fromString = this.findFromStringMethod(cls, con == null);
        if (con == null && fromString == null) {
            throw new IllegalStateException("Class annotated with @ToString but not with @FromString");
        }
        if (con != null && fromString != null) {
            throw new IllegalStateException("Both method and constructor are annotated with @FromString");
        }
        if (con != null) {
            return new MethodConstructorStringConverter<T>(cls, toString, con);
        }
        return new MethodsStringConverter<T>(cls, toString, fromString);
    }

    private Method findToStringMethod(Class<?> cls) {
        Method matched = null;
        for (Class<?> loopCls = cls; loopCls != null && matched == null; loopCls = loopCls.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = loopCls.getDeclaredMethods()) {
                ToString toString = method.getAnnotation(ToString.class);
                if (toString == null) continue;
                if (matched != null) {
                    throw new IllegalStateException("Two methods are annotated with @ToString");
                }
                matched = method;
            }
        }
        return matched;
    }

    private <T> Constructor<T> findFromStringConstructor(Class<T> cls) {
        Constructor<FromString> con;
        try {
            con = cls.getDeclaredConstructor(String.class);
        }
        catch (NoSuchMethodException ex) {
            try {
                con = cls.getDeclaredConstructor(CharSequence.class);
            }
            catch (NoSuchMethodException ex2) {
                return null;
            }
        }
        FromString fromString = con.getAnnotation(FromString.class);
        return fromString != null ? con : null;
    }

    private Method findFromStringMethod(Class<?> cls, boolean searchSuperclasses) {
        Method matched = null;
        for (Class<?> loopCls = cls; loopCls != null && matched == null; loopCls = loopCls.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = loopCls.getDeclaredMethods()) {
                FromString fromString = method.getAnnotation(FromString.class);
                if (fromString == null) continue;
                if (matched != null) {
                    throw new IllegalStateException("Two methods are annotated with @ToString");
                }
                matched = method;
            }
            if (!searchSuperclasses) break;
        }
        return matched;
    }

    public <T> void register(Class<T> cls, StringConverter<T> converter) {
        if (cls == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (converter == null) {
            throw new IllegalArgumentException("StringConverter must not be null");
        }
        if (this == INSTANCE) {
            throw new IllegalStateException("Global singleton cannot be extended");
        }
        StringConverter<T> old = this.registered.putIfAbsent(cls, converter);
        if (old != null) {
            throw new IllegalStateException("Converter already registered for class: " + cls);
        }
    }

    public <T> void registerMethods(Class<T> cls, String toStringMethodName, String fromStringMethodName) {
        Method fromString;
        if (cls == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (toStringMethodName == null || fromStringMethodName == null) {
            throw new IllegalArgumentException("Method names must not be null");
        }
        if (this == INSTANCE) {
            throw new IllegalStateException("Global singleton cannot be extended");
        }
        Method toString = this.findToStringMethod(cls, toStringMethodName);
        MethodsStringConverter<T> converter = new MethodsStringConverter<T>(cls, toString, fromString = this.findFromStringMethod(cls, fromStringMethodName));
        StringConverter old = this.registered.putIfAbsent(cls, converter);
        if (old != null) {
            throw new IllegalStateException("Converter already registered for class: " + cls);
        }
    }

    public <T> void registerMethodConstructor(Class<T> cls, String toStringMethodName) {
        Constructor<T> fromString;
        if (cls == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (toStringMethodName == null) {
            throw new IllegalArgumentException("Method name must not be null");
        }
        if (this == INSTANCE) {
            throw new IllegalStateException("Global singleton cannot be extended");
        }
        Method toString = this.findToStringMethod(cls, toStringMethodName);
        MethodConstructorStringConverter<T> converter = new MethodConstructorStringConverter<T>(cls, toString, fromString = this.findFromStringConstructorByType(cls));
        StringConverter old = this.registered.putIfAbsent(cls, converter);
        if (old != null) {
            throw new IllegalStateException("Converter already registered for class: " + cls);
        }
    }

    private Method findToStringMethod(Class<?> cls, String methodName) {
        Method m;
        try {
            m = cls.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(ex);
        }
        if (Modifier.isStatic(m.getModifiers())) {
            throw new IllegalArgumentException("Method must not be static: " + methodName);
        }
        return m;
    }

    private Method findFromStringMethod(Class<?> cls, String methodName) {
        Method m;
        try {
            m = cls.getMethod(methodName, String.class);
        }
        catch (NoSuchMethodException ex) {
            try {
                m = cls.getMethod(methodName, CharSequence.class);
            }
            catch (NoSuchMethodException ex2) {
                throw new IllegalArgumentException("Method not found", ex2);
            }
        }
        if (!Modifier.isStatic(m.getModifiers())) {
            throw new IllegalArgumentException("Method must be static: " + methodName);
        }
        return m;
    }

    private <T> Constructor<T> findFromStringConstructorByType(Class<T> cls) {
        try {
            return cls.getDeclaredConstructor(String.class);
        }
        catch (NoSuchMethodException ex) {
            try {
                return cls.getDeclaredConstructor(CharSequence.class);
            }
            catch (NoSuchMethodException ex2) {
                throw new IllegalArgumentException("Constructor not found", ex2);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

