/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.IllegalInstantException;
import org.joda.time.JodaTimePermission;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.UTCDateTimeZone;
import org.joda.time.chrono.BaseChronology;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.FormatUtils;
import org.joda.time.tz.DefaultNameProvider;
import org.joda.time.tz.FixedDateTimeZone;
import org.joda.time.tz.NameProvider;
import org.joda.time.tz.Provider;
import org.joda.time.tz.UTCProvider;
import org.joda.time.tz.ZoneInfoProvider;

public abstract class DateTimeZone
implements Serializable {
    private static final long serialVersionUID = 5546345482340108586L;
    public static final DateTimeZone UTC = UTCDateTimeZone.INSTANCE;
    private static final int MAX_MILLIS = 86399999;
    private static final AtomicReference<Provider> cProvider = new AtomicReference();
    private static final AtomicReference<NameProvider> cNameProvider = new AtomicReference();
    private static final AtomicReference<DateTimeZone> cDefault = new AtomicReference();
    public static final String DEFAULT_TZ_DATA_PATH = "org/joda/time/tz/data";
    private final String iID;

    public static DateTimeZone getDefault() {
        DateTimeZone zone = cDefault.get();
        if (zone == null) {
            try {
                try {
                    String id = System.getProperty("user.timezone");
                    if (id != null) {
                        zone = DateTimeZone.forID(id);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (zone == null) {
                    zone = DateTimeZone.forTimeZone(TimeZone.getDefault());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (zone == null) {
                zone = UTC;
            }
            if (!cDefault.compareAndSet(null, zone)) {
                zone = cDefault.get();
            }
        }
        return zone;
    }

    public static void setDefault(DateTimeZone zone) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JodaTimePermission("DateTimeZone.setDefault"));
        }
        if (zone == null) {
            throw new IllegalArgumentException("The datetime zone must not be null");
        }
        cDefault.set(zone);
    }

    @FromString
    public static DateTimeZone forID(String id) {
        if (id == null) {
            return DateTimeZone.getDefault();
        }
        if (id.equals("UTC")) {
            return UTC;
        }
        DateTimeZone zone = DateTimeZone.getProvider().getZone(id);
        if (zone != null) {
            return zone;
        }
        if (id.startsWith("+") || id.startsWith("-")) {
            int offset = DateTimeZone.parseOffset(id);
            if ((long)offset == 0L) {
                return UTC;
            }
            id = DateTimeZone.printOffset(offset);
            return DateTimeZone.fixedOffsetZone(id, offset);
        }
        throw new IllegalArgumentException("The datetime zone id '" + id + "' is not recognised");
    }

    public static DateTimeZone forOffsetHours(int hoursOffset) throws IllegalArgumentException {
        return DateTimeZone.forOffsetHoursMinutes(hoursOffset, 0);
    }

    public static DateTimeZone forOffsetHoursMinutes(int hoursOffset, int minutesOffset) throws IllegalArgumentException {
        if (hoursOffset == 0 && minutesOffset == 0) {
            return UTC;
        }
        if (hoursOffset < -23 || hoursOffset > 23) {
            throw new IllegalArgumentException("Hours out of range: " + hoursOffset);
        }
        if (minutesOffset < -59 || minutesOffset > 59) {
            throw new IllegalArgumentException("Minutes out of range: " + minutesOffset);
        }
        if (hoursOffset > 0 && minutesOffset < 0) {
            throw new IllegalArgumentException("Positive hours must not have negative minutes: " + minutesOffset);
        }
        int offset = 0;
        try {
            int hoursInMinutes = hoursOffset * 60;
            minutesOffset = hoursInMinutes < 0 ? hoursInMinutes - Math.abs(minutesOffset) : hoursInMinutes + minutesOffset;
            offset = FieldUtils.safeMultiply(minutesOffset, 60000);
        }
        catch (ArithmeticException ex) {
            throw new IllegalArgumentException("Offset is too large");
        }
        return DateTimeZone.forOffsetMillis(offset);
    }

    public static DateTimeZone forOffsetMillis(int millisOffset) {
        if (millisOffset < -86399999 || millisOffset > 86399999) {
            throw new IllegalArgumentException("Millis out of range: " + millisOffset);
        }
        String id = DateTimeZone.printOffset(millisOffset);
        return DateTimeZone.fixedOffsetZone(id, millisOffset);
    }

    public static DateTimeZone forTimeZone(TimeZone zone) {
        if (zone == null) {
            return DateTimeZone.getDefault();
        }
        String id = zone.getID();
        if (id == null) {
            throw new IllegalArgumentException("The TimeZone id must not be null");
        }
        if (id.equals("UTC")) {
            return UTC;
        }
        DateTimeZone dtz = null;
        String convId = DateTimeZone.getConvertedId(id);
        Provider provider = DateTimeZone.getProvider();
        if (convId != null) {
            dtz = provider.getZone(convId);
        }
        if (dtz == null) {
            dtz = provider.getZone(id);
        }
        if (dtz != null) {
            return dtz;
        }
        if (convId == null && ((convId = id).startsWith("GMT+") || convId.startsWith("GMT-"))) {
            int offset;
            char firstDigit;
            if ((convId = convId.substring(3)).length() > 2 && (firstDigit = convId.charAt(1)) > '9' && Character.isDigit(firstDigit)) {
                convId = DateTimeZone.convertToAsciiNumber(convId);
            }
            if ((long)(offset = DateTimeZone.parseOffset(convId)) == 0L) {
                return UTC;
            }
            convId = DateTimeZone.printOffset(offset);
            return DateTimeZone.fixedOffsetZone(convId, offset);
        }
        throw new IllegalArgumentException("The datetime zone id '" + id + "' is not recognised");
    }

    private static String convertToAsciiNumber(String convId) {
        StringBuilder buf = new StringBuilder(convId);
        for (int i = 0; i < buf.length(); ++i) {
            char ch = buf.charAt(i);
            int digit = Character.digit(ch, 10);
            if (digit < 0) continue;
            buf.setCharAt(i, (char)(48 + digit));
        }
        return buf.toString();
    }

    private static DateTimeZone fixedOffsetZone(String id, int offset) {
        if (offset == 0) {
            return UTC;
        }
        return new FixedDateTimeZone(id, null, offset, offset);
    }

    public static Set<String> getAvailableIDs() {
        return DateTimeZone.getProvider().getAvailableIDs();
    }

    public static Provider getProvider() {
        Provider provider = cProvider.get();
        if (provider == null && !cProvider.compareAndSet(null, provider = DateTimeZone.getDefaultProvider())) {
            provider = cProvider.get();
        }
        return provider;
    }

    public static void setProvider(Provider provider) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JodaTimePermission("DateTimeZone.setProvider"));
        }
        if (provider == null) {
            provider = DateTimeZone.getDefaultProvider();
        } else {
            DateTimeZone.validateProvider(provider);
        }
        cProvider.set(provider);
    }

    private static Provider validateProvider(Provider provider) {
        Set<String> ids = provider.getAvailableIDs();
        if (ids == null || ids.size() == 0) {
            throw new IllegalArgumentException("The provider doesn't have any available ids");
        }
        if (!ids.contains("UTC")) {
            throw new IllegalArgumentException("The provider doesn't support UTC");
        }
        if (!UTC.equals(provider.getZone("UTC"))) {
            throw new IllegalArgumentException("Invalid UTC zone provided");
        }
        return provider;
    }

    private static Provider getDefaultProvider() {
        try {
            String providerClass = System.getProperty("org.joda.time.DateTimeZone.Provider");
            if (providerClass != null) {
                try {
                    Class<?> cls = Class.forName(providerClass, false, DateTimeZone.class.getClassLoader());
                    if (!Provider.class.isAssignableFrom(cls)) {
                        throw new IllegalArgumentException("System property referred to class that does not implement " + Provider.class);
                    }
                    Provider provider = cls.asSubclass(Provider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                    return DateTimeZone.validateProvider(provider);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        catch (SecurityException providerClass) {
            // empty catch block
        }
        try {
            String dataFolder = System.getProperty("org.joda.time.DateTimeZone.Folder");
            if (dataFolder != null) {
                try {
                    ZoneInfoProvider provider = new ZoneInfoProvider(new File(dataFolder));
                    return DateTimeZone.validateProvider(provider);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        catch (SecurityException dataFolder) {
            // empty catch block
        }
        try {
            ZoneInfoProvider provider = new ZoneInfoProvider(DEFAULT_TZ_DATA_PATH);
            return DateTimeZone.validateProvider(provider);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new UTCProvider();
        }
    }

    public static NameProvider getNameProvider() {
        NameProvider nameProvider = cNameProvider.get();
        if (nameProvider == null && !cNameProvider.compareAndSet(null, nameProvider = DateTimeZone.getDefaultNameProvider())) {
            nameProvider = cNameProvider.get();
        }
        return nameProvider;
    }

    public static void setNameProvider(NameProvider nameProvider) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JodaTimePermission("DateTimeZone.setNameProvider"));
        }
        if (nameProvider == null) {
            nameProvider = DateTimeZone.getDefaultNameProvider();
        }
        cNameProvider.set(nameProvider);
    }

    private static NameProvider getDefaultNameProvider() {
        NameProvider nameProvider;
        block6: {
            nameProvider = null;
            try {
                String providerClass = System.getProperty("org.joda.time.DateTimeZone.NameProvider");
                if (providerClass == null) break block6;
                try {
                    Class<?> cls = Class.forName(providerClass, false, DateTimeZone.class.getClassLoader());
                    if (!NameProvider.class.isAssignableFrom(cls)) {
                        throw new IllegalArgumentException("System property referred to class that does not implement " + NameProvider.class);
                    }
                    nameProvider = cls.asSubclass(NameProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (nameProvider == null) {
            nameProvider = new DefaultNameProvider();
        }
        return nameProvider;
    }

    private static String getConvertedId(String id) {
        return LazyInit.CONVERSION_MAP.get(id);
    }

    private static int parseOffset(String str) {
        return -((int)LazyInit.OFFSET_FORMATTER.parseMillis(str));
    }

    private static String printOffset(int offset) {
        StringBuffer buf = new StringBuffer();
        if (offset >= 0) {
            buf.append('+');
        } else {
            buf.append('-');
            offset = -offset;
        }
        int hours = offset / 3600000;
        FormatUtils.appendPaddedInteger(buf, hours, 2);
        int minutes = (offset -= hours * 3600000) / 60000;
        buf.append(':');
        FormatUtils.appendPaddedInteger(buf, minutes, 2);
        if ((offset -= minutes * 60000) == 0) {
            return buf.toString();
        }
        int seconds = offset / 1000;
        buf.append(':');
        FormatUtils.appendPaddedInteger(buf, seconds, 2);
        if ((offset -= seconds * 1000) == 0) {
            return buf.toString();
        }
        buf.append('.');
        FormatUtils.appendPaddedInteger(buf, offset, 3);
        return buf.toString();
    }

    protected DateTimeZone(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Id must not be null");
        }
        this.iID = id;
    }

    @ToString
    public final String getID() {
        return this.iID;
    }

    public abstract String getNameKey(long var1);

    public final String getShortName(long instant) {
        return this.getShortName(instant, null);
    }

    public String getShortName(long instant, Locale locale) {
        String nameKey;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((nameKey = this.getNameKey(instant)) == null) {
            return this.iID;
        }
        NameProvider np = DateTimeZone.getNameProvider();
        String name = np instanceof DefaultNameProvider ? ((DefaultNameProvider)np).getShortName(locale, this.iID, nameKey, this.isStandardOffset(instant)) : np.getShortName(locale, this.iID, nameKey);
        if (name != null) {
            return name;
        }
        return DateTimeZone.printOffset(this.getOffset(instant));
    }

    public final String getName(long instant) {
        return this.getName(instant, null);
    }

    public String getName(long instant, Locale locale) {
        String nameKey;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((nameKey = this.getNameKey(instant)) == null) {
            return this.iID;
        }
        NameProvider np = DateTimeZone.getNameProvider();
        String name = np instanceof DefaultNameProvider ? ((DefaultNameProvider)np).getName(locale, this.iID, nameKey, this.isStandardOffset(instant)) : np.getName(locale, this.iID, nameKey);
        if (name != null) {
            return name;
        }
        return DateTimeZone.printOffset(this.getOffset(instant));
    }

    public abstract int getOffset(long var1);

    public final int getOffset(ReadableInstant instant) {
        if (instant == null) {
            return this.getOffset(DateTimeUtils.currentTimeMillis());
        }
        return this.getOffset(instant.getMillis());
    }

    public abstract int getStandardOffset(long var1);

    public boolean isStandardOffset(long instant) {
        return this.getOffset(instant) == this.getStandardOffset(instant);
    }

    public int getOffsetFromLocal(long instantLocal) {
        int offsetPrev;
        int diff;
        long prev;
        long instantAdjusted;
        int offsetAdjusted;
        int offsetLocal = this.getOffset(instantLocal);
        if (offsetLocal != (offsetAdjusted = this.getOffset(instantAdjusted = instantLocal - (long)offsetLocal))) {
            if (offsetLocal - offsetAdjusted < 0) {
                long nextAdjusted;
                long nextLocal = this.nextTransition(instantAdjusted);
                if (nextLocal == instantLocal - (long)offsetLocal) {
                    nextLocal = Long.MAX_VALUE;
                }
                if ((nextAdjusted = this.nextTransition(instantLocal - (long)offsetAdjusted)) == instantLocal - (long)offsetAdjusted) {
                    nextAdjusted = Long.MAX_VALUE;
                }
                if (nextLocal != nextAdjusted) {
                    return offsetLocal;
                }
            }
        } else if (offsetLocal >= 0 && (prev = this.previousTransition(instantAdjusted)) < instantAdjusted && instantAdjusted - prev <= (long)(diff = (offsetPrev = this.getOffset(prev)) - offsetLocal)) {
            return offsetPrev;
        }
        return offsetAdjusted;
    }

    public long convertUTCToLocal(long instantUTC) {
        int offset = this.getOffset(instantUTC);
        long instantLocal = instantUTC + (long)offset;
        if ((instantUTC ^ instantLocal) < 0L && (instantUTC ^ (long)offset) >= 0L) {
            throw new ArithmeticException("Adding time zone offset caused overflow");
        }
        return instantLocal;
    }

    public long convertLocalToUTC(long instantLocal, boolean strict, long originalInstantUTC) {
        int offsetOriginal = this.getOffset(originalInstantUTC);
        long instantUTC = instantLocal - (long)offsetOriginal;
        int offsetLocalFromOriginal = this.getOffset(instantUTC);
        if (offsetLocalFromOriginal == offsetOriginal) {
            return instantUTC;
        }
        return this.convertLocalToUTC(instantLocal, strict);
    }

    public long convertLocalToUTC(long instantLocal, boolean strict) {
        long instantUTC;
        int offset;
        int offsetLocal = this.getOffset(instantLocal);
        if (offsetLocal != (offset = this.getOffset(instantLocal - (long)offsetLocal)) && (strict || offsetLocal < 0)) {
            long nextAdjusted;
            long nextLocal = this.nextTransition(instantLocal - (long)offsetLocal);
            if (nextLocal == instantLocal - (long)offsetLocal) {
                nextLocal = Long.MAX_VALUE;
            }
            if ((nextAdjusted = this.nextTransition(instantLocal - (long)offset)) == instantLocal - (long)offset) {
                nextAdjusted = Long.MAX_VALUE;
            }
            if (nextLocal != nextAdjusted) {
                if (strict) {
                    throw new IllegalInstantException(instantLocal, this.getID());
                }
                offset = offsetLocal;
            }
        }
        if ((instantLocal ^ (instantUTC = instantLocal - (long)offset)) < 0L && (instantLocal ^ (long)offset) < 0L) {
            throw new ArithmeticException("Subtracting time zone offset caused overflow");
        }
        return instantUTC;
    }

    public long getMillisKeepLocal(DateTimeZone newZone, long oldInstant) {
        if (newZone == null) {
            newZone = DateTimeZone.getDefault();
        }
        if (newZone == this) {
            return oldInstant;
        }
        long instantLocal = this.convertUTCToLocal(oldInstant);
        return newZone.convertLocalToUTC(instantLocal, false, oldInstant);
    }

    public boolean isLocalDateTimeGap(LocalDateTime localDateTime) {
        if (this.isFixed()) {
            return false;
        }
        try {
            localDateTime.toDateTime(this);
            return false;
        }
        catch (IllegalInstantException ex) {
            return true;
        }
    }

    public long adjustOffset(long instant, boolean earlierOrLater) {
        long offsetAfter;
        long instantBefore = instant - 10800000L;
        long instantAfter = instant + 10800000L;
        long offsetBefore = this.getOffset(instantBefore);
        if (offsetBefore <= (offsetAfter = (long)this.getOffset(instantAfter))) {
            return instant;
        }
        long diff = offsetBefore - offsetAfter;
        long transition = this.nextTransition(instantBefore);
        long overlapStart = transition - diff;
        long overlapEnd = transition + diff;
        if (instant < overlapStart || instant >= overlapEnd) {
            return instant;
        }
        long afterStart = instant - overlapStart;
        if (afterStart >= diff) {
            return earlierOrLater ? instant : instant - diff;
        }
        return earlierOrLater ? instant + diff : instant;
    }

    public abstract boolean isFixed();

    public abstract long nextTransition(long var1);

    public abstract long previousTransition(long var1);

    public TimeZone toTimeZone() {
        return TimeZone.getTimeZone(this.iID);
    }

    public abstract boolean equals(Object var1);

    public int hashCode() {
        return 57 + this.getID().hashCode();
    }

    public String toString() {
        return this.getID();
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new Stub(this.iID);
    }

    static final class LazyInit {
        static final Map<String, String> CONVERSION_MAP = LazyInit.buildMap();
        static final DateTimeFormatter OFFSET_FORMATTER = LazyInit.buildFormatter();

        LazyInit() {
        }

        private static DateTimeFormatter buildFormatter() {
            BaseChronology chrono = new BaseChronology(){
                private static final long serialVersionUID = -3128740902654445468L;

                @Override
                public DateTimeZone getZone() {
                    return null;
                }

                @Override
                public Chronology withUTC() {
                    return this;
                }

                @Override
                public Chronology withZone(DateTimeZone zone) {
                    return this;
                }

                @Override
                public String toString() {
                    return this.getClass().getName();
                }
            };
            return new DateTimeFormatterBuilder().appendTimeZoneOffset(null, true, 2, 4).toFormatter().withChronology(chrono);
        }

        private static Map<String, String> buildMap() {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("GMT", "UTC");
            map.put("WET", "WET");
            map.put("CET", "CET");
            map.put("MET", "CET");
            map.put("ECT", "CET");
            map.put("EET", "EET");
            map.put("MIT", "Pacific/Apia");
            map.put("HST", "Pacific/Honolulu");
            map.put("AST", "America/Anchorage");
            map.put("PST", "America/Los_Angeles");
            map.put("MST", "America/Denver");
            map.put("PNT", "America/Phoenix");
            map.put("CST", "America/Chicago");
            map.put("EST", "America/New_York");
            map.put("IET", "America/Indiana/Indianapolis");
            map.put("PRT", "America/Puerto_Rico");
            map.put("CNT", "America/St_Johns");
            map.put("AGT", "America/Argentina/Buenos_Aires");
            map.put("BET", "America/Sao_Paulo");
            map.put("ART", "Africa/Cairo");
            map.put("CAT", "Africa/Harare");
            map.put("EAT", "Africa/Addis_Ababa");
            map.put("NET", "Asia/Yerevan");
            map.put("PLT", "Asia/Karachi");
            map.put("IST", "Asia/Kolkata");
            map.put("BST", "Asia/Dhaka");
            map.put("VST", "Asia/Ho_Chi_Minh");
            map.put("CTT", "Asia/Shanghai");
            map.put("JST", "Asia/Tokyo");
            map.put("ACT", "Australia/Darwin");
            map.put("AET", "Australia/Sydney");
            map.put("SST", "Pacific/Guadalcanal");
            map.put("NST", "Pacific/Auckland");
            return Collections.unmodifiableMap(map);
        }
    }

    private static final class Stub
    implements Serializable {
        private static final long serialVersionUID = -6471952376487863581L;
        private transient String iID;

        Stub(String id) {
            this.iID = id;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeUTF(this.iID);
        }

        private void readObject(ObjectInputStream in) throws IOException {
            this.iID = in.readUTF();
        }

        private Object readResolve() throws ObjectStreamException {
            return DateTimeZone.forID(this.iID);
        }
    }
}

