/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BaseInterval;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public final class Interval
extends BaseInterval
implements ReadableInterval,
Serializable {
    private static final long serialVersionUID = 4922451897541386752L;

    public static Interval parse(String str) {
        return new Interval(str);
    }

    public static Interval parseWithOffset(String str) {
        int separator = str.indexOf(47);
        if (separator < 0) {
            throw new IllegalArgumentException("Format requires a '/' separator: " + str);
        }
        String leftStr = str.substring(0, separator);
        if (leftStr.length() <= 0) {
            throw new IllegalArgumentException("Format invalid: " + str);
        }
        String rightStr = str.substring(separator + 1);
        if (rightStr.length() <= 0) {
            throw new IllegalArgumentException("Format invalid: " + str);
        }
        DateTimeFormatter dateTimeParser = ISODateTimeFormat.dateTimeParser().withOffsetParsed();
        PeriodFormatter periodParser = ISOPeriodFormat.standard();
        DateTime start = null;
        Period period = null;
        char c = leftStr.charAt(0);
        if (c == 'P' || c == 'p') {
            period = periodParser.withParseType(PeriodType.standard()).parsePeriod(leftStr);
        } else {
            start = dateTimeParser.parseDateTime(leftStr);
        }
        c = rightStr.charAt(0);
        if (c == 'P' || c == 'p') {
            if (period != null) {
                throw new IllegalArgumentException("Interval composed of two durations: " + str);
            }
            period = periodParser.withParseType(PeriodType.standard()).parsePeriod(rightStr);
            return new Interval((ReadableInstant)start, period);
        }
        DateTime end = dateTimeParser.parseDateTime(rightStr);
        if (period != null) {
            return new Interval(period, (ReadableInstant)end);
        }
        return new Interval((ReadableInstant)start, (ReadableInstant)end);
    }

    public Interval(long startInstant, long endInstant) {
        super(startInstant, endInstant, null);
    }

    public Interval(long startInstant, long endInstant, DateTimeZone zone) {
        super(startInstant, endInstant, ISOChronology.getInstance(zone));
    }

    public Interval(long startInstant, long endInstant, Chronology chronology) {
        super(startInstant, endInstant, chronology);
    }

    public Interval(ReadableInstant start, ReadableInstant end) {
        super(start, end);
    }

    public Interval(ReadableInstant start, ReadableDuration duration) {
        super(start, duration);
    }

    public Interval(ReadableDuration duration, ReadableInstant end) {
        super(duration, end);
    }

    public Interval(ReadableInstant start, ReadablePeriod period) {
        super(start, period);
    }

    public Interval(ReadablePeriod period, ReadableInstant end) {
        super(period, end);
    }

    public Interval(Object interval) {
        super(interval, null);
    }

    public Interval(Object interval, Chronology chronology) {
        super(interval, chronology);
    }

    @Override
    public Interval toInterval() {
        return this;
    }

    public Interval overlap(ReadableInterval interval) {
        if (!this.overlaps(interval = DateTimeUtils.getReadableInterval(interval))) {
            return null;
        }
        long start = Math.max(this.getStartMillis(), interval.getStartMillis());
        long end = Math.min(this.getEndMillis(), interval.getEndMillis());
        return new Interval(start, end, this.getChronology());
    }

    public Interval gap(ReadableInterval interval) {
        interval = DateTimeUtils.getReadableInterval(interval);
        long otherStart = interval.getStartMillis();
        long otherEnd = interval.getEndMillis();
        long thisStart = this.getStartMillis();
        long thisEnd = this.getEndMillis();
        if (thisStart > otherEnd) {
            return new Interval(otherEnd, thisStart, this.getChronology());
        }
        if (otherStart > thisEnd) {
            return new Interval(thisEnd, otherStart, this.getChronology());
        }
        return null;
    }

    public boolean abuts(ReadableInterval interval) {
        if (interval == null) {
            long now = DateTimeUtils.currentTimeMillis();
            return this.getStartMillis() == now || this.getEndMillis() == now;
        }
        return interval.getEndMillis() == this.getStartMillis() || this.getEndMillis() == interval.getStartMillis();
    }

    public Interval withChronology(Chronology chronology) {
        if (this.getChronology() == chronology) {
            return this;
        }
        return new Interval(this.getStartMillis(), this.getEndMillis(), chronology);
    }

    public Interval withStartMillis(long startInstant) {
        if (startInstant == this.getStartMillis()) {
            return this;
        }
        return new Interval(startInstant, this.getEndMillis(), this.getChronology());
    }

    public Interval withStart(ReadableInstant start) {
        long startMillis = DateTimeUtils.getInstantMillis(start);
        return this.withStartMillis(startMillis);
    }

    public Interval withEndMillis(long endInstant) {
        if (endInstant == this.getEndMillis()) {
            return this;
        }
        return new Interval(this.getStartMillis(), endInstant, this.getChronology());
    }

    public Interval withEnd(ReadableInstant end) {
        long endMillis = DateTimeUtils.getInstantMillis(end);
        return this.withEndMillis(endMillis);
    }

    public Interval withDurationAfterStart(ReadableDuration duration) {
        long durationMillis = DateTimeUtils.getDurationMillis(duration);
        if (durationMillis == this.toDurationMillis()) {
            return this;
        }
        Chronology chrono = this.getChronology();
        long startMillis = this.getStartMillis();
        long endMillis = chrono.add(startMillis, durationMillis, 1);
        return new Interval(startMillis, endMillis, chrono);
    }

    public Interval withDurationBeforeEnd(ReadableDuration duration) {
        long durationMillis = DateTimeUtils.getDurationMillis(duration);
        if (durationMillis == this.toDurationMillis()) {
            return this;
        }
        Chronology chrono = this.getChronology();
        long endMillis = this.getEndMillis();
        long startMillis = chrono.add(endMillis, durationMillis, -1);
        return new Interval(startMillis, endMillis, chrono);
    }

    public Interval withPeriodAfterStart(ReadablePeriod period) {
        if (period == null) {
            return this.withDurationAfterStart(null);
        }
        Chronology chrono = this.getChronology();
        long startMillis = this.getStartMillis();
        long endMillis = chrono.add(period, startMillis, 1);
        return new Interval(startMillis, endMillis, chrono);
    }

    public Interval withPeriodBeforeEnd(ReadablePeriod period) {
        if (period == null) {
            return this.withDurationBeforeEnd(null);
        }
        Chronology chrono = this.getChronology();
        long endMillis = this.getEndMillis();
        long startMillis = chrono.add(period, endMillis, -1);
        return new Interval(startMillis, endMillis, chrono);
    }
}

