/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import org.joda.convert.ToString;
import org.joda.time.DurationFieldType;
import org.joda.time.MutablePeriod;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public abstract class AbstractPeriod
implements ReadablePeriod {
    protected AbstractPeriod() {
    }

    @Override
    public int size() {
        return this.getPeriodType().size();
    }

    @Override
    public DurationFieldType getFieldType(int index) {
        return this.getPeriodType().getFieldType(index);
    }

    public DurationFieldType[] getFieldTypes() {
        DurationFieldType[] result = new DurationFieldType[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getFieldType(i);
        }
        return result;
    }

    public int[] getValues() {
        int[] result = new int[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getValue(i);
        }
        return result;
    }

    @Override
    public int get(DurationFieldType type) {
        int index = this.indexOf(type);
        if (index == -1) {
            return 0;
        }
        return this.getValue(index);
    }

    @Override
    public boolean isSupported(DurationFieldType type) {
        return this.getPeriodType().isSupported(type);
    }

    public int indexOf(DurationFieldType type) {
        return this.getPeriodType().indexOf(type);
    }

    @Override
    public Period toPeriod() {
        return new Period(this);
    }

    @Override
    public MutablePeriod toMutablePeriod() {
        return new MutablePeriod(this);
    }

    @Override
    public boolean equals(Object period) {
        if (this == period) {
            return true;
        }
        if (!(period instanceof ReadablePeriod)) {
            return false;
        }
        ReadablePeriod other = (ReadablePeriod)period;
        if (this.size() != other.size()) {
            return false;
        }
        int isize = this.size();
        for (int i = 0; i < isize; ++i) {
            if (this.getValue(i) == other.getValue(i) && this.getFieldType(i) == other.getFieldType(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int total = 17;
        int isize = this.size();
        for (int i = 0; i < isize; ++i) {
            total = 27 * total + this.getValue(i);
            total = 27 * total + this.getFieldType(i).hashCode();
        }
        return total;
    }

    @Override
    @ToString
    public String toString() {
        return ISOPeriodFormat.standard().print(this);
    }

    public String toString(PeriodFormatter formatter) {
        if (formatter == null) {
            return this.toString();
        }
        return formatter.print(this);
    }
}

