/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.field.DelegatedDateTimeField;
import org.joda.time.field.FieldUtils;

public final class SkipUndoDateTimeField
extends DelegatedDateTimeField {
    private static final long serialVersionUID = -5875876968979L;
    private final Chronology iChronology;
    private final int iSkip;
    private transient int iMinValue;

    public SkipUndoDateTimeField(Chronology chronology, DateTimeField field) {
        this(chronology, field, 0);
    }

    public SkipUndoDateTimeField(Chronology chronology, DateTimeField field, int skip) {
        super(field);
        this.iChronology = chronology;
        int min = super.getMinimumValue();
        this.iMinValue = min < skip ? min + 1 : (min == skip + 1 ? skip : min);
        this.iSkip = skip;
    }

    @Override
    public int get(long millis) {
        int value = super.get(millis);
        if (value < this.iSkip) {
            ++value;
        }
        return value;
    }

    @Override
    public long set(long millis, int value) {
        FieldUtils.verifyValueBounds(this, value, this.iMinValue, this.getMaximumValue());
        if (value <= this.iSkip) {
            --value;
        }
        return super.set(millis, value);
    }

    @Override
    public int getMinimumValue() {
        return this.iMinValue;
    }

    private Object readResolve() {
        return this.getType().getField(this.iChronology);
    }
}

