/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.net.http.server.application.config;

import java.util.Optional;
import java.util.ServiceLoader;
import org.xbib.config.ConfigLoader;
import org.xbib.config.ConfigLogger;
import org.xbib.config.ConfigParams;
import org.xbib.config.SystemConfigLogger;
import org.xbib.net.http.server.Application;
import org.xbib.net.http.server.BaseApplicationModule;
import org.xbib.net.http.server.HttpRequest;
import org.xbib.net.http.server.HttpServerContext;
import org.xbib.net.http.server.HttpService;
import org.xbib.settings.Settings;

public class ConfigApplicationModule
extends BaseApplicationModule {
    private static final ConfigLogger bootLogger;
    private ConfigParams configParams;
    private ConfigLoader configLoader;
    private Settings settings;

    public String getName() {
        return "config";
    }

    public void onOpen(Application application) throws Exception {
        String profile = System.getProperty("application.profile");
        if (profile == null) {
            profile = "developer";
        }
        String[] args = profile.split(";");
        this.configParams = new ConfigParams().withArgs(args).withDirectoryName("application").withFileNamesWithoutSuffix(new String[]{args[0]}).withSystemEnvironment().withSystemProperties();
        this.configLoader = ConfigLoader.getInstance().withLogger(bootLogger);
        this.settings = this.configLoader.load(this.configParams);
    }

    public void onOpen(Application application, HttpServerContext httpServerContext, HttpService httpService) {
        httpServerContext.attributes().put((Object)"configparams", (Object)this.configParams);
        httpServerContext.attributes().put((Object)"configloader", (Object)this.configLoader);
        httpServerContext.attributes().put((Object)"settings", (Object)this.settings);
    }

    public void onOpen(Application application, HttpServerContext httpServerContext, HttpService httpService, HttpRequest httpRequest) {
    }

    static {
        ServiceLoader<ConfigLogger> serviceLoader = ServiceLoader.load(ConfigLogger.class);
        Optional<ConfigLogger> optionalBootLogger = serviceLoader.findFirst();
        bootLogger = optionalBootLogger.orElse((ConfigLogger)new SystemConfigLogger());
    }
}

