/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common;

import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Range;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;

public interface Condition {
    public static Condition buildFrom(Object operator, Object limit) {
        if (operator instanceof Types.TypeConditionOperatorRel) {
            if (limit instanceof Number) {
                return new ConditionVal((Types.TypeConditionOperatorRel)((Object)operator), ((Number)limit).longValue());
            }
            return new ConditionVar((Types.TypeConditionOperatorRel)((Object)operator), (IVar)limit);
        }
        if (limit instanceof Range) {
            Utilities.control(((Range)limit).step == 1, "Pb with range");
            return new ConditionIntvl((Types.TypeConditionOperatorSet)((Object)operator), ((Range)limit).minIncluded, ((Range)limit).maxIncluded);
        }
        return new ConditionIntset((Types.TypeConditionOperatorSet)((Object)operator), (int[])limit);
    }

    default public IVar involvedVar() {
        return null;
    }

    public static class ConditionIntset
    extends ConditionSet {
        public int[] t;

        public ConditionIntset(Types.TypeConditionOperatorSet operator, int[] t) {
            super(operator);
            t = IntStream.of(t).sorted().distinct().toArray();
            Utilities.control(t.length > 0, "The sepcified array is not valid.");
            this.t = t;
        }

        public String toString() {
            return "(" + this.operator.name().toLowerCase() + ",{" + Utilities.join(this.t, ",") + "})";
        }
    }

    public static class ConditionIntvl
    extends ConditionSet {
        public long min;
        public long max;

        public ConditionIntvl(Types.TypeConditionOperatorSet operator, long min, long max) {
            super(operator);
            Utilities.control(min <= max, "The sepcified bouds are not valid.");
            this.min = min;
            this.max = max;
        }

        public String toString() {
            return "(" + this.operator.name().toLowerCase() + "," + this.min + ".." + this.max + ")";
        }
    }

    public static abstract class ConditionSet
    implements Condition {
        public Types.TypeConditionOperatorSet operator;

        public ConditionSet(Types.TypeConditionOperatorSet operator) {
            this.operator = operator;
        }
    }

    public static class ConditionVal
    extends ConditionRel {
        public long k;

        public ConditionVal(Types.TypeConditionOperatorRel operator, long k) {
            super(operator);
            this.k = k;
        }

        public String toString() {
            return "(" + this.operator.name().toLowerCase() + "," + this.k + ")";
        }
    }

    public static class ConditionVar
    extends ConditionRel {
        public IVar x;

        public ConditionVar(Types.TypeConditionOperatorRel operator, IVar x) {
            super(operator);
            this.x = x;
        }

        @Override
        public IVar involvedVar() {
            return this.x;
        }

        public String toString() {
            return "(" + this.operator.name().toLowerCase() + "," + this.x + ")";
        }
    }

    public static abstract class ConditionRel
    implements Condition {
        public Types.TypeConditionOperatorRel operator;

        public ConditionRel(Types.TypeConditionOperatorRel operator) {
            this.operator = operator;
        }
    }
}

