/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xcsp.common.Constants;
import org.xcsp.common.Range;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeLeaf;
import org.xcsp.parser.entries.XVariables;
import org.xcsp.parser.exceptions.WrongTypeException;

public class Utilities {
    public static final Comparator<int[]> lexComparatorInt = (t1, t2) -> {
        for (int i = 0; i < ((int[])t1).length; ++i) {
            if (t1[i] < t2[i]) {
                return -1;
            }
            if (t1[i] <= t2[i]) continue;
            return 1;
        }
        return 0;
    };
    public static final Comparator<String[]> lexComparatorString = (t1, t2) -> {
        for (int i = 0; i < ((String[])t1).length; ++i) {
            int res = t1[i].compareTo(t2[i]);
            if (res == 0) continue;
            return res;
        }
        return 0;
    };

    public static Object firstNonNull(Object array) {
        if (array != null && array.getClass().isArray()) {
            return IntStream.range(0, Array.getLength(array)).mapToObj(i -> Utilities.firstNonNull(Array.get(array, i))).filter(o -> o != null).findFirst().orElse(null);
        }
        return array;
    }

    public static <T> T[] convert(Collection<T> list) {
        Object obj = list.stream().filter(o -> o != null).findFirst().orElse(null);
        if (obj == null) {
            return null;
        }
        Object[] ts = (Object[])Array.newInstance(obj.getClass(), list.size());
        int i = 0;
        for (T x : list) {
            ts[i++] = x;
        }
        return ts;
    }

    private static <T> List<T> collectRec(Class<T> clazz, List<T> list, Object src) {
        if (src != null) {
            if (src instanceof Stream) {
                ((Stream)src).forEach(o -> Utilities.collectRec(clazz, list, o));
            } else if (src.getClass().isArray()) {
                IntStream.range(0, Array.getLength(src)).forEach(i -> Utilities.collectRec(clazz, list, Array.get(src, i)));
            } else if (clazz.isAssignableFrom(src.getClass())) {
                list.add(clazz.cast(src));
            }
        }
        return list;
    }

    public static <T> T[] collect(Class<T> clazz, Object ... src) {
        ArrayList list = new ArrayList();
        Stream.of(src).forEach(o -> Utilities.collectRec(clazz, list, o));
        return Utilities.convert(list.stream().collect(Collectors.toList()));
    }

    public static <T> T[] collectDistinct(Class<T> clazz, Object ... src) {
        ArrayList list = new ArrayList();
        Stream.of(src).forEach(o -> Utilities.collectRec(clazz, list, o));
        return Utilities.convert(list.stream().distinct().collect(Collectors.toList()));
    }

    public static int[] flatten(int[][] m) {
        return Stream.of(m).filter(t -> t != null).flatMapToInt(t -> Arrays.stream(t)).toArray();
    }

    public static int[] flatten(int[][][] c) {
        return Stream.of(c).filter(m -> m != null).flatMapToInt(m -> Arrays.stream(Utilities.flatten(m))).toArray();
    }

    public static int[] collectVals(Object ... valsToConcat) {
        assert (valsToConcat.length > 0 && Stream.of(valsToConcat).allMatch(o -> o instanceof Integer || o instanceof int[] || o instanceof int[][] || o instanceof int[][][] || o instanceof Range));
        return Stream.of(valsToConcat).map(o -> {
            int[] nArray;
            if (o instanceof Integer) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = (Integer)o;
            } else {
                nArray = o instanceof Range ? ((Range)o).toArray() : (o instanceof int[][][] ? Utilities.flatten((int[][][])o) : (o instanceof int[][] ? Utilities.flatten((int[][])o) : (int[])o));
            }
            return nArray;
        }).flatMapToInt(t -> Arrays.stream(t)).toArray();
    }

    public static boolean isNumeric(String token) {
        return token.matches("-?\\d+(\\.\\d+)?");
    }

    public static boolean isNumericInterval(String token) {
        return token.matches("-?\\d+\\.\\.-?\\d+");
    }

    public static Boolean toBoolean(String s) {
        if ((s = s.toLowerCase()).equals("yes") || s.equals("y") || s.equals("true") || s.equals("t") || s.equals("1")) {
            return Boolean.TRUE;
        }
        if (s.equals("no") || s.equals("n") || s.equals("false") || s.equals("f") || s.equals("0")) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static boolean isInteger(String token) {
        try {
            Integer.parseInt(token);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static Integer toInteger(String token, Predicate<Integer> p) {
        try {
            Integer i = Integer.parseInt(token);
            Utilities.control(p == null || p.test(i), "Value " + i + " not accepted by " + p);
            return i;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static Integer toInteger(String token) {
        return Utilities.toInteger(token, null);
    }

    public static Double toDouble(String token, Predicate<Double> p) {
        try {
            Double d = Double.parseDouble(token);
            Utilities.control(p == null || p.test(d), "Value " + d + " not accepted by " + p);
            return d;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static double toDouble(String token) {
        return Utilities.toDouble(token, null);
    }

    private static BigInteger recursiveFactorial(long start, long n) {
        if (n <= 16L) {
            BigInteger r = BigInteger.valueOf(start);
            for (long i = start + 1L; i < start + n; ++i) {
                r = r.multiply(BigInteger.valueOf(i));
            }
            return r;
        }
        long i = n / 2L;
        return Utilities.recursiveFactorial(start, i).multiply(Utilities.recursiveFactorial(start + i, n - i));
    }

    public static BigInteger factorial(int n) {
        return Utilities.recursiveFactorial(1L, n);
    }

    public static BigInteger binomial(int n, int k) {
        if (k < 0 || n < k) {
            return BigInteger.ZERO;
        }
        if (k > n - k) {
            k = n - k;
        }
        BigInteger i = BigInteger.ONE;
        for (int v = 0; v < k; ++v) {
            i = i.multiply(BigInteger.valueOf(n - v)).divide(BigInteger.valueOf(v + 1));
        }
        return i;
    }

    public static BigInteger nArrangementsFor(int[] nValues) {
        return IntStream.of(nValues).mapToObj(v -> BigInteger.valueOf(v)).reduce(BigInteger.ONE, (acc, v) -> acc.multiply((BigInteger)v));
    }

    public static int[] splitToInts(String s, String regex) {
        return Arrays.stream(s.trim().split(regex)).filter(tok -> tok.length() > 0).mapToInt(tok -> Integer.parseInt(tok)).toArray();
    }

    public static int[] splitToInts(String s) {
        return Utilities.splitToInts(s, "\\s+");
    }

    public static Object[] specificArrayFrom(List<Object> list) {
        Object firstObject = list.stream().filter(o -> o != null).findFirst().orElse(null);
        Class<?> clazz = firstObject == null ? null : (list.stream().noneMatch(o -> o != null && o.getClass() != firstObject.getClass()) ? firstObject.getClass() : null);
        return clazz == null ? list.toArray() : list.toArray((Object[])Array.newInstance(clazz, list.size()));
    }

    public static Object[][] specificArray2DFrom(List<Object[]> list) {
        Class<?> clazz = list.stream().noneMatch(o -> o.getClass() != ((Object[])list.get(0)).getClass()) ? list.get(0).getClass() : null;
        return clazz == null ? (Object[][])list.toArray((T[])new Object[0][]) : (Object[][])list.toArray((T[])((Object[][])Array.newInstance(clazz, list.size())));
    }

    public static boolean contains(int[] tab, int v, int from, int to) {
        return IntStream.rangeClosed(from, to).anyMatch(i -> tab[i] == v);
    }

    public static boolean contains(int[] tab, int v) {
        return Utilities.contains(tab, v, 0, tab.length - 1);
    }

    public static int indexOf(String s, String ... t) {
        return IntStream.range(0, t.length).filter(i -> t[i].equals(s)).findFirst().orElse(-1);
    }

    public static int indexOf(String s, List<Object> list) {
        return IntStream.range(0, list.size()).filter(i -> list.get(i).equals(s)).findFirst().orElse(-1);
    }

    public static int indexOf(int value, int[] t) {
        for (int i = 0; i < t.length; ++i) {
            if (value != t[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(Object value, Object[] t) {
        return IntStream.range(0, t.length).filter(i -> t[i] == value).findFirst().orElse(-1);
    }

    public static boolean hasSize(Object array, int ... size) {
        boolean b2;
        boolean b1 = array != null && array.getClass().isArray();
        boolean bl = b2 = size.length > 0;
        if (!b1 && !b2) {
            return true;
        }
        if (b1 && !b2 || !b1 && b2 || Array.getLength(array) != size[0]) {
            return false;
        }
        return IntStream.range(0, size[0]).noneMatch(i -> !Utilities.hasSize(Array.get(array, i), Arrays.stream(size).skip(1L).toArray()));
    }

    public static boolean isRegular(Object array) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Object a = array;
        while (a != null && a.getClass().isArray()) {
            list.add(Array.getLength(a));
            a = Array.getLength(a) == 0 ? null : Array.get(a, 0);
        }
        return Utilities.hasSize(array, list.stream().mapToInt(i -> i).toArray());
    }

    public static Object control(boolean condition, String message) {
        if (!condition) {
            System.out.println("\n\nFatal Error: " + message);
            throw new RuntimeException();
        }
        return null;
    }

    public static Object exit(String message) {
        return Utilities.control(false, message);
    }

    public static boolean checkSafeArithmeticOperation(Runnable r) {
        try {
            r.run();
            return true;
        }
        catch (ArithmeticException e) {
            return false;
        }
    }

    public static Long safeLong(String s, boolean checkSpecialValues) {
        if (checkSpecialValues) {
            if (s.equals("+infinity")) {
                return Long.MAX_VALUE;
            }
            if (s.equals("-infinity")) {
                return Long.MIN_VALUE;
            }
        }
        if (s.length() > 18) {
            BigInteger big = new BigInteger(s);
            Utilities.control(big.compareTo(Constants.BIG_MIN_SAFE_LONG) >= 0 && big.compareTo(Constants.BIG_MAX_SAFE_LONG) <= 0, "Too small or big value for this parser : " + s);
            return big.longValue();
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw new WrongTypeException("\"" + s + "\" is not an integer expression");
        }
    }

    public static Long safeLong(String s) {
        return Utilities.safeLong(s, false);
    }

    public static boolean isSafeInt(long l, boolean useMargin) {
        return (useMargin ? -2147483638L : Integer.MIN_VALUE) <= l && l <= (useMargin ? 0x7FFFFFF5L : Integer.MAX_VALUE);
    }

    public static boolean isSafeInt(long l) {
        return Utilities.isSafeInt(l, true);
    }

    public static int safeLong2Int(long l, boolean useMargin) {
        Utilities.control(Utilities.isSafeInt(l, useMargin), "Too big integer value " + l);
        return (int)l;
    }

    public static int safeLong2Int(Number number, boolean useMargin) {
        return Utilities.safeLong2Int(number.longValue(), useMargin);
    }

    public static int safeLong2IntWhileHandlingInfinity(long l, boolean useMargin) {
        return l == Long.MIN_VALUE ? Integer.MIN_VALUE : (l == Long.MAX_VALUE ? Integer.MAX_VALUE : Utilities.safeLong2Int(l, true));
    }

    public static <T> T[] sort(T[] t) {
        Arrays.sort(t);
        return t;
    }

    public static <T> T[] swap(T[] t, int i, int j) {
        T tmp = t[i];
        t[i] = t[j];
        t[j] = tmp;
        return t;
    }

    public static String join(Object array, String delimiter) {
        StringBuilder sb = new StringBuilder();
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object item = Array.get(array, i);
            if (item != null && item.getClass().isArray()) {
                sb.append("[").append(Utilities.join(item, delimiter)).append("]");
                continue;
            }
            sb.append(item != null ? item.toString() : "null").append(i < length - 1 ? delimiter : "");
        }
        return sb.toString();
    }

    public static String join(Object array) {
        return Utilities.join(array, " ");
    }

    public static String join(Collection<? extends Object> c) {
        return Utilities.join(c.toArray());
    }

    public static <K, V> String join(Map<K, V> m, String separator, String delimiter) {
        return m.entrySet().stream().map(e -> e.getKey() + separator + e.getValue()).reduce("", (n, p) -> n + (n.length() == 0 ? "" : delimiter) + p);
    }

    public static String join(Object[][] m, String separator, String delimiter) {
        return Arrays.stream(m).map(t -> Utilities.join(t, delimiter)).reduce("", (n, p) -> n + (n.length() == 0 ? "" : separator) + p);
    }

    public static String join(int[][] m, String separator, String delimiter) {
        return Arrays.stream(m).map(t -> Utilities.join(t, delimiter)).reduce("", (n, p) -> n + (n.length() == 0 ? "" : separator) + p);
    }

    public static String toCamelCase(String s) {
        String[] words = s.split("_");
        return IntStream.range(0, words.length).mapToObj(i -> i == 0 ? words[i].toLowerCase() : words[i].substring(0, 1).toUpperCase() + words[i].substring(1).toLowerCase()).collect(Collectors.joining());
    }

    public static String arrayToString(Object array, char LEFT, char RIGHT, String SEP) {
        assert (array.getClass().isArray());
        if (array instanceof boolean[]) {
            return Arrays.toString((boolean[])array);
        }
        if (array instanceof byte[]) {
            return Arrays.toString((byte[])array);
        }
        if (array instanceof short[]) {
            return Arrays.toString((short[])array);
        }
        if (array instanceof int[]) {
            return Arrays.toString((int[])array);
        }
        if (array instanceof long[]) {
            return Arrays.toString((long[])array);
        }
        if (array instanceof String[]) {
            return LEFT + String.join((CharSequence)SEP, (String[])array) + RIGHT;
        }
        if (array instanceof XVariables.XVar[]) {
            return LEFT + String.join((CharSequence)SEP, (CharSequence[])Stream.of((XVariables.XVar[])array).map(x -> x.toString()).toArray(String[]::new)) + RIGHT;
        }
        if (array instanceof boolean[][]) {
            return LEFT + String.join((CharSequence)SEP, (CharSequence[])Stream.of((boolean[][])array).map(t -> Utilities.arrayToString(t, LEFT, RIGHT, SEP)).toArray(String[]::new)) + RIGHT;
        }
        if (array instanceof byte[][]) {
            return LEFT + String.join((CharSequence)SEP, (CharSequence[])Stream.of((byte[][])array).map(t -> Utilities.arrayToString(t, LEFT, RIGHT, SEP)).toArray(String[]::new)) + RIGHT;
        }
        if (array instanceof short[][]) {
            return LEFT + String.join((CharSequence)SEP, (CharSequence[])Stream.of((short[][])array).map(t -> Utilities.arrayToString(t, LEFT, RIGHT, SEP)).toArray(String[]::new)) + RIGHT;
        }
        if (array instanceof int[][]) {
            return LEFT + String.join((CharSequence)SEP, (CharSequence[])Stream.of((int[][])array).map(t -> Utilities.arrayToString(t, LEFT, RIGHT, SEP)).toArray(String[]::new)) + RIGHT;
        }
        if (array instanceof long[][]) {
            return LEFT + String.join((CharSequence)SEP, (CharSequence[])Stream.of((long[][])array).map(t -> Utilities.arrayToString(t, LEFT, RIGHT, SEP)).toArray(String[]::new)) + RIGHT;
        }
        if (array instanceof String[][]) {
            return LEFT + String.join((CharSequence)SEP, (CharSequence[])Stream.of((String[][])array).map(t -> Utilities.arrayToString(t, LEFT, RIGHT, SEP)).toArray(String[]::new)) + RIGHT;
        }
        if (array instanceof boolean[][][]) {
            return LEFT + String.join((CharSequence)SEP, (CharSequence[])Stream.of((boolean[][][])array).map(t -> Utilities.arrayToString(t, LEFT, RIGHT, SEP)).toArray(String[]::new)) + RIGHT;
        }
        if (array instanceof byte[][][]) {
            return LEFT + String.join((CharSequence)SEP, (CharSequence[])Stream.of((byte[][][])array).map(t -> Utilities.arrayToString(t, LEFT, RIGHT, SEP)).toArray(String[]::new)) + RIGHT;
        }
        if (array instanceof short[][][]) {
            return LEFT + String.join((CharSequence)SEP, (CharSequence[])Stream.of((short[][][])array).map(t -> Utilities.arrayToString(t, LEFT, RIGHT, SEP)).toArray(String[]::new)) + RIGHT;
        }
        if (array instanceof int[][][]) {
            return LEFT + String.join((CharSequence)SEP, (CharSequence[])Stream.of((int[][][])array).map(t -> Utilities.arrayToString(t, LEFT, RIGHT, SEP)).toArray(String[]::new)) + RIGHT;
        }
        if (array instanceof long[][][]) {
            return LEFT + String.join((CharSequence)SEP, (CharSequence[])Stream.of((long[][][])array).map(t -> Utilities.arrayToString(t, LEFT, RIGHT, SEP)).toArray(String[]::new)) + RIGHT;
        }
        if (array instanceof String[][][]) {
            return LEFT + String.join((CharSequence)SEP, (CharSequence[])Stream.of((String[][][])array).map(t -> Utilities.arrayToString(t, LEFT, RIGHT, SEP)).toArray(String[]::new)) + RIGHT;
        }
        if (array instanceof Long[][]) {
            return LEFT + String.join((CharSequence)SEP, (CharSequence[])Stream.of((Long[][])array).map(t -> Utilities.arrayToString(t, LEFT, RIGHT, SEP)).toArray(String[]::new)) + RIGHT;
        }
        if (array instanceof XVariables.XVar[][]) {
            return LEFT + String.join((CharSequence)SEP, (CharSequence[])Stream.of((XVariables.XVar[][])array).map(t -> Utilities.arrayToString(t, LEFT, RIGHT, SEP)).toArray(String[]::new)) + RIGHT;
        }
        if (array instanceof Object[][]) {
            return LEFT + String.join((CharSequence)SEP, (CharSequence[])Stream.of((Object[][])array).map(t -> Utilities.arrayToString(t)).toArray(String[]::new)) + RIGHT;
        }
        if (array instanceof Object[]) {
            return String.join((CharSequence)SEP, (CharSequence[])Stream.of((Object[])array).map(t -> t.getClass().isArray() ? LEFT + Utilities.arrayToString(t) + RIGHT : t.toString()).toArray(String[]::new));
        }
        return null;
    }

    public static String arrayToString(Object array) {
        return Utilities.arrayToString(array, '[', ']', ", ");
    }

    public static boolean check(Object obj, Predicate<Object> p) {
        if (obj instanceof Object[]) {
            return IntStream.range(0, Array.getLength(obj)).anyMatch(i -> Utilities.check(Array.get(obj, i), p));
        }
        if (obj instanceof XNode) {
            return ((XNode)obj).firstNodeSuchThat(n -> n instanceof XNodeLeaf && p.test(((XNodeLeaf)n).value)) != null;
        }
        return p.test(obj);
    }

    public static Document loadDocument(String fileName) throws Exception {
        if (fileName.endsWith("xml.bz2") || fileName.endsWith("xml.lzma")) {
            Process p = Runtime.getRuntime().exec((fileName.endsWith("xml.bz2") ? "bunzip2 -c " : "lzma -c -d ") + fileName);
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(p.getInputStream());
            p.waitFor();
            return document;
        }
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new FileInputStream(new File(fileName)));
    }

    public static void save(Document document, PrintWriter out) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(out));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String save(Document document, String fileName) {
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));){
            Utilities.save(document, out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileName;
    }

    public static Element[] childElementsOf(Element element) {
        NodeList childs = element.getChildNodes();
        return (Element[])IntStream.range(0, childs.getLength()).mapToObj(i -> childs.item(i)).filter(e -> e.getNodeType() == 1).toArray(Element[]::new);
    }

    public static boolean isTag(Element elt, Types.TypeChild type) {
        return elt.getTagName().equals(type.name());
    }

    public static Element element(Document doc, String tag, List<Element> sons) {
        Element elt = doc.createElement(tag);
        sons.stream().forEach(c -> elt.appendChild((Node)c));
        return elt;
    }

    public static Element element(Document doc, String tag, Element son) {
        return Utilities.element(doc, tag, Arrays.asList(son));
    }

    public static Element element(Document doc, String tag, Element son, Element ... otherSons) {
        return Utilities.element(doc, tag, IntStream.range(0, 1 + otherSons.length).mapToObj(i -> i == 0 ? son : otherSons[i - 1]).collect(Collectors.toList()));
    }

    public static Element element(Document doc, String tag, Element son, Stream<Element> otherSons) {
        return Utilities.element(doc, tag, Stream.concat(Stream.of(son), otherSons).collect(Collectors.toList()));
    }

    public static Element element(Document doc, String tag, Object textContent) {
        Element elt = doc.createElement(tag);
        elt.setTextContent(" " + textContent + " ");
        return elt;
    }

    public static Element element(Document doc, String tag, String attName, String attValue, Object textContent) {
        Element elt = Utilities.element(doc, tag, textContent);
        elt.setAttribute(attName, attValue);
        return elt;
    }

    public static Element element(Document doc, String tag, String attName, String attValue) {
        Element elt = doc.createElement(tag);
        elt.setAttribute(attName, attValue);
        return elt;
    }

    public static Element element(Document doc, String tag, String attName1, String attValue1, String attName2, String attValue2) {
        Element elt = doc.createElement(tag);
        elt.setAttribute(attName1, attValue1);
        elt.setAttribute(attName2, attValue2);
        return elt;
    }

    public static Element element(Document doc, String tag, Collection<Map.Entry<String, Object>> attributes) {
        Element elt = doc.createElement(tag);
        if (attributes != null) {
            attributes.stream().forEach(e -> elt.setAttribute((String)e.getKey(), e.getValue().toString()));
        }
        return elt;
    }

    public static class ModifiableBoolean {
        public Boolean value;

        public ModifiableBoolean(Boolean value) {
            this.value = value;
        }
    }
}

