/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.structures;

import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Utilities;
import org.xcsp.common.structures.Transition;
import org.xcsp.common.structures.Transitions;

public final class Automaton {
    public final Transition[] transitions;
    public final String startState;
    public final String[] finalStates;

    public Automaton(Transition[] transitions, String startState, String ... finalStates) {
        this.transitions = transitions;
        this.startState = startState;
        this.finalStates = finalStates;
    }

    public Automaton(Transitions transitions, String startState, String ... finalStates) {
        this(transitions.toArray(), startState, finalStates);
    }

    @Deprecated
    public Automaton(int[] nonogramPattern) {
        Function<Integer, String> q = i -> "q" + i;
        int nbStates = 0;
        Transitions transitions = new Transitions();
        if (nonogramPattern.length == 0) {
            nbStates = 1;
            transitions.add(q.apply(0), 0, q.apply(0));
        } else {
            nbStates = IntStream.of(nonogramPattern).sum() + nonogramPattern.length;
            int num = 0;
            for (int i2 = 0; i2 < nonogramPattern.length; ++i2) {
                transitions.add(q.apply(num), 0, q.apply(num));
                for (int j = 0; j < nonogramPattern[i2]; ++j) {
                    transitions.add(q.apply(num), 1, q.apply(num + 1));
                    ++num;
                }
                if (i2 >= nonogramPattern.length - 1) continue;
                transitions.add(q.apply(num), 0, q.apply(num + 1));
                ++num;
            }
            transitions.add(q.apply(num), 0, q.apply(num));
        }
        this.transitions = transitions.toArray();
        this.startState = q.apply(0);
        this.finalStates = new String[]{q.apply(nbStates - 1)};
    }

    public Automaton(String expression) {
        Utilities.exit("Unimplemented code; converting regular expressions into an automaton");
        this.transitions = null;
        this.startState = null;
        this.finalStates = null;
    }

    public String toString() {
        return "startState=" + this.startState + " finalStates={" + Utilities.join(this.finalStates) + "} \ntransitions={" + Stream.of(this.transitions).map(t -> t.toString()).collect(Collectors.joining()) + "}";
    }
}

