/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.modeler;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Condition;
import org.xcsp.common.FunctionalInterfaces;
import org.xcsp.common.IVar;
import org.xcsp.common.Range;
import org.xcsp.common.Size;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.common.structures.Automaton;
import org.xcsp.common.structures.TableInteger;
import org.xcsp.common.structures.TableSymbolic;
import org.xcsp.common.structures.Transition;
import org.xcsp.modeler.entities.CtrEntities;
import org.xcsp.modeler.entities.ObjEntities;
import org.xcsp.modeler.implementation.ProblemIMP;
import org.xcsp.parser.entries.XDomains;

public interface ProblemAPI {
    public static final Map<ProblemAPI, ProblemIMP> api2imp = new HashMap<ProblemAPI, ProblemIMP>();
    public static final Types.TypeConditionOperatorRel LT = Types.TypeConditionOperatorRel.LT;
    public static final Types.TypeConditionOperatorRel LE = Types.TypeConditionOperatorRel.LE;
    public static final Types.TypeConditionOperatorRel GE = Types.TypeConditionOperatorRel.GE;
    public static final Types.TypeConditionOperatorRel GT = Types.TypeConditionOperatorRel.GT;
    public static final Types.TypeConditionOperatorRel NE = Types.TypeConditionOperatorRel.NE;
    public static final Types.TypeConditionOperatorRel EQ = Types.TypeConditionOperatorRel.EQ;
    public static final Types.TypeConditionOperatorSet IN = Types.TypeConditionOperatorSet.IN;
    public static final Types.TypeConditionOperatorSet NOTIN = Types.TypeConditionOperatorSet.NOTIN;
    public static final Types.TypeOperatorRel STRICTLY_INCREASING = Types.TypeOperatorRel.LT;
    public static final Types.TypeOperatorRel INCREASING = Types.TypeOperatorRel.LE;
    public static final Types.TypeOperatorRel DECREASING = Types.TypeOperatorRel.GE;
    public static final Types.TypeOperatorRel STRICTLY_DECREASING = Types.TypeOperatorRel.GT;
    public static final Types.TypeObjective EXPRESSION = Types.TypeObjective.EXPRESSION;
    public static final Types.TypeObjective SUM = Types.TypeObjective.SUM;
    public static final Types.TypeObjective PRODUCT = Types.TypeObjective.PRODUCT;
    public static final Types.TypeObjective MINIMUM = Types.TypeObjective.MINIMUM;
    public static final Types.TypeObjective MAXIMUM = Types.TypeObjective.MAXIMUM;
    public static final Types.TypeObjective NVALUES = Types.TypeObjective.NVALUES;
    public static final Types.TypeObjective LEX = Types.TypeObjective.LEX;
    public static final Types.TypeClass CHANNELING = Types.StandardClass.CHANNELING;
    public static final Types.TypeClass CLUES = Types.StandardClass.CLUES;
    public static final Types.TypeClass ROWS = Types.StandardClass.ROWS;
    public static final Types.TypeClass COLUMNS = Types.StandardClass.COLUMNS;
    public static final Types.TypeClass BLOCKS = Types.StandardClass.BLOCKS;
    public static final Types.TypeClass DIAGONALS = Types.StandardClass.DIAGONALS;
    public static final Types.TypeClass SYMMETRY_BREAKING = Types.StandardClass.SYMMETRY_BREAKING;
    public static final Types.TypeClass REDUNDANT_CONSTRAINTS = Types.StandardClass.REDUNDANT_CONSTRAINTS;
    public static final Types.TypeClass NOGOODS = Types.StandardClass.NOGOODS;
    public static final Types.TypeRank FIRST = Types.TypeRank.FIRST;
    public static final Types.TypeRank LAST = Types.TypeRank.LAST;
    public static final Types.TypeRank ANY = Types.TypeRank.ANY;
    public static final Boolean POSITIVE = Boolean.TRUE;
    public static final Boolean NEGATIVE = Boolean.FALSE;
    public static final int STAR_INT = 0x7FFFFFFE;
    public static final String STAR_SYMBOL = "*";

    default public void control(boolean b, Object ... objects) {
        ProblemIMP.control(b, objects);
    }

    default public ProblemIMP imp() {
        this.control(api2imp.get(this) != null, "The method has been called before the associated problem implementation object was created.");
        return api2imp.get(this);
    }

    default public String name() {
        return this.imp().name();
    }

    default public boolean isModel(String s) {
        return s.equals(this.imp().model);
    }

    default public <T extends IVar> T[] select(T[] vars, int fromIndex, int toIndex) {
        this.control(Utilities.firstNonNull(vars) != null, "The specified array must contain at least one non-null variable.");
        this.control(0 <= fromIndex && fromIndex < toIndex && toIndex <= vars.length, "The specified indexes are not correct.");
        IVar[] t = (IVar[])Utilities.convert(IntStream.range(fromIndex, toIndex).mapToObj(i -> vars[i]).filter(x -> x != null).collect(Collectors.toList()));
        return t != null ? t : (IVar[])Array.newInstance(Utilities.firstNonNull(vars).getClass(), 0);
    }

    default public <T extends IVar> T[] select(T[] vars, int[] indexes) {
        this.control(Utilities.firstNonNull(vars) != null, "The specified array must contain at least one non-null variable.");
        this.control(IntStream.of(indexes).allMatch(i -> 0 <= i && i < vars.length), "The indexes in the specified array are not correct.");
        IVar[] t = (IVar[])Utilities.convert(Arrays.stream(indexes).mapToObj(i -> vars[i]).filter(x -> x != null).collect(Collectors.toList()));
        return t != null ? t : (IVar[])Array.newInstance(Utilities.firstNonNull(vars).getClass(), 0);
    }

    default public <T extends IVar> T[] select(T[] vars, FunctionalInterfaces.Intx1Predicate p) {
        this.control(Utilities.firstNonNull(vars) != null, "The specified array must contain at least one non-null variable.");
        IVar[] t = (IVar[])Utilities.convert(FunctionalInterfaces.Intx1Predicate.select(vars, p, new ArrayList()));
        return t != null ? t : (IVar[])Array.newInstance(Utilities.firstNonNull(vars).getClass(), 0);
    }

    default public <T extends IVar> T[] select(T[][] vars, FunctionalInterfaces.Intx2Predicate p) {
        this.control(Utilities.firstNonNull(vars) != null, "The specified array must contain at least one non-null variable.");
        IVar[] t = (IVar[])Utilities.convert(FunctionalInterfaces.Intx2Predicate.select(vars, p, new ArrayList()));
        return t != null ? t : (IVar[])Array.newInstance(Utilities.firstNonNull(vars).getClass(), 0);
    }

    default public <T extends IVar> T[] select(T[][][] vars, FunctionalInterfaces.Intx3Predicate p) {
        this.control(Utilities.firstNonNull(vars) != null, "The specified array must contain at least one non-null variable.");
        IVar[] t = (IVar[])Utilities.convert(FunctionalInterfaces.Intx3Predicate.select(vars, (FunctionalInterfaces.Intx3Predicate)p, new ArrayList()));
        return t != null ? t : (IVar[])Array.newInstance(Utilities.firstNonNull(vars).getClass(), 0);
    }

    default public <T extends IVar> T[] select(T[][][][] vars, FunctionalInterfaces.Intx4Predicate p) {
        this.control(Utilities.firstNonNull(vars) != null, "The specified array must contain at least one non-null variable.");
        IVar[] t = (IVar[])Utilities.convert(FunctionalInterfaces.Intx4Predicate.select(vars, (FunctionalInterfaces.Intx4Predicate)p, new ArrayList()));
        return t != null ? t : (IVar[])Array.newInstance(Utilities.firstNonNull(vars).getClass(), 0);
    }

    default public <T extends IVar> T[] select(T[][][][][] vars, FunctionalInterfaces.Intx5Predicate p) {
        this.control(Utilities.firstNonNull(vars) != null, "The specified array must contain at least one non-null variable.");
        IVar[] t = (IVar[])Utilities.convert(FunctionalInterfaces.Intx5Predicate.select(vars, (FunctionalInterfaces.Intx5Predicate)p, new ArrayList()));
        return t != null ? t : (IVar[])Array.newInstance(Utilities.firstNonNull(vars).getClass(), 0);
    }

    default public <T extends IVar> T[] select(T[] vars, Range range) {
        return this.select((IVar[])vars, i -> range.contains(i));
    }

    default public <T extends IVar> T[] select(T[][] vars, Range.Rangesx2 rangesx2) {
        return this.select((IVar[][])vars, (i, j) -> rangesx2.contains(new int[]{i, j}));
    }

    default public <T extends IVar> T[] select(T[][][] vars, Range.Rangesx3 rangesx3) {
        return this.select((IVar[][][])vars, (i, j, k) -> rangesx3.contains(new int[]{i, j, k}));
    }

    default public <T extends IVar> T[] select(T[][][][] vars, Range.Rangesx4 rangesx4) {
        return this.select((IVar[][][][])vars, (i, j, k, l) -> rangesx4.contains(new int[]{i, j}));
    }

    default public <T extends IVar> T[] select(T[][][][][] vars, Range.Rangesx5 rangesx5) {
        return this.select((IVar[][][][][])vars, (i, j, k, l, m) -> rangesx5.contains(new int[]{i, j, k, l, m}));
    }

    default public <T extends IVar> T[] columnOf(T[][] vars, int idColumn) {
        this.control(Utilities.firstNonNull(vars) != null, "The specified array must contain at least one non-null object.");
        this.control(0 <= idColumn && Stream.of(vars).allMatch(t -> t != null && idColumn < ((IVar[])t).length), "The specified index is not valid.");
        IVar[] t2 = (IVar[])Utilities.convert(Stream.of(vars).map(p -> p[idColumn]).collect(Collectors.toList()));
        return t2 != null ? t2 : (IVar[])Array.newInstance(Utilities.firstNonNull(vars).getClass(), vars.length);
    }

    default public <T extends IVar> T[] diagonalDown(T[][] vars, int idDiagonal) {
        this.control(Utilities.isRegular(vars), "The specified array must have the same number of rows and columns");
        this.control(0 <= idDiagonal && idDiagonal < vars.length, "The specified index is not valid.");
        IVar[] t = (IVar[])Utilities.convert(IntStream.range(0, vars.length).mapToObj(i -> vars[i][i < idDiagonal ? vars.length - (idDiagonal - i) : i - idDiagonal]).collect(Collectors.toList()));
        return t != null ? t : (IVar[])Array.newInstance(Utilities.firstNonNull(vars).getClass(), vars.length);
    }

    default public <T extends IVar> T[] diagonalUp(T[][] vars, int idDiagonal) {
        this.control(Utilities.isRegular(vars), "The specified array must have the same number of rows and columns");
        this.control(0 <= idDiagonal && idDiagonal < vars.length, "The specified index is not valid.");
        IVar[] t = (IVar[])Utilities.convert(IntStream.range(0, vars.length).mapToObj(i -> vars[i][i < vars.length - idDiagonal ? vars.length - idDiagonal - i - 1 : 2 * vars.length - idDiagonal - i - 1]).collect(Collectors.toList()));
        return t != null ? t : (IVar[])Array.newInstance(Utilities.firstNonNull(vars).getClass(), vars.length);
    }

    default public <T extends IVar> T[] diagonalDown(T[][] vars) {
        return this.diagonalDown((IVar[][])vars, 0);
    }

    default public <T extends IVar> T[] diagonalUp(T[][] vars) {
        return this.diagonalUp((IVar[][])vars, 0);
    }

    default public <T extends IVar> T[] diagonalDown(T[][] vars, int i, int j) {
        this.control(Utilities.isRegular(vars) && vars.length == vars[0].length, "");
        this.control(i == 0 && 0 <= j && j < vars.length - 1 || j == 0 && 0 <= i && i < vars.length - 1, "");
        return (IVar[])Utilities.convert(IntStream.range(0, vars.length - Math.max(i, j)).mapToObj(k -> vars[i + k][j + k]).collect(Collectors.toList()));
    }

    default public <T extends IVar> T[] diagonalUp(T[][] vars, int i, int j) {
        this.control(Utilities.isRegular(vars) && vars.length == vars[0].length, "");
        this.control(j == 0 && 0 < i && j < vars.length || i == vars.length - 1 && 0 <= j && j < vars.length - 1, "");
        return (IVar[])Utilities.convert(IntStream.range(0, Math.min(i + 1, vars.length - j)).mapToObj(k -> vars[i - k][j + k]).collect(Collectors.toList()));
    }

    default public <T extends IVar> T[][] transpose(T[] ... vars) {
        this.control(Utilities.isRegular(vars), "The specified array must have the same number of rows and columns");
        this.control(Utilities.firstNonNull(vars) != null, "The specified array must contain at least one non-null variable.");
        IVar[][] t = (IVar[][])Array.newInstance(Utilities.firstNonNull(vars).getClass(), vars[0].length, vars.length);
        IntStream.range(0, t.length).forEach(i -> IntStream.range(0, t[0].length).forEach(j -> {
            t[i][j] = vars[j][i];
        }));
        return t;
    }

    default public <T extends IVar> T[][] eliminateDim2(T[][][] vars, int idx) {
        this.control(Utilities.isRegular(vars), "The specified array must be regular");
        this.control(Utilities.firstNonNull(vars) != null, "The specified array must contain at least one non-null variable.");
        IVar[][] m = (IVar[][])Array.newInstance(vars[0][0][0].getClass(), vars.length, vars[0][0].length);
        IntStream.range(0, m.length).forEach(i -> IntStream.range(0, m[0].length).forEach(j -> {
            m[i][j] = vars[i][idx][j];
        }));
        return m;
    }

    default public <T extends IVar> T[][] eliminateDim3(T[][][] vars, int idx) {
        this.control(Utilities.isRegular(vars), "The specified array must be regular");
        this.control(Utilities.firstNonNull(vars) != null, "The specified array must contain at least one non-null variable.");
        IVar[][] m = (IVar[][])Array.newInstance(vars[0][0][0].getClass(), vars.length, vars[0].length);
        IntStream.range(0, m.length).forEach(i -> IntStream.range(0, m[0].length).forEach(j -> {
            m[i][j] = vars[i][j][idx];
        }));
        return m;
    }

    default public <T extends IVar> T[] vars(Object first, Object ... others) {
        return this.imp().vars(first, others);
    }

    default public <T extends IVar> T[] vars(Stream<T> stream) {
        return this.imp().vars(stream);
    }

    default public <T extends IVar> T[] vars(T x) {
        return this.imp().vars(x);
    }

    default public <T extends IVar> T[] vars(T x, T y) {
        return this.imp().vars(x, y);
    }

    default public <T extends IVar> T[] vars(T x, T y, T z) {
        return this.imp().vars(x, y, z);
    }

    default public <T extends IVar> T[] vars(T x, T y, T z, T ... otherVars) {
        return this.imp().vars(x, y, z, (IVar[])otherVars);
    }

    default public <T extends IVar> T[] vars(T[][] vars) {
        return this.imp().vars((IVar[][])vars);
    }

    default public <T extends IVar> T[] vars(T[][][] vars) {
        return this.imp().vars((IVar[][][])vars);
    }

    default public <T extends IVar> T[] vars(T[][][][] vars) {
        return this.imp().vars((IVar[][][][])vars);
    }

    default public <T extends IVar> T[] vars(T[][][][][] vars) {
        return this.imp().vars((IVar[][][][][])vars);
    }

    default public <T extends IVar> T[] vars(Object first, T x) {
        return this.imp().vars(first, x);
    }

    default public <T extends IVar> T[] vars(Object first, T[] vars) {
        return this.imp().vars(first, (IVar[])vars);
    }

    default public <T extends IVar> T[] vars(Object first, T[][] vars) {
        return this.imp().vars(first, (IVar[][])vars);
    }

    default public <T extends IVar> T[] clean(T[] vars) {
        return this.imp().clean((IVar[])vars);
    }

    default public <T extends IVar> T[] distinctSorted(T[] vars) {
        return this.imp().distinctSorted((IVar[])vars);
    }

    default public int[] vals(Object ... objects) {
        return Utilities.collectVals(objects);
    }

    default public int[] tuple(int val, int ... otherVals) {
        return IntStream.range(0, otherVals.length + 1).map(i -> i == 0 ? val : otherVals[i - 1]).toArray();
    }

    default public int[][] tuples(int[] tuple, int[] ... otherTuples) {
        return (int[][])IntStream.range(0, otherTuples.length + 1).mapToObj(i -> i == 0 ? tuple : otherTuples[i - 1]).toArray(x$0 -> new int[x$0][]);
    }

    default public String[] tuple(String symbol, String ... otherSymbols) {
        return (String[])IntStream.range(0, otherSymbols.length + 1).mapToObj(i -> i == 0 ? symbol : otherSymbols[i - 1]).toArray(String[]::new);
    }

    default public String[][] tuples(String[] tuple, String[] ... otherTuples) {
        return (String[][])IntStream.range(0, otherTuples.length + 1).mapToObj(i -> i == 0 ? tuple : otherTuples[i - 1]).toArray(x$0 -> new String[x$0][]);
    }

    default public int[] select(int[] t, int fromIndex, int toIndex) {
        this.control(0 <= fromIndex && fromIndex < toIndex && toIndex <= t.length, "The specified indexes are not correct.");
        return IntStream.range(fromIndex, toIndex).map(i -> t[i]).toArray();
    }

    default public int[] select(int[] t, int[] indexes) {
        this.control(IntStream.of(indexes).allMatch(i -> 0 <= i && i < t.length), "The indexes in the specified array are not correct.");
        return IntStream.of(indexes).map(i -> t[i]).toArray();
    }

    default public int[] select(int[] t, FunctionalInterfaces.Intx1Predicate p) {
        return IntStream.range(0, t.length).filter(i -> p.test(i)).map(i -> t[i]).toArray();
    }

    default public int[] select(int[][] m, FunctionalInterfaces.Intx2Predicate p) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i2 = 0; i2 < m.length; ++i2) {
            for (int j = 0; j < m[i2].length; ++j) {
                if (!p.test(i2, j)) continue;
                list.add(m[i2][j]);
            }
        }
        return list.stream().mapToInt(i -> i).toArray();
    }

    default public int[] select(int[][][] c, FunctionalInterfaces.Intx3Predicate p) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i2 = 0; i2 < c.length; ++i2) {
            for (int j = 0; j < c[i2].length; ++j) {
                for (int k = 0; k < c[i2][j].length; ++k) {
                    if (!p.test(i2, j, k)) continue;
                    list.add(c[i2][j][k]);
                }
            }
        }
        return list.stream().mapToInt(i -> i).toArray();
    }

    default public int[] repeat(int value, int length) {
        return IntStream.generate(() -> value).limit(length).toArray();
    }

    default public int[][] dub(int[] values) {
        return (int[][])Arrays.stream(values).mapToObj(v -> this.tuple(v, new int[0])).toArray(x$0 -> new int[x$0][]);
    }

    /*
     * Exception decompiling
     */
    default public String[][] dub(String[] values) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    default public int[] columnOf(int[][] m, int idColumn) {
        this.control(0 <= idColumn && Stream.of(m).allMatch(t -> t != null && idColumn < ((int[])t).length), "The specified index is not valid.");
        return Stream.of(m).mapToInt(t -> t[idColumn]).toArray();
    }

    default public int[][] transpose(int[] ... m) {
        this.control(Utilities.isRegular(m), "The specified array must have the same number of rows and columns");
        return (int[][])IntStream.range(0, m[0].length).mapToObj(i -> IntStream.range(0, m.length).map(j -> m[j][i]).toArray()).toArray(x$0 -> new int[x$0][]);
    }

    default public boolean contains(int[] t, int v) {
        return IntStream.of(t).anyMatch(w -> w == v);
    }

    default public int[] distinctSorted(int ... t) {
        return IntStream.of(t).sorted().distinct().toArray();
    }

    default public int[] distinctSorted(int[] t, FunctionalInterfaces.Intx1Predicate p) {
        return IntStream.of(t).sorted().distinct().filter(v -> p.test(v)).toArray();
    }

    default public int[] distinctSorted(int[][] m) {
        return Stream.of(m).map(t -> Arrays.stream(t)).flatMapToInt(i -> i).distinct().sorted().toArray();
    }

    default public int[][] addColumn(int[] t, IntUnaryOperator f) {
        return (int[][])IntStream.of(t).mapToObj(p -> this.tuple(p, f.applyAsInt(p))).toArray(x$0 -> new int[x$0][]);
    }

    default public int[][] number(int ... t) {
        return (int[][])IntStream.range(0, t.length).mapToObj(i -> this.tuple(i, t[i])).toArray(x$0 -> new int[x$0][]);
    }

    default public int[][] number(int[] t, FunctionalInterfaces.Intx1Predicate p) {
        return (int[][])IntStream.range(0, t.length).filter(i -> p.test(i)).mapToObj(i -> this.tuple(i, t[i])).toArray(x$0 -> new int[x$0][]);
    }

    default public int[][] numberx2(int[][] m, FunctionalInterfaces.Intx2Predicate p) {
        return (int[][])IntStream.range(0, m.length).mapToObj(i -> IntStream.range(0, m[i].length).filter(j -> p.test(i, j)).mapToObj(j -> this.vals(i, j, m[i][j]))).flatMap(s -> s).toArray(x$0 -> new int[x$0][]);
    }

    default public int[][] clean(int[] ... tuples) {
        TreeSet<int[]> set = new TreeSet<int[]>(Utilities.lexComparatorInt);
        for (int i = 0; i < tuples.length - 1; ++i) {
            if (set.size() > 0) {
                set.add(tuples[i]);
                continue;
            }
            if (Utilities.lexComparatorInt.compare(tuples[i], tuples[i + 1]) < 0) continue;
            for (int j = 0; j <= i; ++j) {
                set.add(tuples[j]);
            }
        }
        if (set.size() > 0) {
            set.add(tuples[tuples.length - 1]);
        }
        return set.size() == 0 ? tuples : (int[][])set.stream().toArray(x$0 -> new int[x$0][]);
    }

    default public int[][] clean(List<int[]> tuples) {
        return this.clean((int[][])tuples.stream().toArray(x$0 -> new int[x$0][]));
    }

    default public String[][] clean(String[][] tuples) {
        TreeSet<String[]> set = new TreeSet<String[]>(Utilities.lexComparatorString);
        for (int i = 0; i < tuples.length - 1; ++i) {
            if (set.size() > 0) {
                set.add(tuples[i]);
                continue;
            }
            if (Utilities.lexComparatorString.compare(tuples[i], tuples[i + 1]) < 0) continue;
            for (int j = 0; j <= i; ++j) {
                set.add(tuples[j]);
            }
        }
        if (set.size() > 0) {
            set.add(tuples[tuples.length - 1]);
        }
        return set.size() == 0 ? tuples : (String[][])set.stream().toArray(x$0 -> new String[x$0][]);
    }

    default public TableInteger table() {
        return new TableInteger();
    }

    default public TableInteger table(int ... tuple) {
        return new TableInteger().add(tuple);
    }

    default public TableInteger table(int[] ... tuples) {
        return new TableInteger().add(tuples);
    }

    default public TableInteger table(String tuples) {
        return new TableInteger().add(tuples);
    }

    default public TableSymbolic tableSymbolic() {
        return new TableSymbolic();
    }

    default public TableSymbolic tableSymbolic(String ... tuple) {
        return new TableSymbolic().add(tuple);
    }

    default public TableSymbolic tableSymbolic(String[] ... tuples) {
        return new TableSymbolic().add(tuples);
    }

    default public TableSymbolic tableSymbolic(String tuples) {
        return new TableSymbolic().addSequence(tuples);
    }

    default public Transition[] transitions(String transitions) {
        Stream<String> st = Stream.of(transitions.trim().split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L);
        return (Transition[])st.map(tok -> {
            String[] t = tok.split("\\s*,\\s*");
            this.control(t.length == 3, "Pb with a transition, which is not formed of 3 peices");
            return new Transition(t[0], Utilities.isInteger(t[1]) ? Integer.valueOf(Integer.parseInt(t[1])) : t[1], t[2]);
        }).toArray(Transition[]::new);
    }

    default public Automaton automaton(Transition[] transitions, String startState, String[] finalStates) {
        return new Automaton(transitions, startState, finalStates);
    }

    default public <T> T[] addObject(T[] t, T object, int index) {
        this.control(t != null && object != null, "The two first parameters must be diffrent from null");
        this.control(0 <= index && index <= t.length, "The sepcified index is not valid");
        Object[] tt = (Object[])Array.newInstance(object.getClass(), t.length + 1);
        for (int i = 0; i < tt.length; ++i) {
            tt[i] = i < index ? t[i] : (i == index ? object : t[i - 1]);
        }
        return tt;
    }

    default public XNodeParent<IVar.Var>[] trees(XNodeParent<?> ... trees) {
        return trees;
    }

    default public XDomains.XDomInteger dom(int[] values, FunctionalInterfaces.Intx1Predicate p) {
        this.control(values.length > 0, "At least one value must be spedified");
        values = IntStream.of(values).sorted().distinct().filter(v -> p == null || p.test(v)).toArray();
        return new XDomains.XDomInteger(values);
    }

    default public XDomains.XDomInteger dom(int[] values) {
        return this.dom(values, null);
    }

    default public XDomains.XDomInteger dom(int val, int ... otherVals) {
        return this.dom(IntStream.range(0, otherVals.length + 1).map(i -> i == 0 ? val : otherVals[i - 1]).toArray());
    }

    default public XDomains.XDomInteger dom(Collection<Integer> values) {
        return this.dom(values.stream().mapToInt(i -> i).toArray());
    }

    default public XDomains.XDomInteger dom(int[][] m) {
        return this.dom(Stream.of(m).map(t -> Arrays.stream(t)).flatMapToInt(i -> i).toArray());
    }

    default public XDomains.XDomInteger dom(Range range) {
        return range.step == 1 ? new XDomains.XDomInteger(range.minIncluded, range.maxIncluded) : new XDomains.XDomInteger(range.toArray());
    }

    default public XDomains.XDomSymbolic dom(String[] values) {
        this.control(values.length > 0, "At least one value must be spedified");
        values = (String[])Stream.of(values).distinct().toArray(String[]::new);
        return new XDomains.XDomSymbolic(values);
    }

    default public XDomains.XDomSymbolic dom(String val, String ... otherVals) {
        return new XDomains.XDomSymbolic((String[])IntStream.range(0, otherVals.length + 1).mapToObj(i -> i == 0 ? val : otherVals[i - 1]).toArray(String[]::new));
    }

    default public Size.Size1D size(int length) {
        this.control(length > 0, "The specified length must be strictly positive");
        return Size.Size1D.build(length);
    }

    default public Size.Size2D size(int length0, int length1) {
        this.control(length0 > 0 && length1 > 0, "The specified lengths must be strictly positive");
        return Size.Size2D.build(length0, length1);
    }

    default public Size.Size3D size(int length0, int length1, int length2) {
        this.control(length0 > 0 && length1 > 0 && length2 > 0, "The specified lengths must be strictly positive");
        return Size.Size3D.build(length0, length1, length2);
    }

    default public Size.Size4D size(int length0, int length1, int length2, int length3) {
        this.control(length0 > 0 && length1 > 0 && length2 > 0 && length3 > 0, "The specified lengths must be strictly positive");
        return Size.Size4D.build(length0, length1, length2, length3);
    }

    default public Size.Size5D size(int length0, int length1, int length2, int length3, int length4) {
        this.control(length0 > 0 && length1 > 0 && length2 > 0 && length3 > 0 && length4 > 0, "The specified lengths must be strictly positive");
        return Size.Size5D.build(length0, length1, length2, length3, length4);
    }

    default public Range range(int minIncluded, int maxIncluded, int step) {
        return this.imp().range(minIncluded, maxIncluded, step);
    }

    default public Range range(int minIncluded, int maxIncluded) {
        return this.imp().range(minIncluded, maxIncluded);
    }

    default public Range range(int length) {
        return this.imp().range(length);
    }

    default public IVar.Var var(String id, XDomains.XDomInteger dom, String note, Types.TypeClass ... classes) {
        IVar.Var x = this.imp().buildVarInteger(id, dom);
        if (x != null) {
            this.imp().varEntities.newVarAloneEntity(id, x, note, classes);
        }
        return x;
    }

    default public IVar.Var var(String id, XDomains.XDomInteger dom, Types.TypeClass ... classes) {
        return this.var(id, dom, (String)null, classes);
    }

    default public IVar.VarSymbolic var(String id, XDomains.XDomSymbolic dom, String note, Types.TypeClass ... classes) {
        IVar.VarSymbolic x = this.imp().buildVarSymbolic(id, dom);
        if (x != null) {
            this.imp().varEntities.newVarAloneEntity(id, x, note, classes);
        }
        return x;
    }

    default public IVar.VarSymbolic var(String id, XDomains.XDomSymbolic dom, Types.TypeClass ... classes) {
        return this.var(id, dom, (String)null, classes);
    }

    default public IVar.Var[] array(String id, Size.Size1D size, FunctionalInterfaces.IntToDomInteger f, String note, Types.TypeClass ... classes) {
        IVar.Var[] t = this.imp().fill(id, size, f, (IVar.Var[])Array.newInstance(this.imp().classVI(), size.lengths));
        this.imp().varEntities.newVarArrayEntity(id, size, t, note, classes);
        return t;
    }

    default public IVar.Var[] array(String id, Size.Size1D size, FunctionalInterfaces.IntToDomInteger f, Types.TypeClass ... classes) {
        return this.array(id, size, f, (String)null, classes);
    }

    default public IVar.Var[] array(String id, Size.Size1D size, XDomains.XDomInteger dom, String note, Types.TypeClass ... classes) {
        return this.array(id, size, (int i) -> dom, note, classes);
    }

    default public IVar.Var[] array(String id, Size.Size1D size, XDomains.XDomInteger dom, Types.TypeClass ... classes) {
        return this.array(id, size, (int i) -> dom, (String)null, classes);
    }

    default public IVar.VarSymbolic[] arraySymbolic(String id, Size.Size1D size, FunctionalInterfaces.IntToDomSymbolic f, String note, Types.TypeClass ... classes) {
        IVar.VarSymbolic[] t = this.imp().fill(id, size, f, (IVar.VarSymbolic[])Array.newInstance(this.imp().classVS(), size.lengths));
        this.imp().varEntities.newVarArrayEntity(id, size, t, note, classes);
        return t;
    }

    default public IVar.VarSymbolic[] arraySymbolic(String id, Size.Size1D size, FunctionalInterfaces.IntToDomSymbolic f, Types.TypeClass ... classes) {
        return this.arraySymbolic(id, size, f, (String)null, classes);
    }

    default public IVar.VarSymbolic[] arraySymbolic(String id, Size.Size1D size, XDomains.XDomSymbolic dom, String note, Types.TypeClass ... classes) {
        return this.arraySymbolic(id, size, (int i) -> dom, note, classes);
    }

    default public IVar.VarSymbolic[] arraySymbolic(String id, Size.Size1D size, XDomains.XDomSymbolic dom, Types.TypeClass ... classes) {
        return this.arraySymbolic(id, size, (int i) -> dom, (String)null, classes);
    }

    default public IVar.Var[][] array(String id, Size.Size2D size, FunctionalInterfaces.Intx2ToDomInteger f, String note, Types.TypeClass ... classes) {
        IVar.Var[][] m = this.imp().fill(id, size, f, (IVar.Var[][])Array.newInstance(this.imp().classVI(), size.lengths));
        this.imp().varEntities.newVarArrayEntity(id, size, m, note, classes);
        return m;
    }

    default public IVar.Var[][] array(String id, Size.Size2D size, FunctionalInterfaces.Intx2ToDomInteger f, Types.TypeClass ... classes) {
        return this.array(id, size, f, (String)null, classes);
    }

    default public IVar.Var[][] array(String id, Size.Size2D size, XDomains.XDomInteger dom, String note, Types.TypeClass ... classes) {
        return this.array(id, size, (int i, int j) -> dom, note, classes);
    }

    default public IVar.Var[][] array(String id, Size.Size2D size, XDomains.XDomInteger dom, Types.TypeClass ... classes) {
        return this.array(id, size, (int i, int j) -> dom, (String)null, classes);
    }

    default public IVar.VarSymbolic[][] arraySymbolic(String id, Size.Size2D size, FunctionalInterfaces.Intx2ToDomSymbolic f, String note, Types.TypeClass ... classes) {
        IVar.VarSymbolic[][] m = this.imp().fill(id, size, f, (IVar.VarSymbolic[][])Array.newInstance(this.imp().classVS(), size.lengths));
        this.imp().varEntities.newVarArrayEntity(id, size, m, note, classes);
        return m;
    }

    default public IVar.VarSymbolic[][] arraySymbolic(String id, Size.Size2D size, FunctionalInterfaces.Intx2ToDomSymbolic f, Types.TypeClass ... classes) {
        return this.arraySymbolic(id, size, f, (String)null, classes);
    }

    default public IVar.VarSymbolic[][] arraySymbolic(String id, Size.Size2D size, XDomains.XDomSymbolic dom, String note, Types.TypeClass ... classes) {
        return this.arraySymbolic(id, size, (int i, int j) -> dom, note, classes);
    }

    default public IVar.VarSymbolic[][] arraySymbolic(String id, Size.Size2D size, XDomains.XDomSymbolic dom, Types.TypeClass ... classes) {
        return this.arraySymbolic(id, size, (int i, int j) -> dom, (String)null, classes);
    }

    default public IVar.Var[][][] array(String id, Size.Size3D size, FunctionalInterfaces.Intx3ToDomInteger f, String note, Types.TypeClass ... classes) {
        IVar.Var[][][] m = this.imp().fill(id, size, f, (IVar.Var[][][])Array.newInstance(this.imp().classVI(), size.lengths));
        this.imp().varEntities.newVarArrayEntity(id, size, m, note, classes);
        return m;
    }

    default public IVar.Var[][][] array(String id, Size.Size3D size, FunctionalInterfaces.Intx3ToDomInteger f, Types.TypeClass ... classes) {
        return this.array(id, size, f, (String)null, classes);
    }

    default public IVar.Var[][][] array(String id, Size.Size3D size, XDomains.XDomInteger dom, String note, Types.TypeClass ... classes) {
        return this.array(id, size, (int i, int j, int k) -> dom, note, classes);
    }

    default public IVar.Var[][][] array(String id, Size.Size3D size, XDomains.XDomInteger dom, Types.TypeClass ... classes) {
        return this.array(id, size, (int i, int j, int k) -> dom, (String)null, classes);
    }

    default public IVar.Var[][][][] array(String id, Size.Size4D size, FunctionalInterfaces.Intx4ToDomInteger f, String note, Types.TypeClass ... classes) {
        IVar.Var[][][][] m = this.imp().fill(id, size, f, (IVar.Var[][][][])Array.newInstance(this.imp().classVI(), size.lengths));
        this.imp().varEntities.newVarArrayEntity(id, size, m, note, classes);
        return m;
    }

    default public IVar.Var[][][][] array(String id, Size.Size4D size, FunctionalInterfaces.Intx4ToDomInteger f, Types.TypeClass ... classes) {
        return this.array(id, size, f, (String)null, classes);
    }

    default public IVar.Var[][][][] array(String id, Size.Size4D size, XDomains.XDomInteger dom, String note, Types.TypeClass ... classes) {
        return this.array(id, size, (int i, int j, int k, int l) -> dom, note, classes);
    }

    default public IVar.Var[][][][] array(String id, Size.Size4D size, XDomains.XDomInteger dom, Types.TypeClass ... classes) {
        return this.array(id, size, (int i, int j, int k, int l) -> dom, (String)null, classes);
    }

    default public IVar.Var[][][][][] array(String id, Size.Size5D size, FunctionalInterfaces.Intx5ToDomInteger f, String note, Types.TypeClass ... classes) {
        IVar.Var[][][][][] q = this.imp().fill(id, size, f, (IVar.Var[][][][][])Array.newInstance(this.imp().classVI(), size.lengths));
        this.imp().varEntities.newVarArrayEntity(id, size, q, note, classes);
        return q;
    }

    default public IVar.Var[][][][][] array(String id, Size.Size5D size, FunctionalInterfaces.Intx5ToDomInteger f, Types.TypeClass ... classes) {
        return this.array(id, size, f, (String)null, classes);
    }

    default public IVar.Var[][][][][] array(String id, Size.Size5D size, XDomains.XDomInteger dom, String note, Types.TypeClass ... classes) {
        return this.array(id, size, (int i, int j, int k, int l, int m) -> dom, note, classes);
    }

    default public IVar.Var[][][][][] array(String id, Size.Size5D size, XDomains.XDomInteger dom, Types.TypeClass ... classes) {
        return this.array(id, size, (int i, int j, int k, int l, int m) -> dom, (String)null, classes);
    }

    default public Occurrences occursEachExactly(int occurs) {
        return new Occurrences.OccurrencesIntBasic(occurs);
    }

    default public Occurrences occursEachBetween(int occursMin, int occursMax) {
        return new Occurrences.OccurrencesIntRange(occursMin, occursMax);
    }

    default public Occurrences occurrences(int o1, int o2, int o3, int ... others) {
        return new Occurrences.OccurrencesIntSimple(IntStream.range(0, others.length + 3).map(i -> i == 0 ? o1 : (i == 1 ? o2 : (i == 2 ? o3 : others[i - 3]))).toArray());
    }

    default public Occurrences occurrences(int[] occurs) {
        return new Occurrences.OccurrencesIntSimple(occurs);
    }

    default public Occurrences occursBetween(int[] occursMin, int[] occursMax) {
        return new Occurrences.OccurrencesIntDouble(occursMin, occursMax);
    }

    default public Occurrences occurrences(IVar.Var ... occurs) {
        return new Occurrences.OccurrencesVar(occurs);
    }

    default public Condition condition(Types.TypeConditionOperatorRel op, long limit) {
        return new Condition.ConditionVal(op, limit);
    }

    default public Condition condition(Types.TypeConditionOperatorRel op, IVar.Var limit) {
        return new Condition.ConditionVar(op, limit);
    }

    default public Condition condition(Types.TypeConditionOperatorSet op, Range range) {
        this.control(range.step == 1 && range.length() >= 1, "Bad form of range");
        return new Condition.ConditionIntvl(op, range.minIncluded, range.maxIncluded);
    }

    default public Condition condition(Types.TypeConditionOperatorSet op, int[] values) {
        return new Condition.ConditionIntset(op, this.distinctSorted(values));
    }

    default public Index index(IVar.Var variable) {
        return new Index(variable);
    }

    default public Index index(IVar.Var variable, Types.TypeRank rank) {
        return new Index(variable, rank);
    }

    default public StartIndex startIndex(int value) {
        return new StartIndex(value);
    }

    default public CtrEntities.CtrEntity ctrFalse(IVar.Var[] scp) {
        return this.extension(scp, (int[][])new int[0][], POSITIVE);
    }

    default public CtrEntities.CtrEntity ctrFalse(IVar.VarSymbolic[] scp) {
        return this.extension(scp, (String[][])new String[0][], POSITIVE);
    }

    default public CtrEntities.CtrEntity ctrTrue(IVar.Var[] scp) {
        return this.extension(scp, (int[][])new int[0][], NEGATIVE);
    }

    default public CtrEntities.CtrEntity ctrTrue(IVar.VarSymbolic[] scp) {
        return this.extension(scp, (String[][])new String[0][], NEGATIVE);
    }

    default public CtrEntities.CtrEntity intension(XNodeParent<IVar> tree) {
        return this.imp().intension(tree);
    }

    default public XNodeParent<IVar> abs(Object operand) {
        return this.imp().abs(operand);
    }

    default public XNodeParent<IVar> neg(Object operand) {
        return this.imp().neg(operand);
    }

    default public XNodeParent<IVar> sqr(Object operand) {
        return this.imp().sqr(operand);
    }

    default public XNodeParent<IVar> add(Object ... operands) {
        return this.imp().add(operands);
    }

    default public XNodeParent<IVar> sub(Object operand1, Object operand2) {
        return this.imp().sub(operand1, operand2);
    }

    default public XNodeParent<IVar> mul(Object ... operands) {
        return this.imp().mul(operands);
    }

    default public XNodeParent<IVar> div(Object operand1, Object operand2) {
        return this.imp().div(operand1, operand2);
    }

    default public XNodeParent<IVar> mod(Object operand1, Object operand2) {
        return this.imp().mod(operand1, operand2);
    }

    default public XNodeParent<IVar> pow(Object operand1, Object operand2) {
        return this.imp().pow(operand1, operand2);
    }

    default public XNodeParent<IVar> min(Object ... operands) {
        return this.imp().min(operands);
    }

    default public XNodeParent<IVar> max(Object ... operands) {
        return this.imp().max(operands);
    }

    default public XNodeParent<IVar> dist(Object operand1, Object operand2) {
        return this.imp().dist(operand1, operand2);
    }

    default public XNodeParent<IVar> lt(Object operand1, Object operand2) {
        return this.imp().lt(operand1, operand2);
    }

    default public XNodeParent<IVar> le(Object operand1, Object operand2) {
        return this.imp().le(operand1, operand2);
    }

    default public XNodeParent<IVar> ge(Object operand1, Object operand2) {
        return this.imp().ge(operand1, operand2);
    }

    default public XNodeParent<IVar> gt(Object operand1, Object operand2) {
        return this.imp().gt(operand1, operand2);
    }

    default public XNodeParent<IVar> ne(Object ... operands) {
        return this.imp().ne(operands);
    }

    default public XNodeParent<IVar> eq(Object ... operands) {
        return this.imp().eq(operands);
    }

    default public XNode<IVar> set(Object ... operands) {
        return this.imp().set(operands);
    }

    default public XNode<IVar> set(int[] operands) {
        return this.imp().set(operands);
    }

    default public XNodeParent<IVar> in(Object var, Object set) {
        return this.imp().in(var, set);
    }

    default public XNodeParent<IVar> notin(Object var, Object set) {
        return this.imp().notin(var, set);
    }

    default public XNodeParent<IVar> not(Object operand) {
        return this.imp().not(operand);
    }

    default public XNodeParent<IVar> and(Object ... operands) {
        return operands.length == 1 && operands[0] instanceof Stream ? this.imp().and(((Stream)operands[0]).toArray()) : this.imp().and(operands);
    }

    default public XNodeParent<IVar> or(Object ... operands) {
        return operands.length == 1 && operands[0] instanceof Stream ? this.imp().or(((Stream)operands[0]).toArray()) : this.imp().or(operands);
    }

    default public XNodeParent<IVar> xor(Object ... operands) {
        return this.imp().xor(operands);
    }

    default public XNodeParent<IVar> iff(Object ... operands) {
        return this.imp().iff(operands);
    }

    default public XNodeParent<IVar> imp(Object operand1, Object operand2) {
        return this.imp().imp(operand1, operand2);
    }

    default public XNodeParent<IVar> ifThenElse(Object operand1, Object operand2, Object operand3) {
        return this.imp().ifThenElse(operand1, operand2, operand3);
    }

    default public XNodeParent<IVar> knightAttack(IVar x, IVar y, int order) {
        XNodeParent<IVar> rowDist = this.dist(this.div(x, order), this.div(y, order));
        XNodeParent<IVar> colDist = this.dist(this.mod(x, order), this.mod(y, order));
        return this.or(this.and(this.eq(rowDist, 1), this.eq(colDist, 2)), this.and(this.eq(rowDist, 2), this.eq(colDist, 1)));
    }

    default public XNodeParent<IVar> queenAttack(IVar x, IVar y, int order) {
        XNodeParent<IVar> rowDist = this.dist(this.div(x, order), this.div(y, order));
        XNodeParent<IVar> colDist = this.dist(this.mod(x, order), this.mod(y, order));
        return this.and(this.ne(x, y), this.or(this.eq(this.mod(x, order), this.mod(y, order)), this.eq(this.div(x, order), this.div(y, order)), this.eq(rowDist, colDist)));
    }

    default public CtrEntities.CtrEntity lessThan(Object operand1, Object operand2) {
        return this.imp().lessThan(operand1, operand2);
    }

    default public CtrEntities.CtrEntity lessEqual(Object operand1, Object operand2) {
        return this.imp().lessEqual(operand1, operand2);
    }

    default public CtrEntities.CtrEntity greaterEqual(Object operand1, Object operand2) {
        return this.imp().greaterEqual(operand1, operand2);
    }

    default public CtrEntities.CtrEntity greaterThan(Object operand1, Object operand2) {
        return this.imp().greaterThan(operand1, operand2);
    }

    default public CtrEntities.CtrEntity equal(Object ... operands) {
        return this.imp().equal(operands);
    }

    default public CtrEntities.CtrEntity notEqual(Object ... operands) {
        return this.imp().notEqual(operands);
    }

    default public CtrEntities.CtrEntity imply(Object operand1, Object operand2) {
        return this.imp().imply(operand1, operand2);
    }

    default public CtrEntities.CtrEntity belong(Object operand1, Object operand2) {
        return this.imp().belong(operand1, operand2);
    }

    default public CtrEntities.CtrAlone extension(XNodeParent<IVar> tree) {
        return this.imp().extension(tree);
    }

    default public CtrEntities.CtrAlone extension(List<XNodeParent<IVar>> trees) {
        return this.imp().extension(trees);
    }

    default public CtrEntities.CtrAlone extension(XNodeParent<IVar> ... trees) {
        return this.extension(Arrays.asList(trees));
    }

    default public CtrEntities.CtrEntity extension(IVar.Var[] scp, int[][] tuples, Boolean positive) {
        return this.imp().extension(scp, tuples, (boolean)positive);
    }

    default public CtrEntities.CtrEntity extension(IVar.Var[] scp, int[] ... tuples) {
        return this.extension(scp, tuples, POSITIVE);
    }

    default public CtrEntities.CtrEntity extension(IVar.Var[] scp, TableInteger table) {
        return this.extension(scp, table instanceof TableInteger ? table.toArray() : (int[][])new int[0][], table.positive);
    }

    default public CtrEntities.CtrEntity extension(IVar.Var x, int[] values, Boolean positive) {
        return this.extension((IVar.Var[])this.vars(x), this.dub(values), positive);
    }

    default public CtrEntities.CtrEntity extension(IVar.Var x, int ... values) {
        return this.extension(x, values, POSITIVE);
    }

    default public CtrEntities.CtrEntity extension(IVar.VarSymbolic[] scp, String[][] tuples, Boolean positive) {
        return this.imp().extension(scp, tuples, (boolean)positive);
    }

    default public CtrEntities.CtrEntity extension(IVar.VarSymbolic[] scp, String[] ... tuples) {
        return this.extension(scp, tuples, POSITIVE);
    }

    default public CtrEntities.CtrEntity extension(IVar.VarSymbolic[] scp, TableSymbolic table) {
        return this.extension(scp, (String[][])(table instanceof TableSymbolic ? table.toArray() : new String[][]{}), table.positive);
    }

    default public CtrEntities.CtrEntity extension(IVar.VarSymbolic x, String[] values, Boolean positive) {
        return this.extension((IVar.VarSymbolic[])this.vars(x), this.dub(values), positive);
    }

    default public CtrEntities.CtrEntity extension(IVar.VarSymbolic x, String ... values) {
        return this.extension(x, values, POSITIVE);
    }

    default public CtrEntities.CtrEntity regular(IVar.Var[] scp, Automaton automaton) {
        return this.imp().regular(scp, automaton);
    }

    default public CtrEntities.CtrEntity mdd(IVar.Var[] scp, Transition[] transitions) {
        return this.imp().mdd(scp, transitions);
    }

    default public CtrEntities.CtrEntity allDifferent(IVar.Var[] list) {
        return this.imp().allDifferent((IVar.Var[])this.distinctSorted(list));
    }

    default public CtrEntities.CtrEntity allDifferent(IVar.Var x, IVar.Var ... others) {
        return this.allDifferent((IVar.Var[])this.vars(x, new Object[]{others}));
    }

    default public CtrEntities.CtrEntity allDifferent(IVar.Var[][] list) {
        return this.allDifferent((IVar.Var[])this.vars(list));
    }

    default public CtrEntities.CtrEntity allDifferent(IVar.Var[][][] list) {
        return this.allDifferent((IVar.Var[])this.vars(list));
    }

    default public CtrEntities.CtrEntity allDifferent(IVar.VarSymbolic[] list) {
        return this.imp().allDifferent(list);
    }

    default public CtrEntities.CtrEntity allDifferent(IVar.VarSymbolic x, IVar.VarSymbolic ... others) {
        return this.allDifferent((IVar.VarSymbolic[])this.vars(x, new Object[]{others}));
    }

    default public CtrEntities.CtrEntity allDifferent(IVar.VarSymbolic[][] list) {
        return this.allDifferent((IVar.VarSymbolic[])this.vars(list));
    }

    default public CtrEntities.CtrEntity allDifferent(IVar.VarSymbolic[][][] list) {
        return this.allDifferent((IVar.VarSymbolic[])this.vars(list));
    }

    default public CtrEntities.CtrEntity allDifferentExcept(IVar.Var[] list, int ... zeroValues) {
        return this.imp().allDifferentExcept(list, zeroValues);
    }

    default public CtrEntities.CtrEntity allDifferentList(IVar.Var[] ... lists) {
        return this.imp().allDifferentList(lists);
    }

    default public CtrEntities.CtrEntity allDifferentMatrix(IVar.Var[][] matrix) {
        return this.imp().allDifferentMatrix(matrix);
    }

    default public CtrEntities.CtrEntity allDifferent(XNodeParent<IVar>[] trees) {
        return this.imp().allDifferent(trees);
    }

    default public CtrEntities.CtrEntity allDifferent(Stream<XNodeParent<IVar>> trees) {
        XNodeParent[] atrees = (XNodeParent[])trees.toArray(XNodeParent[]::new);
        return this.imp().allDifferent(atrees);
    }

    default public CtrEntities.CtrEntity allEqual(IVar.Var ... list) {
        return this.imp().allEqual(list);
    }

    default public CtrEntities.CtrEntity allEqual(IVar.Var[][] list) {
        return this.allEqual((IVar.Var[])this.vars(list));
    }

    default public CtrEntities.CtrEntity allEqual(IVar.VarSymbolic ... list) {
        return this.imp().allEqual(list);
    }

    default public CtrEntities.CtrEntity allEqual(IVar.VarSymbolic[][] list) {
        return this.allEqual((IVar.VarSymbolic[])this.vars(list));
    }

    default public CtrEntities.CtrEntity allEqualList(IVar.Var[] ... lists) {
        return this.imp().allEqualList(lists);
    }

    default public CtrEntities.CtrEntity ordered(IVar.Var[] list, int[] lengths, Types.TypeOperatorRel operator) {
        this.control(list.length == lengths.length + 1, "The size of list must be the size of lengths, plus 1");
        return this.imp().ordered(list, lengths, operator);
    }

    default public CtrEntities.CtrEntity ordered(IVar.Var[] list, Types.TypeOperatorRel operator) {
        return this.ordered(list, new int[list.length - 1], operator);
    }

    default public CtrEntities.CtrEntity strictlyIncreasing(IVar.Var ... list) {
        return this.ordered(list, STRICTLY_INCREASING);
    }

    default public CtrEntities.CtrEntity increasing(IVar.Var ... list) {
        return this.ordered(list, INCREASING);
    }

    default public CtrEntities.CtrEntity decreasing(IVar.Var ... list) {
        return this.ordered(list, DECREASING);
    }

    default public CtrEntities.CtrEntity strictlyDecreasing(IVar.Var ... list) {
        return this.ordered(list, STRICTLY_DECREASING);
    }

    default public CtrEntities.CtrEntity lex(IVar.Var[][] lists, Types.TypeOperatorRel operator) {
        return this.imp().lex(lists, operator);
    }

    default public CtrEntities.CtrEntity strictlyIncreasing(IVar.Var[] ... lists) {
        return this.lex(lists, STRICTLY_INCREASING);
    }

    default public CtrEntities.CtrEntity increasing(IVar.Var[] ... lists) {
        return this.lex(lists, INCREASING);
    }

    default public CtrEntities.CtrEntity decreasing(IVar.Var[] ... lists) {
        return this.lex(lists, DECREASING);
    }

    default public CtrEntities.CtrEntity strictlyDecreasing(IVar.Var[] ... lists) {
        return this.lex(lists, STRICTLY_DECREASING);
    }

    default public CtrEntities.CtrEntity lexMatrix(IVar.Var[][] matrix, Types.TypeOperatorRel operator) {
        return this.imp().lexMatrix(matrix, operator);
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, int[] coeffs, Condition condition) {
        return this.imp().sum(list, coeffs, condition);
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, Condition condition) {
        IVar.Var[] t = (IVar.Var[])this.clean(list);
        return this.sum(t, this.repeat(1, t.length), condition);
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, int[] coeffs, Types.TypeConditionOperatorRel op, long limit) {
        this.control(list.length == coeffs.length, "Pb because the number of variables is different form the number of coefficients");
        return this.sum(list, coeffs, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, Range coeffs, Types.TypeConditionOperatorRel op, long limit) {
        return this.sum(list, this.vals(coeffs), op, limit);
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, Types.TypeConditionOperatorRel op, long limit) {
        return this.sum(list, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, int[] coeffs, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        this.control(list.length == coeffs.length, "Pb because the number of variables is different form the number of coefficients");
        return this.sum(list, coeffs, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        return this.sum(list, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, int[] coeffs, Types.TypeConditionOperatorSet op, Range range) {
        this.control(list.length == coeffs.length, "Pb because the number of variables is different form the number of coefficients");
        return this.sum(list, coeffs, this.condition(op, range));
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, Types.TypeConditionOperatorSet op, Range range) {
        return this.sum(list, this.condition(op, range));
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, int[] coeffs, Types.TypeConditionOperatorSet op, int[] set) {
        this.control(list.length == coeffs.length, "Pb because the number of variables is different form the number of coefficients");
        return this.sum(list, coeffs, this.condition(op, set));
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, Types.TypeConditionOperatorSet op, int[] set) {
        return this.sum(list, this.condition(op, set));
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, IVar.Var[] coeffs, Condition condition) {
        return this.imp().sum(list, coeffs, condition);
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, IVar.Var[] coeffs, Types.TypeConditionOperatorRel op, long limit) {
        this.control(list.length == coeffs.length, "Pb because the number of variables is different form the number of coefficients");
        return this.sum(list, coeffs, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, IVar.Var[] coeffs, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        this.control(list.length == coeffs.length, "Pb because the number of variables is different form the number of coefficients");
        return this.sum(list, coeffs, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, IVar.Var[] coeffs, Types.TypeConditionOperatorSet op, Range range) {
        this.control(list.length == coeffs.length, "Pb because the number of variables is different form the number of coefficients");
        return this.sum(list, coeffs, this.condition(op, range));
    }

    default public CtrEntities.CtrEntity sum(IVar.Var[] list, IVar.Var[] coeffs, Types.TypeConditionOperatorSet op, int[] set) {
        this.control(list.length == coeffs.length, "Pb because the number of variables is different form the number of coefficients");
        return this.sum(list, coeffs, this.condition(op, set));
    }

    default public CtrEntities.CtrEntity sum(XNodeParent<IVar>[] trees, int[] coeffs, Condition condition) {
        return this.imp().sum(trees, coeffs == null ? this.repeat(1, trees.length) : coeffs, condition);
    }

    default public CtrEntities.CtrEntity sum(XNodeParent<IVar>[] trees, Condition condition) {
        return this.sum(trees, null, condition);
    }

    default public CtrEntities.CtrEntity sum(XNodeParent<IVar>[] trees, Types.TypeConditionOperatorRel op, long limit) {
        return this.sum(trees, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(XNodeParent<IVar>[] trees, int[] coeffs, Types.TypeConditionOperatorRel op, long limit) {
        return this.sum(trees, coeffs, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(XNodeParent<IVar>[] trees, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        return this.sum(trees, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(XNodeParent<IVar>[] trees, int[] coeffs, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        return this.sum(trees, coeffs, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(Stream<XNodeParent<IVar>> trees, int[] coeffs, Condition condition) {
        XNodeParent[] atrees = (XNodeParent[])trees.toArray(XNodeParent[]::new);
        return this.sum(atrees, coeffs, condition);
    }

    default public CtrEntities.CtrEntity sum(Stream<XNodeParent<IVar>> trees, Condition condition) {
        return this.sum(trees, null, condition);
    }

    default public CtrEntities.CtrEntity sum(Stream<XNodeParent<IVar>> trees, Types.TypeConditionOperatorRel op, long limit) {
        return this.sum(trees, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(Stream<XNodeParent<IVar>> trees, int[] coeffs, Types.TypeConditionOperatorRel op, long limit) {
        return this.sum(trees, coeffs, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(Stream<XNodeParent<IVar>> trees, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        return this.sum(trees, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity sum(Stream<XNodeParent<IVar>> trees, int[] coeffs, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        return this.sum(trees, coeffs, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, int[] values, Condition condition) {
        return this.imp().count((IVar.Var[])this.clean(list), values, condition);
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, int[] values, Types.TypeConditionOperatorRel op, int limit) {
        return this.count(list, values, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, int value, Types.TypeConditionOperatorRel op, int limit) {
        return this.count(list, this.vals(value), this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, int[] values, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        return this.count(list, values, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, int value, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        return this.count(list, this.vals(value), this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, int[] values, Types.TypeConditionOperatorSet op, Range range) {
        return this.count(list, values, this.condition(op, range));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, int value, Types.TypeConditionOperatorSet op, Range range) {
        return this.count(list, this.vals(value), this.condition(op, range));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, int[] values, Types.TypeConditionOperatorSet op, int[] set) {
        return this.count(list, values, this.condition(op, set));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, int value, Types.TypeConditionOperatorSet op, int[] set) {
        return this.count(list, this.vals(value), this.condition(op, set));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, IVar.Var[] values, Condition condition) {
        return this.imp().count((IVar.Var[])this.clean(list), (IVar.Var[])this.clean(values), condition);
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, IVar.Var[] values, Types.TypeConditionOperatorRel op, int limit) {
        return this.count(list, values, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, IVar.Var value, Types.TypeConditionOperatorRel op, int limit) {
        return this.count(list, (IVar.Var[])this.vars(value), this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, IVar.Var[] values, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        return this.count(list, values, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, IVar.Var value, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        return this.count(list, (IVar.Var[])this.vars(value), this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, IVar.Var[] values, Types.TypeConditionOperatorSet op, Range range) {
        return this.count(list, values, this.condition(op, range));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, IVar.Var value, Types.TypeConditionOperatorSet op, Range range) {
        return this.count(list, (IVar.Var[])this.vars(value), this.condition(op, range));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, IVar.Var[] values, Types.TypeConditionOperatorSet op, int[] set) {
        return this.count(list, values, this.condition(op, set));
    }

    default public CtrEntities.CtrEntity count(IVar.Var[] list, IVar.Var value, Types.TypeConditionOperatorSet op, int[] set) {
        return this.count(list, (IVar.Var[])this.vars(value), this.condition(op, set));
    }

    default public CtrEntities.CtrEntity atLeast(IVar.Var[] list, int value, int k) {
        return this.count(list, value, GE, k);
    }

    default public CtrEntities.CtrEntity atMost(IVar.Var[] list, int value, int k) {
        return this.count(list, value, LE, k);
    }

    default public CtrEntities.CtrEntity exactly(IVar.Var[] list, int value, int k) {
        return this.count(list, value, EQ, k);
    }

    default public CtrEntities.CtrEntity among(IVar.Var[] list, int[] values, int k) {
        return this.count(list, values, EQ, k);
    }

    default public CtrEntities.CtrEntity atLeast(IVar.Var[] list, int value, IVar.Var k) {
        return this.count(list, value, GE, k);
    }

    default public CtrEntities.CtrEntity atMost(IVar.Var[] list, int value, IVar.Var k) {
        return this.count(list, value, LE, k);
    }

    default public CtrEntities.CtrEntity exactly(IVar.Var[] list, int value, IVar.Var k) {
        return this.count(list, value, EQ, k);
    }

    default public CtrEntities.CtrEntity among(IVar.Var[] list, int[] values, IVar.Var k) {
        return this.count(list, values, EQ, k);
    }

    default public CtrEntities.CtrEntity atLeast1(IVar.Var[] list, int value) {
        return this.atLeast(list, value, 1);
    }

    default public CtrEntities.CtrEntity atMost1(IVar.Var[] list, int value) {
        return this.atMost(list, value, 1);
    }

    default public CtrEntities.CtrEntity exactly1(IVar.Var[] list, int value) {
        return this.exactly(list, value, 1);
    }

    default public CtrEntities.CtrEntity nValues(IVar.Var[] list, Condition condition) {
        return this.imp().nValues(list, condition);
    }

    default public CtrEntities.CtrEntity nValues(IVar.Var[] list, Types.TypeConditionOperatorRel op, int limit) {
        return this.nValues(list, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity nValues(IVar.Var[] list, Types.TypeConditionOperatorRel op, IVar.Var limit) {
        return this.nValues(list, this.condition(op, limit));
    }

    default public CtrEntities.CtrEntity nValues(IVar.Var[] list, Types.TypeConditionOperatorSet op, Range range) {
        return this.nValues(list, this.condition(op, range));
    }

    default public CtrEntities.CtrEntity nValues(IVar.Var[] list, Types.TypeConditionOperatorSet op, int[] set) {
        return this.nValues(list, this.condition(op, set));
    }

    default public CtrEntities.CtrEntity nValuesExcept(IVar.Var[] list, Condition condition, int ... exceptValues) {
        return this.imp().nValues(list, condition);
    }

    default public CtrEntities.CtrEntity nValuesExcept(IVar.Var[] list, Types.TypeConditionOperatorRel op, int limit, int ... exceptValues) {
        return this.nValuesExcept(list, this.condition(op, limit), exceptValues);
    }

    default public CtrEntities.CtrEntity nValuesExcept(IVar.Var[] list, Types.TypeConditionOperatorRel op, IVar.Var limit, int ... exceptValues) {
        return this.nValuesExcept(list, this.condition(op, limit), exceptValues);
    }

    default public CtrEntities.CtrEntity nValuesExcept(IVar.Var[] list, Types.TypeConditionOperatorSet op, Range range, int ... exceptValues) {
        return this.nValuesExcept(list, this.condition(op, range), exceptValues);
    }

    default public CtrEntities.CtrEntity nValuesExcept(IVar.Var[] list, Types.TypeConditionOperatorSet op, int[] set, int ... exceptValues) {
        return this.nValuesExcept(list, this.condition(op, set), exceptValues);
    }

    default public CtrEntities.CtrEntity notAllEqual(IVar.Var ... list) {
        return this.nValues(list, this.condition(GT, 1L));
    }

    default public CtrEntities.CtrEntity cardinality(IVar.Var[] list, int[] values, boolean mustBeClosed, Occurrences occurrences) {
        if (occurrences instanceof Occurrences.OccurrencesIntBasic) {
            return this.imp().cardinality((IVar.Var[])this.clean(list), values, mustBeClosed, this.repeat(((Occurrences.OccurrencesIntBasic)occurrences).occurs, values.length));
        }
        if (occurrences instanceof Occurrences.OccurrencesIntSimple) {
            return this.imp().cardinality((IVar.Var[])this.clean(list), values, mustBeClosed, ((Occurrences.OccurrencesIntSimple)occurrences).occurs);
        }
        if (occurrences instanceof Occurrences.OccurrencesIntRange) {
            return this.imp().cardinality((IVar.Var[])this.clean(list), values, mustBeClosed, this.repeat(((Occurrences.OccurrencesIntRange)occurrences).occursMin, values.length), this.repeat(((Occurrences.OccurrencesIntRange)occurrences).occursMax, values.length));
        }
        if (occurrences instanceof Occurrences.OccurrencesIntDouble) {
            return this.imp().cardinality((IVar.Var[])this.clean(list), values, mustBeClosed, ((Occurrences.OccurrencesIntDouble)occurrences).occursMin, ((Occurrences.OccurrencesIntDouble)occurrences).occursMax);
        }
        return this.imp().cardinality((IVar.Var[])this.clean(list), values, mustBeClosed, (IVar.Var[])this.clean(((Occurrences.OccurrencesVar)occurrences).occurs));
    }

    default public CtrEntities.CtrEntity cardinality(IVar.Var[] list, int[] values, Occurrences occurrences) {
        return this.cardinality(list, values, false, occurrences);
    }

    default public CtrEntities.CtrEntity cardinality(IVar.Var[] list, Range values, Occurrences occurrences) {
        return this.cardinality(list, this.vals(values), occurrences);
    }

    default public CtrEntities.CtrEntity cardinality(IVar.Var[] list, IVar.Var[] values, boolean mustBeClosed, Occurrences occurrences) {
        if (occurrences instanceof Occurrences.OccurrencesIntBasic) {
            return this.imp().cardinality((IVar.Var[])this.clean(list), (IVar.Var[])this.clean(values), mustBeClosed, this.repeat(((Occurrences.OccurrencesIntBasic)occurrences).occurs, values.length));
        }
        if (occurrences instanceof Occurrences.OccurrencesIntSimple) {
            return this.imp().cardinality((IVar.Var[])this.clean(list), (IVar.Var[])this.clean(values), mustBeClosed, ((Occurrences.OccurrencesIntSimple)occurrences).occurs);
        }
        if (occurrences instanceof Occurrences.OccurrencesIntRange) {
            return this.imp().cardinality((IVar.Var[])this.clean(list), (IVar.Var[])this.clean(values), mustBeClosed, this.repeat(((Occurrences.OccurrencesIntRange)occurrences).occursMin, values.length), this.repeat(((Occurrences.OccurrencesIntRange)occurrences).occursMax, values.length));
        }
        if (occurrences instanceof Occurrences.OccurrencesIntDouble) {
            return this.imp().cardinality((IVar.Var[])this.clean(list), (IVar.Var[])this.clean(values), mustBeClosed, ((Occurrences.OccurrencesIntDouble)occurrences).occursMin, ((Occurrences.OccurrencesIntDouble)occurrences).occursMax);
        }
        return this.imp().cardinality((IVar.Var[])this.clean(list), (IVar.Var[])this.clean(values), mustBeClosed, (IVar.Var[])this.clean(((Occurrences.OccurrencesVar)occurrences).occurs));
    }

    default public CtrEntities.CtrEntity cardinality(IVar.Var[] list, IVar.Var[] values, Occurrences occurs) {
        return this.cardinality(list, values, false, occurs);
    }

    default public CtrEntities.CtrEntity maximum(IVar.Var[] list, Condition condition) {
        return this.imp().maximum((IVar.Var[])this.clean(list), condition);
    }

    default public CtrEntities.CtrEntity maximum(IVar.Var[] list, IVar.Var max) {
        return this.maximum(list, this.condition(EQ, max));
    }

    default public CtrEntities.CtrEntity maximum(IVar.Var[] list, StartIndex startIndex, Index index) {
        return this.imp().maximum(list, startIndex.value, index.variable, index.rank);
    }

    default public CtrEntities.CtrEntity maximum(IVar.Var[] list, Index index) {
        return this.maximum(list, this.startIndex(0), index);
    }

    default public CtrEntities.CtrEntity maximum(IVar.Var[] list, StartIndex startIndex, Index index, Condition condition) {
        return this.imp().maximum(list, startIndex.value, index.variable, index.rank, condition);
    }

    default public CtrEntities.CtrEntity maximum(IVar.Var[] list, Index index, Condition condition) {
        return this.maximum(list, this.startIndex(0), index, condition);
    }

    default public CtrEntities.CtrEntity minimum(IVar.Var[] list, Condition condition) {
        return this.imp().minimum(list, condition);
    }

    default public CtrEntities.CtrEntity minimum(IVar.Var[] list, IVar.Var min) {
        return this.minimum(list, this.condition(EQ, min));
    }

    default public CtrEntities.CtrEntity minimum(IVar.Var[] list, StartIndex startIndex, Index index) {
        return this.imp().minimum(list, startIndex.value, index.variable, index.rank);
    }

    default public CtrEntities.CtrEntity minimum(IVar.Var[] list, Index index) {
        return this.minimum(list, this.startIndex(0), index);
    }

    default public CtrEntities.CtrEntity minimum(IVar.Var[] list, StartIndex startIndex, Index index, Condition condition) {
        return this.imp().minimum(list, startIndex.value, index.variable, index.rank, condition);
    }

    default public CtrEntities.CtrEntity minimum(IVar.Var[] list, Index index, Condition condition) {
        return this.minimum(list, this.startIndex(0), index, condition);
    }

    default public CtrEntities.CtrEntity element(IVar.Var[] list, int value) {
        return this.imp().element(list, value);
    }

    default public CtrEntities.CtrEntity element(IVar.Var[] list, IVar.Var value) {
        return this.imp().element(list, value);
    }

    default public CtrEntities.CtrEntity element(IVar.Var[] list, StartIndex startIndex, Index index, int value) {
        return this.imp().element(list, startIndex.value, index.variable, index.rank, value);
    }

    default public CtrEntities.CtrEntity element(IVar.Var[] list, Index index, int value) {
        return this.element(list, this.startIndex(0), index, value);
    }

    default public CtrEntities.CtrEntity element(IVar.Var[] list, IVar.Var index, int value) {
        return this.element(list, this.startIndex(0), this.index(index), value);
    }

    default public CtrEntities.CtrEntity element(IVar.Var[] list, StartIndex startIndex, Index index, IVar.Var value) {
        return this.imp().element(list, startIndex.value, index.variable, index.rank, value);
    }

    default public CtrEntities.CtrEntity element(IVar.Var[] list, Index index, IVar.Var value) {
        return this.element(list, this.startIndex(0), index, value);
    }

    default public CtrEntities.CtrEntity element(IVar.Var[] list, IVar.Var index, IVar.Var value) {
        return this.element(list, this.startIndex(0), this.index(index), value);
    }

    default public CtrEntities.CtrEntity element(int[] list, StartIndex startIndex, Index index, IVar.Var value) {
        return this.imp().element(list, startIndex.value, index.variable, index.rank, value);
    }

    default public CtrEntities.CtrEntity element(int[] list, Index index, IVar.Var value) {
        return this.element(list, this.startIndex(0), index, value);
    }

    default public CtrEntities.CtrEntity element(int[] list, IVar.Var index, IVar.Var value) {
        return this.element(list, this.startIndex(0), this.index(index), value);
    }

    default public CtrEntities.CtrEntity channel(IVar.Var[] list, StartIndex startIndex) {
        return this.imp().channel(list, startIndex.value);
    }

    default public CtrEntities.CtrEntity channel(IVar.Var[] list) {
        return this.channel(list, this.startIndex(0));
    }

    default public CtrEntities.CtrEntity channel(IVar.Var[] list1, StartIndex startIndex1, IVar.Var[] list2, StartIndex startIndex2) {
        this.control(list1.length <= list2.length, "The size of the first list must be less than or equal to the size of the second list");
        return this.imp().channel(list1, startIndex1.value, list2, startIndex2.value);
    }

    default public CtrEntities.CtrEntity channel(IVar.Var[] list1, IVar.Var[] list2) {
        return this.channel(list1, this.startIndex(0), list2, this.startIndex(0));
    }

    default public CtrEntities.CtrEntity channel(IVar.Var[] list, StartIndex startIndex, IVar.Var value) {
        return this.imp().channel(list, startIndex.value, value);
    }

    default public CtrEntities.CtrEntity channel(IVar.Var[] list, IVar.Var value) {
        return this.channel(list, this.startIndex(0), value);
    }

    default public CtrEntities.CtrEntity stretch(IVar.Var[] list, int[] values, int[] widthsMin, int[] widthsMax, int[][] patterns) {
        return this.imp().stretch(list, values, widthsMin, widthsMax, patterns);
    }

    default public CtrEntities.CtrEntity stretch(IVar.Var[] list, int[] values, int[] widthsMin, int[] widthsMax) {
        return this.stretch(list, values, widthsMin, widthsMax, null);
    }

    default public CtrEntities.CtrEntity noOverlap(IVar.Var[] origins, int[] lengths, boolean zeroIgnored) {
        return this.imp().noOverlap(origins, lengths, zeroIgnored);
    }

    default public CtrEntities.CtrEntity noOverlap(IVar.Var[] origins, int[] lengths) {
        return this.noOverlap(origins, lengths, true);
    }

    default public CtrEntities.CtrEntity noOverlap(IVar.Var x1, IVar.Var x2, int length1, int length2) {
        this.control(length1 > 0 && length2 > 0, "It is not relevant to have a length which is not strictly positive");
        return this.noOverlap((IVar.Var[])this.vars(x1, x2), this.vals(length1, length2));
    }

    default public CtrEntities.CtrEntity noOverlap(IVar.Var[] origins, IVar.Var[] lengths, boolean zeroIgnored) {
        return this.imp().noOverlap(origins, lengths, zeroIgnored);
    }

    default public CtrEntities.CtrEntity noOverlap(IVar.Var[] origins, IVar.Var[] lengths) {
        return this.noOverlap(origins, lengths, true);
    }

    default public CtrEntities.CtrEntity noOverlap(IVar.Var x1, IVar.Var x2, IVar.Var length1, IVar.Var length2) {
        return this.noOverlap((IVar.Var[])this.vars(x1, x2), (IVar.Var[])this.vars(length1, length2));
    }

    default public CtrEntities.CtrEntity noOverlap(IVar.Var[][] origins, int[][] lengths, boolean zeroIgnored) {
        return this.imp().noOverlap(origins, lengths, zeroIgnored);
    }

    default public CtrEntities.CtrEntity noOverlap(IVar.Var[][] origins, int[][] lengths) {
        return this.noOverlap(origins, lengths, true);
    }

    default public CtrEntities.CtrEntity noOverlap(IVar.Var[][] origins, IVar.Var[][] lengths, boolean zeroIgnored) {
        return this.imp().noOverlap(origins, lengths, zeroIgnored);
    }

    default public CtrEntities.CtrEntity noOverlap(IVar.Var[][] origins, IVar.Var[][] lengths) {
        return this.noOverlap(origins, lengths, true);
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, int[] lengths, IVar.Var[] ends, int[] heights, Condition condition) {
        return this.imp().cumulative(origins, lengths, ends, heights, condition);
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, int[] lengths, int[] heights, Condition condition) {
        return this.cumulative(origins, lengths, null, heights, condition);
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, int[] lengths, int[] heights, long limit) {
        return this.cumulative(origins, lengths, null, heights, this.condition(LE, limit));
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, IVar.Var[] lengths, IVar.Var[] ends, int[] heights, Condition condition) {
        return this.imp().cumulative(origins, lengths, ends, heights, condition);
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, IVar.Var[] lengths, int[] heights, Condition condition) {
        return this.cumulative(origins, lengths, null, heights, condition);
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, IVar.Var[] lengths, int[] heights, long limit) {
        return this.cumulative(origins, lengths, null, heights, this.condition(LE, limit));
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, int[] lengths, IVar.Var[] ends, IVar.Var[] heights, Condition condition) {
        return this.imp().cumulative(origins, lengths, ends, heights, condition);
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, int[] lengths, IVar.Var[] heights, Condition condition) {
        return this.cumulative(origins, lengths, null, heights, condition);
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, int[] lengths, IVar.Var[] heights, long limit) {
        return this.cumulative(origins, lengths, null, heights, this.condition(LE, limit));
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, IVar.Var[] lengths, IVar.Var[] ends, IVar.Var[] heights, Condition condition) {
        return this.imp().cumulative(origins, lengths, ends, heights, condition);
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, IVar.Var[] lengths, IVar.Var[] heights, Condition condition) {
        return this.cumulative(origins, lengths, null, heights, condition);
    }

    default public CtrEntities.CtrEntity cumulative(IVar.Var[] origins, IVar.Var[] lengths, IVar.Var[] heights, long limit) {
        return this.cumulative(origins, lengths, null, heights, this.condition(LE, limit));
    }

    default public CtrEntities.CtrEntity circuit(IVar.Var[] list, int startIndex) {
        return this.imp().circuit(list, startIndex);
    }

    default public CtrEntities.CtrEntity circuit(IVar.Var[] list) {
        return this.circuit(list, 0);
    }

    default public CtrEntities.CtrEntity circuit(IVar.Var[] list, int startIndex, int size) {
        return this.imp().circuit(list, startIndex, size);
    }

    default public CtrEntities.CtrEntity circuit(IVar.Var[] list, int startIndex, IVar.Var size) {
        return this.imp().circuit(list, startIndex, size);
    }

    default public CtrEntities.CtrEntity circuit(IVar.Var[] list, IVar.Var size) {
        return this.circuit(list, 0, size);
    }

    default public CtrEntities.CtrEntity clause(IVar.Var[] list, Boolean[] phases) {
        this.control(Stream.of(list).noneMatch(x -> x == null) && Stream.of(phases).noneMatch(x -> x == null), "No null values is allowed in the specified arrays.");
        return this.imp().clause(list, phases);
    }

    default public CtrEntities.CtrEntity clause(IVar.Var[] pos, IVar.Var[] neg) {
        this.control(Stream.of(pos).noneMatch(x -> x == null) && Stream.of(neg).noneMatch(x -> x == null), "No null values is allowed in the specified arrays.");
        Boolean[] phases = (Boolean[])IntStream.range(0, pos.length + neg.length).mapToObj(i -> i < pos.length).toArray(Boolean[]::new);
        return this.clause((IVar.Var[])this.vars(pos, new Object[]{neg}), phases);
    }

    default public CtrEntities.CtrEntity instantiation(IVar.Var[] list, int[] values) {
        list = list == null ? list : (IVar.Var[])this.clean(list);
        this.control(list == null && values.length == 0 || list.length == values.length, "The length of list is diffrent from the length of values");
        if (values.length == 0) {
            return this.imp().dummyConstraint("A constraint instantiation with a scope of 0 variable.");
        }
        return this.imp().instantiation(list, values);
    }

    default public CtrEntities.CtrEntity instantiation(Stream<IVar.Var> list, IntStream values) {
        return this.instantiation((IVar.Var[])this.vars(list), values.toArray());
    }

    default public CtrEntities.CtrEntity instantiation(IVar.Var[] list, Range values) {
        return this.instantiation(list, values.toArray());
    }

    default public CtrEntities.CtrEntity instantiation(IVar.Var[][] list, int[][] values, FunctionalInterfaces.Intx2Predicate p) {
        this.control(list != null && values != null, "One array is null");
        return this.instantiation((IVar.Var[])this.select(list, p), this.select(values, p));
    }

    default public CtrEntities.CtrEntity instantiation(IVar.Var[][][] list, int[][][] values, FunctionalInterfaces.Intx3Predicate p) {
        return this.instantiation((IVar.Var[])this.select(list, p), this.select(values, p));
    }

    default public CtrEntities.CtrEntity slide(IVar[] list, Range range, IntFunction<CtrEntities.CtrEntity> template) {
        this.control(range.minIncluded == 0 && range.length() > 0, "Bad form of range");
        return this.imp().slide(list, range, template);
    }

    default public CtrEntities.CtrEntity ifThen(CtrEntities.CtrEntity c1, CtrEntities.CtrEntity c2) {
        return this.imp().ifThen(c1, c2);
    }

    default public CtrEntities.CtrEntity ifThenElse(CtrEntities.CtrEntity c1, CtrEntities.CtrEntity c2, CtrEntities.CtrEntity c3) {
        return this.imp().ifThenElse(c1, c2, c3);
    }

    default public CtrEntities.CtrArray block(Runnable r) {
        return this.imp().manageLoop(r);
    }

    default public CtrEntities.CtrArray forall(Range range, IntConsumer c) {
        return this.imp().forall(range, c);
    }

    default public CtrEntities.CtrArray forall(Range.Rangesx2 rangesx2, FunctionalInterfaces.Intx2Consumer c2) {
        return this.imp().forall(rangesx2, c2);
    }

    default public CtrEntities.CtrArray forall(Range.Rangesx3 rangesx3, FunctionalInterfaces.Intx3Consumer c3) {
        return this.imp().forall(rangesx3, c3);
    }

    default public CtrEntities.CtrArray forall(Range.Rangesx4 rangesx4, FunctionalInterfaces.Intx4Consumer c4) {
        return this.imp().forall(rangesx4, c4);
    }

    default public CtrEntities.CtrArray forall(Range.Rangesx5 rangesx5, FunctionalInterfaces.Intx5Consumer c5) {
        return this.imp().forall(rangesx5, c5);
    }

    default public ObjEntities.ObjEntity minimize(IVar x) {
        return this.imp().minimize(x);
    }

    default public ObjEntities.ObjEntity maximize(IVar x) {
        return this.imp().maximize(x);
    }

    default public ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar ... list) {
        return this.imp().minimize(type, this.vars(list, new Object[0]));
    }

    default public ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar[][] list) {
        return this.minimize(type, this.vars(list));
    }

    default public ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar[][][] list) {
        return this.minimize(type, this.vars(list));
    }

    default public ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar ... list) {
        return this.imp().maximize(type, this.vars(list, new Object[0]));
    }

    default public ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar[][] list) {
        return this.maximize(type, this.vars(list));
    }

    default public ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar[][][] list) {
        return this.maximize(type, this.vars(list));
    }

    default public ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar[] list, int[] coeffs) {
        this.control(list.length == coeffs.length, "Size of list and coeffs are different");
        return this.imp().minimize(type, list, coeffs);
    }

    default public ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar[][] list, int[][] coeffs) {
        return this.minimize(type, this.vars(list), this.vals(new Object[]{coeffs}));
    }

    default public ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar[][] list, int[][] coeffs, FunctionalInterfaces.Intx2Predicate p) {
        return this.minimize(type, this.select(list, p), this.select(coeffs, p));
    }

    default public ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar[][][] list, int[][][] coeffs) {
        return this.minimize(type, this.vars(list), this.vals(new Object[]{coeffs}));
    }

    default public ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar[][][] list, int[][][] coeffs, FunctionalInterfaces.Intx3Predicate p) {
        return this.minimize(type, this.select(list, p), this.select(coeffs, p));
    }

    default public ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar[] list, int[] coeffs) {
        this.control(list.length == coeffs.length, "Size of list and coeffs are different");
        return this.imp().maximize(type, list, coeffs);
    }

    default public ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar[][] list, int[][] coeffs) {
        return this.maximize(type, this.vars(list), this.vals(new Object[]{coeffs}));
    }

    default public ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar[][] list, int[][] coeffs, FunctionalInterfaces.Intx2Predicate p) {
        return this.maximize(type, this.select(list, p), this.select(coeffs, p));
    }

    default public ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar[][][] list, int[][][] coeffs) {
        return this.maximize(type, this.vars(list), this.vals(new Object[]{coeffs}));
    }

    default public ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar[][][] list, int[][][] coeffs, FunctionalInterfaces.Intx3Predicate p) {
        return this.maximize(type, this.select(list, p), this.select(coeffs, p));
    }

    public void model();

    default public void prettyDisplay() {
    }

    default public void decisionVariables(IVar[] list) {
        this.imp().decisionVariables(list);
    }

    private static /* synthetic */ String[][] lambda$dub$40(int x$0) {
        return new String[x$0][];
    }

    public static interface Occurrences {

        public static class OccurrencesVar
        implements Occurrences {
            public IVar.Var[] occurs;

            public OccurrencesVar(IVar.Var[] occurs) {
                this.occurs = occurs;
            }
        }

        public static class OccurrencesIntDouble
        implements Occurrences {
            public int[] occursMin;
            public int[] occursMax;

            public OccurrencesIntDouble(int[] occursMin, int[] occursMax) {
                this.occursMin = occursMin;
                this.occursMax = occursMax;
            }
        }

        public static class OccurrencesIntSimple
        implements Occurrences {
            public int[] occurs;

            public OccurrencesIntSimple(int[] occurs) {
                this.occurs = occurs;
            }
        }

        public static class OccurrencesIntRange
        implements Occurrences {
            public int occursMin;
            public int occursMax;

            public OccurrencesIntRange(int occursMin, int occursMax) {
                this.occursMin = occursMin;
                this.occursMax = occursMax;
            }
        }

        public static class OccurrencesIntBasic
        implements Occurrences {
            public int occurs;

            public OccurrencesIntBasic(int occurs) {
                this.occurs = occurs;
            }
        }
    }

    public static class StartIndex {
        public int value;

        public StartIndex(int val) {
            this.value = val;
        }
    }

    public static class Index {
        public IVar.Var variable;
        public Types.TypeRank rank;

        public Index(IVar.Var index, Types.TypeRank rank) {
            this.variable = index;
            this.rank = rank;
        }

        public Index(IVar.Var index) {
            this(index, Types.TypeRank.ANY);
        }
    }
}

