/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.modeler.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Size;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.enumerations.EnumerationCartesian;
import org.xcsp.modeler.entities.ModelingEntity;
import org.xcsp.modeler.implementation.ProblemIMP;
import org.xcsp.parser.entries.XVariables;

public final class VarEntities {
    private ProblemIMP imp;
    public List<VarEntity> allEntities = new ArrayList<VarEntity>();
    public List<VarAlone> varAlones = new ArrayList<VarAlone>();
    public List<VarArray> varArrays = new ArrayList<VarArray>();
    public Map<IVar, VarAlone> varToVarAlone = new LinkedHashMap<IVar, VarAlone>();
    public Map<IVar, VarArray> varToVarArray = new LinkedHashMap<IVar, VarArray>();
    public Map<VarEntity, Integer> buildTimes = new HashMap<VarEntity, Integer>();

    public VarEntities(ProblemIMP imp) {
        this.imp = imp;
    }

    public boolean isVarAlone(IVar x) {
        return this.varToVarArray.get(x) != null;
    }

    public void newVarAloneEntity(String id, IVar var, String note, Types.TypeClass ... classes) {
        int l;
        VarAlone va = new VarAlone(id, var, note, classes);
        this.allEntities.add(va);
        this.varAlones.add(va);
        this.varToVarAlone.put(var, va);
        int n = l = this.imp.stackLoops.size() > 0 ? this.imp.stackLoops.peek() : -1;
        if (l != -1) {
            this.buildTimes.put(va, l);
        }
    }

    public void newVarArrayEntity(String id, Size size, Object vars, String note, Types.TypeClass ... classes) {
        int l;
        VarArray va = size instanceof Size.Size1D ? new VarArray1D(id, (IVar[])vars, note, classes) : (size instanceof Size.Size2D ? new VarArray2D(id, (IVar[][])vars, note, classes) : (size instanceof Size.Size3D ? new VarArray3D(id, (IVar[][][])vars, note, classes) : (size instanceof Size.Size4D ? new VarArray4D(id, (IVar[][][][])vars, note, classes) : new VarArray5D(id, (IVar[][][][][])vars, note, classes))));
        this.allEntities.add(va);
        this.varArrays.add(va);
        if (va.flatVars != null) {
            Stream.of(va.flatVars).forEach(x -> this.varToVarArray.put((IVar)x, va));
        }
        int n = l = this.imp.stackLoops.size() > 0 ? this.imp.stackLoops.peek() : -1;
        if (l != -1) {
            this.buildTimes.put(va, l);
        }
    }

    private String expand(String compactForm) {
        Utilities.control(compactForm.indexOf(32) == -1, "The specified string must correspond to a single token; bad form : " + compactForm);
        int pos = compactForm.indexOf("[");
        if (pos == -1) {
            VarAlone va = this.varAlones.stream().filter(a -> a.id.equals(compactForm)).findAny().orElse(null);
            Utilities.control(va != null, "An object VarAlone should have been found");
            return compactForm;
        }
        String prefix = compactForm.substring(0, pos);
        String suffix = compactForm.substring(pos);
        VarArray va = this.varArrays.stream().filter(a -> a.id.equals(prefix)).findAny().orElse(null);
        Utilities.control(va != null, "");
        ArrayList<String> list = new ArrayList<String>();
        while (suffix.length() > 0) {
            pos = suffix.indexOf("]");
            list.add(suffix.substring(1, pos));
            suffix = suffix.substring(pos + 1);
        }
        String[] tokens = list.toArray(new String[0]);
        Utilities.control(tokens.length == va.sizes.length, prefix + " ");
        int[] mins = new int[tokens.length];
        int[] maxs = new int[tokens.length];
        int[] sizes = new int[tokens.length];
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            if (tokens[i2].length() == 0) {
                mins[i2] = 0;
                maxs[i2] = va.sizes[i2] - 1;
            } else if (Utilities.isInteger(tokens[i2])) {
                mins[i2] = maxs[i2] = Integer.parseInt(tokens[i2]);
            } else {
                StringTokenizer st = new StringTokenizer(tokens[i2], "..");
                mins[i2] = Integer.parseInt(st.nextToken());
                maxs[i2] = Integer.parseInt(st.nextToken());
            }
            sizes[i2] = maxs[i2] - mins[i2] + 1;
        }
        String s = "";
        EnumerationCartesian ec = new EnumerationCartesian(sizes);
        while (ec.hasNext()) {
            int[] t = ec.next();
            s = s + prefix + IntStream.range(0, t.length).mapToObj(i -> "[" + (mins[i] + t[i]) + "]").collect(Collectors.joining()) + " ";
        }
        return s.trim();
    }

    private String compact(IVar[] vars, boolean preserveOrder) {
        if (vars.length == 2) {
            return vars[0].id() + " " + vars[1].id();
        }
        String compactFromOneArray = this.varArrays.stream().map(va -> va.compactFormOf(vars)).filter(s -> s != null).findFirst().orElse(null);
        if (compactFromOneArray != null && (!preserveOrder || this.expand(compactFromOneArray).equals(Stream.of(vars).map(x -> x.id()).collect(Collectors.joining(" "))))) {
            return compactFromOneArray;
        }
        String s2 = "";
        List<IVar> list = null;
        if (!preserveOrder) {
            boolean[] bs = new boolean[vars.length];
            for (VarArray va2 : this.varArrays) {
                if (!(va2 instanceof VarArray2D)) continue;
                IVar[][] m = (IVar[][])((VarArray2D)VarArray2D.class.cast((Object)va2)).vars;
                for (int i2 = 0; i2 < m[0].length; ++i2) {
                    int j;
                    for (j = 0; j < m.length && Utilities.indexOf(m[j][i2], vars) != -1; ++j) {
                    }
                    if (j != m.length) continue;
                    for (j = 0; j < m.length; ++j) {
                        bs[Utilities.indexOf((Object)m[j][i2], (Object[])vars)] = true;
                    }
                    s2 = s2 + " " + va2.id + "[][" + i2 + "]";
                }
            }
            list = IntStream.range(0, vars.length).filter(i -> !bs[i]).mapToObj(i -> vars[i]).collect(Collectors.toList());
        } else {
            list = Arrays.asList(vars);
        }
        if (list.size() > 0) {
            SequenceOfSuccessiveVariables sequence = null;
            for (IVar var : list) {
                if (sequence == null) {
                    sequence = new SequenceOfSuccessiveVariables(var);
                    continue;
                }
                if (sequence.canBeExtendedWith(var.id())) continue;
                s2 = s2 + " " + sequence.toString();
                sequence = new SequenceOfSuccessiveVariables(var);
            }
            s2 = s2 + " " + sequence.toString();
        }
        return s2.trim();
    }

    public String compact(IVar[] vars) {
        return this.compact(vars, false);
    }

    public String compactOrdered(IVar[] vars) {
        return this.compact(vars, true);
    }

    public String[] compact(IVar[][] vars) {
        return (String[])Stream.of(vars).map(t -> this.compact((IVar[])t)).toArray(String[]::new);
    }

    public String[] compactOrdered(IVar[][] vars) {
        return (String[])Stream.of(vars).map(t -> this.compactOrdered((IVar[])t)).toArray(String[]::new);
    }

    public String compactMatrix(IVar[][] matrix) {
        String s = this.compactOrdered(Utilities.collect(IVar.class, new Object[]{matrix}));
        if (s.indexOf(" ") == -1) {
            return s;
        }
        return Stream.of(matrix).map(t -> "(" + Stream.of(t).map(x -> x.toString()).collect(Collectors.joining(",")) + ")").collect(Collectors.joining("\n"));
    }

    public int nVarsIn(String s) {
        return this.expand(s).split(" ").length;
    }

    private final class SequenceOfSuccessiveVariables {
        private IVar firstVar;
        private String prefix;
        private int[] starts;
        private int posMod = -1;
        private int stopMod;

        SequenceOfSuccessiveVariables(IVar var) {
            this.firstVar = var;
            String id = var.id();
            if (id.indexOf(91) != -1) {
                this.prefix = id.substring(0, id.indexOf(91));
                this.starts = Utilities.splitToInts(id.substring(id.indexOf(91)), "\\[|\\]");
            }
        }

        int differJustAt(int[] t) {
            int pos = -1;
            for (int i = 0; i < this.starts.length; ++i) {
                if (this.starts[i] == t[i]) continue;
                if (pos == -1) {
                    pos = i;
                    continue;
                }
                return -1;
            }
            return pos;
        }

        boolean canBeExtendedWith(String id) {
            if (id.indexOf(91) == -1 || this.prefix == null || !this.prefix.equals(id.substring(0, id.indexOf(91)))) {
                return false;
            }
            int[] t = Utilities.splitToInts(id.substring(id.indexOf(91)), "\\[|\\]");
            int pos = this.differJustAt(t);
            if (pos == -1) {
                return false;
            }
            if (this.posMod == -1) {
                if (t[pos] != this.starts[pos] + 1) {
                    return false;
                }
                this.posMod = pos;
                this.stopMod = t[pos];
            } else {
                if (pos != this.posMod) {
                    return false;
                }
                if (t[pos] != this.stopMod + 1) {
                    return false;
                }
                this.stopMod = t[pos];
            }
            return true;
        }

        public String toString() {
            if (this.prefix == null) {
                return this.firstVar.id();
            }
            String s = this.prefix;
            for (int i = 0; i < this.starts.length; ++i) {
                s = this.posMod != i ? s + "[" + this.starts[i] + "]" : (this.starts[this.posMod] == 0 && VarEntities.this.varToVarArray.get(this.firstVar) != null && this.stopMod == VarEntities.this.varToVarArray.get((Object)this.firstVar).sizes[this.posMod] - 1 ? s + "[]" : s + "[" + this.starts[i] + ".." + this.stopMod + "]");
            }
            return s;
        }
    }

    class VarArray5D
    extends VarArray {
        protected VarArray5D(String id, IVar[][][][][] vars, String note, Types.TypeClass ... classes) {
            super(id, new int[]{vars.length, vars[0].length, vars[0][0].length, vars[0][0][0].length, vars[0][0][0][0].length}, note, classes, vars, 0, 1, 2, 3, 4);
        }
    }

    class VarArray4D
    extends VarArray {
        protected VarArray4D(String id, IVar[][][][] vars, String note, Types.TypeClass ... classes) {
            super(id, new int[]{vars.length, vars[0].length, vars[0][0].length, vars[0][0][0].length}, note, classes, vars, 0, 1, 2, 3);
        }
    }

    class VarArray3D
    extends VarArray {
        protected VarArray3D(String id, IVar[][][] vars, String note, Types.TypeClass ... classes) {
            super(id, new int[]{vars.length, vars[0].length, vars[0][0].length}, note, classes, vars, 0, 1, 2);
        }
    }

    class VarArray2D
    extends VarArray {
        protected VarArray2D(String id, IVar[][] vars, String note, Types.TypeClass ... classes) {
            super(id, new int[]{vars.length, vars[0].length}, note, classes, vars, 0, 1);
        }
    }

    class VarArray1D
    extends VarArray {
        public VarArray1D(String id, IVar[] vars, String note, Types.TypeClass ... classes) {
            super(id, new int[]{vars.length}, note, classes, vars, 0);
        }
    }

    public abstract class VarArray
    extends VarEntity {
        public final int[] sizes;
        final int[] mins;
        final int[] maxs;
        final int[] dimensions;
        public Object vars;
        public final IVar[] flatVars;

        public String getStringSize() {
            return Arrays.stream(this.sizes).mapToObj(s -> "[" + s + "]").reduce("", (s, t) -> s + t);
        }

        @Override
        public XVariables.TypeVar getType() {
            return this.flatVars[0] instanceof IVar.Var ? XVariables.TypeVar.integer : (this.flatVars[0] instanceof IVar.VarSymbolic ? XVariables.TypeVar.symbolic : null);
        }

        protected VarArray(String id, int[] sizes, String note, Types.TypeClass[] classes, Object vars, int ... dimensions) {
            super(id, note, classes);
            this.sizes = sizes;
            this.mins = new int[sizes.length];
            this.maxs = new int[sizes.length];
            this.vars = vars;
            this.flatVars = Utilities.collect(IVar.class, vars);
            this.dimensions = dimensions;
            Utilities.control(Utilities.isRegular(vars), "Not regular arrays");
        }

        private int updateWith(int increment, int dimension, int i) {
            this.mins[dimension] = Math.min(this.mins[dimension], i);
            this.maxs[dimension] = Math.max(this.maxs[dimension], i);
            return increment;
        }

        protected int updateRanges(Object array, IVar[] t, int dimIndex) {
            Object[] vars = (Object[])array;
            if (dimIndex == this.dimensions.length - 1) {
                return IntStream.range(0, vars.length).filter(i -> Utilities.indexOf(vars[i], t) != -1).map(i -> this.updateWith(1, this.dimensions[dimIndex], i)).sum();
            }
            int nbFound = 0;
            for (int i2 = 0; i2 < vars.length; ++i2) {
                int nb = this.updateRanges(vars[i2], t, dimIndex + 1);
                if (nb <= 0) continue;
                nbFound += this.updateWith(nb, this.dimensions[dimIndex], i2);
            }
            return nbFound;
        }

        protected String compactFormOf(IVar[] t) {
            assert (IntStream.range(0, t.length).noneMatch(i -> IntStream.range(i + 1, t.length).anyMatch(j -> t[i] == t[j])));
            if (Utilities.indexOf(t[0], this.flatVars) == -1) {
                return null;
            }
            Arrays.fill(this.mins, Integer.MAX_VALUE);
            Arrays.fill(this.maxs, -1);
            int nbFound = this.updateRanges(this.vars, t, 0);
            if (nbFound != t.length) {
                return null;
            }
            int size = 1;
            for (int i2 = 0; i2 < this.mins.length; ++i2) {
                size *= this.maxs[i2] - this.mins[i2] + 1;
            }
            if (size != t.length) {
                return null;
            }
            String s = this.id;
            for (int i3 = 0; i3 < this.mins.length; ++i3) {
                s = s + "[" + (this.mins[i3] == 0 && this.maxs[i3] == this.sizes[i3] - 1 ? "" : (this.mins[i3] == this.maxs[i3] ? this.mins[i3] + "" : this.mins[i3] + ".." + this.maxs[i3])) + "]";
            }
            return s;
        }
    }

    public final class VarAlone
    extends VarEntity {
        public final IVar var;

        protected VarAlone(String id, IVar var, String note, Types.TypeClass ... classes) {
            super(id, note, classes);
            this.var = var;
        }

        @Override
        public XVariables.TypeVar getType() {
            return this.var instanceof IVar.Var ? XVariables.TypeVar.integer : (this.var instanceof IVar.VarSymbolic ? XVariables.TypeVar.symbolic : null);
        }
    }

    public abstract class VarEntity
    extends ModelingEntity {
        protected VarEntity(String id, String note, Types.TypeClass[] classes) {
            super(id, note, classes);
        }

        public abstract XVariables.TypeVar getType();
    }
}

