/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.modeler.problems;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.ProblemAPI;

public class Warehouse
implements ProblemAPI {
    int fixedCost;
    int[] warehouseCapacities;
    int[][] storeSupplyCosts;

    @Override
    public void model() {
        int nWarehouses = this.warehouseCapacities.length;
        int nStores = this.storeSupplyCosts.length;
        IVar.Var[] s = this.array("s", this.size(nStores), this.dom(this.range(nWarehouses)), "s[i] is the warehouse supplier of the ith store", new Types.TypeClass[0]);
        IVar.Var[] c = this.array("c", this.size(nStores), (int i) -> this.dom(this.storeSupplyCosts[i]), "c[i] is the cost of supplying the ith store", new Types.TypeClass[0]);
        IVar[] o = this.array("o", this.size(nWarehouses), this.dom(0, 1), "o[i] is 1 if the ith warehouse is open", new Types.TypeClass[0]);
        this.forall(this.range(nWarehouses), (int i) -> this.atMost(s, i, this.warehouseCapacities[i])).note("Capacities of warehouses must not be exceeded.");
        this.forall(this.range(nStores), arg_0 -> this.lambda$model$2((IVar.Var[])o, s, arg_0)).note("The warehouse supplier of the ith store must be open.");
        this.forall(this.range(nStores), (int i) -> this.element(this.storeSupplyCosts[i], s[i], c[i])).note("Computing the cost of supplying the ith store.");
        int[] coeffs = this.vals(this.repeat(1, nStores), this.repeat(this.fixedCost, nWarehouses));
        this.minimize(SUM, this.vars(c, o), coeffs).note("minimizing the overall cost");
    }

    private /* synthetic */ void lambda$model$2(IVar.Var[] o, IVar.Var[] s, int i) {
        this.element(o, s[i], 1);
    }
}

