/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.parser.entries;

import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Utilities;
import org.xcsp.parser.entries.XValues;
import org.xcsp.parser.entries.XVariables;

public class XDomains {

    public static final class XDomGraph
    implements XDomComplex {
        public final String[] requiredV;
        public final String[] possibleV;
        public final String[][] requiredE;
        public final String[][] possibleE;

        public static XDomGraph parse(String reqV, String reqE, String posV, String posE, XVariables.TypeVar type) {
            String[] rV = reqV.split("\\s+");
            String[] pV = posV.split("\\s+");
            String[][] rE = (String[][])Stream.of(reqE.split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L).map(tok -> tok.split("\\s*,\\s*")).toArray(x$0 -> new String[x$0][]);
            String[][] pE = (String[][])Stream.of(posE.split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L).map(tok -> tok.split("\\s*,\\s*")).toArray(x$0 -> new String[x$0][]);
            return new XDomGraph(rV, pV, rE, pE);
        }

        protected XDomGraph(String[] requiredV, String[] possibleV, String[][] requiredE, String[][] possibleE) {
            this.requiredV = requiredV;
            this.possibleV = possibleV;
            this.requiredE = requiredE;
            this.possibleE = possibleE;
        }

        public String toString() {
            return "[{" + Utilities.join(this.requiredV) + "-" + Utilities.join(this.requiredE) + "},{" + Utilities.join(this.possibleV) + "-" + Utilities.join(this.possibleE) + "}]";
        }
    }

    public static final class XDomSet
    implements XDomComplex {
        public final Object[] required;
        public final Object[] possible;

        public static XDomSet parse(String req, String pos, XVariables.TypeVar type) {
            return type == XVariables.TypeVar.set ? new XDomSet(XValues.IntegerEntity.parseSeq(req), XValues.IntegerEntity.parseSeq(pos)) : new XDomSet(req.split("\\s+"), pos.split("\\s+"));
        }

        protected XDomSet(Object[] required, Object[] possible) {
            this.required = required;
            this.possible = possible;
        }

        public String toString() {
            return "[{" + Utilities.join(this.required) + "},{" + Utilities.join(this.possible) + "}]";
        }
    }

    public static interface XDomComplex
    extends XDom {
    }

    public static final class XDomStochastic
    extends XDomBasic {
        public final XValues.SimpleValue[] probas;

        public static XDomStochastic parse(String s, XVariables.TypeVar type) {
            String[] toks = s.split("\\s+");
            Object[] values = new Object[toks.length];
            XValues.SimpleValue[] probas = new XValues.SimpleValue[toks.length];
            for (int i = 0; i < toks.length; ++i) {
                String[] t = toks[i].split(":");
                values[i] = type == XVariables.TypeVar.symbolic_stochastic ? t[0] : XValues.IntegerEntity.parse(t[0]);
                probas[i] = XValues.SimpleValue.parse(t[1]);
            }
            return new XDomStochastic(values, probas);
        }

        protected XDomStochastic(Object[] values, XValues.SimpleValue[] probas) {
            super(values);
            this.probas = probas;
            assert (values.length == probas.length);
        }

        @Override
        public String toString() {
            return super.toString() + " Probas: " + Utilities.join(this.probas);
        }
    }

    public static class XDomReal
    extends XDomBasic {
        protected XDomReal(String seq) {
            super(XValues.RealInterval.parseSeq(seq));
        }
    }

    public static final class XDomSymbolic
    extends XDomBasic {
        protected XDomSymbolic(String seq) {
            super(Utilities.sort(seq.split("\\s+")));
        }

        public XDomSymbolic(String[] values) {
            super(values);
        }

        public boolean contains(String s) {
            return Arrays.binarySearch(this.values, s) >= 0;
        }
    }

    public static final class XDomInteger
    extends XDomBasic {
        private Long nValues;

        public static String compactFormOf(int[] values) {
            int prevVal;
            StringBuilder sb = new StringBuilder();
            int startInterval = prevVal = values[0];
            for (int i = 1; i < values.length; ++i) {
                int currVal = values[i];
                if (currVal != prevVal + 1) {
                    sb.append(prevVal == startInterval ? Integer.valueOf(prevVal) : startInterval + (prevVal == startInterval + 1 ? " " : "..") + prevVal).append(" ");
                    startInterval = currVal;
                }
                prevVal = currVal;
            }
            return sb.append(prevVal == startInterval ? Integer.valueOf(prevVal) : startInterval + (prevVal == startInterval + 1 ? " " : "..") + prevVal).toString();
        }

        protected XDomInteger(String seq) {
            super(XValues.IntegerEntity.parseSeq(seq));
        }

        public XDomInteger(int[] values) {
            super(IntStream.of(values).mapToObj(v -> new XValues.IntegerValue(v)).toArray(XValues.IntegerEntity[]::new));
        }

        public XDomInteger(int min, int max) {
            super(new XValues.IntegerEntity[]{new XValues.IntegerInterval(min, max)});
        }

        public long firstValue() {
            return ((XValues.IntegerEntity)this.values[0]).smallest();
        }

        public long lastValue() {
            return ((XValues.IntegerEntity)this.values[this.values.length - 1]).greatest();
        }

        public XValues.TypePrimitive whichPrimitive() {
            return XValues.TypePrimitive.whichPrimitiveFor(this.firstValue(), this.lastValue());
        }

        public boolean contains(long v) {
            int left = 0;
            int right = this.values.length - 1;
            while (left <= right) {
                int center = (left + right) / 2;
                int res = ((XValues.IntegerEntity)this.values[center]).compareContains(v);
                if (res == 0) {
                    return true;
                }
                if (res == -1) {
                    left = center + 1;
                    continue;
                }
                right = center - 1;
            }
            return false;
        }

        public long nValues() {
            return this.nValues != null ? this.nValues : (this.nValues = Long.valueOf(XValues.IntegerEntity.nValues((XValues.IntegerEntity[])this.values)));
        }
    }

    public static class XDomBasic
    implements XDom {
        public final Object[] values;

        public static XDomBasic parse(String s, XVariables.TypeVar type) {
            return type == XVariables.TypeVar.integer ? new XDomInteger(s) : (type == XVariables.TypeVar.symbolic ? new XDomSymbolic(s) : (type == XVariables.TypeVar.real ? new XDomReal(s) : XDomStochastic.parse(s, type)));
        }

        public static XDomBasic[] domainsFor(XVariables.XVar[] vars) {
            return (XDomBasic[])Stream.of(vars).map(x -> (XDomBasic)x.dom).toArray(XDomBasic[]::new);
        }

        public static XDomBasic[] domainsFor(XVariables.XVar[][] varss) {
            XDomBasic[] doms = XDomBasic.domainsFor(varss[0]);
            for (XVariables.XVar[] vars : varss) {
                if (!IntStream.range(0, vars.length).anyMatch(i -> doms[i] != vars[i].dom)) continue;
                return null;
            }
            return doms;
        }

        protected XDomBasic(Object[] values) {
            this.values = values;
        }

        public String toString() {
            return Utilities.join(this.values);
        }
    }

    public static interface XDom {
    }
}

