/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.domains;

import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Range;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.domains.Values;

public class Domains {

    public static final class DomGraph
    implements DomComplex {
        public final String[] requiredV;
        public final String[] possibleV;
        public final String[][] requiredE;
        public final String[][] possibleE;

        public static DomGraph parse(String reqV, String reqE, String posV, String posE, Types.TypeVar type) {
            String[] rV = reqV.split("\\s+");
            String[] pV = posV.split("\\s+");
            String[][] rE = (String[][])Stream.of(reqE.split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L).map(tok -> tok.split("\\s*,\\s*")).toArray(x$0 -> new String[x$0][]);
            String[][] pE = (String[][])Stream.of(posE.split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L).map(tok -> tok.split("\\s*,\\s*")).toArray(x$0 -> new String[x$0][]);
            return new DomGraph(rV, pV, rE, pE);
        }

        protected DomGraph(String[] requiredV, String[] possibleV, String[][] requiredE, String[][] possibleE) {
            this.requiredV = requiredV;
            this.possibleV = possibleV;
            this.requiredE = requiredE;
            this.possibleE = possibleE;
        }

        public String toString() {
            return "[{" + Utilities.join(this.requiredV) + "-" + Utilities.join(this.requiredE) + "},{" + Utilities.join(this.possibleV) + "-" + Utilities.join(this.possibleE) + "}]";
        }
    }

    public static final class DomSet
    implements DomComplex {
        public final Object[] required;
        public final Object[] possible;

        public static DomSet parse(String req, String pos, Types.TypeVar type) {
            return type == Types.TypeVar.set ? new DomSet(Values.IntegerEntity.parseSeq(req), Values.IntegerEntity.parseSeq(pos)) : new DomSet(req.split("\\s+"), pos.split("\\s+"));
        }

        protected DomSet(Object[] required, Object[] possible) {
            this.required = required;
            this.possible = possible;
        }

        public String toString() {
            return "[{" + Utilities.join(this.required) + "},{" + Utilities.join(this.possible) + "}]";
        }
    }

    public static interface DomComplex
    extends IDom {
    }

    public static final class DomStochastic
    extends DomBasic {
        public final Values.SimpleValue[] probas;

        public static DomStochastic parse(String s, Types.TypeVar type) {
            String[] toks = s.split("\\s+");
            Object[] values = new Object[toks.length];
            Values.SimpleValue[] probas = new Values.SimpleValue[toks.length];
            for (int i = 0; i < toks.length; ++i) {
                String[] t = toks[i].split(":");
                values[i] = type == Types.TypeVar.symbolic_stochastic ? t[0] : Values.IntegerEntity.parse(t[0]);
                probas[i] = Values.SimpleValue.parse(t[1]);
            }
            return new DomStochastic(values, probas);
        }

        protected DomStochastic(Object[] values, Values.SimpleValue[] probas) {
            super(values);
            this.probas = probas;
            assert (values.length == probas.length);
        }

        @Override
        public String toString() {
            return super.toString() + " Probas: " + Utilities.join(this.probas);
        }
    }

    public static class DomReal
    extends DomBasic {
        protected DomReal(String seq) {
            super(Values.RealInterval.parseSeq(seq));
        }
    }

    public static final class DomSymbolic
    extends DomBasic {
        protected DomSymbolic(String seq) {
            super(Stream.of(seq.split("\\s+")).sorted().toArray(String[]::new));
        }

        public DomSymbolic(String[] values) {
            super(values);
        }

        public boolean contains(String s) {
            return Arrays.binarySearch(this.values, s) >= 0;
        }
    }

    public static final class Dom
    extends DomBasic {
        private Object cacheAllValues;

        public static String compactFormOf(int[] values) {
            int prevVal;
            StringBuilder sb = new StringBuilder();
            if (values.length == 2) {
                return values[0] + " " + values[1];
            }
            int startInterval = prevVal = values[0];
            for (int i = 1; i < values.length; ++i) {
                int currVal = values[i];
                if (currVal != prevVal + 1) {
                    sb.append(prevVal == startInterval ? Integer.valueOf(prevVal) : startInterval + (prevVal == startInterval + 1 ? " " : "..") + prevVal).append(" ");
                    startInterval = currVal;
                }
                prevVal = currVal;
            }
            return sb.append(prevVal == startInterval ? Integer.valueOf(prevVal) : startInterval + (prevVal == startInterval + 1 ? " " : "..") + prevVal).toString();
        }

        protected Dom(String seq) {
            super(Values.IntegerEntity.parseSeq(seq));
        }

        public Dom(int[] values) {
            super(IntStream.of(values).mapToObj(v -> new Values.IntegerValue(v)).toArray(Values.IntegerEntity[]::new));
        }

        public Dom(int min, int max) {
            super(new Values.IntegerEntity[]{new Values.IntegerInterval(min, max)});
        }

        public long firstValue() {
            return ((Values.IntegerEntity)this.values[0]).smallest();
        }

        public long lastValue() {
            return ((Values.IntegerEntity)this.values[this.values.length - 1]).greatest();
        }

        public boolean contains(long v) {
            int left = 0;
            int right = this.values.length - 1;
            while (left <= right) {
                int center = (left + right) / 2;
                int res = ((Values.IntegerEntity)this.values[center]).compareContains(v);
                if (res == 0) {
                    return true;
                }
                if (res == -1) {
                    left = center + 1;
                    continue;
                }
                right = center - 1;
            }
            return false;
        }

        public long nValues() {
            if (this.cacheAllValues == null) {
                this.cacheAllValues = this.allValues();
            }
            return this.cacheAllValues == null ? -1L : (this.cacheAllValues instanceof Range ? (long)((Range)this.cacheAllValues).length() : (long)((int[])this.cacheAllValues).length);
        }

        public Object allValues() {
            if (this.cacheAllValues == null) {
                Values.IntegerInterval ii;
                Values.IntegerEntity[] vs = (Values.IntegerEntity[])this.values;
                this.cacheAllValues = this.values.length == 1 && this.values[0] instanceof Values.IntegerInterval ? ((ii = (Values.IntegerInterval)this.values[0]).width() == -1L ? null : new Range(ii)) : (Object)Values.IntegerEntity.toIntArray(vs, Integer.MAX_VALUE);
            }
            assert (!(this.cacheAllValues instanceof int[]) || IntStream.range(0, ((int[])this.cacheAllValues).length - 1).allMatch(i -> ((int[])this.cacheAllValues)[i] < ((int[])this.cacheAllValues)[i + 1]));
            return this.cacheAllValues;
        }

        public Dom when(boolean condition) {
            return condition ? this : null;
        }
    }

    public static class DomBasic
    implements IDom {
        public final Object[] values;

        public static DomBasic parse(String s, Types.TypeVar type) {
            return type == Types.TypeVar.integer ? new Dom(s) : (type == Types.TypeVar.symbolic ? new DomSymbolic(s) : (type == Types.TypeVar.real ? new DomReal(s) : DomStochastic.parse(s, type)));
        }

        protected DomBasic(Object[] values) {
            this.values = values;
        }

        public String toString() {
            return this.values.length == 2 ? this.values[0] + " " + this.values[1] : Utilities.join(this.values);
        }
    }

    public static interface IDom {
    }
}

