/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.enumerations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Utilities;
import org.xcsp.common.enumerations.EnumerationAbstract;
import org.xcsp.common.enumerations.EnumerationOfCombinations;
import org.xcsp.common.enumerations.EnumerationOfPermutations;

public class EnumerationCartesian
extends EnumerationAbstract {
    private static Map<String, int[][]> cacheOfTuples;
    protected final int[][] values;

    public static int[][] tuplesWithDiffValuesSummingTo(int limit, int nValues, int tupleLength, int offset) {
        String key;
        int[][] tuples;
        if (cacheOfTuples == null) {
            cacheOfTuples = new HashMap<String, int[][]>();
        }
        if ((tuples = cacheOfTuples.get(key = limit + "_" + nValues + "_" + tupleLength + "_" + offset)) != null) {
            return tuples;
        }
        ArrayList<int[]> list = new ArrayList<int[]>();
        int[][] combinations = new EnumerationOfCombinations(nValues, tupleLength).toArray();
        int[][] permutations = new EnumerationOfPermutations(tupleLength).toArray();
        for (int[] t : combinations) {
            if (offset != 0) {
                int i2 = 0;
                while (i2 < t.length) {
                    int n = i2++;
                    t[n] = t[n] + offset;
                }
            }
            if (IntStream.of(t).sum() != limit) continue;
            for (int[] perm : permutations) {
                list.add(IntStream.range(0, t.length).map(i -> t[perm[i]]).toArray());
            }
        }
        tuples = (int[][])list.stream().sorted(Utilities.lexComparatorInt).toArray((int x$0) -> new int[x$0][]);
        cacheOfTuples.put(key, tuples);
        return tuples;
    }

    public EnumerationCartesian(int[][] values, boolean clone) {
        super(values.length, Stream.of(values).allMatch(t -> IntStream.range(0, ((int[])t).length).allMatch(i -> t[i] == i)));
        this.values = clone ? (int[][])Stream.of(values).map(t -> (int[])t.clone()).toArray((int x$0) -> new int[x$0][]) : values;
        Utilities.control(Stream.of(values).allMatch(t -> ((int[])t).length > 0 && IntStream.range(0, ((int[])t).length - 1).allMatch(i -> t[i] < t[i + 1])), "values are not correctly formed (order,...)");
        this.reset();
    }

    public EnumerationCartesian(int[][] values) {
        this(values, true);
    }

    public EnumerationCartesian(int ... nValues) {
        this((int[][])IntStream.range(0, nValues.length).mapToObj(i -> IntStream.range(0, nValues[i]).toArray()).toArray((int x$0) -> new int[x$0][]), false);
    }

    public EnumerationCartesian(int nValues, int tupleLength) {
        this(IntStream.range(0, tupleLength).map(i -> nValues).toArray());
    }

    @Override
    protected int valAt(int i) {
        return this.values[i][this.currTupleOfIdxs[i]];
    }

    @Override
    protected void computeFirstTuple() {
        Arrays.fill(this.currTupleOfIdxs, 0);
    }

    @Override
    public boolean hasNext() {
        if (this.nextTuple != null) {
            return this.nextTuple == Boolean.TRUE;
        }
        for (int i = this.values.length - 1; i >= 0; --i) {
            if (this.currTupleOfIdxs[i] + 1 != this.values[i].length) {
                int n = i;
                this.currTupleOfIdxs[n] = this.currTupleOfIdxs[n] + 1;
                this.nextTuple = Boolean.TRUE;
                return true;
            }
            this.currTupleOfIdxs[i] = 0;
        }
        this.nextTuple = Boolean.FALSE;
        return false;
    }

    public static void main(String[] args) {
        new EnumerationCartesian(7, 7, 7, 7).displayAllTuples();
        new EnumerationCartesian(new int[][]{{2, 3, 4}, {1, 5}, {12, 20}}).displayAllTuples();
    }
}

