/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.structures;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Condition;
import org.xcsp.common.Utilities;

public interface AbstractTuple {
    public boolean match(int[] var1);

    public static class SmartTuple
    implements AbstractTuple {
        public Object[] values;

        public SmartTuple(Object[] values) {
            this.values = values;
            Utilities.control(Stream.of(values).allMatch(v -> v instanceof Integer || v instanceof Condition.ConditionVal || v instanceof Condition.ConditionSet), "Bad form for smart tuple");
        }

        @Override
        public boolean match(int[] t) {
            assert (t.length == this.values.length);
            for (int i = 0; i < t.length; ++i) {
                Condition condition;
                int v;
                if (!(this.values[i] instanceof Integer ? (v = ((Integer)this.values[i]).intValue()) != 0x7FFFFFFE && t[i] != 0x7FFFFFFE && v != t[i] : ((condition = (Condition)this.values[i]) instanceof Condition.ConditionVal ? !((Condition.ConditionVal)condition).operator.isValidFor(t[i], ((Condition.ConditionVal)condition).k) : (condition instanceof Condition.ConditionIntvl ? !((Condition.ConditionIntvl)condition).operator.isValidFor(t[i], ((Condition.ConditionIntvl)condition).min, ((Condition.ConditionIntvl)condition).max) : condition instanceof Condition.ConditionIntset && !((Condition.ConditionIntset)condition).operator.isValidFor(t[i], ((Condition.ConditionIntset)condition).t))))) continue;
                return false;
            }
            return true;
        }
    }

    public static class OrdinaryTuple
    implements AbstractTuple {
        public int[] values;

        public OrdinaryTuple(int[] values) {
            this.values = values;
        }

        @Override
        public boolean match(int[] t) {
            assert (t.length == this.values.length);
            return IntStream.range(0, t.length).allMatch(i -> this.values[i] == 0x7FFFFFFE || t[i] == 0x7FFFFFFE || this.values[i] == t[i]);
        }
    }
}

