/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.structures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Range;
import org.xcsp.common.Utilities;
import org.xcsp.common.enumerations.EnumerationCartesian;
import org.xcsp.common.structures.TableAbstract;

public class Table
extends TableAbstract {
    private List<int[]> list = new ArrayList<int[]>();

    public static int[][] clean(int[] ... tuples) {
        TreeSet<int[]> set = new TreeSet<int[]>(Utilities.lexComparatorInt);
        for (int i = 0; i < tuples.length - 1; ++i) {
            if (set.size() > 0) {
                set.add(tuples[i]);
                continue;
            }
            if (Utilities.lexComparatorInt.compare(tuples[i], tuples[i + 1]) < 0) continue;
            for (int j = 0; j <= i; ++j) {
                set.add(tuples[j]);
            }
        }
        if (set.size() > 0) {
            set.add(tuples[tuples.length - 1]);
        }
        return set.size() == 0 ? tuples : (int[][])set.stream().toArray(x$0 -> new int[x$0][]);
    }

    public static int[][] clean(List<int[]> tuples) {
        return Table.clean((int[][])tuples.stream().toArray(x$0 -> new int[x$0][]));
    }

    public static int[][] toOrdinaryTable(int[][] shortTable, int[][] values) {
        ArrayList<Object> tuples = new ArrayList<Object>();
        for (int[] t : shortTable) {
            int[] pos = IntStream.range(0, t.length).filter(i -> t[i] == 0x7FFFFFFE).toArray();
            if (pos.length == 0) {
                tuples.add(t.clone());
                continue;
            }
            EnumerationCartesian ec = new EnumerationCartesian((int[][])IntStream.range(0, t.length).mapToObj(i -> {
                int[] nArray;
                if (t[i] == 0x7FFFFFFE) {
                    nArray = values[i];
                } else {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = t[i];
                }
                return nArray;
            }).toArray(x$0 -> new int[x$0][]));
            while (ec.hasNext()) {
                tuples.add(ec.next().clone());
            }
        }
        return (int[][])tuples.stream().sorted(Utilities.lexComparatorInt).distinct().toArray(x$0 -> new int[x$0][]);
    }

    public static int[][] toOrdinaryTable(int[][] shortTable, int ... nValues) {
        return Table.toOrdinaryTable(shortTable, (int[][])IntStream.of(nValues).mapToObj(i -> IntStream.range(0, i).toArray()).toArray(x$0 -> new int[x$0][]));
    }

    @Override
    public Table positive(Boolean positive) {
        this.positive = positive;
        return this;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    private Table addTuple(int[] tuple) {
        Utilities.control(tuple != null && tuple.length > 0, "The tuple has a bad length");
        Utilities.control(this.list.size() == 0 || this.list.get(0).length == tuple.length, "The tuple has a different length from those already recorded");
        this.list.add(tuple);
        return this;
    }

    public Table add(int val, int ... otherVals) {
        return this.addTuple(IntStream.range(0, otherVals.length + 1).map(i -> i == 0 ? val : otherVals[i - 1]).toArray());
    }

    public Table add(int[] ... tuples) {
        Stream.of(tuples).forEach(t -> this.addTuple((int[])t));
        return this;
    }

    public Table add(Stream<int[]> stream) {
        return this.add((int[][])stream.toArray(x$0 -> new int[x$0][]));
    }

    public Table add(Collection<int[]> tuples) {
        return this.add((int[][])tuples.toArray((T[])new int[0][]));
    }

    public Table add(Table table) {
        return this.add(table.toArray());
    }

    public Table add(String s) {
        boolean b = this.controlStringRepresentationOfTuples(s);
        Utilities.control(b, "The specified string is not correct, as it does not correspond to a sequence of integer tuples");
        int[][] tuples = (int[][])Stream.of(s.split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L).map(tok -> Stream.of(tok.split("\\s*,\\s*")).mapToInt(v -> v.equals("*") ? 0x7FFFFFFE : Integer.parseInt(v)).toArray()).toArray(x$0 -> new int[x$0][]);
        Stream.of(tuples).forEach(tuple -> this.addTuple((int[])tuple));
        return this;
    }

    public Table addFrom(Range r, Function<Integer, int[]> f) {
        r.stream().mapToObj(i -> (int[])f.apply(i)).filter(t -> t != null).forEach(t -> this.add(new int[][]{t}));
        return this;
    }

    public Table addFrom(Range.Rangesx2 r2, BiFunction<Integer, Integer, int[]> f) {
        for (int i : r2.items[0]) {
            for (int j : r2.items[1]) {
                int[] t = f.apply(i, j);
                if (t == null) continue;
                this.add(new int[][]{t});
            }
        }
        return this;
    }

    private int[] intersectionOf(int[] t1, int[] t2, int[] out) {
        assert (t1.length == t2.length);
        for (int i = 0; i < t1.length; ++i) {
            if (t1[i] == t2[i]) {
                out[i] = t1[i];
                continue;
            }
            if (t1[i] == 0x7FFFFFFE) {
                out[i] = t2[i];
                continue;
            }
            if (t2[i] == 0x7FFFFFFE) {
                out[i] = t1[i];
                continue;
            }
            return null;
        }
        return out;
    }

    public Table intersectionWith(Table other) {
        Utilities.control(this.positive != false && other.positive != false, "Tables must be both positive");
        int[][] m1 = this.toArray();
        int[][] m2 = other.toArray();
        Utilities.control(m1[0].length == m2[0].length, "Not the same arity");
        if (m1.length > m2.length) {
            int[][] m = m1;
            m1 = m2;
            m2 = m;
        }
        int[] tmp = new int[m1[0].length];
        TreeSet<int[]> setOfSupports = new TreeSet<int[]>(Utilities.lexComparatorInt);
        for (int[] t1 : m1) {
            IntStream.range(0, tmp.length).forEach(i -> {
                tmp[i] = t1[i] == 0x7FFFFFFE ? Integer.MIN_VALUE : t1[i];
            });
            int index = Arrays.binarySearch(m2, tmp, Utilities.lexComparatorInt);
            if (index >= 0) {
                setOfSupports.add((int[])t1.clone());
                continue;
            }
            for (int i2 = -index - 1; i2 < m2.length; ++i2) {
                if (this.intersectionOf(t1, m2[i2], tmp) == null) continue;
                setOfSupports.add((int[])tmp.clone());
            }
        }
        return new Table().add(setOfSupports.stream());
    }

    public Table addColumnWithValue(int position, int value) {
        int[][] m = this.toArray();
        Utilities.control(0 <= position && position <= m[0].length, "bad value of column position");
        return new Table().add(IntStream.range(0, m.length).mapToObj(i -> IntStream.range(0, m[0].length + 1).map(j -> j < position ? m[i][j] : (j == position ? 0x7FFFFFFE : m[i][j - 1])).toArray()));
    }

    public int[][] toArray() {
        return (int[][])this.list.stream().sorted(Utilities.lexComparatorInt).distinct().toArray(x$0 -> new int[x$0][]);
    }

    public int[][] toOrdinaryTableArray(int[][] values) {
        return Table.toOrdinaryTable(this.toArray(), values);
    }

    public int[][] toOrdinaryTableArray(int ... nValues) {
        return Table.toOrdinaryTable(this.toArray(), nValues);
    }

    public String toString() {
        return this.list.stream().map(t -> "(" + Utilities.join(t, ",") + ")").collect(Collectors.joining(" "));
    }
}

