/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.structures;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.xcsp.common.Utilities;
import org.xcsp.common.structures.TableAbstract;

public class TableSymbolic
extends TableAbstract {
    private List<String[]> list = new ArrayList<String[]>();

    public static String[][] clean(String[][] tuples) {
        TreeSet<String[]> set = new TreeSet<String[]>(Utilities.lexComparatorString);
        for (int i = 0; i < tuples.length - 1; ++i) {
            if (set.size() > 0) {
                set.add(tuples[i]);
                continue;
            }
            if (Utilities.lexComparatorString.compare(tuples[i], tuples[i + 1]) < 0) continue;
            for (int j = 0; j <= i; ++j) {
                set.add(tuples[j]);
            }
        }
        if (set.size() > 0) {
            set.add(tuples[tuples.length - 1]);
        }
        return set.size() == 0 ? tuples : (String[][])set.stream().toArray(x$0 -> new String[x$0][]);
    }

    public static String[][] clean(List<String[]> tuples) {
        return TableSymbolic.clean((String[][])tuples.stream().toArray(x$0 -> new String[x$0][]));
    }

    @Override
    public TableSymbolic positive(Boolean positive) {
        this.positive = positive;
        return this;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    public TableSymbolic add(String ... tuple) {
        Utilities.control(tuple.length > 0, "A tuple of length 0 has been encoutered during parsing.\nThe syntax used for listing tuples is not correct.\nFor example, this should be (1,2)(2,1)(2,3) for an integer table and (a,b)(b,b)(c,a) for a symbolic table");
        Utilities.control(this.list.size() == 0 || this.list.get(0).length == tuple.length, "The tuple has a different length from those already recorded");
        this.list.add(tuple);
        return this;
    }

    public TableSymbolic add(String[] ... tuples) {
        Stream.of(tuples).forEach(t -> this.add((String)t));
        return this;
    }

    public TableSymbolic add(Stream<String[]> stream) {
        stream.forEach(t -> this.add((String)t));
        return this;
    }

    public TableSymbolic addSequence(String s) {
        boolean b = this.controlStringRepresentationOfTuples(s);
        Utilities.control(!b, "The specified string is not correct, as it does not correspond to a sequence of symbolic tuples");
        String[][] tuples = (String[][])Stream.of(s.split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L).map(tok -> (String[])Stream.of(tok.split("\\s*,\\s*")).toArray(String[]::new)).toArray(x$0 -> new String[x$0][]);
        Stream.of(tuples).forEach(tuple -> this.add((String)tuple));
        return this;
    }

    public String[][] toArray() {
        return (String[][])this.list.stream().sorted(Utilities.lexComparatorString).distinct().toArray(x$0 -> new String[x$0][]);
    }
}

