/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.modeler.definitions;

import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.xcsp.common.Condition;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.domains.Domains;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.modeler.definitions.DefXCSP;
import org.xcsp.modeler.definitions.IRootForCtrAndObj;
import org.xcsp.modeler.entities.CtrEntities;

public interface ICtr
extends IRootForCtrAndObj {
    public static final String EXTENSION = Types.TypeCtr.extension.name();
    public static final String INTENSION = Types.TypeCtr.intension.name();
    public static final String SMART = Types.TypeCtr.smart.name();
    public static final String REGULAR = Types.TypeCtr.regular.name();
    public static final String GRAMMAR = Types.TypeCtr.grammar.name();
    public static final String MDD = Types.TypeCtr.mdd.name();
    public static final String ALL_DIFFERENT = Types.TypeCtr.allDifferent.name();
    public static final String ALL_EQUAL = Types.TypeCtr.allEqual.name();
    public static final String ALL_DISTANT = Types.TypeCtr.allDistant.name();
    public static final String ORDERED = Types.TypeCtr.ordered.name();
    public static final String LEX = Types.TypeCtr.lex.name();
    public static final String ALL_INCOMPARABLE = Types.TypeCtr.allIncomparable.name();
    public static final String SUM = Types.TypeCtr.sum.name();
    public static final String COUNT = Types.TypeCtr.count.name();
    public static final String NVALUES = Types.TypeCtr.nValues.name();
    public static final String CARDINALITY = Types.TypeCtr.cardinality.name();
    public static final String BALANCE = Types.TypeCtr.balance.name();
    public static final String SPREAD = Types.TypeCtr.spread.name();
    public static final String DEVIATION = Types.TypeCtr.deviation.name();
    public static final String SUM_COSTS = Types.TypeCtr.sumCosts.name();
    public static final String STRETCH = Types.TypeCtr.stretch.name();
    public static final String NO_OVERLAP = Types.TypeCtr.noOverlap.name();
    public static final String CUMULATIVE = Types.TypeCtr.cumulative.name();
    public static final String BIN_PACKING = Types.TypeCtr.binPacking.name();
    public static final String KNAPSACK = Types.TypeCtr.knapsack.name();
    public static final String NETWORK_FLOW = Types.TypeCtr.networkFlow.name();
    public static final String CIRCUIT = Types.TypeCtr.circuit.name();
    public static final String NCIRCUITS = Types.TypeCtr.nCircuits.name();
    public static final String P\u00c4TH = Types.TypeCtr.path.name();
    public static final String NPATHS = Types.TypeCtr.nPaths.name();
    public static final String TREE = Types.TypeCtr.tree.name();
    public static final String NTREES = Types.TypeCtr.nTrees.name();
    public static final String ARBO = Types.TypeCtr.arbo.name();
    public static final String NARBOS = Types.TypeCtr.nArbos.name();
    public static final String NCLIQUES = Types.TypeCtr.nCliques.name();
    public static final String CLAUSE = Types.TypeCtr.clause.name();
    public static final String INSTANTIATION = Types.TypeCtr.instantiation.name();
    public static final String ALL_INTERSECTING = Types.TypeCtr.allIntersecting.name();
    public static final String RANGE = Types.TypeCtr.range.name();
    public static final String ROOTS = Types.TypeCtr.roots.name();
    public static final String PARTITION = Types.TypeCtr.partition.name();
    public static final String MINIMUM = Types.TypeCtr.minimum.name();
    public static final String MAXIMUM = Types.TypeCtr.maximum.name();
    public static final String ELEMENT = Types.TypeCtr.element.name();
    public static final String CHANNEL = Types.TypeCtr.channel.name();
    public static final String PERMUTATION = Types.TypeCtr.permutation.name();
    public static final String PRECEDENCE = Types.TypeCtr.precedence.name();
    public static final String AND = Types.TypeCtr.and.name();
    public static final String OR = Types.TypeCtr.or.name();
    public static final String NOT = Types.TypeCtr.not.name();
    public static final String IF_THEN = Types.TypeCtr.ifThen.name();
    public static final String IF_THEN_ELSE = Types.TypeCtr.ifThenElse.name();
    public static final String SLIDE = Types.TypeCtr.slide.name();
    public static final String SEQBIN = Types.TypeCtr.seqbin.name();
    public static final String LIST = Types.TypeChild.list.name();
    public static final String SET = Types.TypeChild.set.name();
    public static final String MSET = Types.TypeChild.mset.name();
    public static final String MATRIX = Types.TypeChild.matrix.name();
    public static final String FUNCTION = Types.TypeChild.function.name();
    public static final String SUPPORTS = Types.TypeChild.supports.name();
    public static final String CONFLICTS = Types.TypeChild.conflicts.name();
    public static final String EXCEPT = Types.TypeChild.except.name();
    public static final String VALUE = Types.TypeChild.value.name();
    public static final String VALUES = Types.TypeChild.values.name();
    public static final String TOTAL = Types.TypeChild.total.name();
    public static final String COEFFS = Types.TypeChild.coeffs.name();
    public static final String CONDITION = Types.TypeChild.condition.name();
    public static final String COST = Types.TypeChild.cost.name();
    public static final String OPERATOR = Types.TypeChild.operator.name();
    public static final String NUMBER = Types.TypeChild.number.name();
    public static final String TRANSITIONS = Types.TypeChild.transitions.name();
    public static final String START = Types.TypeChild.start.name();
    public static final String FINAL = Types.TypeChild.FINAL.name().toLowerCase();
    public static final String TERMINAL = Types.TypeChild.terminal.name();
    public static final String RULES = Types.TypeChild.rules.name();
    public static final String INDEX = Types.TypeChild.index.name();
    public static final String MAPPING = Types.TypeChild.mapping.name();
    public static final String OCCURS = Types.TypeChild.occurs.name();
    public static final String ROW_OCCURS = Types.TypeChild.rowOccurs.name();
    public static final String COL_OCCURS = Types.TypeChild.colOccurs.name();
    public static final String WIDTHS = Types.TypeChild.widths.name();
    public static final String PATTERNS = Types.TypeChild.patterns.name();
    public static final String ORIGINS = Types.TypeChild.origins.name();
    public static final String LENGTHS = Types.TypeChild.lengths.name();
    public static final String ENDS = Types.TypeChild.ends.name();
    public static final String HEIGHTS = Types.TypeChild.heights.name();
    public static final String MACHINES = Types.TypeChild.machines.name();
    public static final String CONDITIONS = Types.TypeChild.conditions.name();
    public static final String SIZES = Types.TypeChild.sizes.name();
    public static final String WEIGHTS = Types.TypeChild.weights.name();
    public static final String PROFITS = Types.TypeChild.profits.name();
    public static final String LIMIT = Types.TypeChild.limit.name();
    public static final String SIZE = Types.TypeChild.size.name();
    public static final String ROOT = Types.TypeChild.root.name();
    public static final String IMAGE = Types.TypeChild.image.name();
    public static final String GRAPH = Types.TypeChild.graph.name();
    public static final String ROW = Types.TypeChild.row.name();
    public static final String ARITY = "arity";
    public static final String TUPLES = "tuples";
    public static final String POSITIVE = "positive";
    public static final String START_INDEX = "startIndex";
    public static final String START_ROW_INDEX = "startRowIndex";
    public static final String START_COL_INDEX = "startColIndex";
    public static final String RANK = "rank";
    public static final String CLOSED = "closed";
    public static final String START_INDEX2 = "startIndex2";
    public static final String LIST2 = "list2";
    public static final String LISTS = "lists";
    public static final String SETS = "sets";
    public static final String MSETS = "msets";
    public static final String ROWS = "rows";
    public static final String CIRCULAR = "circular";
    public static final String OFFSETS = "offsets";
    public static final String COLLECTS = "collects";
    public static final String ALONES = "alones";
    public static final String ZERO_IGNORED = "zeroIgnored";
    public static final String REC = "rec";

    default public Class<?> findInterfaceFor(Class<?> c) {
        if (c == null) {
            return null;
        }
        if (c.isInterface() && ICtr.class.isAssignableFrom(c)) {
            return c;
        }
        Class c1 = Stream.of(c.getInterfaces()).map(cc -> this.findInterfaceFor((Class<?>)cc)).filter(cc -> cc != null).findFirst().orElse(null);
        if (c1 != null) {
            return c1;
        }
        return this.findInterfaceFor(c.getSuperclass());
    }

    @Override
    default public DefXCSP defXCSP() {
        Class<?> cc = this.findInterfaceFor(this.getClass());
        String s = cc.getSimpleName();
        String name = Character.toLowerCase(s.charAt(4)) + s.substring(5);
        DefXCSP def = this.def(name);
        Map<String, Object> map = this.mapXCSP();
        String[] keys = (String[])map.keySet().stream().filter(key -> key != null && !key.equals("scope")).toArray(String[]::new);
        for (int i = 0; i < keys.length; ++i) {
            def.addOne(keys[i]);
        }
        return def;
    }

    public static interface ICtrIfThenElse
    extends ICtr,
    Meta {
        public static ICtrIfThenElse buildFrom(final IVar[] scope, final CtrEntities.CtrAlone ca1, final CtrEntities.CtrAlone ca2, final CtrEntities.CtrAlone ca3) {
            return new ICtrIfThenElse(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, ICtr.ALONES, (Object)new CtrEntities.CtrAlone[]{ca1, ca2, ca3});
                }
            };
        }

        @Override
        default public DefXCSP defXCSP() {
            DefXCSP def = this.def(IF_THEN_ELSE);
            CtrEntities.CtrAlone[] cas = (CtrEntities.CtrAlone[])def.map.get(ICtr.ALONES);
            def.addSon(ICtr.REC, cas[0]);
            def.addSon(ICtr.REC, cas[1]);
            def.addSon(ICtr.REC, cas[2]);
            return def;
        }
    }

    public static interface ICtrIfThen
    extends ICtr,
    Meta {
        public static ICtrIfThen buildFrom(final IVar[] scope, final CtrEntities.CtrAlone ca1, final CtrEntities.CtrAlone ca2) {
            return new ICtrIfThen(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, ICtr.ALONES, (Object)new CtrEntities.CtrAlone[]{ca1, ca2});
                }
            };
        }

        @Override
        default public DefXCSP defXCSP() {
            DefXCSP def = this.def(IF_THEN);
            CtrEntities.CtrAlone[] cas = (CtrEntities.CtrAlone[])def.map.get(ICtr.ALONES);
            def.addSon(ICtr.REC, cas[0]);
            def.addSon(ICtr.REC, cas[1]);
            return def;
        }
    }

    public static interface ICtrSlide
    extends ICtr,
    Meta {
        public static ICtrSlide buildFrom(final IVar[] scope, final Boolean circular, final IVar[][] lists, final int[] offsets, final int[] collects, final CtrEntities.CtrAlone[] cas) {
            return new ICtrSlide(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, ICtr.CIRCULAR, (Object)circular, ICtr.LISTS, lists, ICtr.OFFSETS, (Object)offsets, ICtr.COLLECTS, (Object)collects, ICtr.ALONES, (Object)cas);
                }
            };
        }

        @Override
        default public DefXCSP defXCSP() {
            throw new RuntimeException();
        }
    }

    public static interface Meta {
    }

    public static interface ICtrSmart
    extends ICtr {
        public static ICtrSmart buildFrom(final IVar[] scope, final String list, final String[] rows) {
            return new ICtrSmart(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, LIST, (Object)list, ICtr.ROWS, (Object)rows);
                }
            };
        }

        @Override
        default public DefXCSP defXCSP() {
            DefXCSP def = this.def(SMART).add(LIST);
            String[] rows = (String[])def.map.get(ICtr.ROWS);
            Stream.of(rows).forEach(o -> def.addSon(ROW, o));
            return def;
        }
    }

    public static interface ICtrInstantiation
    extends ICtr {
        public static ICtrInstantiation buildFrom(final IVar[] scope, final String list, final String values) {
            return new ICtrInstantiation(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, LIST, (Object)list, VALUES, (Object)values);
                }
            };
        }
    }

    public static interface ICtrClause
    extends ICtr {
        public static ICtrClause buildFrom(final IVar[] scope, final String list) {
            return new ICtrClause(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, LIST, (Object)list);
                }
            };
        }
    }

    public static interface ICtrCircuit
    extends ICtr {
        public static ICtrCircuit buildFrom(final IVar[] scope, final String list, final Integer startIndex, final Object size) {
            return new ICtrCircuit(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, LIST, (Object)list, ICtr.START_INDEX, (Object)startIndex, SIZE, size);
                }
            };
        }

        @Override
        default public DefXCSP defXCSP() {
            DefXCSP def = this.def(CIRCUIT);
            if (def.map.get(ICtr.START_INDEX) == null || (Integer)def.map.get(ICtr.START_INDEX) == 0) {
                def.add(LIST);
            } else {
                def.addSon(LIST, def.map.get(LIST), ICtr.START_INDEX, def.map.get(ICtr.START_INDEX));
            }
            return def.add(SIZE);
        }
    }

    public static interface ICtrCumulative
    extends ICtr {
        public static ICtrCumulative buildFrom(final IVar[] scope, final String origins, final String lengths, final String ends, final String heights, final Condition condition) {
            return new ICtrCumulative(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, ORIGINS, (Object)origins, LENGTHS, (Object)lengths, ENDS, (Object)ends, HEIGHTS, (Object)heights, CONDITION, (Object)condition);
                }
            };
        }
    }

    public static interface ICtrNoOverlap
    extends ICtr {
        public static ICtrNoOverlap buildFrom(final IVar[] scope, final String origins, final String lengths, final Boolean zeroIgnored) {
            return new ICtrNoOverlap(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, ORIGINS, (Object)origins, LENGTHS, (Object)lengths, ICtr.ZERO_IGNORED, (Object)zeroIgnored);
                }
            };
        }

        @Override
        default public DefXCSP defXCSP() {
            DefXCSP def = this.def(NO_OVERLAP).add(ORIGINS, LENGTHS);
            if (def.map.get(ICtr.ZERO_IGNORED) != null && !((Boolean)def.map.get(ICtr.ZERO_IGNORED)).booleanValue()) {
                def.attributes.add(new AbstractMap.SimpleEntry<String, Boolean>(ICtr.ZERO_IGNORED, Boolean.FALSE));
            }
            return def;
        }
    }

    public static interface ICtrStretch
    extends ICtr {
        public static ICtrStretch buildFrom(final IVar[] scope, final String list, final String values, final String widths, final String patterns) {
            return new ICtrStretch(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, LIST, (Object)list, VALUES, (Object)values, WIDTHS, (Object)widths, PATTERNS, (Object)patterns);
                }
            };
        }
    }

    public static interface ICtrChannel
    extends ICtr {
        public static ICtrChannel buildFrom(final IVar[] scope, final String list, final Integer startIndex, final String list2, final Integer startIndex2, final Object value) {
            return new ICtrChannel(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, LIST, (Object)list, ICtr.START_INDEX, (Object)startIndex, ICtr.LIST2, (Object)list2, ICtr.START_INDEX2, (Object)startIndex2, VALUE, value);
                }
            };
        }

        @Override
        default public DefXCSP defXCSP() {
            DefXCSP def = this.def(CHANNEL);
            if (def.map.get(ICtr.START_INDEX) == null || (Integer)def.map.get(ICtr.START_INDEX) == 0) {
                def.add(LIST);
            } else {
                def.addSon(LIST, def.map.get(LIST), ICtr.START_INDEX, def.map.get(ICtr.START_INDEX));
            }
            if (def.map.containsKey(ICtr.LIST2)) {
                if (def.map.get(ICtr.START_INDEX2) == null || (Integer)def.map.get(ICtr.START_INDEX2) == 0) {
                    def.addSon(LIST, def.map.get(ICtr.LIST2));
                } else {
                    def.addSon(LIST, def.map.get(ICtr.LIST2), ICtr.START_INDEX, def.map.get(ICtr.START_INDEX2));
                }
            }
            if (def.map.containsKey(VALUE)) {
                def.add(VALUE);
            }
            return def;
        }
    }

    public static interface ICtrElementMatrix
    extends ICtr {
        public static ICtrElementMatrix buildFrom(final IVar[] scope, final Object matrix, final Integer startRowIndex, final Object rowIndex, final Integer startColIndex, final Object colIndex, final Object value) {
            return new ICtrElementMatrix(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, MATRIX, matrix, ICtr.START_ROW_INDEX, (Object)startRowIndex, INDEX, (Object)(rowIndex + " " + colIndex), ICtr.START_COL_INDEX, (Object)startColIndex, VALUE, value);
                }
            };
        }

        @Override
        default public DefXCSP defXCSP() {
            DefXCSP def = this.def(ELEMENT);
            if (def.map.get(ICtr.START_ROW_INDEX) == null && def.map.get(ICtr.START_COL_INDEX) == null || (Integer)def.map.get(ICtr.START_ROW_INDEX) == 0) {
                def.add(MATRIX);
            } else {
                def.addSon(MATRIX, def.map.get(MATRIX), ICtr.START_ROW_INDEX, def.map.get(ICtr.START_ROW_INDEX), ICtr.START_COL_INDEX, def.map.get(ICtr.START_COL_INDEX));
            }
            def.add(INDEX);
            return def.add(VALUE);
        }
    }

    public static interface ICtrElement
    extends ICtr {
        public static ICtrElement buildFrom(final IVar[] scope, final String list, final Integer startIndex, final Object index, final Types.TypeRank rank, final Condition condition) {
            return new ICtrElement(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, LIST, (Object)list, ICtr.START_INDEX, (Object)startIndex, INDEX, index, ICtr.RANK, (Object)rank, CONDITION, (Object)condition);
                }
            };
        }

        @Override
        default public DefXCSP defXCSP() {
            DefXCSP def = this.def(ELEMENT);
            if (def.map.get(ICtr.START_INDEX) == null || (Integer)def.map.get(ICtr.START_INDEX) == 0) {
                def.add(LIST);
            } else {
                def.addSon(LIST, def.map.get(LIST), ICtr.START_INDEX, def.map.get(ICtr.START_INDEX));
            }
            if (def.map.get(ICtr.RANK) == null || (Types.TypeRank)((Object)def.map.get(ICtr.RANK)) == Types.TypeRank.ANY) {
                def.add(INDEX);
            } else {
                def.addSon(INDEX, def.map.get(INDEX), ICtr.RANK, ((Types.TypeRank)((Object)def.map.get(ICtr.RANK))).name().toLowerCase());
            }
            return def.add(CONDITION);
        }
    }

    public static interface ICtrMinimum
    extends ICtr {
        public static ICtrMinimum buildFrom(final IVar[] scope, final String list, final Integer startIndex, final Object index, final Types.TypeRank rank, final Condition condition) {
            return new ICtrMinimum(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, LIST, (Object)list, ICtr.START_INDEX, (Object)startIndex, INDEX, index, ICtr.RANK, (Object)rank, CONDITION, (Object)condition);
                }
            };
        }

        @Override
        default public DefXCSP defXCSP() {
            DefXCSP def = this.def(MINIMUM);
            if (def.map.get(ICtr.START_INDEX) == null || (Integer)def.map.get(ICtr.START_INDEX) == 0) {
                def.add(LIST);
            } else {
                def.addSon(LIST, def.map.get(LIST), ICtr.START_INDEX, def.map.get(ICtr.START_INDEX));
            }
            if (def.map.containsKey(INDEX)) {
                if (def.map.get(ICtr.RANK) == null || (Types.TypeRank)((Object)def.map.get(ICtr.RANK)) == Types.TypeRank.ANY) {
                    def.add(INDEX);
                } else {
                    def.addSon(INDEX, def.map.get(INDEX), ICtr.RANK, ((Types.TypeRank)((Object)def.map.get(ICtr.RANK))).name().toLowerCase());
                }
            }
            return def.map.containsKey(CONDITION) ? def.add(CONDITION) : def;
        }
    }

    public static interface ICtrMaximum
    extends ICtr {
        public static ICtrMaximum buildFrom(final IVar[] scope, final String list, final Integer startIndex, final Object index, final Types.TypeRank rank, final Condition condition) {
            return new ICtrMaximum(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, LIST, (Object)list, ICtr.START_INDEX, (Object)startIndex, INDEX, index, ICtr.RANK, (Object)rank, CONDITION, (Object)condition);
                }
            };
        }

        @Override
        default public DefXCSP defXCSP() {
            DefXCSP def = this.def(MAXIMUM);
            if (def.map.get(ICtr.START_INDEX) == null || (Integer)def.map.get(ICtr.START_INDEX) == 0) {
                def.add(LIST);
            } else {
                def.addSon(LIST, def.map.get(LIST), ICtr.START_INDEX, def.map.get(ICtr.START_INDEX));
            }
            if (def.map.containsKey(INDEX)) {
                if (def.map.get(ICtr.RANK) == null || (Types.TypeRank)((Object)def.map.get(ICtr.RANK)) == Types.TypeRank.ANY) {
                    def.add(INDEX);
                } else {
                    def.addSon(INDEX, def.map.get(INDEX), ICtr.RANK, ((Types.TypeRank)((Object)def.map.get(ICtr.RANK))).name().toLowerCase());
                }
            }
            return def.map.containsKey(CONDITION) ? def.add(CONDITION) : def;
        }
    }

    public static interface ICtrCardinality
    extends ICtr {
        public static ICtrCardinality buildFrom(final IVar[] scope, final String list, final String values, final Boolean closed, final String occurs) {
            return new ICtrCardinality(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, LIST, (Object)list, VALUES, (Object)values, ICtr.CLOSED, (Object)closed, OCCURS, (Object)occurs);
                }
            };
        }

        @Override
        default public DefXCSP defXCSP() {
            DefXCSP def = this.def(CARDINALITY).add(LIST);
            if (def.map.get(ICtr.CLOSED) == null || !((Boolean)def.map.get(ICtr.CLOSED)).booleanValue()) {
                def.add(VALUES);
            } else {
                def.addSon(VALUES, def.map.get(VALUES), ICtr.CLOSED, def.map.get(ICtr.CLOSED));
            }
            return def.add(OCCURS);
        }
    }

    public static interface ICtrNValues
    extends ICtr {
        public static ICtrNValues buildFrom(final IVar[] scope, final String list, final String except, final Condition condition) {
            return new ICtrNValues(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, LIST, (Object)list, EXCEPT, (Object)except, CONDITION, (Object)condition);
                }
            };
        }
    }

    public static interface ICtrCount
    extends ICtr {
        public static ICtrCount buildFrom(final IVar[] scope, final String list, final Object values, final Condition condition) {
            return new ICtrCount(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, LIST, (Object)list, VALUES, values, CONDITION, (Object)condition);
                }
            };
        }
    }

    public static interface ICtrSum
    extends ICtr {
        public static ICtrSum buildFrom(final IVar[] scope, final String list, final Object coeffs, final Condition condition) {
            return new ICtrSum(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, LIST, (Object)list, COEFFS, coeffs, CONDITION, (Object)condition);
                }
            };
        }
    }

    public static interface ICtrOrdered
    extends ICtr {
        public static ICtrOrdered buildFrom(final IVar[] scope, final String key1, final Object value1, final Object lengths, final Types.TypeOperatorRel operator) {
            return new ICtrOrdered(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, key1, value1, LENGTHS, lengths, OPERATOR, (Object)operator.name().toLowerCase());
                }
            };
        }

        @Override
        default public DefXCSP defXCSP() {
            DefXCSP def = this.def(this.mapXCSP().containsKey(ICtr.LISTS) || this.mapXCSP().containsKey(MATRIX) ? LEX : ORDERED).addListOrLifted();
            return def.add(LENGTHS, OPERATOR);
        }
    }

    public static interface ICtrAllEqual
    extends ICtr {
        public static ICtrAllEqual buildFrom(final IVar[] scope, final String key, final Object value) {
            return new ICtrAllEqual(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, key, value);
                }
            };
        }
    }

    public static interface ICtrAllDifferent
    extends ICtr {
        public static ICtrAllDifferent buildFrom(final IVar[] scope, final String key1, final Object value1, final String except) {
            Utilities.control(except == null || except.length() > 0, "Pb with except values");
            return new ICtrAllDifferent(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, key1, value1, EXCEPT, (Object)except);
                }
            };
        }
    }

    public static interface ICtrMdd
    extends ICtr {
        public static ICtrMdd buildFrom(final IVar[] scope, final String list, final String transitions) {
            return new ICtrMdd(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, LIST, (Object)list, TRANSITIONS, (Object)transitions);
                }
            };
        }

        @Override
        default public DefXCSP defXCSP() {
            return this.def(MDD).add(LIST, TRANSITIONS);
        }
    }

    public static interface ICtrRegular
    extends ICtr {
        public static ICtrRegular buildFrom(final IVar[] scope, final String list, final String transitions, final String startState, final String[] finalStates) {
            return new ICtrRegular(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, LIST, (Object)list, TRANSITIONS, (Object)transitions, START, (Object)startState, FINAL, (Object)Utilities.join(finalStates));
                }
            };
        }
    }

    public static interface ICtrExtension
    extends ICtr {
        public static ICtrExtension buildFrom(final IVar[] scope, final String list, final int arity, final int[][] tuples, final boolean positive) {
            return new ICtrExtension(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, LIST, (Object)list, ICtr.ARITY, (Object)arity, ICtr.TUPLES, tuples, ICtr.POSITIVE, (Object)positive);
                }
            };
        }

        public static ICtrExtension buildFrom(final IVar[] scope, final String list, final int arity, final String[][] tuples, final boolean positive) {
            return new ICtrExtension(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, LIST, (Object)list, ICtr.ARITY, (Object)arity, ICtr.TUPLES, tuples, ICtr.POSITIVE, (Object)positive);
                }
            };
        }

        public static String tableAsString(int[][] tuples) {
            if (tuples.length == 0) {
                return "";
            }
            if (tuples[0].length == 1) {
                return Domains.Dom.compactFormOf(Stream.of(tuples).mapToInt(t -> t[0]).toArray());
            }
            StringBuilder sb = new StringBuilder();
            for (int[] t2 : tuples) {
                sb.append("(");
                for (int i = 0; i < t2.length; ++i) {
                    sb.append(t2[i] == 0x7FFFFFFE ? "*" : Integer.valueOf(t2[i]));
                    sb.append(i < t2.length - 1 ? "," : "");
                }
                sb.append(")");
            }
            return sb.toString();
        }

        public static String tableAsString(String[][] tuples) {
            if (tuples.length == 0) {
                return "";
            }
            if (tuples[0].length == 1) {
                return Stream.of(tuples).map(t -> t[0]).collect(Collectors.joining(" "));
            }
            return Stream.of(tuples).map(t -> "(" + Stream.of(t).collect(Collectors.joining(",")) + ")").collect(Collectors.joining());
        }

        default public boolean isSimilarTo(ICtrExtension c) {
            Map<String, Object> map = this.mapXCSP();
            Map<String, Object> mapc = c.mapXCSP();
            if (!map.get(ICtr.ARITY).equals(mapc.get(ICtr.ARITY))) {
                return false;
            }
            if (!map.get(ICtr.POSITIVE).equals(mapc.get(ICtr.POSITIVE))) {
                return false;
            }
            if (map.get(ICtr.TUPLES).getClass() != mapc.get(ICtr.TUPLES).getClass()) {
                return false;
            }
            if (map.get(ICtr.TUPLES) instanceof int[][]) {
                int[][] t2;
                int[][] t1 = (int[][])map.get(ICtr.TUPLES);
                if (t1.length != (t2 = (int[][])mapc.get(ICtr.TUPLES)).length) {
                    return false;
                }
                if (t1 == t2 || t1.length == 0) {
                    return true;
                }
                if (t1.length > 50000) {
                    return false;
                }
                int arity = t1[0].length;
                for (int i = t1.length - 1; i >= 0; --i) {
                    for (int j = arity - 1; j >= 0; --j) {
                        if (t1[i][j] == t2[i][j]) continue;
                        return false;
                    }
                }
            } else {
                String[][] t2;
                String[][] t1 = (String[][])map.get(ICtr.TUPLES);
                if (t1.length != (t2 = (String[][])mapc.get(ICtr.TUPLES)).length) {
                    return false;
                }
                if (t1 == t2 || t1.length == 0) {
                    return true;
                }
                if (t1.length > 50000) {
                    return false;
                }
                int arity = t1[0].length;
                for (int i = t1.length - 1; i >= 0; --i) {
                    for (int j = arity - 1; j >= 0; --j) {
                        if (t1[i][j].equals(t2[i][j])) continue;
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        default public DefXCSP defXCSP() {
            DefXCSP def = this.def(EXTENSION).add(LIST);
            String tuples = def.map.get(ICtr.TUPLES) instanceof int[][] ? ICtrExtension.tableAsString((int[][])def.map.get(ICtr.TUPLES)) : ICtrExtension.tableAsString((String[][])def.map.get(ICtr.TUPLES));
            return def.addSon((Boolean)def.map.get(ICtr.POSITIVE) != false ? SUPPORTS : CONFLICTS, tuples);
        }
    }

    public static interface ICtrIntension
    extends ICtr {
        public static ICtrIntension buildFrom(final IVar[] scope, final XNodeParent<IVar> tree) {
            return new ICtrIntension(){

                @Override
                public Map<String, Object> mapXCSP() {
                    return IRootForCtrAndObj.map("scope", (Object)scope, FUNCTION, (Object)tree);
                }
            };
        }
    }
}

