/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.modeler.entities;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;

public abstract class ModelingEntity {
    public String id;
    public String note;
    public final Set<Types.TypeClass> classes;

    protected ModelingEntity(String id, String note, Types.TypeClass ... classes) {
        this.id = id;
        this.note = note;
        this.classes = classes == null ? new HashSet<Types.TypeClass>() : new HashSet<Types.TypeClass>(Arrays.asList(classes));
    }

    protected ModelingEntity(Types.TypeClass ... classes) {
        this((String)null, (String)null, classes);
    }

    public final ModelingEntity id(String id) {
        Utilities.control(this.id == null && id != null, "Pb with the id");
        this.id = id;
        return this;
    }

    public ModelingEntity note(String note) {
        this.note = this.note == null ? note : this.note + " " + note;
        return this;
    }

    public ModelingEntity tag(Types.TypeClass ... classes) {
        this.classes.addAll(Arrays.asList(classes));
        return this;
    }

    public final ModelingEntity tag(String ... classes) {
        return this.tag(Types.TypeClass.classesFor(classes));
    }

    public final boolean nullBasicAttributes() {
        return !(this.id != null && this.id.length() != 0 || this.note != null && this.note.length() != 0 || this.classes.size() != 0);
    }

    public static interface TagDummy {
    }
}

