/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.modeler.implementation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Stack;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.w3c.dom.Document;
import org.xcsp.common.Condition;
import org.xcsp.common.FunctionalInterfaces;
import org.xcsp.common.IVar;
import org.xcsp.common.Range;
import org.xcsp.common.Size;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.domains.Domains;
import org.xcsp.common.predicates.TreeEvaluator;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.common.structures.AbstractTuple;
import org.xcsp.common.structures.Automaton;
import org.xcsp.common.structures.Table;
import org.xcsp.common.structures.Transition;
import org.xcsp.modeler.Compiler;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.definitions.ICtr;
import org.xcsp.modeler.entities.CtrEntities;
import org.xcsp.modeler.entities.ObjEntities;
import org.xcsp.modeler.entities.VarEntities;
import org.xcsp.modeler.implementation.NotData;
import org.xcsp.modeler.implementation.ProblemDataHandler;

public abstract class ProblemIMP {
    public final ProblemAPI api;
    public final String modelVariant;
    public final String[] argsForPb;
    public final VarEntities varEntities = new VarEntities(this);
    public CtrEntities ctrEntities = new CtrEntities();
    public ObjEntities objEntities = new ObjEntities();
    public Stack<Integer> stackLoops = new Stack();
    private Scanner inScanner = new Scanner(System.in);
    public ArrayList<AbstractMap.SimpleEntry<Object, String>> parameters = new ArrayList();
    private Scanner fileScanner;
    public Annotations annotations = new Annotations();

    private static Object fatalError(Object ... objects) {
        System.out.println("\nProblem: " + Stream.of(objects).filter(o -> o != null).map(o -> o.toString()).collect(Collectors.joining("\n")));
        System.out.println("\n**********************");
        StackTraceElement[] t = Thread.currentThread().getStackTrace();
        boolean notEncounteredSubclass = true;
        boolean nextofControl = false;
        for (StackTraceElement s : t) {
            if (nextofControl) {
                System.out.println("  Line " + s.getLineNumber() + " in Class " + s.getClassName());
                nextofControl = false;
            }
            if (s.getMethodName().equals("control") && s.getClassName().equals(ProblemIMP.class.getName())) {
                nextofControl = true;
            }
            try {
                if (!notEncounteredSubclass || !ProblemAPI.class.isAssignableFrom(Class.forName(s.getClassName())) || s.getClassName().equals(ProblemAPI.class.getName())) continue;
                System.out.println("  Line " + s.getLineNumber() + " in Class " + s.getClassName());
                notEncounteredSubclass = false;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        System.out.println("**********************");
        if (Compiler.ev) {
            throw new RuntimeException();
        }
        System.exit(1);
        return null;
    }

    public static void control(boolean b, Object ... objects) {
        if (!b) {
            ProblemIMP.fatalError(objects);
        }
    }

    public static Method searchMethod(Class<?> cl, String name) {
        if (cl != ProblemAPI.class && ProblemAPI.class.isAssignableFrom(cl)) {
            for (Method m : cl.getDeclaredMethods()) {
                m.setAccessible(true);
                if (!m.getName().equals(name) || m.getGenericReturnType() != Void.TYPE || m.getGenericParameterTypes().length != 0) continue;
                return m;
            }
            return ProblemIMP.searchMethod(cl.getSuperclass(), name);
        }
        return null;
    }

    public static boolean executeMethod(Object o, String methodName) {
        Method m = ProblemIMP.searchMethod(o.getClass(), methodName);
        if (m == null) {
            return false;
        }
        m.setAccessible(true);
        try {
            m.invoke(o, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            System.out.println("Pb when executing " + methodName);
            System.out.println(e.getCause());
            System.exit(1);
        }
        return true;
    }

    public static List<Field> problemDataFields(List<Field> list, Class<?> cl) {
        if (ProblemAPI.class.isAssignableFrom(cl)) {
            ProblemIMP.problemDataFields(list, cl.getSuperclass());
            Stream.of(cl.getDeclaredFields()).filter(f -> !ProblemIMP.mustBeIgnored(f)).forEach(f -> list.add((Field)f));
        }
        return list;
    }

    public static boolean mustBeIgnored(Field field) {
        return Modifier.isStatic(field.getModifiers()) || field.isSynthetic() || field.getAnnotation(NotData.class) != null;
    }

    private Object buildInternClassObject(Constructor<?> c, Object ... fieldValues) {
        try {
            c.setAccessible(true);
            Object o = c.newInstance(this.api);
            Field[] fields = o.getClass().getDeclaredFields();
            int j = 0;
            for (int i = 0; i < fieldValues.length; ++i) {
                while (ProblemIMP.mustBeIgnored(fields[j])) {
                    ++j;
                }
                fields[j].setAccessible(true);
                fields[j++].set(o, fieldValues[i]);
            }
            return o;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Pb " + e.getCause());
            System.exit(1);
            return null;
        }
    }

    public Object buildInternClassObject(String internClass, Object ... fieldValues) {
        Class<?> c = this.api.getClass();
        while (c.getSuperclass() != Object.class) {
            c = c.getSuperclass();
        }
        Optional<Class> clazz = Stream.of(c.getDeclaredClasses()).filter(cl -> cl.getName().endsWith(internClass)).findFirst();
        ProblemIMP.control(clazz.isPresent(), "Pb with " + internClass + " as it has not been found (did you give the right name?)");
        return this.buildInternClassObject(clazz.get().getDeclaredConstructors()[0], fieldValues);
    }

    protected ProblemIMP(ProblemAPI api, String modelVariant, String[] argsForPb) {
        this.api = api;
        this.modelVariant = modelVariant;
        this.argsForPb = argsForPb;
        ProblemAPI.api2imp.put(api, this);
    }

    private String[] fmt(String dataFormat) {
        String[] stringArray;
        if (dataFormat.length() == 0) {
            return null;
        }
        if (dataFormat.startsWith("[")) {
            stringArray = dataFormat.substring(1, dataFormat.length() - 1).split(",");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = dataFormat;
        }
        String[] fmt = stringArray;
        return (String[])Stream.of(fmt).map(s -> s.equals("null") || s.equals("-") ? "" : s).toArray(String[]::new);
    }

    private Object prepareData(Class<?> type, String v) {
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Utilities.toBoolean(v);
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return Byte.parseByte(v);
        }
        if (type == Short.TYPE || type == Short.class) {
            return Short.parseShort(v);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.parseInt(v);
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long.parseLong(v);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(Float.parseFloat(v));
        }
        if (type == Double.TYPE || type == Double.class) {
            return Double.parseDouble(v);
        }
        if (type == String.class) {
            return v;
        }
        Utilities.exit("No other types for data fields currently managed " + type);
        return null;
    }

    private void setFormattedValuesOfProblemDataFields(Object[] values, String[] fmt, boolean prepare) {
        Field[] fields = ProblemIMP.problemDataFields(new ArrayList<Field>(), this.api.getClass()).toArray(new Field[0]);
        ProblemIMP.control(fields.length == values.length, "The number of fields is different from the number of specified data " + fields.length + " vs " + values.length + " " + Stream.of(fields).map(f -> f == null ? " null" : f.toString()).collect(Collectors.joining(" ")) + " " + Stream.of(values).map(f -> f == null ? "null" : f.toString()).collect(Collectors.joining(" ")));
        for (int i = 0; i < fields.length; ++i) {
            try {
                fields[i].setAccessible(true);
                Object value = values[i] instanceof String && (((String)values[i]).equals("-") || ((String)values[i]).equals("null")) ? null : (prepare ? this.prepareData(fields[i].getType(), (String)values[i]) : values[i]);
                fields[i].set(this.api, value);
                if (!prepare) continue;
                this.addParameter(value, fmt == null ? null : fmt[i]);
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                ProblemIMP.control(false, "Problem when setting the value of field " + fields[i].getName());
                e.printStackTrace();
                System.out.println(e);
            }
        }
    }

    protected void loadData(String data, String dataFormat, boolean dataSaving) {
        if (data.length() != 0) {
            if (data.endsWith("json")) {
                new ProblemDataHandler().load(this.api, data);
                String value = data.startsWith(this.api.getClass().getSimpleName()) ? data.substring(this.api.getClass().getSimpleName().length() + 1) : data;
                this.addParameter(value);
            } else {
                Object[] objectArray;
                ProblemIMP.control(data.startsWith("[") == data.endsWith("]"), "Either specify a simple value (such as an integer) or an array with the form [v1,v2,..]");
                ProblemIMP.control(data.indexOf(" ") == -1, "No space is allowed in specified data");
                if (data.startsWith("[")) {
                    objectArray = data.substring(1, data.length() - 1).split(",");
                } else {
                    Object[] objectArray2 = new String[1];
                    objectArray = objectArray2;
                    objectArray2[0] = data;
                }
                Object[] values = objectArray;
                this.setFormattedValuesOfProblemDataFields(values, this.fmt(dataFormat), true);
            }
        } else {
            Method m = ProblemIMP.searchMethod(this.api.getClass(), "data");
            if (m == null) {
                ProblemIMP.control(ProblemIMP.problemDataFields(new ArrayList<Field>(), this.api.getClass()).toArray(new Field[0]).length == 0, "Data must be specified.");
            } else {
                ProblemIMP.executeMethod(this.api, "data");
            }
            String[] fmt = this.fmt(dataFormat);
            if (fmt != null) {
                ProblemIMP.control(fmt.length == this.parameters.size(), "");
                IntStream.range(0, fmt.length).forEach(i -> this.parameters.get(i).setValue(fmt[i]));
            }
        }
        if (dataSaving) {
            new ProblemDataHandler().save(this.api, this.api.name());
        }
    }

    public void setDataValues(Object value1, Object ... otherValues) {
        this.setFormattedValuesOfProblemDataFields(IntStream.range(0, otherValues.length + 1).mapToObj(i -> i == 0 ? value1 : otherValues[i - 1]).toArray(), null, false);
    }

    private String nameSimplified() {
        Class<?> clazz = this.api.getClass();
        while (clazz.getSuperclass() != Object.class) {
            clazz = clazz.getSuperclass();
        }
        return clazz.getSimpleName();
    }

    public String name() {
        String s = this.nameSimplified();
        s = s + (this.modelVariant != null && this.modelVariant.length() > 0 ? "-" + this.modelVariant : "") + this.formattedPbParameters();
        return s.endsWith(".xml") ? s.substring(0, s.lastIndexOf(".xml")) : s;
    }

    public abstract Class<? extends IVar.Var> classVI();

    public abstract Class<? extends IVar.VarSymbolic> classVS();

    public Types.TypeFramework typeFramework() {
        return Types.TypeFramework.CSP;
    }

    public Object addParameter(Object value, String format) {
        this.parameters.add(new AbstractMap.SimpleEntry<Object, String>(value, format));
        return value;
    }

    public Object addParameter(Object value) {
        return this.addParameter(value, null);
    }

    public final String ask(String message) {
        if (this.parameters.size() < this.argsForPb.length) {
            return this.argsForPb[this.parameters.size()];
        }
        System.out.print(message + " : ");
        return this.inScanner.next();
    }

    public String trimParameter(String s) {
        int start = s.lastIndexOf(File.separator) == -1 ? 0 : s.lastIndexOf(File.separator) + 1;
        int end = s.lastIndexOf(".") == -1 ? s.length() : s.lastIndexOf(".");
        return s.substring(start, end);
    }

    public String formattedPbParameters() {
        String s = "";
        for (AbstractMap.SimpleEntry<Object, String> p : this.parameters) {
            String t;
            if (p.getKey() == null) continue;
            String string = t = p.getValue() != null ? String.format(p.getValue(), p.getKey()) : p.getKey().toString();
            if ((t = this.trimParameter(t)).length() == 0) continue;
            s = s + "-" + t;
        }
        return s;
    }

    public boolean askBoolean(String message, Function<Boolean, String> format) {
        Boolean b = Utilities.toBoolean(this.ask(message + " (yes/no)"));
        Utilities.control(b != null, "A boolean value was expected when asking " + message);
        return (Boolean)this.addParameter(b, format == null ? null : format.apply(b));
    }

    public boolean askBoolean(String message) {
        return this.askBoolean(message, null);
    }

    public int askInt(String message, Predicate<Integer> control, IntFunction<String> format) {
        Integer v = Utilities.toInteger(this.ask(message));
        Utilities.control(v != null, "Value " + v + " for " + message + " is not valid (not an integer)");
        Utilities.control(control == null || control.test(v), "Value " + v + " for " + message + " does not respect the control " + control);
        return (Integer)this.addParameter(v, format == null ? null : format.apply(v));
    }

    public int askInt(String message, Range range, IntFunction<String> format) {
        return this.askInt(message, (Integer i) -> range.contains((int)i), format);
    }

    public int askInt(String message, Predicate<Integer> control, String format) {
        return this.askInt(message, control, (int v) -> format);
    }

    public int askInt(String message, Range range, String format) {
        return this.askInt(message, (Integer i) -> range.contains((int)i), (int v) -> format);
    }

    public int askInt(String message, Predicate<Integer> control) {
        return this.askInt(message, control, (IntFunction<String>)null);
    }

    public int askInt(String message, Range range) {
        return this.askInt(message, (Integer i) -> range.contains((int)i), (IntFunction<String>)null);
    }

    public int askInt(String message, String format) {
        return this.askInt(message, (Predicate<Integer>)null, format);
    }

    public int askInt(String message) {
        return this.askInt(message, (Predicate<Integer>)null, (IntFunction<String>)null);
    }

    public double askDouble(String message, Predicate<Double> control, DoubleFunction<String> format) {
        Double d = Utilities.toDouble(this.ask(message));
        Utilities.control(d != null, "Value " + d + " for " + message + " is not valid (not a double)");
        Utilities.control(control == null || control.test(d), "Value " + d + " for " + message + " does not respect the control " + control);
        return (Double)this.addParameter(d, format == null ? null : format.apply(d));
    }

    public double askDouble(String message, Predicate<Double> control, String format) {
        return this.askDouble(message, control, (double v) -> format);
    }

    public double askDouble(String message, Predicate<Double> control) {
        return this.askDouble(message, control, (DoubleFunction<String>)null);
    }

    public double askDouble(String message, String format) {
        return this.askDouble(message, null, format);
    }

    public double askDouble(String message) {
        return this.askDouble(message, null, (DoubleFunction<String>)null);
    }

    public String askString(String message, Function<String, String> format) {
        String s = this.ask(message);
        return (String)this.addParameter(s, format == null ? null : format.apply(s));
    }

    public String askString(String message) {
        return this.askString(message, null);
    }

    public Scanner fileScanner() {
        if (this.fileScanner != null) {
            return this.fileScanner;
        }
        String fileName = this.askString("Enter data filename");
        try {
            this.fileScanner = new Scanner(new File(fileName));
            return this.fileScanner;
        }
        catch (FileNotFoundException e) {
            System.out.println("Error with " + fileName);
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    public abstract IVar.Var buildVarInteger(String var1, Domains.Dom var2);

    public abstract IVar.VarSymbolic buildVarSymbolic(String var1, Domains.DomSymbolic var2);

    public IVar.Var[] fill(String id, Size.Size1D size, FunctionalInterfaces.IntToDom f, IVar.Var[] t) {
        for (int i = 0; i < size.lengths[0]; ++i) {
            IVar.Var x;
            Domains.Dom dom = f.apply(i);
            if (dom == null || (x = this.buildVarInteger(id + this.variableNameSuffixFor(i), dom)) == null) continue;
            t[i] = x;
        }
        return t;
    }

    public IVar.Var[][] fill(String id, Size.Size2D size, FunctionalInterfaces.Intx2ToDom f, IVar.Var[][] t) {
        IntStream.range(0, size.lengths[0]).forEach(i -> this.fill(id + "[" + i + "]", Size.Size1D.build(size.lengths[1]), (int j) -> f.apply(i, j), t[i]));
        return t;
    }

    public IVar.Var[][][] fill(String id, Size.Size3D size, FunctionalInterfaces.Intx3ToDom f, IVar.Var[][][] t) {
        IntStream.range(0, size.lengths[0]).forEach(i -> this.fill(id + "[" + i + "]", Size.Size2D.build(size.lengths[1], size.lengths[2]), (int j, int k) -> f.apply(i, j, k), t[i]));
        return t;
    }

    public IVar.Var[][][][] fill(String id, Size.Size4D size, FunctionalInterfaces.Intx4ToDom f, IVar.Var[][][][] t) {
        IntStream.range(0, size.lengths[0]).forEach(i -> this.fill(id + "[" + i + "]", Size.Size3D.build(size.lengths[1], size.lengths[2], size.lengths[3]), (int j, int k, int l) -> f.apply(i, j, k, l), t[i]));
        return t;
    }

    public IVar.Var[][][][][] fill(String id, Size.Size5D size, FunctionalInterfaces.Intx5ToDom f, IVar.Var[][][][][] t) {
        IntStream.range(0, size.lengths[0]).forEach(i -> this.fill(id + "[" + i + "]", Size.Size4D.build(size.lengths[1], size.lengths[2], size.lengths[3], size.lengths[4]), (int j, int k, int l, int m) -> f.apply(i, j, k, l, m), t[i]));
        return t;
    }

    public IVar.VarSymbolic[] fill(String id, Size.Size1D size, FunctionalInterfaces.IntToDomSymbolic f, IVar.VarSymbolic[] t) {
        for (int i = 0; i < size.lengths[0]; ++i) {
            IVar.VarSymbolic x;
            Domains.DomSymbolic dom = f.apply(i);
            if (dom == null || (x = this.buildVarSymbolic(id + this.variableNameSuffixFor(i), dom)) == null) continue;
            t[i] = x;
        }
        return t;
    }

    public IVar.VarSymbolic[][] fill(String id, Size.Size2D size, FunctionalInterfaces.Intx2ToDomSymbolic f, IVar.VarSymbolic[][] t) {
        IntStream.range(0, size.lengths[0]).forEach(i -> this.fill(id + "[" + i + "]", Size.Size1D.build(size.lengths[1]), (int j) -> f.apply(i, j), t[i]));
        return t;
    }

    public IVar.VarSymbolic[][][] fill(String id, Size.Size3D size, FunctionalInterfaces.Intx3ToDomSymbolic f, IVar.VarSymbolic[][][] t) {
        IntStream.range(0, size.lengths[0]).forEach(i -> this.fill(id + "[" + i + "]", Size.Size2D.build(size.lengths[1], size.lengths[2]), (int j, int k) -> f.apply(i, j, k), t[i]));
        return t;
    }

    public <T extends IVar> T[] vars(Object ... objects) {
        return Utilities.collect(IVar.class, Stream.of(objects).map(o -> o instanceof XNode ? ((XNode)o).vars() : o));
    }

    public <T extends IVar> T[] vars(T[][] x) {
        return this.vars(new Object[]{x});
    }

    public <T extends IVar> T[] clean(T[] vars) {
        return (IVar[])Utilities.convert(Stream.of(vars).filter(x -> x != null).collect(Collectors.toList()));
    }

    public <T extends IVar> T[] distinct(T[] vars) {
        return (IVar[])Utilities.convert(Stream.of(vars).filter(x -> x != null).distinct().collect(Collectors.toList()));
    }

    public <T extends IVar> T[] distinctSorted(T[] vars) {
        return (IVar[])Utilities.convert(Stream.of(vars).filter(x -> x != null).distinct().sorted().collect(Collectors.toList()));
    }

    public void save(Document document, String fileName) {
        if (fileName == null) {
            Utilities.save(document, new PrintWriter(System.out, true));
        } else {
            System.out.print("\n  Saving XCSP File " + fileName + " ... ");
            Utilities.save(document, fileName);
            System.out.println("Finished.");
        }
    }

    public void indentAndCompressXmlUnderLinux(String fileName) {
        if (fileName != null) {
            System.out.print("  Indenting and Compressing File, yielding " + fileName + ".lzma ... ");
            try {
                Runtime.getRuntime().exec("xmlindent -i 2 -w " + fileName).waitFor();
                Runtime.getRuntime().exec("rm " + fileName + ".lzma").waitFor();
                Runtime.getRuntime().exec("lzma " + fileName).waitFor();
                Runtime.getRuntime().exec("rm " + fileName + "~").waitFor();
            }
            catch (Exception e) {
                Utilities.exit("Pb when Indenting/Compressing File " + fileName + " " + e);
            }
            System.out.println("Finished.\n");
        }
    }

    public String variableNameSuffixFor(int ... vals) {
        return "[" + Utilities.join(vals, "][") + "]";
    }

    public String intervalAsString(int[] lbs, int[] ubs) {
        Utilities.control(lbs.length == ubs.length, "Bad form of intervals");
        return IntStream.range(0, lbs.length).mapToObj(i -> lbs[i] + ".." + ubs[i]).collect(Collectors.joining(" "));
    }

    public IVar[] scope(Object ... objects) {
        objects = Stream.of(objects).filter(o -> o != null).map(o -> o instanceof Condition ? ((Condition)o).involvedVar() : o).toArray();
        return (IVar[])Utilities.convert(Stream.of(Utilities.collect(IVar.class, objects)).distinct().collect(Collectors.toList()));
    }

    public CtrEntities.CtrEntity dummyConstraint(String message) {
        System.out.println("Dummy constraint. " + message + " Is that correct?");
        CtrEntities ctrEntities = this.ctrEntities;
        ctrEntities.getClass();
        return ctrEntities.new CtrEntities.CtrAloneDummy(message, new Types.TypeClass[0]);
    }

    public abstract CtrEntities.CtrEntity intension(XNodeParent<IVar> var1);

    public CtrEntities.CtrEntity lessThan(Object operand1, Object operand2) {
        return this.intension(XNodeParent.lt(operand1, operand2));
    }

    public CtrEntities.CtrEntity lessEqual(Object operand1, Object operand2) {
        return this.intension(XNodeParent.le(operand1, operand2));
    }

    public CtrEntities.CtrEntity greaterThan(Object operand1, Object operand2) {
        return this.intension(XNodeParent.gt(operand1, operand2));
    }

    public CtrEntities.CtrEntity greaterEqual(Object operand1, Object operand2) {
        return this.intension(XNodeParent.ge(operand1, operand2));
    }

    public CtrEntities.CtrEntity equal(Object ... operands) {
        return this.intension(XNodeParent.eq(operands));
    }

    public final CtrEntities.CtrEntity different(Object ... operands) {
        return this.intension(XNodeParent.ne(operands));
    }

    public final CtrEntities.CtrEntity conjunction(Object ... operands) {
        return this.intension(XNodeParent.and(operands));
    }

    public final CtrEntities.CtrEntity disjunction(Object ... operands) {
        return this.intension(XNodeParent.or(operands));
    }

    protected abstract Converter getConverter();

    public CtrEntities.CtrAlone extension(XNodeParent<IVar> tree) {
        Utilities.control(tree.vars() instanceof IVar.Var[], "Currently, only implemented for integer variables");
        Converter converter = this.getConverter();
        IVar.Var[] scp = (IVar.Var[])tree.vars();
        String key = converter.handle(scp, tree);
        return this.extension(scp, converter.cacheTable.get(key), (boolean)converter.cachePositive.get(key));
    }

    public final CtrEntities.CtrAlone extensionDisjunction(List<XNodeParent<IVar>> trees) {
        Utilities.control(trees.stream().allMatch(tree -> tree.vars() instanceof IVar.Var[]), "Currently, only implemented for integer variables");
        Converter converter = this.getConverter();
        Object[] scp = (IVar.Var[])this.api.singleVariablesFrom(trees, t -> t.vars());
        Table table = new Table();
        for (XNodeParent<IVar> root : trees) {
            IVar.Var[] ls = (IVar.Var[])root.vars();
            int[][] supports = new TreeEvaluator(root).generateSupports(converter.domValuesOf(ls));
            int[][] tuples = this.api.range(supports.length).range(scp.length).map((i, j) -> 0x7FFFFFFE);
            for (int c = 0; c < ls.length; ++c) {
                int cc = Utilities.indexOf(ls[c], scp);
                for (int i2 = 0; i2 < tuples.length; ++i2) {
                    tuples[i2][cc] = supports[i2][c];
                }
            }
            table.add(tuples);
        }
        return this.extension((IVar.Var[])scp, table.toArray(), true);
    }

    public abstract CtrEntities.CtrAlone extension(IVar.Var[] var1, int[][] var2, boolean var3);

    public abstract CtrEntities.CtrAlone extension(IVar.VarSymbolic[] var1, String[][] var2, boolean var3);

    public abstract CtrEntities.CtrAlone extension(IVar.Var[] var1, AbstractTuple[] var2, boolean var3);

    public abstract CtrEntities.CtrEntity regular(IVar.Var[] var1, Automaton var2);

    public abstract CtrEntities.CtrEntity mdd(IVar.Var[] var1, Transition[] var2);

    public abstract CtrEntities.CtrEntity allDifferent(IVar.Var[] var1);

    public abstract CtrEntities.CtrEntity allDifferent(IVar.VarSymbolic[] var1);

    public abstract CtrEntities.CtrEntity allDifferent(IVar.Var[] var1, int[] var2);

    public abstract CtrEntities.CtrEntity allDifferentList(IVar.Var[] ... var1);

    public abstract CtrEntities.CtrEntity allDifferentMatrix(IVar.Var[][] var1);

    public abstract CtrEntities.CtrEntity allDifferent(XNode<IVar>[] var1);

    public abstract CtrEntities.CtrEntity allEqual(IVar.Var ... var1);

    public abstract CtrEntities.CtrEntity allEqual(IVar.VarSymbolic ... var1);

    public abstract CtrEntities.CtrEntity allEqualList(IVar.Var[] ... var1);

    public abstract CtrEntities.CtrEntity ordered(IVar.Var[] var1, int[] var2, Types.TypeOperatorRel var3);

    public abstract CtrEntities.CtrEntity ordered(IVar.Var[] var1, IVar.Var[] var2, Types.TypeOperatorRel var3);

    public abstract CtrEntities.CtrEntity lex(IVar.Var[][] var1, Types.TypeOperatorRel var2);

    public abstract CtrEntities.CtrEntity lexMatrix(IVar.Var[][] var1, Types.TypeOperatorRel var2);

    public abstract CtrEntities.CtrEntity precedence(IVar.Var[] var1, int[] var2, boolean var3);

    public abstract CtrEntities.CtrEntity sum(IVar.Var[] var1, int[] var2, Condition var3);

    public abstract CtrEntities.CtrEntity sum(IVar.Var[] var1, IVar.Var[] var2, Condition var3);

    public abstract CtrEntities.CtrEntity sum(XNode<IVar>[] var1, int[] var2, Condition var3);

    public abstract CtrEntities.CtrEntity count(IVar.Var[] var1, int[] var2, Condition var3);

    public abstract CtrEntities.CtrEntity count(IVar.Var[] var1, IVar.Var[] var2, Condition var3);

    public abstract CtrEntities.CtrEntity nValues(IVar.Var[] var1, Condition var2);

    public abstract CtrEntities.CtrEntity nValues(IVar.Var[] var1, Condition var2, int[] var3);

    public abstract CtrEntities.CtrEntity cardinality(IVar.Var[] var1, int[] var2, boolean var3, int[] var4);

    public abstract CtrEntities.CtrEntity cardinality(IVar.Var[] var1, int[] var2, boolean var3, IVar.Var[] var4);

    public abstract CtrEntities.CtrEntity cardinality(IVar.Var[] var1, int[] var2, boolean var3, int[] var4, int[] var5);

    public abstract CtrEntities.CtrEntity cardinality(IVar.Var[] var1, IVar.Var[] var2, boolean var3, int[] var4);

    public abstract CtrEntities.CtrEntity cardinality(IVar.Var[] var1, IVar.Var[] var2, boolean var3, IVar.Var[] var4);

    public abstract CtrEntities.CtrEntity cardinality(IVar.Var[] var1, IVar.Var[] var2, boolean var3, int[] var4, int[] var5);

    public abstract CtrEntities.CtrEntity maximum(IVar.Var[] var1, Condition var2);

    public abstract CtrEntities.CtrEntity maximum(IVar.Var[] var1, int var2, IVar.Var var3, Types.TypeRank var4);

    public abstract CtrEntities.CtrEntity maximum(IVar.Var[] var1, int var2, IVar.Var var3, Types.TypeRank var4, Condition var5);

    public abstract CtrEntities.CtrEntity maximum(XNode<IVar>[] var1, Condition var2);

    public abstract CtrEntities.CtrEntity minimum(IVar.Var[] var1, Condition var2);

    public abstract CtrEntities.CtrEntity minimum(IVar.Var[] var1, int var2, IVar.Var var3, Types.TypeRank var4);

    public abstract CtrEntities.CtrEntity minimum(IVar.Var[] var1, int var2, IVar.Var var3, Types.TypeRank var4, Condition var5);

    public abstract CtrEntities.CtrEntity minimum(XNode<IVar>[] var1, Condition var2);

    public abstract CtrEntities.CtrEntity element(IVar.Var[] var1, Condition var2);

    public abstract CtrEntities.CtrEntity element(IVar.Var[] var1, int var2, IVar.Var var3, Types.TypeRank var4, Condition var5);

    public abstract CtrEntities.CtrEntity element(int[] var1, int var2, IVar.Var var3, Types.TypeRank var4, Condition var5);

    public abstract CtrEntities.CtrEntity element(int[][] var1, int var2, IVar.Var var3, int var4, IVar.Var var5, Condition var6);

    public abstract CtrEntities.CtrEntity channel(IVar.Var[] var1, int var2);

    public abstract CtrEntities.CtrEntity channel(IVar.Var[] var1, int var2, IVar.Var[] var3, int var4);

    public abstract CtrEntities.CtrEntity channel(IVar.Var[] var1, int var2, IVar.Var var3);

    public abstract CtrEntities.CtrEntity stretch(IVar.Var[] var1, int[] var2, int[] var3, int[] var4, int[][] var5);

    public abstract CtrEntities.CtrEntity noOverlap(IVar.Var[] var1, int[] var2, boolean var3);

    public abstract CtrEntities.CtrEntity noOverlap(IVar.Var[] var1, IVar.Var[] var2, boolean var3);

    public abstract CtrEntities.CtrEntity noOverlap(IVar.Var[][] var1, int[][] var2, boolean var3);

    public abstract CtrEntities.CtrEntity noOverlap(IVar.Var[][] var1, IVar.Var[][] var2, boolean var3);

    public abstract CtrEntities.CtrEntity cumulative(IVar.Var[] var1, int[] var2, IVar.Var[] var3, int[] var4, Condition var5);

    public abstract CtrEntities.CtrEntity cumulative(IVar.Var[] var1, IVar.Var[] var2, IVar.Var[] var3, int[] var4, Condition var5);

    public abstract CtrEntities.CtrEntity cumulative(IVar.Var[] var1, int[] var2, IVar.Var[] var3, IVar.Var[] var4, Condition var5);

    public abstract CtrEntities.CtrEntity cumulative(IVar.Var[] var1, IVar.Var[] var2, IVar.Var[] var3, IVar.Var[] var4, Condition var5);

    public abstract CtrEntities.CtrEntity circuit(IVar.Var[] var1, int var2);

    public abstract CtrEntities.CtrEntity circuit(IVar.Var[] var1, int var2, int var3);

    public abstract CtrEntities.CtrEntity circuit(IVar.Var[] var1, int var2, IVar.Var var3);

    public abstract CtrEntities.CtrEntity clause(IVar.Var[] var1, Boolean[] var2);

    public abstract CtrEntities.CtrEntity instantiation(IVar.Var[] var1, int[] var2);

    public abstract CtrEntities.CtrEntity slide(IVar[] var1, Range var2, IntFunction<CtrEntities.CtrEntity> var3);

    public abstract CtrEntities.CtrEntity ifThen(CtrEntities.CtrEntity var1, CtrEntities.CtrEntity var2);

    public abstract CtrEntities.CtrEntity ifThenElse(CtrEntities.CtrEntity var1, CtrEntities.CtrEntity var2, CtrEntities.CtrEntity var3);

    public CtrEntities.CtrArray manageLoop(Runnable r) {
        this.stackLoops.push(this.ctrEntities.allEntities.size());
        r.run();
        int limit = this.stackLoops.pop();
        ICtr[] ctrs = (ICtr[])IntStream.range(limit, this.ctrEntities.allEntities.size()).mapToObj(i -> this.ctrEntities.allEntities.get(i)).filter(e -> e instanceof CtrEntities.CtrAlone && !(e instanceof CtrEntities.CtrAloneDummy)).map(e -> ((CtrEntities.CtrAlone)e).ctr).toArray(ICtr[]::new);
        CtrEntities.CtrArray ca = this.ctrEntities.newCtrArrayEntity(ctrs, this.stackLoops.size() > 0, new Types.TypeClass[0]);
        ca.varEntitiessSubjectToTags = this.varEntities.buildTimes.entrySet().stream().filter(e -> (Integer)e.getValue() >= limit).map(e -> (VarEntities.VarEntity)e.getKey()).collect(Collectors.toList());
        return ca;
    }

    public CtrEntities.CtrArray forall(Range range, IntConsumer c) {
        return this.manageLoop(() -> range.execute(c));
    }

    public CtrEntities.CtrArray forall(Range.Rangesx2 rangesx2, FunctionalInterfaces.Intx2Consumer c2) {
        return this.manageLoop(() -> rangesx2.execute(c2));
    }

    public CtrEntities.CtrArray forall(Range.Rangesx3 rangesx3, FunctionalInterfaces.Intx3Consumer c3) {
        return this.manageLoop(() -> rangesx3.execute(c3));
    }

    public CtrEntities.CtrArray forall(Range.Rangesx4 rangesx4, FunctionalInterfaces.Intx4Consumer c4) {
        return this.manageLoop(() -> rangesx4.execute(c4));
    }

    public CtrEntities.CtrArray forall(Range.Rangesx5 rangesx5, FunctionalInterfaces.Intx5Consumer c5) {
        return this.manageLoop(() -> rangesx5.execute(c5));
    }

    public CtrEntities.CtrArray forall(Range.Rangesx6 rangesx6, FunctionalInterfaces.Intx6Consumer c6) {
        return this.manageLoop(() -> rangesx6.execute(c6));
    }

    public abstract ObjEntities.ObjEntity minimize(IVar var1);

    public abstract ObjEntities.ObjEntity maximize(IVar var1);

    public abstract ObjEntities.ObjEntity minimize(XNode<IVar> var1);

    public abstract ObjEntities.ObjEntity maximize(XNode<IVar> var1);

    public abstract ObjEntities.ObjEntity minimize(Types.TypeObjective var1, IVar[] var2);

    public abstract ObjEntities.ObjEntity maximize(Types.TypeObjective var1, IVar[] var2);

    public abstract ObjEntities.ObjEntity maximize(Types.TypeObjective var1, IVar[] var2, int[] var3);

    public abstract ObjEntities.ObjEntity minimize(Types.TypeObjective var1, IVar[] var2, int[] var3);

    public abstract ObjEntities.ObjEntity minimize(Types.TypeObjective var1, XNode<IVar>[] var2);

    public abstract ObjEntities.ObjEntity minimize(Types.TypeObjective var1, XNode<IVar>[] var2, int[] var3);

    public abstract ObjEntities.ObjEntity maximize(Types.TypeObjective var1, XNode<IVar>[] var2);

    public abstract ObjEntities.ObjEntity maximize(Types.TypeObjective var1, XNode<IVar>[] var2, int[] var3);

    public void decisionVariables(IVar[] list) {
        this.annotations.decision = list;
    }

    public static class Annotations {
        public IVar[] decision;

        public boolean active() {
            return this.decision != null;
        }
    }

    protected abstract class Converter {
        public Map<String, int[][]> cacheTable = new HashMap<String, int[][]>();
        public Map<String, Boolean> cachePositive = new HashMap<String, Boolean>();

        protected Converter() {
        }

        public abstract StringBuilder signatureFor(IVar.Var[] var1);

        public abstract int[][] domValuesOf(IVar.Var[] var1);

        public abstract Utilities.ModifiableBoolean mode();

        public String handle(IVar.Var[] scp, XNodeParent<IVar> tree) {
            String key = this.signatureFor(scp).append(tree.abstraction(new ArrayList<Object>(), false, true).canonization().toString()).toString();
            if (this.cacheTable.containsKey(key)) {
                return key;
            }
            Utilities.ModifiableBoolean b = this.mode();
            int[][] tuples = new TreeEvaluator(tree).generateTuples(this.domValuesOf(scp), b);
            assert (b.value != null);
            this.cacheTable.put(key, tuples);
            this.cachePositive.put(key, b.value);
            return key;
        }
    }
}

