/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.modeler.implementation;

import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Condition;
import org.xcsp.common.IVar;
import org.xcsp.common.Range;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.domains.Domains;
import org.xcsp.common.domains.Values;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeLeaf;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.common.structures.AbstractTuple;
import org.xcsp.common.structures.Automaton;
import org.xcsp.common.structures.Table;
import org.xcsp.common.structures.TableSymbolic;
import org.xcsp.common.structures.Transition;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.definitions.ICtr;
import org.xcsp.modeler.definitions.IObj;
import org.xcsp.modeler.entities.CtrEntities;
import org.xcsp.modeler.entities.ObjEntities;
import org.xcsp.modeler.implementation.ProblemIMP;

public class ProblemIMP3
extends ProblemIMP {
    public final Map<String, MVariable> mapForVars = new HashMap<String, MVariable>();
    private ProblemIMP.Converter converter = new ProblemIMP.Converter(){

        @Override
        public StringBuilder signatureFor(IVar.Var[] scp) {
            StringBuilder sb = new StringBuilder();
            for (MVariable.MVarInteger x : (MVariable.MVarInteger[])scp) {
                sb.append(System.identityHashCode(x.dom)).append(' ');
            }
            return sb;
        }

        @Override
        public int[][] domValuesOf(IVar.Var[] scp) {
            Values.IntegerEntity[][] ies = (Values.IntegerEntity[][])Stream.of((MVariable.MVarInteger[])scp).map(x -> (Values.IntegerEntity[])((Domains.Dom)x.dom).values).toArray(x$0 -> new Values.IntegerEntity[x$0][]);
            Utilities.control(Stream.of(ies).allMatch(t -> Values.IntegerEntity.nValues(t) != -1L && Values.IntegerEntity.nValues(t) < 1000000L), "");
            return (int[][])Stream.of(ies).map(t -> Values.IntegerEntity.toIntArray(t, 1000000)).toArray(x$0 -> new int[x$0][]);
        }

        @Override
        public Utilities.ModifiableBoolean mode() {
            return new Utilities.ModifiableBoolean(null);
        }
    };

    private static final Object unimplementedCase(Object ... objects) {
        System.out.println("\n\n**********************");
        System.out.println("Missing Implementation");
        StackTraceElement[] t = Thread.currentThread().getStackTrace();
        System.out.println("  Method " + t[2].getMethodName());
        System.out.println("  Class " + t[2].getClassName());
        System.out.println("  Line " + t[2].getLineNumber());
        System.out.println("**********************");
        System.out.println(Stream.of(objects).filter(o -> o != null).map(o -> o.toString()).collect(Collectors.joining("\n")));
        System.exit(1);
        return null;
    }

    public Class<MVariable.MVarInteger> classVI() {
        return MVariable.MVarInteger.class;
    }

    public Class<MVariable.MVarSymbolic> classVS() {
        return MVariable.MVarSymbolic.class;
    }

    public ProblemIMP3(ProblemAPI api, String modelVariant, String data, String dataFormat, boolean dataSaving, String[] argsForPb) {
        super(api, modelVariant, argsForPb);
        this.loadData(data, dataFormat, dataSaving);
        api.model();
    }

    public final MVariable addVar(MVariable x) {
        Utilities.control(!this.mapForVars.containsKey(x.id()), x.id() + " duplicated");
        this.mapForVars.put(x.id(), x);
        return x;
    }

    @Override
    public MVariable.MVarInteger buildVarInteger(String id, Domains.Dom dom) {
        return (MVariable.MVarInteger)this.addVar(new MVariable.MVarInteger(id, dom));
    }

    @Override
    public MVariable.MVarSymbolic buildVarSymbolic(String id, Domains.DomSymbolic dom) {
        return (MVariable.MVarSymbolic)this.addVar(new MVariable.MVarSymbolic(id, dom));
    }

    public CtrEntities.CtrAlone post(ICtr c) {
        CtrEntities ctrEntities = this.ctrEntities;
        ctrEntities.getClass();
        return ctrEntities.new CtrEntities.CtrAlone(c, new Types.TypeClass[0]);
    }

    @Override
    public CtrEntities.CtrEntity intension(XNodeParent<IVar> tree) {
        return this.post(ICtr.ICtrIntension.buildFrom(tree.vars(), tree));
    }

    @Override
    protected ProblemIMP.Converter getConverter() {
        return this.converter;
    }

    @Override
    public CtrEntities.CtrAlone extension(IVar.Var[] list, int[][] tuples, boolean positive) {
        return this.post(ICtr.ICtrExtension.buildFrom((IVar[])list, this.varEntities.compactOrdered(list), list.length, Table.clean(tuples), positive));
    }

    @Override
    public CtrEntities.CtrAlone extension(IVar.VarSymbolic[] list, String[][] tuples, boolean positive) {
        return this.post(ICtr.ICtrExtension.buildFrom((IVar[])list, this.varEntities.compactOrdered(list), list.length, TableSymbolic.clean(tuples), positive));
    }

    @Override
    public CtrEntities.CtrAlone extension(IVar.Var[] scp, AbstractTuple[] tuples, boolean positive) {
        return (CtrEntities.CtrAlone)ProblemIMP3.unimplementedCase(new Object[0]);
    }

    @Override
    public CtrEntities.CtrAlone regular(IVar.Var[] list, Automaton automaton) {
        return this.post(ICtr.ICtrRegular.buildFrom(list, this.varEntities.compactOrdered(list), Stream.of(automaton.transitions).map(t -> t.toString()).collect(Collectors.joining()), automaton.startState, automaton.finalStates));
    }

    @Override
    public CtrEntities.CtrAlone mdd(IVar.Var[] list, Transition[] transitions) {
        return this.post(ICtr.ICtrMdd.buildFrom(list, this.varEntities.compactOrdered(list), Stream.of(transitions).map(t -> t.toString()).collect(Collectors.joining())));
    }

    @Override
    public CtrEntities.CtrEntity allDifferent(IVar.Var[] list) {
        return this.post(ICtr.ICtrAllDifferent.buildFrom(list, ICtr.LIST, this.varEntities.compact(list), null));
    }

    @Override
    public CtrEntities.CtrEntity allDifferent(IVar.VarSymbolic[] list) {
        return this.post(ICtr.ICtrAllDifferent.buildFrom(list, ICtr.LIST, this.varEntities.compact(list), null));
    }

    @Override
    public CtrEntities.CtrEntity allDifferent(IVar.Var[] list, int[] exceptValues) {
        return this.post(ICtr.ICtrAllDifferent.buildFrom(list, ICtr.LIST, this.varEntities.compact(list), Utilities.join(exceptValues)));
    }

    @Override
    public CtrEntities.CtrEntity allDifferentList(IVar.Var[] ... lists) {
        return this.post(ICtr.ICtrAllDifferent.buildFrom(this.vars(lists), "lists", this.varEntities.compactOrdered(lists), null));
    }

    @Override
    public CtrEntities.CtrEntity allDifferentMatrix(IVar.Var[][] matrix) {
        return this.post(ICtr.ICtrAllDifferent.buildFrom(this.vars(matrix), ICtr.MATRIX, this.varEntities.compactMatrix(matrix), null));
    }

    @Override
    public CtrEntities.CtrEntity allDifferent(XNode<IVar>[] trees) {
        String s = Stream.of(trees).map(t -> t.toString()).collect(Collectors.joining(" "));
        return this.post(ICtr.ICtrAllDifferent.buildFrom(this.scope(Stream.of(trees).map(t -> t.vars())), ICtr.LIST, s, null));
    }

    @Override
    public CtrEntities.CtrEntity allEqual(IVar.Var ... list) {
        return this.post(ICtr.ICtrAllEqual.buildFrom(list, ICtr.LIST, this.varEntities.compact(list)));
    }

    @Override
    public CtrEntities.CtrEntity allEqual(IVar.VarSymbolic ... list) {
        return this.post(ICtr.ICtrAllEqual.buildFrom(list, ICtr.LIST, this.varEntities.compact(list)));
    }

    @Override
    public CtrEntities.CtrEntity allEqualList(IVar.Var[] ... lists) {
        return this.post(ICtr.ICtrAllEqual.buildFrom(this.vars(lists), "lists", this.varEntities.compactOrdered(lists)));
    }

    @Override
    public CtrEntities.CtrEntity ordered(IVar.Var[] list, int[] lengths, Types.TypeOperatorRel operator) {
        return this.post(ICtr.ICtrOrdered.buildFrom(list, ICtr.LIST, this.varEntities.compactOrdered(list), IntStream.of(lengths).allMatch(v -> v == 0) ? null : Utilities.join(lengths), operator));
    }

    @Override
    public CtrEntities.CtrEntity ordered(IVar.Var[] list, IVar.Var[] lengths, Types.TypeOperatorRel operator) {
        return this.post(ICtr.ICtrOrdered.buildFrom(list, ICtr.LIST, this.varEntities.compactOrdered(list), this.varEntities.compactOrdered(lengths), operator));
    }

    @Override
    public CtrEntities.CtrEntity lex(IVar.Var[][] lists, Types.TypeOperatorRel operator) {
        return this.post(ICtr.ICtrOrdered.buildFrom(this.vars(lists), "lists", this.varEntities.compactOrdered(lists), null, operator));
    }

    @Override
    public CtrEntities.CtrEntity lexMatrix(IVar.Var[][] matrix, Types.TypeOperatorRel operator) {
        return this.post(ICtr.ICtrOrdered.buildFrom(this.vars(matrix), ICtr.MATRIX, this.varEntities.compactMatrix(matrix), null, operator));
    }

    @Override
    public CtrEntities.CtrEntity precedence(IVar.Var[] list, int[] values, boolean covered) {
        throw new AssertionError((Object)"not implemented");
    }

    @Override
    public CtrEntities.CtrEntity sum(IVar.Var[] list, int[] coeffs, Condition condition) {
        Utilities.control(Stream.of(list).noneMatch(x -> x == null), "A variable is null");
        Utilities.control(list.length == coeffs.length, "Pb because the number of variables is different form the number of coefficients");
        IVar[] newList = list;
        int[] newCoeffs = coeffs;
        Utilities.control(newList.length == newCoeffs.length, "Pb because the number of variables is different form the number of coefficients");
        return this.post(ICtr.ICtrSum.buildFrom(this.scope(newList, condition), this.varEntities.compactOrdered(newList), IntStream.range(0, newCoeffs.length).allMatch(i -> newCoeffs[i] == 1) ? null : Utilities.join(newCoeffs), condition));
    }

    @Override
    public CtrEntities.CtrEntity sum(IVar.Var[] list, IVar.Var[] coeffs, Condition condition) {
        Utilities.control(Stream.of(list).noneMatch(x -> x == null) && Stream.of(coeffs).noneMatch(x -> x == null), "A variable is null");
        Utilities.control(list.length == coeffs.length, "Pb because the number of variables is different form the number of coefficients");
        return this.post(ICtr.ICtrSum.buildFrom(this.scope(list, coeffs, condition), this.varEntities.compactOrdered(list), this.varEntities.compactOrdered(coeffs), condition));
    }

    @Override
    public CtrEntities.CtrEntity sum(XNode<IVar>[] trees, int[] coeffs, Condition condition) {
        Utilities.control(trees.length == coeffs.length, "Pb because the number of trees is different form the number of coefficients");
        String s = Stream.of(trees).map(t -> t.toString()).collect(Collectors.joining(" "));
        return this.post(ICtr.ICtrSum.buildFrom(this.scope(Stream.of(trees).map(t -> t.vars()), condition), s, IntStream.range(0, coeffs.length).allMatch(i -> coeffs[i] == 1) ? null : Utilities.join(coeffs), condition));
    }

    @Override
    public CtrEntities.CtrEntity count(IVar.Var[] list, int[] values, Condition condition) {
        return this.post(ICtr.ICtrCount.buildFrom(this.scope(list, condition), this.varEntities.compact(this.clean(list)), Utilities.join(values), condition));
    }

    @Override
    public CtrEntities.CtrEntity count(IVar.Var[] list, IVar.Var[] values, Condition condition) {
        return this.post(ICtr.ICtrCount.buildFrom(this.scope(list, values, condition), this.varEntities.compact(this.clean(list)), this.varEntities.compact(this.clean(values)), condition));
    }

    @Override
    public CtrEntities.CtrEntity nValues(IVar.Var[] list, Condition condition) {
        return this.post(ICtr.ICtrNValues.buildFrom(this.scope(list, condition), this.varEntities.compact(this.clean(list)), null, condition));
    }

    @Override
    public CtrEntities.CtrEntity nValues(IVar.Var[] list, Condition condition, int[] exceptValues) {
        return this.post(ICtr.ICtrNValues.buildFrom(this.scope(list, condition), this.varEntities.compact(this.clean(list)), Utilities.join(exceptValues), condition));
    }

    @Override
    public CtrEntities.CtrEntity cardinality(IVar.Var[] list, int[] values, boolean mustBeClosed, int[] occurs) {
        Utilities.control(values.length == occurs.length, "Arrays values and occurs have different length.");
        return this.post(ICtr.ICtrCardinality.buildFrom(list, this.varEntities.compact(this.clean(list)), Utilities.join(values), mustBeClosed, Utilities.join(occurs)));
    }

    @Override
    public CtrEntities.CtrEntity cardinality(IVar.Var[] list, int[] values, boolean mustBeClosed, IVar.Var[] occurs) {
        Utilities.control(values.length == occurs.length, "Arrays values and occurs have different length.");
        Utilities.control(Stream.of(occurs).noneMatch(x -> x == null), "A variable in array occurs is null");
        return this.post(ICtr.ICtrCardinality.buildFrom(this.scope(list, occurs), this.varEntities.compact(this.clean(list)), Utilities.join(values), mustBeClosed, this.varEntities.compactOrdered(occurs)));
    }

    @Override
    public CtrEntities.CtrEntity cardinality(IVar.Var[] list, int[] values, boolean mustBeClosed, int[] minOccurs, int[] maxOccurs) {
        Utilities.control(values.length == minOccurs.length && values.length == maxOccurs.length, "Arrays values, minOccurs and maxOccurs have different length.");
        return this.post(ICtr.ICtrCardinality.buildFrom(list, this.varEntities.compact(this.clean(list)), Utilities.join(values), mustBeClosed, this.intervalAsString(minOccurs, maxOccurs)));
    }

    @Override
    public CtrEntities.CtrEntity cardinality(IVar.Var[] list, IVar.Var[] values, boolean mustBeClosed, int[] occurs) {
        Utilities.control(values.length == occurs.length, "Arrays values and occurs have different length.");
        Utilities.control(Stream.of(values).noneMatch(x -> x == null), "A variable in array values is null");
        return this.post(ICtr.ICtrCardinality.buildFrom(this.scope(list, values), this.varEntities.compact(this.clean(list)), this.varEntities.compactOrdered(values), mustBeClosed, Utilities.join(occurs)));
    }

    @Override
    public CtrEntities.CtrEntity cardinality(IVar.Var[] list, IVar.Var[] values, boolean mustBeClosed, IVar.Var[] occurs) {
        Utilities.control(values.length == occurs.length, "Arrays values and occurs have different length.");
        Utilities.control(Stream.of(values).noneMatch(x -> x == null) && Stream.of(occurs).noneMatch(x -> x == null), "A variable in array values or occurs is null");
        return this.post(ICtr.ICtrCardinality.buildFrom(this.scope(list, values, occurs), this.varEntities.compact(this.clean(list)), this.varEntities.compactOrdered(values), mustBeClosed, this.varEntities.compactOrdered(occurs)));
    }

    @Override
    public CtrEntities.CtrEntity cardinality(IVar.Var[] list, IVar.Var[] values, boolean mustBeClosed, int[] minOccurs, int[] maxOccurs) {
        Utilities.control(values.length == minOccurs.length && values.length == maxOccurs.length, "Arrays values, minOccurs and maxOccurs have different length.");
        Utilities.control(Stream.of(values).noneMatch(x -> x == null), "A variable in array values is null");
        return this.post(ICtr.ICtrCardinality.buildFrom(this.scope(list, values), this.varEntities.compact(this.clean(list)), this.varEntities.compactOrdered(values), mustBeClosed, this.intervalAsString(minOccurs, maxOccurs)));
    }

    @Override
    public CtrEntities.CtrEntity maximum(IVar.Var[] list, Condition condition) {
        return this.post(ICtr.ICtrMaximum.buildFrom(this.scope(list, condition), this.varEntities.compact(this.clean(list)), null, null, null, condition));
    }

    @Override
    public CtrEntities.CtrEntity maximum(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank) {
        Utilities.control(Stream.of(list).noneMatch(x -> x == null), "A variable in array list is null");
        return this.post(ICtr.ICtrMaximum.buildFrom(this.scope(list, index), this.varEntities.compactOrdered(list), startIndex, index, rank, null));
    }

    @Override
    public CtrEntities.CtrEntity maximum(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank, Condition condition) {
        Utilities.control(Stream.of(list).noneMatch(x -> x == null), "A variable in array list is null");
        return this.post(ICtr.ICtrMaximum.buildFrom(this.scope(list, index, condition), this.varEntities.compactOrdered(list), startIndex, index, rank, condition));
    }

    @Override
    public CtrEntities.CtrEntity maximum(XNode<IVar>[] trees, Condition condition) {
        return (CtrEntities.CtrEntity)ProblemIMP3.unimplementedCase(new Object[0]);
    }

    @Override
    public CtrEntities.CtrEntity minimum(IVar.Var[] list, Condition condition) {
        return this.post(ICtr.ICtrMinimum.buildFrom(this.scope(list, condition), this.varEntities.compact(this.clean(list)), null, null, null, condition));
    }

    @Override
    public CtrEntities.CtrEntity minimum(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank) {
        Utilities.control(Stream.of(list).noneMatch(x -> x == null), "A variable in array list is null");
        return this.post(ICtr.ICtrMinimum.buildFrom(this.scope(list, index), this.varEntities.compactOrdered(list), startIndex, index, rank, null));
    }

    @Override
    public CtrEntities.CtrEntity minimum(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank, Condition condition) {
        Utilities.control(Stream.of(list).noneMatch(x -> x == null), "A variable in array list is null");
        return this.post(ICtr.ICtrMinimum.buildFrom(this.scope(list, index, condition), this.varEntities.compactOrdered(list), startIndex, index, rank, condition));
    }

    @Override
    public CtrEntities.CtrEntity minimum(XNode<IVar>[] trees, Condition condition) {
        return (CtrEntities.CtrEntity)ProblemIMP3.unimplementedCase(new Object[0]);
    }

    @Override
    public CtrEntities.CtrEntity element(IVar.Var[] list, Condition condition) {
        return this.post(ICtr.ICtrElement.buildFrom(list, this.varEntities.compact(list), null, null, null, condition));
    }

    @Override
    public CtrEntities.CtrEntity element(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank, Condition condition) {
        return this.post(ICtr.ICtrElement.buildFrom(this.scope(list, index), this.varEntities.compactOrdered(list), startIndex, index, rank, condition));
    }

    @Override
    public CtrEntities.CtrEntity element(int[] list, int startIndex, IVar.Var index, Types.TypeRank rank, Condition condition) {
        return this.post(ICtr.ICtrElement.buildFrom(this.scope(index, condition), Utilities.join(list), startIndex, index, rank, condition));
    }

    @Override
    public CtrEntities.CtrEntity element(int[][] matrix, int startRowIndex, IVar.Var rowIndex, int startColIndex, IVar.Var colIndex, Condition condition) {
        return this.post(ICtr.ICtrElementMatrix.buildFrom(this.vars(new Object[]{rowIndex, colIndex, condition}), ICtr.ICtrExtension.tableAsString(matrix), startRowIndex, rowIndex, startColIndex, colIndex, condition));
    }

    @Override
    public CtrEntities.CtrEntity channel(IVar.Var[] list, int startIndex) {
        return this.post(ICtr.ICtrChannel.buildFrom(list, this.varEntities.compactOrdered(list), startIndex, null, null, null));
    }

    @Override
    public CtrEntities.CtrEntity channel(IVar.Var[] list1, int startIndex1, IVar.Var[] list2, int startIndex2) {
        return this.post(ICtr.ICtrChannel.buildFrom(this.scope(list1, list2), this.varEntities.compactOrdered(list1), startIndex1, this.varEntities.compactOrdered(list2), startIndex2, null));
    }

    @Override
    public CtrEntities.CtrEntity channel(IVar.Var[] list, int startIndex, IVar.Var value) {
        return this.post(ICtr.ICtrChannel.buildFrom(list, this.varEntities.compactOrdered(list), startIndex, null, null, value));
    }

    @Override
    public CtrEntities.CtrEntity stretch(IVar.Var[] list, int[] values, int[] widthsMin, int[] widthsMax, int[][] patterns) {
        ProblemIMP3.control(values.length == widthsMin.length && values.length == widthsMax.length, "The length of the arrays are not compatible.");
        ProblemIMP3.control(IntStream.range(0, values.length).allMatch(i -> widthsMin[i] <= widthsMax[i]), "a min width is greater than a max width");
        ProblemIMP3.control(patterns == null || Stream.of(patterns).allMatch(t -> ((int[])t).length == 2), "");
        String t2 = patterns == null ? null : ICtr.ICtrExtension.tableAsString(Table.clean(patterns));
        return this.post(ICtr.ICtrStretch.buildFrom(list, this.varEntities.compactOrdered(list), Utilities.join(values), this.intervalAsString(widthsMin, widthsMax), t2));
    }

    @Override
    public CtrEntities.CtrEntity noOverlap(IVar.Var[] origins, int[] lengths, boolean zeroIgnored) {
        return this.post(ICtr.ICtrNoOverlap.buildFrom(origins, this.varEntities.compactOrdered(origins), Utilities.join(lengths), zeroIgnored));
    }

    @Override
    public CtrEntities.CtrEntity noOverlap(IVar.Var[] origins, IVar.Var[] lengths, boolean zeroIgnored) {
        return this.post(ICtr.ICtrNoOverlap.buildFrom(this.scope(origins, lengths), this.varEntities.compactOrdered(origins), this.varEntities.compactOrdered(lengths), zeroIgnored));
    }

    @Override
    public CtrEntities.CtrEntity noOverlap(IVar.Var[][] origins, int[][] lengths, boolean zeroIgnored) {
        return this.post(ICtr.ICtrNoOverlap.buildFrom(this.scope(new Object[]{origins, lengths}), this.varEntities.compactMatrix(origins), "(" + Utilities.join(lengths, ")(", ",") + ")", zeroIgnored));
    }

    @Override
    public CtrEntities.CtrEntity noOverlap(IVar.Var[][] origins, IVar.Var[][] lengths, boolean zeroIgnored) {
        return this.post(ICtr.ICtrNoOverlap.buildFrom(this.scope(new Object[]{origins, lengths}), this.varEntities.compactMatrix(origins), "(" + Utilities.join(lengths, ")(", ",") + ")", zeroIgnored));
    }

    @Override
    public final CtrEntities.CtrEntity cumulative(IVar.Var[] origins, int[] lengths, IVar.Var[] ends, int[] heights, Condition condition) {
        return this.post(ICtr.ICtrCumulative.buildFrom(this.scope(origins, ends, condition), this.varEntities.compactOrdered(origins), Utilities.join(lengths), ends == null ? null : this.varEntities.compactOrdered(ends), Utilities.join(heights), condition));
    }

    @Override
    public final CtrEntities.CtrEntity cumulative(IVar.Var[] origins, IVar.Var[] lengths, IVar.Var[] ends, int[] heights, Condition condition) {
        return this.post(ICtr.ICtrCumulative.buildFrom(this.scope(origins, lengths, ends, condition), this.varEntities.compactOrdered(origins), this.varEntities.compactOrdered(lengths), ends == null ? null : this.varEntities.compactOrdered(ends), Utilities.join(heights), condition));
    }

    @Override
    public final CtrEntities.CtrEntity cumulative(IVar.Var[] origins, int[] lengths, IVar.Var[] ends, IVar.Var[] heights, Condition condition) {
        return this.post(ICtr.ICtrCumulative.buildFrom(this.scope(origins, ends, heights, condition), this.varEntities.compactOrdered(origins), Utilities.join(lengths), ends == null ? null : this.varEntities.compactOrdered(ends), this.varEntities.compactOrdered(heights), condition));
    }

    @Override
    public final CtrEntities.CtrEntity cumulative(IVar.Var[] origins, IVar.Var[] lengths, IVar.Var[] ends, IVar.Var[] heights, Condition condition) {
        return this.post(ICtr.ICtrCumulative.buildFrom(this.scope(origins, lengths, ends, heights, condition), this.varEntities.compactOrdered(origins), this.varEntities.compactOrdered(lengths), ends == null ? null : this.varEntities.compactOrdered(ends), this.varEntities.compactOrdered(heights), condition));
    }

    @Override
    public CtrEntities.CtrEntity circuit(IVar.Var[] list, int startIndex) {
        return this.post(ICtr.ICtrCircuit.buildFrom(list, this.varEntities.compactOrdered(list), startIndex, null));
    }

    @Override
    public CtrEntities.CtrEntity circuit(IVar.Var[] list, int startIndex, int size) {
        return this.post(ICtr.ICtrCircuit.buildFrom(list, this.varEntities.compactOrdered(list), startIndex, size));
    }

    @Override
    public CtrEntities.CtrEntity circuit(IVar.Var[] list, int startIndex, IVar.Var size) {
        return this.post(ICtr.ICtrCircuit.buildFrom(this.scope(list, size), this.varEntities.compactOrdered(list), startIndex, size));
    }

    @Override
    public CtrEntities.CtrEntity clause(IVar.Var[] list, Boolean[] phases) {
        Utilities.control(Stream.of(list).noneMatch(x -> x == null), "A variable in array list is null");
        Utilities.control(list.length == phases.length && list.length > 0, "Bad form of clause.");
        String s = IntStream.range(0, list.length).mapToObj(i -> phases[i] != false ? list[i].id() : "not(" + list[i].id() + ")").collect(Collectors.joining(" "));
        return this.post(ICtr.ICtrClause.buildFrom(list, s));
    }

    @Override
    public CtrEntities.CtrEntity instantiation(IVar.Var[] list, int[] values) {
        Utilities.control(list.length == values.length && list.length > 0, "Bad form of instantiation.");
        return this.post(ICtr.ICtrInstantiation.buildFrom(list, this.varEntities.compactOrdered(list), Utilities.join(values)));
    }

    private int[] computeOffsets(IVar[][] lists, IVar[] scp0, IVar[] scp1) {
        return IntStream.range(0, lists.length).map(i -> {
            int pos0 = Stream.of(scp0).filter(x -> Utilities.indexOf(x, lists[i]) >= 0).mapToInt(x -> Utilities.indexOf(x, lists[i])).min().orElse(-1);
            int pos1 = Stream.of(scp1).filter(x -> Utilities.indexOf(x, lists[i]) >= 0).mapToInt(x -> Utilities.indexOf(x, lists[i])).min().orElse(-1);
            Utilities.control(pos0 != -1 && pos1 != -1, "");
            return pos1 - pos0;
        }).toArray();
    }

    private int[] computeCollects(IVar[][] lists, IVar[] scp) {
        return IntStream.range(0, lists.length).map(i -> (int)Stream.of(scp).filter(x -> Utilities.indexOf(x, lists[i]) >= 0).count()).toArray();
    }

    @Override
    public CtrEntities.CtrEntity slide(IVar[] list, Range range, IntFunction<CtrEntities.CtrEntity> template) {
        Utilities.control(range.start == 0 && range.length() > 0, "Bad form of range");
        if (range.length() == 1) {
            return template.apply(0);
        }
        CtrEntities.CtrAlone[] cas = (CtrEntities.CtrAlone[])range.stream().mapToObj(i -> (CtrEntities.CtrEntity)template.apply(i)).toArray(CtrEntities.CtrAlone[]::new);
        for (int i2 = cas.length - 1; i2 >= 0; --i2) {
            this.ctrEntities.allEntities.remove(cas[i2]);
            this.ctrEntities.ctrToCtrAlone.remove(cas[i2].ctr);
        }
        IVar[][] scopes = (IVar[][])Stream.of(cas).map(ca -> ca.ctr.scope()).toArray(x$0 -> new IVar[x$0][]);
        Utilities.control(IntStream.range(1, scopes.length).noneMatch(i -> scopes[i].length != scopes[0].length), "");
        IVar[][] lists = new IVar[][]{list};
        boolean circular = Stream.of(scopes[scopes.length - 1]).anyMatch(x -> x == lists[0][0]);
        int[] offsets = this.computeOffsets(lists, scopes[0], scopes[1]);
        int[] collects = this.computeCollects(lists, scopes[0]);
        return this.post(ICtr.ICtrSlide.buildFrom(list, circular, lists, offsets, collects, cas));
    }

    @Override
    public final CtrEntities.CtrEntity ifThen(CtrEntities.CtrEntity c1, CtrEntities.CtrEntity c2) {
        Utilities.control(c1 instanceof CtrEntities.CtrAlone && c2 instanceof CtrEntities.CtrAlone, "unimplemented for the moment");
        for (CtrEntities.CtrEntity c : new CtrEntities.CtrEntity[]{c2, c1}) {
            this.ctrEntities.allEntities.remove(c);
            this.ctrEntities.ctrToCtrAlone.remove(((CtrEntities.CtrAlone)c).ctr);
        }
        return this.post(ICtr.ICtrIfThen.buildFrom(this.scope(((CtrEntities.CtrAlone)c1).ctr.scope(), ((CtrEntities.CtrAlone)c2).ctr.scope()), (CtrEntities.CtrAlone)c1, (CtrEntities.CtrAlone)c2));
    }

    @Override
    public final CtrEntities.CtrEntity ifThenElse(CtrEntities.CtrEntity c1, CtrEntities.CtrEntity c2, CtrEntities.CtrEntity c3) {
        Utilities.control(c1 instanceof CtrEntities.CtrAlone && c2 instanceof CtrEntities.CtrAlone && c3 instanceof CtrEntities.CtrAlone, "unimplemented for the moment");
        for (CtrEntities.CtrEntity c : new CtrEntities.CtrEntity[]{c3, c2, c1}) {
            this.ctrEntities.allEntities.remove(c);
            this.ctrEntities.ctrToCtrAlone.remove(((CtrEntities.CtrAlone)c).ctr);
        }
        return this.post(ICtr.ICtrIfThenElse.buildFrom(this.scope(((CtrEntities.CtrAlone)c1).ctr.scope(), ((CtrEntities.CtrAlone)c2).ctr.scope(), ((CtrEntities.CtrAlone)c3).ctr.scope()), (CtrEntities.CtrAlone)c1, (CtrEntities.CtrAlone)c2, (CtrEntities.CtrAlone)c3));
    }

    public ObjEntities.ObjEntity postObj(IObj o) {
        ObjEntities objEntities = this.objEntities;
        objEntities.getClass();
        return objEntities.new ObjEntities.ObjEntity(o, new Types.TypeClass[0]);
    }

    @Override
    public final ObjEntities.ObjEntity minimize(IVar x) {
        return this.postObj(IObj.IObjFunctional.buildFrom(this.scope(x), true, new XNodeLeaf<IVar>(Types.TypeExpr.VAR, x)));
    }

    @Override
    public final ObjEntities.ObjEntity maximize(IVar x) {
        return this.postObj(IObj.IObjFunctional.buildFrom(this.scope(x), false, new XNodeLeaf<IVar>(Types.TypeExpr.VAR, x)));
    }

    @Override
    public final ObjEntities.ObjEntity minimize(XNode<IVar> tree) {
        return this.postObj(IObj.IObjFunctional.buildFrom(tree.vars(), true, tree));
    }

    @Override
    public final ObjEntities.ObjEntity maximize(XNode<IVar> tree) {
        return this.postObj(IObj.IObjFunctional.buildFrom(tree.vars(), false, tree));
    }

    @Override
    public final ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar[] list) {
        return this.postObj(IObj.IObjSpecialized.buildFrom(list, true, type, this.varEntities.compactOrdered(list), null));
    }

    @Override
    public final ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar[] list) {
        return this.postObj(IObj.IObjSpecialized.buildFrom(list, false, type, this.varEntities.compactOrdered(list), null));
    }

    @Override
    public final ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar[] list, int[] coeffs) {
        return this.postObj(IObj.IObjSpecialized.buildFrom(list, true, type, this.varEntities.compactOrdered(list), Utilities.join(coeffs)));
    }

    @Override
    public final ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar[] list, int[] coeffs) {
        return this.postObj(IObj.IObjSpecialized.buildFrom(list, false, type, this.varEntities.compactOrdered(list), Utilities.join(coeffs)));
    }

    private ObjEntities.ObjEntity optimizeTreeBasedObjective(boolean minimize, Types.TypeObjective type, XNode<IVar>[] trees, String coeffs) {
        String s = Stream.of(trees).map(t -> t.toString()).collect(Collectors.joining(" "));
        return this.postObj(IObj.IObjSpecialized.buildFrom(this.scope(Stream.of(trees).map(t -> t.vars())), minimize, type, s, coeffs));
    }

    @Override
    public ObjEntities.ObjEntity minimize(Types.TypeObjective type, XNode<IVar>[] trees) {
        return this.optimizeTreeBasedObjective(true, type, trees, null);
    }

    @Override
    public ObjEntities.ObjEntity minimize(Types.TypeObjective type, XNode<IVar>[] trees, int[] coeffs) {
        return this.optimizeTreeBasedObjective(true, type, trees, Utilities.join(coeffs));
    }

    @Override
    public ObjEntities.ObjEntity maximize(Types.TypeObjective type, XNode<IVar>[] trees) {
        return this.optimizeTreeBasedObjective(false, type, trees, null);
    }

    @Override
    public ObjEntities.ObjEntity maximize(Types.TypeObjective type, XNode<IVar>[] trees, int[] coeffs) {
        return this.optimizeTreeBasedObjective(false, type, trees, Utilities.join(coeffs));
    }

    public static class MVariable
    implements IVar,
    Comparable<MVariable> {
        protected String id;
        private String idPrefix;
        private int[] idIndexes;
        public Domains.IDom dom;

        @Override
        public int compareTo(MVariable x) {
            int res = this.idPrefix.compareTo(x.idPrefix);
            if (res != 0) {
                return res;
            }
            if (this.idIndexes == null) {
                return 0;
            }
            return Utilities.lexComparatorInt.compare(this.idIndexes, x.idIndexes);
        }

        public MVariable(String id, Domains.IDom dom) {
            this.id = id;
            int pos = id.indexOf(91);
            this.idPrefix = pos == -1 ? id : id.substring(0, pos);
            this.idIndexes = pos == -1 ? null : Utilities.splitToInts(id.substring(pos), "\\[|\\]");
            this.dom = dom;
        }

        @Override
        public String id() {
            return this.id;
        }

        public String toString() {
            return this.id;
        }

        public static class MVarInteger
        extends MVariable
        implements IVar.Var {
            public MVarInteger(String id, Domains.Dom dom) {
                super(id, dom);
            }

            @Override
            public Object allValues() {
                return null;
            }
        }

        public static class MVarSymbolic
        extends MVariable
        implements IVar.VarSymbolic {
            public MVarSymbolic(String id, Domains.DomSymbolic dom) {
                super(id, dom);
            }
        }
    }
}

