/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.parser.entries;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Condition;
import org.xcsp.common.Softening;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.parser.entries.ParsingEntry;
import org.xcsp.parser.entries.XVariables;

public class XConstraints {
    private static LinkedHashSet<XVariables.XVar> collectVarsIn(Object obj, LinkedHashSet<XVariables.XVar> set) {
        if (obj instanceof Object[]) {
            IntStream.range(0, Array.getLength(obj)).forEach(i -> XConstraints.collectVarsIn(Array.get(obj, i), set));
        } else if (obj instanceof XNode) {
            ((XNode)obj).collectVarsToSet(set);
        } else if (obj instanceof XVariables.XVar) {
            set.add((XVariables.XVar)obj);
        } else if (obj instanceof Condition.ConditionVar) {
            set.add((XVariables.XVar)((Condition.ConditionVar)obj).x);
        }
        return set;
    }

    public static final class CChild
    extends ParsingEntry.CEntry {
        public final Types.TypeChild type;
        public Object value;

        public final Types.TypeChild getType() {
            return this.type;
        }

        public CChild(Types.TypeChild type, Object value) {
            this.type = type;
            this.value = value;
        }

        public boolean setVariableInvolved() {
            return Utilities.check(this.value, obj -> obj instanceof XVariables.XVar && ((XVariables.XVar)obj).type.isSet());
        }

        @Override
        public LinkedHashSet<XVariables.XVar> collectVars(LinkedHashSet<XVariables.XVar> set) {
            return this.type == Types.TypeChild.supports || this.type == Types.TypeChild.conflicts ? set : XConstraints.collectVarsIn(this.value, set);
        }

        @Override
        public boolean subjectToAbstraction() {
            if (this.type == Types.TypeChild.function && ((XNode)this.value).firstNodeSuchThat(n -> n.type == Types.TypeExpr.PAR) != null) {
                return true;
            }
            if (this.type == Types.TypeChild.condition && this.value instanceof Condition.ConditionPar) {
                return true;
            }
            return Utilities.check(this.value, obj -> obj instanceof XParameter);
        }

        public boolean isTotallyAbstract() {
            if (!this.value.getClass().isArray()) {
                return this.value instanceof XParameter;
            }
            int size = Array.getLength(this.value);
            return size > 0 && IntStream.range(0, size).allMatch(i -> (XParameter)Array.get(this.value, i) instanceof XParameter);
        }

        @Override
        public String toString() {
            return (Object)((Object)this.type) + super.toString() + " : " + (this.value == null ? "" : (this.value.getClass().isArray() ? Utilities.arrayToString(this.value) : this.value));
        }
    }

    public static final class XLogic
    extends CEntryReifiable {
        public final Types.TypeCtr type;
        public final CEntryReifiable[] components;

        public final Types.TypeCtr getType() {
            return this.type;
        }

        private boolean validArity() {
            int arity = this.components.length;
            if (this.type.oneOf(Types.TypeCtr.and, Types.TypeCtr.or, Types.TypeCtr.iff) && arity < 2) {
                return false;
            }
            return !(this.type == Types.TypeCtr.not && arity != 1 || this.type == Types.TypeCtr.ifThen && arity != 2 || this.type == Types.TypeCtr.ifThenElse && arity == 3);
        }

        public XLogic(Types.TypeCtr type, CEntryReifiable ... components) {
            this.type = type;
            this.components = components;
            Utilities.control(type.isLogical() || type.isControl(), "Bad type for a meta-constraint");
            Utilities.control(this.validArity(), "Bad logic construction");
        }

        @Override
        public LinkedHashSet<XVariables.XVar> collectVars(LinkedHashSet<XVariables.XVar> set) {
            Stream.of(this.components).forEach(c -> c.collectVars(set));
            return super.collectVars(set);
        }

        @Override
        public boolean subjectToAbstraction() {
            return Arrays.stream(this.components).anyMatch(c -> c.subjectToAbstraction());
        }

        @Override
        public String toString() {
            return (Object)((Object)this.type) + super.toString() + "\n" + Utilities.join(this.components, "\n");
        }
    }

    public static final class XSeqbin
    extends CEntryReifiable {
        public final CChild list;
        public final XCtr template1;
        public final XCtr template2;
        public final CChild number;
        public final XVariables.XVar[][] scopes;

        public XSeqbin(CChild list, XCtr template1, XCtr template2, CChild number, XVariables.XVar[][] scopes) {
            this.list = list;
            this.template1 = template1;
            this.template2 = template2;
            this.number = number;
            this.scopes = scopes;
        }

        @Override
        public LinkedHashSet<XVariables.XVar> collectVars(LinkedHashSet<XVariables.XVar> set) {
            this.list.collectVars(set);
            this.template1.collectVars(set);
            this.template2.collectVars(set);
            if (this.number.value instanceof XVariables.XVar) {
                set.add((XVariables.XVar)this.number.value);
            }
            return super.collectVars(set);
        }

        @Override
        public boolean subjectToAbstraction() {
            return true;
        }

        @Override
        public String toString() {
            return "seqbin" + super.toString() + "\n\t" + this.list + "\n\t" + this.template1.toString() + "\n\t" + this.template2.toString() + "\n\t" + this.number + " \n\tscopes=" + Utilities.arrayToString(this.scopes);
        }
    }

    public static final class XSlide
    extends CEntryReifiable {
        public final CChild[] lists;
        public final int[] offsets;
        public final int[] collects;
        public final CEntryReifiable template;
        public final XVariables.XVar[][] scopes;

        public static XVariables.XVar[][] buildScopes(XVariables.XVar[][] varsOfLists, int[] offset, int[] collect, boolean circular) {
            int[] indexes = new int[collect.length];
            ArrayList<Object> list = new ArrayList<Object>();
            XVariables.XVar[] tmp = new XVariables.XVar[Arrays.stream(collect).sum()];
            while (circular || indexes[0] + collect[0] <= varsOfLists[0].length) {
                boolean lastTurn = indexes[0] + offset[0] >= varsOfLists[0].length;
                int cnt = 0;
                for (int i = 0; i < collect.length; ++i) {
                    for (int j = 0; j < collect[i]; ++j) {
                        tmp[cnt++] = varsOfLists[i][(indexes[i] + j) % varsOfLists[i].length];
                    }
                    int n = i;
                    indexes[n] = indexes[n] + offset[i];
                }
                list.add(tmp.clone());
                if (!lastTurn) continue;
                break;
            }
            return (XVariables.XVar[][])list.toArray((T[])new XVariables.XVar[list.size()][]);
        }

        public XSlide(CChild[] lists, int[] offsets, int[] collects, XCtr template, XVariables.XVar[][] scopes) {
            this.lists = lists;
            this.offsets = offsets;
            this.collects = collects;
            this.template = template;
            this.scopes = scopes;
        }

        @Override
        public LinkedHashSet<XVariables.XVar> collectVars(LinkedHashSet<XVariables.XVar> set) {
            Stream.of(this.lists).forEach(t -> t.collectVars(set));
            this.template.collectVars(set);
            return super.collectVars(set);
        }

        @Override
        public boolean subjectToAbstraction() {
            return true;
        }

        @Override
        public String toString() {
            return super.toString() + "\n\t" + Utilities.join(this.lists, "\n\t") + "\n\tcollect=" + Arrays.toString(this.collects) + " offset=" + Arrays.toString(this.offsets);
        }
    }

    public static class XCtr
    extends CEntryReifiable {
        public final Types.TypeCtr type;
        public final CChild[] childs;
        public XAbstraction abstraction;

        public final Types.TypeCtr getType() {
            return this.type;
        }

        public XCtr(Types.TypeCtr type, CChild ... childs) {
            this.type = type;
            this.childs = childs;
            int[] abstractChildsPositions = IntStream.range(0, childs.length).filter(i -> childs[i].subjectToAbstraction()).toArray();
            if (abstractChildsPositions.length > 0) {
                Utilities.control(IntStream.of(abstractChildsPositions).mapToObj(i -> childs[i]).allMatch(child -> child.type == Types.TypeChild.function || child.isTotallyAbstract() || child.value instanceof Condition.ConditionPar), "Abstraction Form not handled");
                this.abstraction = new XAbstraction((CChild[])IntStream.of(abstractChildsPositions).mapToObj(i -> childs[i]).toArray(CChild[]::new));
            }
        }

        @Override
        public LinkedHashSet<XVariables.XVar> collectVars(LinkedHashSet<XVariables.XVar> set) {
            Stream.of(this.childs).filter(child -> child.type != Types.TypeChild.supports && child.type != Types.TypeChild.conflicts).forEach(child -> child.collectVars(set));
            return super.collectVars(set);
        }

        @Override
        public boolean subjectToAbstraction() {
            return this.abstraction != null;
        }

        @Override
        public String toString() {
            return (Object)((Object)this.type) + super.toString() + "\n\t" + Utilities.join(this.childs, "\n\t");
        }
    }

    public static abstract class CEntryReifiable
    extends ParsingEntry.CEntry {
        public XReification reification;
        public Softening softening;

        @Override
        public LinkedHashSet<XVariables.XVar> collectVars(LinkedHashSet<XVariables.XVar> set) {
            if (this.reification != null) {
                set.add(this.reification.var);
            }
            if (this.softening != null && this.softening.cost instanceof Condition.ConditionVar) {
                set.add((XVariables.XVar)((Condition.ConditionVar)this.softening.cost).x);
            }
            return set;
        }

        @Override
        public String toString() {
            return super.toString() + (this.reification != null ? "\n\t" + this.reification : "") + (this.softening != null ? "\n\t" + this.softening : "");
        }
    }

    public static final class XGroup
    extends ParsingEntry.CEntry {
        public final CEntryReifiable template;
        public final Object[][] argss;
        private XVariables.XVar[][] scopes;

        public XVariables.XVar[] getScope(int i) {
            if (this.scopes == null) {
                this.scopes = new XVariables.XVar[this.argss.length][];
            }
            if (this.scopes[i] != null) {
                return this.scopes[i];
            }
            this.scopes[i] = XConstraints.collectVarsIn(this.argss[i], new LinkedHashSet<XVariables.XVar>(Arrays.asList(this.template.vars()))).toArray(new XVariables.XVar[0]);
            return this.scopes[i];
        }

        public XGroup(CEntryReifiable template, Object[][] argss) {
            this.template = template;
            this.argss = argss;
        }

        @Override
        public LinkedHashSet<XVariables.XVar> collectVars(LinkedHashSet<XVariables.XVar> set) {
            this.template.collectVars(set);
            Stream.of(this.argss).forEach(t -> XConstraints.collectVarsIn(t, set));
            return set;
        }

        @Override
        public boolean subjectToAbstraction() {
            return true;
        }

        @Override
        public String toString() {
            return "Group " + super.toString() + "\n" + this.template.toString() + "\n\t" + Utilities.join(this.argss, "\n\t", " ");
        }
    }

    public static final class XBlock
    extends ParsingEntry.CEntry {
        public List<ParsingEntry.CEntry> subentries = new ArrayList<ParsingEntry.CEntry>();

        public XBlock(List<ParsingEntry.CEntry> subentries) {
            this.subentries = subentries;
        }

        @Override
        public LinkedHashSet<XVariables.XVar> collectVars(LinkedHashSet<XVariables.XVar> set) {
            this.subentries.stream().forEach(e -> e.collectVars(set));
            return set;
        }

        @Override
        public boolean subjectToAbstraction() {
            return this.subentries.stream().anyMatch(e -> e.subjectToAbstraction());
        }

        @Override
        public String toString() {
            return "Block " + super.toString() + " " + this.subentries.stream().map(e -> e.toString()).collect(Collectors.joining("\n"));
        }
    }

    public static final class XAbstraction {
        public final CChild[] abstractChilds;
        private Object[] abstractChildValues;
        private int[][] mappings;
        private int highestParameterNumber;

        private int[] mappingFor(CChild child) {
            if (child.type == Types.TypeChild.function) {
                return null;
            }
            if (child.type == Types.TypeChild.condition) {
                return new int[]{((Condition.ConditionPar)child.value).par.number};
            }
            if (child.value.getClass().isArray()) {
                return IntStream.range(0, Array.getLength(child.value)).map(i -> ((XParameter)Array.get((Object)child.value, (int)i)).number).toArray();
            }
            return new int[]{((XParameter)child.value).number};
        }

        public XAbstraction(CChild ... abstractChilds) {
            this.abstractChilds = abstractChilds;
            this.abstractChildValues = Stream.of(abstractChilds).map(child -> child.value).toArray();
            this.mappings = (int[][])Stream.of(abstractChilds).map(child -> this.mappingFor((CChild)child)).toArray(x$0 -> new int[x$0][]);
            this.highestParameterNumber = Math.max(-1, IntStream.range(0, abstractChilds.length).map(i -> abstractChilds[i].type == Types.TypeChild.function ? ((XNode)abstractChilds[i].value).maxParameterNumber() : IntStream.of(this.mappings[i]).max().getAsInt()).max().getAsInt());
        }

        private Object concreteValueFor(CChild child, Object abstractChildValue, Object[] args, int[] mapping) {
            if (child.type == Types.TypeChild.function) {
                return ((XNodeParent)abstractChildValue).concretization(args);
            }
            if (child.type == Types.TypeChild.condition) {
                return ((Condition.ConditionPar)abstractChildValue).concretizeWith(args[mapping[0]]);
            }
            if (child.value.getClass().isArray()) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i = 0; i < mapping.length; ++i) {
                    if (mapping[i] != -1) {
                        list.add(args[mapping[i]]);
                        continue;
                    }
                    for (int j = this.highestParameterNumber + 1; j < args.length; ++j) {
                        list.add(args[j]);
                    }
                }
                return Utilities.specificArrayFrom(list);
            }
            Utilities.control(mapping.length == 1, "Pb here");
            return args[mapping[0]];
        }

        public void concretize(Object[] args) {
            for (int i = 0; i < this.abstractChilds.length; ++i) {
                this.abstractChilds[i].value = this.concreteValueFor(this.abstractChilds[i], this.abstractChildValues[i], args, this.mappings[i]);
            }
        }
    }

    public static final class XReification {
        public final Types.TypeReification type;
        public final XVariables.XVar var;

        public XReification(Types.TypeReification type, XVariables.XVar var) {
            this.type = type;
            this.var = var;
        }

        public String toString() {
            return "Reification:" + this.var + " (" + (Object)((Object)this.type) + ")";
        }
    }

    public static final class XParameter {
        public final int number;

        public XParameter(int number) {
            this.number = number;
        }

        public String toString() {
            return "%" + (this.number == -1 ? "..." : Integer.valueOf(this.number));
        }
    }
}

