/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common;

import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Range;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.domains.Values;
import org.xcsp.common.predicates.XNodeLeaf;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.parser.entries.XConstraints;

public interface Condition {
    public static Condition buildFrom(Object operator, Object limit) {
        if (limit instanceof XConstraints.XParameter) {
            return new ConditionPar1(operator, (XConstraints.XParameter)limit);
        }
        if (operator instanceof Types.TypeConditionOperatorRel) {
            Types.TypeConditionOperatorRel op = (Types.TypeConditionOperatorRel)((Object)operator);
            return limit instanceof Number ? new ConditionVal(op, ((Number)limit).longValue()) : new ConditionVar(op, (IVar)limit);
        }
        if (operator instanceof Types.TypeConditionOperatorSet) {
            Types.TypeConditionOperatorSet op = (Types.TypeConditionOperatorSet)((Object)operator);
            return limit instanceof Range ? new ConditionIntvl(op, (Range)limit) : new ConditionIntset(op, (int[])limit);
        }
        Utilities.control(operator instanceof Types.TypeConditionOperator, " Bad Argument");
        Types.TypeConditionOperator op = (Types.TypeConditionOperator)((Object)operator);
        if (limit instanceof Long) {
            return new ConditionVal(op.toRel(), (Long)limit);
        }
        if (limit instanceof IVar) {
            return new ConditionVar(op.toRel(), (IVar)limit);
        }
        if (limit instanceof XNodeLeaf && ((XNodeLeaf)limit).type == Types.TypeExpr.VAR) {
            return new ConditionVar(op.toRel(), (IVar)((XNodeLeaf)limit).value);
        }
        if (limit instanceof Values.IntegerInterval) {
            return new ConditionIntvl(op.toSet(), ((Values.IntegerInterval)limit).inf, ((Values.IntegerInterval)limit).sup);
        }
        if (!1.$assertionsDisabled && !(limit instanceof long[])) {
            throw new AssertionError();
        }
        return new ConditionIntset(op.toSet(), LongStream.of((long[])limit).mapToInt(l -> Utilities.safeInt(l)).toArray());
    }

    public static XNodeParent<IVar> toNode(IVar x, Condition condition) {
        Types.TypeExpr te = condition.operatorTypeExpr();
        if (condition instanceof ConditionVal) {
            return XNodeParent.build(te, x, ((ConditionVal)condition).k);
        }
        if (condition instanceof ConditionVar) {
            return XNodeParent.build(te, x, ((ConditionVar)condition).x);
        }
        if (condition instanceof ConditionIntset) {
            return XNodeParent.build(te, x, XNodeParent.set(((ConditionIntset)condition).t));
        }
        if (condition instanceof ConditionIntvl) {
            return XNodeParent.build(te, x, XNodeParent.set(((ConditionIntvl)condition).range().toArray()));
        }
        Utilities.control(te.isRelationalOperator(), " Not implemented for the moment");
        if (condition instanceof ConditionPar1) {
            return XNodeParent.build(te, x, ((ConditionPar1)condition).par1);
        }
        if (condition instanceof ConditionPar2) {
            XConstraints.XParameter y = ((ConditionPar2)condition).par1;
            Object z = ((ConditionPar2)condition).par2;
            return XNodeParent.build(te, x, ((ConditionPar2)condition).addition ? XNodeParent.add(y, z) : XNodeParent.sub(y, z));
        }
        Utilities.control(false, "all other cases not unimplemented for the moment");
        return null;
    }

    default public IVar involvedVar() {
        return null;
    }

    public Types.TypeExpr operatorTypeExpr();

    public Object rightTerm();

    default public int[] filtering(int[] values) {
        throw new AssertionError((Object)"should not be called for this kind of objects");
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static class ConditionIntset
    extends ConditionSet {
        public int[] t;

        public ConditionIntset(Types.TypeConditionOperatorSet operator, int[] t) {
            super(operator);
            t = IntStream.of(t).sorted().distinct().toArray();
            Utilities.control(t.length > 0, "The specified array is empty (and so, not valid).");
            this.t = t;
        }

        @Override
        public Object rightTerm() {
            return this.t;
        }

        @Override
        public int[] filtering(int[] values) {
            return IntStream.of(values).filter(v -> {
                switch (this.operator) {
                    case IN: {
                        return Arrays.binarySearch(this.t, v) >= 0;
                    }
                    case NOTIN: {
                        return Arrays.binarySearch(this.t, v) < 0;
                    }
                }
                throw new AssertionError();
            }).toArray();
        }

        public String toString() {
            return "(" + this.operator.name().toLowerCase() + ",{" + Utilities.join(this.t, ",") + "})";
        }
    }

    public static class ConditionIntvl
    extends ConditionSet {
        public long min;
        public long max;

        public ConditionIntvl(Types.TypeConditionOperatorSet operator, long min, long max) {
            super(operator);
            Utilities.control(min <= max, "The specified bouds are not valid.");
            this.min = min;
            this.max = max;
        }

        public ConditionIntvl(Types.TypeConditionOperatorSet operator, Range range) {
            this(operator, range.start, range.stop - 1);
            Utilities.control(range.step == 1, "Specified ranges must have a step equal to 1");
        }

        public Range range() {
            return new Range(Utilities.safeInt(this.min), Utilities.safeInt(this.max) + 1);
        }

        @Override
        public Object rightTerm() {
            return this.range();
        }

        @Override
        public int[] filtering(int[] values) {
            return IntStream.of(values).filter(v -> {
                switch (this.operator) {
                    case IN: {
                        return this.min <= (long)v && (long)v <= this.max;
                    }
                    case NOTIN: {
                        return (long)v < this.min || (long)v > this.max;
                    }
                }
                throw new AssertionError();
            }).toArray();
        }

        public String toString() {
            return "(" + this.operator.name().toLowerCase() + "," + this.min + ".." + this.max + ")";
        }
    }

    public static abstract class ConditionSet
    implements Condition {
        public Types.TypeConditionOperatorSet operator;

        public ConditionSet(Types.TypeConditionOperatorSet operator) {
            this.operator = operator;
        }

        @Override
        public Types.TypeExpr operatorTypeExpr() {
            return this.operator.toExpr();
        }
    }

    public static class ConditionVal
    extends ConditionRel {
        public long k;

        public ConditionVal(Types.TypeConditionOperatorRel operator, long k) {
            super(operator);
            this.k = k;
        }

        @Override
        public Object rightTerm() {
            return this.k;
        }

        @Override
        public int[] filtering(int[] values) {
            return IntStream.of(values).filter(v -> {
                switch (this.operator) {
                    case LT: {
                        return (long)v < this.k;
                    }
                    case LE: {
                        return (long)v <= this.k;
                    }
                    case GE: {
                        return (long)v >= this.k;
                    }
                    case GT: {
                        return (long)v > this.k;
                    }
                    case EQ: {
                        return (long)v == this.k;
                    }
                    case NE: {
                        return (long)v != this.k;
                    }
                }
                throw new AssertionError();
            }).toArray();
        }

        public String toString() {
            return "(" + this.operator.name().toLowerCase() + "," + this.k + ")";
        }
    }

    public static class ConditionVar
    extends ConditionRel {
        public IVar x;

        public ConditionVar(Types.TypeConditionOperatorRel operator, IVar x) {
            super(operator);
            this.x = x;
        }

        @Override
        public IVar involvedVar() {
            return this.x;
        }

        @Override
        public Object rightTerm() {
            return this.x;
        }

        public String toString() {
            return "(" + this.operator.name().toLowerCase() + "," + this.x + ")";
        }
    }

    public static abstract class ConditionRel
    implements Condition {
        public Types.TypeConditionOperatorRel operator;

        public ConditionRel(Types.TypeConditionOperatorRel operator) {
            this.operator = operator;
        }

        @Override
        public Types.TypeExpr operatorTypeExpr() {
            return this.operator.toExpr();
        }
    }

    public static final class ConditionPar2
    extends ConditionPar {
        public boolean addition;
        public Object par2;

        public ConditionPar2(Object operator, XConstraints.XParameter par1, boolean addition, Object par2) {
            super(operator, par1);
            this.addition = addition;
            this.par2 = par2;
        }

        public Condition concretizeWith(Object limit) {
            throw new AssertionError();
        }

        @Override
        public Object rightTerm() {
            return new Object[]{this.par1, this.addition, this.par2};
        }
    }

    public static final class ConditionPar1
    extends ConditionPar {
        public ConditionPar1(Object operator, XConstraints.XParameter par1) {
            super(operator, par1);
        }

        public Condition concretizeWith(Object limit) {
            return Condition.buildFrom(this.operator, limit);
        }

        @Override
        public Object rightTerm() {
            return this.par1;
        }
    }

    public static abstract class ConditionPar
    implements Condition {
        public Object operator;
        public XConstraints.XParameter par1;

        public ConditionPar(Object operator, XConstraints.XParameter par1) {
            this.operator = operator;
            this.par1 = par1;
        }

        @Override
        public Types.TypeExpr operatorTypeExpr() {
            return this.operator instanceof Types.TypeConditionOperatorRel ? ((Types.TypeConditionOperatorRel)((Object)this.operator)).toExpr() : ((Types.TypeConditionOperatorSet)((Object)this.operator)).toExpr();
        }
    }
}

