/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.enumerations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.xcsp.common.Utilities;

public abstract class EnumerationAbstract
implements Iterator<int[]> {
    protected Boolean nextTuple;
    public final int[] currTupleOfIdxs;
    private final int[] currTupleOfVals;
    protected final boolean indexesMatchValues;

    public EnumerationAbstract(int tupleLength, boolean indexesMatchValues) {
        this.currTupleOfIdxs = new int[tupleLength];
        this.currTupleOfVals = new int[tupleLength];
        this.indexesMatchValues = indexesMatchValues;
    }

    protected abstract void computeFirstTuple();

    public void reset() {
        this.nextTuple = Boolean.TRUE;
        this.computeFirstTuple();
    }

    protected abstract int valAt(int var1);

    private int[] vals() {
        if (this.indexesMatchValues) {
            return this.currTupleOfIdxs;
        }
        for (int i = 0; i < this.currTupleOfVals.length; ++i) {
            this.currTupleOfVals[i] = this.valAt(i);
        }
        return this.currTupleOfVals;
    }

    @Override
    public abstract boolean hasNext();

    @Override
    public int[] next() {
        if (this.nextTuple == null) {
            this.hasNext();
        }
        int[] t = this.nextTuple == Boolean.FALSE ? null : this.vals();
        this.nextTuple = this.nextTuple == Boolean.FALSE ? Boolean.FALSE : null;
        return t;
    }

    public void execute(Consumer<int[]> c) {
        this.reset();
        while (this.hasNext()) {
            int[] t = this.next();
            c.accept(t);
        }
    }

    public int[][] toArray(Predicate<int[]> p) {
        this.reset();
        ArrayList<int[]> list = new ArrayList<int[]>();
        while (this.hasNext()) {
            int[] x = this.next();
            if (!p.test(x)) continue;
            list.add((int[])x.clone());
        }
        return (int[][])list.stream().toArray((int x$0) -> new int[x$0][]);
    }

    public int[][] toArray() {
        this.reset();
        ArrayList<int[]> list = new ArrayList<int[]>();
        while (this.hasNext()) {
            list.add((int[])this.next().clone());
        }
        return (int[][])list.stream().sorted(Utilities.lexComparatorInt).toArray((int x$0) -> new int[x$0][]);
    }

    public void displayAllTuples() {
        this.reset();
        int cnt = 0;
        while (this.hasNext()) {
            System.out.println("(" + Utilities.join(this.next(), ",") + ") ");
            ++cnt;
        }
        System.out.println("\nThere are " + cnt + " tuples");
    }
}

