/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.predicates;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Range;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.enumerations.EnumerationCartesian;
import org.xcsp.common.predicates.MatcherInterface;
import org.xcsp.common.predicates.XNodeLeaf;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.common.predicates.XNodeParentSpecial;

public abstract class XNode<V extends IVar>
implements Comparable<XNode<V>> {
    public final Types.TypeExpr type;
    public final XNode<V>[] sons;

    public static <V extends IVar> XNodeParent<V> node(Types.TypeExpr type, XNode<V> left, XNode<V> right) {
        return new XNodeParent<V>(type, left, right);
    }

    public static <V extends IVar> XNodeParent<V> node(MatcherInterface.AbstractOperation type, XNode<V> left, XNode<V> right) {
        return new XNodeParentSpecial<V>(type.name(), left, right);
    }

    public static <V extends IVar> XNodeParent<V> node(Types.TypeExpr type, XNode<V> son) {
        return new XNodeParent<V>(type, son);
    }

    public static <V extends IVar> XNodeParent<V> node(MatcherInterface.AbstractOperation type, XNode<V> son) {
        return new XNodeParentSpecial<V>(type.name(), son);
    }

    public static <V extends IVar> XNodeParent<V> node(Types.TypeExpr type, XNode<V>[] sons) {
        return new XNodeParent<V>(type, sons);
    }

    public static <V extends IVar> XNodeParent<V> node(Types.TypeExpr type, List<XNode<V>> sons) {
        return new XNodeParent<V>(type, sons);
    }

    public static <V extends IVar> XNodeParent<V> node(Types.TypeExpr type, Stream<XNode<V>> sons) {
        return new XNodeParent(type, (XNode[])sons.toArray(XNode[]::new));
    }

    public static <V extends IVar> XNodeLeaf<V> longLeaf(long value) {
        return new XNodeLeaf(Types.TypeExpr.LONG, value);
    }

    public static <V extends IVar> XNodeLeaf<V> specialLeaf(String value) {
        return new XNodeLeaf(Types.TypeExpr.SPECIAL, value);
    }

    protected XNode(Types.TypeExpr type, XNode<V>[] sons) {
        this.type = type;
        this.sons = sons;
    }

    public final Types.TypeExpr getType() {
        return this.type;
    }

    public final int arity() {
        return this.sons == null ? 0 : this.sons.length;
    }

    public abstract int size();

    public abstract int maxParameterNumber();

    public abstract XNode<V> firstNodeSuchThat(Predicate<XNode<V>> var1);

    public abstract LinkedList<XNode<V>> allNodesSuchThat(Predicate<XNode<V>> var1, LinkedList<XNode<V>> var2);

    public LinkedList<XNode<V>> allNodesSuchThat(Predicate<XNode<V>> p) {
        return this.allNodesSuchThat(p, new LinkedList<XNode<V>>());
    }

    public final LinkedList<V> listOfVars() {
        return this.allNodesSuchThat(s -> s.type == Types.TypeExpr.VAR).stream().map(n -> (IVar)((XNodeLeaf)n).value).collect(Collectors.toCollection(LinkedList::new));
    }

    public final LinkedList<Long> listOfVals() {
        return this.allNodesSuchThat(s -> s.type == Types.TypeExpr.LONG).stream().map(n -> (Long)((XNodeLeaf)n).value).collect(Collectors.toCollection(LinkedList::new));
    }

    public final V var(int i) {
        if (i == 0) {
            XNodeLeaf f = (XNodeLeaf)this.firstNodeSuchThat(n -> n.type == Types.TypeExpr.VAR);
            return (V)(f == null ? null : (IVar)f.value);
        }
        LinkedList<V> list = this.listOfVars();
        return (V)(i >= list.size() ? null : (IVar)list.get(i));
    }

    public final Integer val(int i) {
        if (i == 0) {
            XNodeLeaf f = (XNodeLeaf)this.firstNodeSuchThat(n -> n.type == Types.TypeExpr.LONG);
            return f == null ? null : Integer.valueOf(Utilities.safeInt((Long)f.value));
        }
        LinkedList<Long> list = this.listOfVals();
        return i >= list.size() ? null : Integer.valueOf(Utilities.safeInt(list.get(i)));
    }

    public final Types.TypeConditionOperatorRel relop(int i) {
        if (i == 0) {
            XNode<V> f = this.firstNodeSuchThat(n -> n.type.isRelationalOperator());
            return f == null ? null : f.type.toRelop();
        }
        LinkedList list = this.allNodesSuchThat(s -> s.type.isRelationalOperator()).stream().map(n -> n.type.toRelop()).collect(Collectors.toCollection(LinkedList::new));
        return i >= list.size() ? null : (Types.TypeConditionOperatorRel)((Object)list.get(i));
    }

    public final Types.TypeUnaryArithmeticOperator unalop(int i) {
        if (i == 0) {
            XNode<V> f = this.firstNodeSuchThat(n -> n.type.isUnaryArithmeticOrLogicOperator());
            return f == null ? null : f.type.toUnalop();
        }
        LinkedList list = this.allNodesSuchThat(s -> s.type.isUnaryArithmeticOrLogicOperator()).stream().map(n -> n.type.toUnalop()).collect(Collectors.toCollection(LinkedList::new));
        return i >= list.size() ? null : (Types.TypeUnaryArithmeticOperator)((Object)list.get(i));
    }

    public final Types.TypeArithmeticOperator ariop(int i) {
        if (i == 0) {
            XNode<V> f = this.firstNodeSuchThat(n -> n.type.isArithmeticOperator());
            return f == null ? null : f.type.toAriop();
        }
        LinkedList list = this.allNodesSuchThat(s -> s.type.isArithmeticOperator()).stream().map(n -> n.type.toAriop()).collect(Collectors.toCollection(LinkedList::new));
        return i >= list.size() ? null : (Types.TypeArithmeticOperator)((Object)list.get(i));
    }

    public final Types.TypeLogicalOperator logop(int i) {
        if (i == 0) {
            XNode<V> f = this.firstNodeSuchThat(n -> n.type.isLogicalOperator());
            return f == null ? null : f.type.toLogop();
        }
        LinkedList list = this.allNodesSuchThat(s -> s.type.isLogicalOperator()).stream().map(n -> n.type.toLogop()).collect(Collectors.toCollection(LinkedList::new));
        return i >= list.size() ? null : (Types.TypeLogicalOperator)((Object)list.get(i));
    }

    public final V[] arrayOfVars() {
        LinkedList list = this.listOfVars();
        return list.size() == 0 ? null : (IVar[])list.stream().toArray(s -> (IVar[])Utilities.buildArray(((IVar)list.iterator().next()).getClass(), s));
    }

    public final int[] arrayOfVals() {
        LinkedList<Long> list = this.listOfVals();
        return list.size() == 0 ? new int[]{} : list.stream().mapToInt(l -> Utilities.safeInt(l)).toArray();
    }

    public final V[] vars() {
        LinkedHashSet set = new LinkedHashSet();
        this.listOfVars().stream().forEach(x -> set.add(x));
        return set.size() == 0 ? null : (IVar[])set.stream().toArray(s -> (IVar[])Utilities.buildArray(((IVar)set.iterator().next()).getClass(), s));
    }

    public final boolean exactlyVars(V[] t) {
        IVar[] vars = this.vars();
        return t.length == vars.length && IntStream.range(0, t.length).allMatch(i -> t[i] == vars[i]);
    }

    public final LinkedHashSet<V> collectVarsToSet(LinkedHashSet<V> set) {
        this.listOfVars().stream().forEach(x -> set.add(x));
        return set;
    }

    public abstract XNode<V> replaceSymbols(Map<String, Integer> var1);

    public abstract XNode<V> replaceLeafValues(Function<Object, Object> var1);

    public abstract XNode<V> replacePartiallyParameters(Object[] var1);

    public abstract XNode<V> canonization();

    public abstract XNode<V> abstraction(List<Object> var1, boolean var2, boolean var3);

    public abstract XNode<V> concretization(Object[] var1);

    public abstract String toPostfixExpression(IVar[] var1);

    public abstract String toFunctionalExpression(Object[] var1);

    private static Range negRange(Range r) {
        assert (r.step == 1);
        return new Range(-r.stop + 1, -r.start + 1);
    }

    private static Range absRange(Range r) {
        assert (r.step == 1);
        return new Range(r.contains(0) ? 0 : Math.min(Math.abs(r.start), Math.abs(r.stop - 1)), Math.max(Math.abs(r.start), Math.abs(r.stop - 1)) + 1);
    }

    private static Range addRange(Range r1, Range r2) {
        assert (r1.step == 1 && r2.step == 1);
        return new Range(r1.start + r2.start, r1.stop + r2.stop - 1);
    }

    private static Object possibleRange(int[] s) {
        Object object;
        int[] l = IntStream.of(s).sorted().distinct().toArray();
        int d = l[l.length - 1] - l[0] + 1;
        if (d == l.length) {
            Range range;
            object = range;
            range = new Range(l[0], l[l.length - 1] + 1);
        } else {
            object = l;
        }
        return object;
    }

    public Object possibleValues() {
        Object pv1;
        if (this.type.isPredicateOperator()) {
            return new Range(0, 2);
        }
        if (this.type.arityMin == 0 && this.type.arityMax == 0) {
            if (this.type == Types.TypeExpr.VAR) {
                IVar.Var x = (IVar.Var)(((XNodeLeaf)this).oldValue != null ? ((XNodeLeaf)this).oldValue : ((XNodeLeaf)this).value);
                Object av = x.allValues();
                if (av instanceof Range) {
                    return av;
                }
                int[] values = (int[])av;
                return values.length == 1 ? new Range(values[0], values[0] + 1) : (values.length == 2 && values[0] + 1 == values[1] ? new Range(values[0], values[1] + 1) : (Object)values);
            }
            if (this.type == Types.TypeExpr.LONG) {
                int value = Utilities.safeInt((long)((Long)((XNodeLeaf)this).value));
                return new Range(value, value + 1);
            }
            Utilities.control(false, "no such 0-ary type " + (Object)((Object)this.type) + " is expected");
        }
        if (this.type.arityMin == 1 && this.type.arityMax == 1) {
            Object pv2 = this.sons[0].possibleValues();
            if (this.type == Types.TypeExpr.NEG) {
                if (pv2 instanceof Range) {
                    return XNode.negRange((Range)pv2);
                }
                int[] t2 = (int[])pv2;
                return IntStream.range(0, t2.length).map(i -> -t2[t2.length - i - 1]).toArray();
            }
            if (this.type == Types.TypeExpr.ABS) {
                if (pv2 instanceof Range) {
                    return XNode.absRange((Range)pv2);
                }
                int[] t3 = (int[])pv2;
                return XNode.possibleRange(IntStream.of(t3).map(v -> Math.abs(v)).toArray());
            }
            if (this.type == Types.TypeExpr.SQR) {
                int[] t4 = pv2 instanceof Range ? ((Range)pv2).toArray() : (int[])pv2;
                return XNode.possibleRange(IntStream.of(t4).map(v -> v * v).toArray());
            }
            Utilities.control(false, "no such 1-ary type " + (Object)((Object)this.type) + " is expected");
        }
        if (this.type.arityMin == 2 && this.type.arityMax == 2) {
            pv1 = this.sons[0].possibleValues();
            Object pv2 = this.sons[1].possibleValues();
            if (pv1 instanceof Range && pv2 instanceof Range) {
                if (this.type == Types.TypeExpr.SUB) {
                    return XNode.addRange((Range)pv1, XNode.negRange((Range)pv2));
                }
                if (this.type == Types.TypeExpr.DIST) {
                    return XNode.absRange(XNode.addRange((Range)pv1, XNode.negRange((Range)pv2)));
                }
            }
            Utilities.control(this.type == Types.TypeExpr.SUB || this.type == Types.TypeExpr.DIV || this.type == Types.TypeExpr.MOD || this.type == Types.TypeExpr.POW || this.type == Types.TypeExpr.DIST, "no such 2-ary type " + (Object)((Object)this.type) + " is expected");
            HashSet<Integer> set = new HashSet<Integer>();
            int[] t1 = pv1 instanceof Range ? ((Range)pv1).toArray() : (int[])pv1;
            int[] t2 = pv2 instanceof Range ? ((Range)pv2).toArray() : (int[])pv2;
            for (int v1 : t1) {
                for (int v2 : t2) {
                    if (this.type == Types.TypeExpr.SUB) {
                        set.add(v1 - v2);
                    }
                    if (this.type == Types.TypeExpr.DIV) {
                        set.add(v1 / v2);
                    }
                    if (this.type == Types.TypeExpr.MOD) {
                        set.add(v1 % v2);
                    }
                    if (this.type == Types.TypeExpr.POW) {
                        set.add((int)Math.pow(v1, v2));
                    }
                    if (this.type != Types.TypeExpr.DIST) continue;
                    set.add(Math.abs(v1 - v2));
                }
            }
            return XNode.possibleRange(set.stream().mapToInt(i -> i).toArray());
        }
        if (this.type == Types.TypeExpr.IF) {
            pv1 = this.sons[1].possibleValues();
            Object pv2 = this.sons[2].possibleValues();
            if (pv1 instanceof Range && pv2 instanceof Range) {
                int s1 = ((Range)pv1).start;
                int e1 = ((Range)pv1).stop;
                int s2 = ((Range)pv2).start;
                int e2 = ((Range)pv2).stop;
                if (Math.max(s1, s2) <= Math.min(e1, e2)) {
                    return new Range(Math.min(s1, s2), Math.max(e1, e2));
                }
            }
            int[] t1 = pv1 instanceof Range ? ((Range)pv1).toArray() : (int[])pv1;
            int[] t2 = pv2 instanceof Range ? ((Range)pv2).toArray() : (int[])pv2;
            return XNode.possibleRange(IntStream.range(0, t1.length + t2.length).map(i -> i < t1.length ? t1[i] : t2[i - t1.length]).toArray());
        }
        if (this.type.arityMin == 2 && this.type.arityMax == Integer.MAX_VALUE) {
            if (this.type == Types.TypeExpr.MUL && this.sons.length == 2 && this.sons[0].type == Types.TypeExpr.VAR && this.sons[1].type == Types.TypeExpr.VAR && ((XNodeLeaf)this.sons[0]).value == ((XNodeLeaf)this.sons[1]).value) {
                return XNode.node(Types.TypeExpr.SQR, this.sons[0]).possibleValues();
            }
            Object[] pvs = Stream.of(this.sons).map(t -> t.possibleValues()).toArray();
            if (Stream.of(pvs).allMatch(pv -> pv instanceof Range)) {
                if (this.type == Types.TypeExpr.ADD) {
                    return Stream.of(pvs).reduce((r1, r2) -> ((Range)r1).add((Range)r2)).get();
                }
                if (this.type == Types.TypeExpr.MIN) {
                    return new Range(Stream.of(pvs).mapToInt(pv -> ((Range)pv).start).min().getAsInt(), Stream.of(pvs).mapToInt(pv -> ((Range)pv).stop).min().getAsInt());
                }
                if (this.type == Types.TypeExpr.MAX) {
                    return new Range(Stream.of(pvs).mapToInt(pv -> ((Range)pv).start).max().getAsInt(), Stream.of(pvs).mapToInt(pv -> ((Range)pv).stop).max().getAsInt());
                }
            }
            Utilities.control(this.type == Types.TypeExpr.ADD || this.type == Types.TypeExpr.MUL || this.type == Types.TypeExpr.MIN || this.type == Types.TypeExpr.MAX, "the type " + (Object)((Object)this.type) + " is currently not implemented");
            HashSet<Integer> set = new HashSet<Integer>();
            int[][] values = (int[][])Stream.of(pvs).map(pv -> pv instanceof Range ? ((Range)pv).toArray() : (int[])pv).toArray(x$0 -> new int[x$0][]);
            EnumerationCartesian ec = new EnumerationCartesian(values, false);
            while (ec.hasNext()) {
                int[] t5 = ec.next();
                if (this.type == Types.TypeExpr.ADD) {
                    set.add(IntStream.of(t5).sum());
                }
                if (this.type == Types.TypeExpr.MUL) {
                    set.add(IntStream.of(t5).reduce((a, b) -> a * b).getAsInt());
                }
                if (this.type == Types.TypeExpr.MIN) {
                    set.add(IntStream.of(t5).min().getAsInt());
                }
                if (this.type != Types.TypeExpr.MAX) continue;
                set.add(IntStream.of(t5).max().getAsInt());
            }
            return XNode.possibleRange(set.stream().mapToInt(i -> i).toArray());
        }
        if (this.type == Types.TypeExpr.SET) {
            int[][] values = (int[][])Stream.of(this.sons).map(t -> t.possibleValues()).map(pv -> pv instanceof Range ? ((Range)pv).toArray() : (int[])pv).toArray(x$0 -> new int[x$0][]);
            HashSet<Integer> set = new HashSet<Integer>();
            int[][] nArray = values;
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                int[] t6;
                for (int v2 : t6 = nArray[j]) {
                    set.add(v2);
                }
            }
            return XNode.possibleRange(set.stream().mapToInt(i -> i).toArray());
        }
        Utilities.control(false, "The operator " + (Object)((Object)this.type) + " currently not implemented");
        return null;
    }

    public String toString() {
        return this.toFunctionalExpression(null);
    }
}

