/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.structures;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Condition;
import org.xcsp.common.Utilities;

public interface AbstractTuple {
    public boolean match(int[] var1);

    public static class HybridTuple
    implements AbstractTuple {
        public Object[] values;

        public HybridTuple(Object[] values) {
            this.values = values;
            for (int i = 0; i < values.length; ++i) {
                if (!(values[i] instanceof Long)) continue;
                values[i] = ((Long)values[i]).intValue();
            }
            Utilities.control(Stream.of(values).allMatch(v -> v instanceof Integer || v instanceof Condition.ConditionVal || v instanceof Condition.ConditionSet || v instanceof Condition.ConditionVar || v instanceof Condition.ConditionPar), "Bad form for smart tuple " + Utilities.join(values));
        }

        @Override
        public boolean match(int[] t) {
            assert (t.length == this.values.length);
            for (int i = 0; i < t.length; ++i) {
                if (this.values[i] instanceof Integer) {
                    int v = (Integer)this.values[i];
                    if (v == 0x7FFFFFFE || t[i] == 0x7FFFFFFE || v == t[i]) continue;
                    return false;
                }
                Condition condition = (Condition)this.values[i];
                if (condition instanceof Condition.ConditionVal) {
                    if (((Condition.ConditionVal)condition).operator.isValidFor(t[i], ((Condition.ConditionVal)condition).k)) continue;
                    return false;
                }
                if (condition instanceof Condition.ConditionIntvl) {
                    if (((Condition.ConditionIntvl)condition).operator.isValidFor(t[i], ((Condition.ConditionIntvl)condition).min, ((Condition.ConditionIntvl)condition).max)) continue;
                    return false;
                }
                if (condition instanceof Condition.ConditionIntset) {
                    if (((Condition.ConditionIntset)condition).operator.isValidFor(t[i], ((Condition.ConditionIntset)condition).t)) continue;
                    return false;
                }
                throw new AssertionError((Object)"Not implemented");
            }
            return true;
        }

        public String toString() {
            return "(" + Stream.of(this.values).map(v -> v instanceof Integer && (Integer)v == 0x7FFFFFFE ? "*" : v.toString()).collect(Collectors.joining(",")) + ")";
        }
    }

    public static class OrdinaryTuple
    implements AbstractTuple {
        public int[] values;

        public OrdinaryTuple(int[] values) {
            this.values = values;
        }

        @Override
        public boolean match(int[] t) {
            assert (t.length == this.values.length);
            return IntStream.range(0, t.length).allMatch(i -> this.values[i] == 0x7FFFFFFE || t[i] == 0x7FFFFFFE || this.values[i] == t[i]);
        }

        public String toString() {
            return Utilities.join(this.values);
        }
    }
}

