/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.structures;

import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.xcsp.common.Utilities;
import org.xcsp.common.structures.Transition;
import org.xcsp.common.structures.Transitions;

public final class Automaton {
    public final String startState;
    public final Transition[] transitions;
    public final String[] finalStates;
    private Boolean deterministic;

    public Automaton(String startState, Transition[] transitions, String ... finalStates) {
        this.startState = startState;
        this.transitions = transitions;
        this.finalStates = finalStates;
    }

    public Automaton(String startState, Transitions transitions, String ... finalStates) {
        this(startState, transitions.toArray(), finalStates);
    }

    public Automaton(String expression) {
        Utilities.exit("Unimplemented code; converting regular expressions into an automaton");
        this.startState = null;
        this.transitions = null;
        this.finalStates = null;
    }

    public boolean _isDeterministic() {
        HashSet<String> encountered = new HashSet<String>();
        for (Transition tr : this.transitions) {
            if (tr.value instanceof int[]) {
                for (int v : (int[])tr.value) {
                    if (encountered.contains(tr.start + " " + v)) {
                        return false;
                    }
                    encountered.add(tr.start + " " + v);
                }
                continue;
            }
            if (encountered.contains(tr.start + " " + tr.value)) {
                return false;
            }
            encountered.add(tr.start + " " + tr.value);
        }
        return true;
    }

    public boolean isDeterministic() {
        if (this.deterministic == null) {
            this.deterministic = this._isDeterministic();
        }
        return this.deterministic;
    }

    public String toString() {
        return "startState=" + this.startState + " finalStates={" + Utilities.join(this.finalStates) + "} \ntransitions={" + Stream.of(this.transitions).map(t -> t.toString()).collect(Collectors.joining()) + "}";
    }
}

