/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.modeler;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xcsp.common.Condition;
import org.xcsp.common.IVar;
import org.xcsp.common.Softening;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.domains.Values;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.definitions.DefXCSP;
import org.xcsp.modeler.definitions.ICtr;
import org.xcsp.modeler.entities.CtrEntities;
import org.xcsp.modeler.entities.ModelingEntity;
import org.xcsp.modeler.entities.ObjEntities;
import org.xcsp.modeler.entities.VarEntities;
import org.xcsp.modeler.implementation.ProblemIMP;
import org.xcsp.modeler.implementation.ProblemIMP3;
import org.xcsp.modeler.problems.AllInterval;
import org.xcsp.modeler.problems.Bibd;

public class Compiler {
    public static final String FORMAT = Types.TypeAtt.format.name();
    public static final String XCSP3 = "XCSP3";
    public static final String TYPE = Types.TypeAtt.type.name();
    public static final String ID = Types.TypeAtt.id.name();
    public static final String CLASS = Types.TypeAtt.CLASS.name().toLowerCase();
    public static final String NOTE = Types.TypeAtt.note.name();
    public static final String AS = Types.TypeAtt.as.name();
    public static final String FOR = Types.TypeAtt.FOR.name().toLowerCase();
    public static final String CIRCULAR = Types.TypeAtt.circular.name();
    public static final String OFFSET = Types.TypeAtt.offset.name();
    public static final String COLLECT = Types.TypeAtt.collect.name();
    public static final String VIOLATION_COST = Types.TypeAtt.violationCost.name();
    public static final String VIOLATION_MEASURE = Types.TypeAtt.violationMeasure.name();
    public static final String SUPPORTS = Types.TypeChild.supports.name();
    public static final String CONFLICTS = Types.TypeChild.conflicts.name();
    public static final String VAR_ARGS = "%...";
    public static final int LIMIT_FOR_VAR_ARGS = 3;
    public static final String VARIANT = "-variant";
    public static final String DATA = "-data";
    public static final String DATA_FORMAT = "-dataFormat";
    public static final String DATA_EXPORT = "-dataexport";
    public static final String OUTPUT = "-output";
    public static final String EV = "-ev";
    public static final String MUST_CANONIZE = "-mc";
    public static final String IC = "-ic";
    protected final ProblemIMP imp;
    protected Document doc;
    protected Map<String, Element> tuplesReferents = new HashMap<String, Element>();
    protected int nBuiltTuplesReferents;
    protected int limitForUsingAs = 12;
    protected boolean discardIntegerType = true;
    protected boolean discardAsRelation = true;
    protected boolean printNotes = true;
    protected boolean doubleAbstraction = true;
    protected boolean saveImmediatelyStored = true;
    protected boolean ignoreAutomaticGroups = true;
    protected boolean monoformGroups = false;
    private boolean noGroupAtAllForExtension = false;
    private boolean noGroupAtAllForIntension = false;
    private boolean noGroupAtAllForGlobal = false;
    private boolean uncompactDomainFor = false;
    private boolean mustEraseIdsOfConstraints = false;
    private boolean mergeSuccessiveInstantiations = false;
    private List<Predicate> storedP = new ArrayList<Predicate>();
    private List<Relation> storedR = new ArrayList<Relation>();
    private List<Global> storedG = new ArrayList<Global>();
    private boolean removeSimilarArgs = true;
    public static boolean ev;

    public Compiler(ProblemAPI api) {
        this.imp = api.imp();
    }

    protected Document buildDocument() {
        try {
            this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        Element root = Utilities.element(this.doc, "instance", FORMAT, XCSP3, TYPE, this.imp.objEntities.active() ? Types.TypeFramework.COP.name() : this.imp.typeFramework().name());
        root.appendChild(this.variables());
        root.appendChild(this.constraints());
        if (this.imp.objEntities.active()) {
            root.appendChild(this.objectives());
        }
        if (this.imp.annotations.active()) {
            root.appendChild(this.annotations());
        }
        this.doc.appendChild(root);
        this.doc.normalize();
        return this.doc;
    }

    private void saveStored(Element parent, boolean immediatly, boolean br, boolean bp, boolean bg) {
        if (!immediatly) {
            return;
        }
        if (br && this.storedR.size() > 0) {
            parent.appendChild(this.buildingStoredRelations());
        }
        if (bp && this.storedP.size() > 0) {
            parent.appendChild(this.buildingStoredPredicates());
        }
        if (bg && this.storedG.size() > 0) {
            parent.appendChild(this.buildingStoredGlobals());
        }
    }

    private void saveStored(Element parent) {
        this.saveStored(parent, true, true, true, true);
    }

    private String seqOfParameters(int n, int start, boolean compact) {
        return compact && n > 3 ? VAR_ARGS : IntStream.range(0, n).mapToObj(i -> "%" + (start + i)).collect(Collectors.joining(" "));
    }

    private String seqOfParameters(int n, boolean compact) {
        return this.seqOfParameters(n, 0, compact);
    }

    private String seqOfParameters(int n) {
        return this.seqOfParameters(n, false);
    }

    private void sideAttributes(Element element, ModelingEntity entity) {
        Softening sf;
        if (entity == null) {
            return;
        }
        if (entity.id != null) {
            element.setAttribute(ID, entity.id);
        }
        if (entity.classes.size() > 0) {
            element.setAttribute(CLASS, entity.classes.stream().map(c -> c.ccname()).collect(Collectors.joining(" ")));
        }
        if (this.printNotes && entity.note != null && entity.note.length() > 0) {
            element.setAttribute(NOTE, entity.note);
        }
        if (entity instanceof CtrEntities.CtrAlone && (sf = ((CtrEntities.CtrAlone)entity).softening) != null) {
            Utilities.control(sf.cost == null, "Cannot be managed at this place");
            if (sf instanceof Softening.SofteningSimple) {
                element.setAttribute(VIOLATION_COST, ((Softening.SofteningSimple)sf).violationCost + "");
            } else if (sf instanceof Softening.SofteningGlobal) {
                element.setAttribute(VIOLATION_MEASURE, ((Softening.SofteningGlobal)sf).type.toString());
            } else {
                Utilities.control(false, "Unreachable");
            }
        }
    }

    private Element treatPossibleRecursiveSon(DefXCSP.Son son, int sonIndex, int absIndex1, int absIndex2) {
        if (son.name.equals("rec")) {
            Utilities.control(absIndex1 != sonIndex && absIndex2 != sonIndex && son.content instanceof CtrEntities.CtrAlone, "Pb");
            CtrEntities.CtrAlone ca = (CtrEntities.CtrAlone)son.content;
            Element sub = this.buildingDef(ca.ctr.defXCSP());
            this.sideAttributes(sub, ca);
            return sub;
        }
        return null;
    }

    private Element buildingDef(DefXCSP def, int absIndex1, String absValue1, int absIndex2, String absValue2) {
        Element elt = this.doc.createElement(def.name);
        def.attributes.stream().forEach(a -> elt.setAttribute((String)a.getKey(), a.getValue().toString()));
        if (def.sons.size() == 1 && def.sons.get((int)0).attributes.size() == 0 && def.possibleSimplification) {
            Element recursiveSon = this.treatPossibleRecursiveSon(def.sons.get(0), 0, absIndex1, absIndex2);
            if (recursiveSon != null) {
                elt.appendChild(recursiveSon);
            } else {
                elt.setTextContent(" " + (absIndex1 == 0 ? absValue1 : def.sons.get((int)0).content) + " ");
            }
        } else {
            for (int i = 0; i < def.sons.size(); ++i) {
                Element recursiveSon = this.treatPossibleRecursiveSon(def.sons.get(i), i, absIndex1, absIndex2);
                if (recursiveSon != null) {
                    elt.appendChild(recursiveSon);
                    continue;
                }
                Element sub = Utilities.element(this.doc, def.sons.get((int)i).name, i == absIndex1 ? absValue1 : (i == absIndex2 ? absValue2 : def.sons.get((int)i).content));
                def.sons.get((int)i).attributes.stream().forEach(a -> sub.setAttribute((String)a.getKey(), a.getValue().toString()));
                elt.appendChild(sub);
            }
        }
        return elt;
    }

    private Element buildingDef(DefXCSP def, int absIndex, String absValue) {
        return this.buildingDef(def, absIndex, absValue, -1, "");
    }

    private Element buildingDef(DefXCSP def) {
        return this.buildingDef(def, -1, "", -1, "");
    }

    private Element baseVarEntity(Element element, VarEntities.VarEntity va) {
        this.sideAttributes(element, va);
        if (va instanceof VarEntities.VarArray) {
            element.setAttribute(ICtr.SIZE, ((VarEntities.VarArray)VarEntities.VarArray.class.cast(va)).getStringSize());
        }
        if (!this.discardIntegerType || va.getType() != Types.TypeVar.integer) {
            element.setAttribute(TYPE, va.getType().name());
        }
        return element;
    }

    private Element var(VarEntities.VarAlone va, String s, boolean alias) {
        return this.baseVarEntity(alias ? Utilities.element(this.doc, "var", AS, s) : Utilities.element(this.doc, "var", s), va);
    }

    private Element array(VarEntities.VarArray va, String s, boolean alias) {
        return this.baseVarEntity(alias ? Utilities.element(this.doc, "array", AS, s) : Utilities.element(this.doc, "array", s), va);
    }

    private Element array(VarEntities.VarArray va, Map<IVar, String> varToDomText, Map<Object, List<IVar>> map) {
        Utilities.control(map.size() > 1, "The map only contains one entry");
        Element element = this.baseVarEntity(this.doc.createElement("array"), va);
        for (List<IVar> list : map.values()) {
            String s = this.uncompactDomainFor ? list.stream().map(x -> x.id()).collect(Collectors.joining(" ")) : this.imp.varEntities.compact(list.toArray(new IVar[list.size()]));
            element.appendChild(Utilities.element(this.doc, "domain", FOR, s, varToDomText.get(list.get(0))));
        }
        return element;
    }

    protected void putInMap(IVar x, Map<IVar, String> map) {
        map.put(x, ((ProblemIMP3.MVariable)x).dom.toString());
    }

    protected Element variables() {
        System.out.println("  Saving variables");
        Element element = this.doc.createElement("variables");
        HashMap<IVar, String> varToDom = new HashMap<IVar, String>();
        for (VarEntities.VarEntity ve : this.imp.varEntities.allEntities) {
            if (ve instanceof VarEntities.VarAlone) {
                this.putInMap(((VarEntities.VarAlone)ve).var, varToDom);
                continue;
            }
            for (IVar x2 : ((VarEntities.VarArray)ve).flatVars) {
                this.putInMap(x2, varToDom);
            }
        }
        HashMap<String, String> domToVarReferent = new HashMap<String, String>();
        for (VarEntities.VarEntity ve : this.imp.varEntities.allEntities) {
            VarEntities.VarEntity va;
            if (ve instanceof VarEntities.VarAlone) {
                va = (VarEntities.VarAlone)ve;
                if (this.imp.varEntities.varToVarArray.get(va.var) != null) continue;
                String dom = (String)varToDom.get(va.var);
                if (domToVarReferent.get(dom) == null) {
                    element.appendChild(this.var((VarEntities.VarAlone)va, dom, false));
                    domToVarReferent.put(dom, va.id);
                    continue;
                }
                if (dom.length() < this.limitForUsingAs) {
                    element.appendChild(this.var((VarEntities.VarAlone)va, dom, false));
                    continue;
                }
                element.appendChild(this.var((VarEntities.VarAlone)va, (String)domToVarReferent.get(dom), true));
                continue;
            }
            va = (VarEntities.VarArray)ve;
            Map map = Stream.of(((VarEntities.VarArray)va).flatVars).collect(Collectors.groupingBy(x -> varToDom.get(x), LinkedHashMap::new, Collectors.toList()));
            if (map.size() == 1) {
                String dom = (String)varToDom.get(((VarEntities.VarArray)va).flatVars[0]);
                if (domToVarReferent.get(dom) == null) {
                    element.appendChild(this.array((VarEntities.VarArray)va, dom, false));
                    domToVarReferent.put(dom, ((VarEntities.VarArray)va).id);
                    continue;
                }
                if (dom.length() < this.limitForUsingAs) {
                    element.appendChild(this.array((VarEntities.VarArray)va, dom, false));
                    continue;
                }
                element.appendChild(this.array((VarEntities.VarArray)va, (String)domToVarReferent.get(dom), true));
                continue;
            }
            element.appendChild(this.array((VarEntities.VarArray)va, varToDom, map));
        }
        return element;
    }

    private <T extends Similarable<T>> List<Element> buildChilds(T[] t, List<T> store, Supplier<Element> spl) {
        ArrayList<Element> childs = new ArrayList<Element>();
        if (t[0] instanceof Predicate && this.noGroupAtAllForIntension || t[0] instanceof Relation && this.noGroupAtAllForExtension || t[0] instanceof Global && this.noGroupAtAllForGlobal) {
            for (int i2 = 0; i2 < t.length; ++i2) {
                store.clear();
                store.add(t[i2]);
                childs.add(spl.get());
            }
        } else if (this.monoformGroups) {
            store.add(t[0]);
            boolean similar = ((Similarable)t[0]).isSimilarTo(t[1]);
            Utilities.control(similar, "Should be similar");
            assert (Stream.of(t).allMatch(p -> p.isSimilarTo(t[0])));
            IntStream.range(1, t.length).forEach(i -> store.add(t[i]));
            childs.add(spl.get());
        } else {
            boolean[] flags = new boolean[t.length];
            for (int i3 = 0; i3 < t.length; ++i3) {
                if (flags[i3] || t[i3] == null) continue;
                store.clear();
                store.add(t[i3]);
                for (int j = i3 + 1; j < t.length; ++j) {
                    if (flags[j] || !((Similarable)t[i3]).isSimilarTo(t[j])) continue;
                    store.add(t[j]);
                    flags[j] = true;
                }
                childs.add(spl.get());
            }
        }
        return childs;
    }

    private Element buildingTuples(ICtr.ICtrExtension c) {
        Object tuples = c.mapXCSP().get("tuples");
        String key = tuples instanceof int[][] ? ICtr.ICtrExtension.tableAsString((int[][])tuples) : ICtr.ICtrExtension.tableAsString((String[][])tuples);
        Element eltTgt = this.tuplesReferents.get(key);
        Element eltSrc = null;
        if (eltTgt != null && !this.discardAsRelation) {
            if (eltTgt.getAttribute(ID).length() == 0) {
                eltTgt.setAttribute(ID, "i" + this.nBuiltTuplesReferents);
                ++this.nBuiltTuplesReferents;
            }
            eltSrc = Utilities.element(this.doc, (Boolean)c.mapXCSP().get("positive") != false ? SUPPORTS : CONFLICTS, AS, eltTgt.getAttribute(ID));
        } else {
            eltSrc = Utilities.element(this.doc, (Boolean)c.mapXCSP().get("positive") != false ? SUPPORTS : CONFLICTS, key);
            this.tuplesReferents.put(key, eltSrc);
        }
        return eltSrc;
    }

    private Element buildingStoredRelations() {
        Relation r = this.storedR.get(0);
        Element lst = Utilities.element(this.doc, ICtr.LIST, this.storedR.size() == 1 ? r.c.mapXCSP().get(ICtr.LIST) : this.seqOfParameters((Integer)r.c.mapXCSP().get("arity"), true));
        Element ext = Utilities.element(this.doc, ICtr.EXTENSION, lst, this.buildingTuples(r.c));
        Element elt = this.storedR.size() == 1 ? ext : Utilities.element(this.doc, "group", ext, this.storedR.stream().map(rr -> Utilities.element(this.doc, "args", ((Relation)rr).c.mapXCSP().get(ICtr.LIST))));
        this.sideAttributes(elt, this.imp.ctrEntities.ctrToCtrAlone.get(r.c));
        this.storedR.clear();
        return elt;
    }

    private List<Element> handleListOfExtension(Element parent, List<ICtr> ctrs) {
        this.saveStored(parent, true, true, false, false);
        return this.buildChilds((Relation[])ctrs.stream().map(c -> new Relation((ICtr.ICtrExtension)c)).toArray(Relation[]::new), this.storedR, () -> this.buildingStoredRelations());
    }

    private Element buildingStoredPredicates() {
        Object[] similar;
        Predicate firstPredicate = this.storedP.get(0);
        Utilities.control(this.storedP.stream().allMatch(p -> ((Predicate)p).args.size() == firstPredicate.args.size()), "Not the same size");
        if (this.removeSimilarArgs && this.storedP.size() > 1 && Stream.of(similar = IntStream.range(0, firstPredicate.args.size()).mapToObj(i -> this.storedP.stream().allMatch(p -> ((Predicate)p).args.get(i).equals(firstPredicate.args.get(i))) ? firstPredicate.args.get(i) : null).toArray()).anyMatch(obj -> obj != null)) {
            for (int i2 = similar.length - 1; i2 >= 0; --i2) {
                if (similar[i2] == null) continue;
                for (Predicate p2 : this.storedP) {
                    p2.args.remove(i2);
                }
            }
            firstPredicate.abstractTree = (XNodeParent)firstPredicate.abstractTree.replacePartiallyParameters(similar);
        }
        Element itn = Utilities.element(this.doc, ICtr.INTENSION, this.storedP.size() == 1 ? firstPredicate.c.mapXCSP().get(ICtr.FUNCTION) : firstPredicate.abstractTree);
        Element elt = null;
        if (this.storedP.size() == 1) {
            elt = itn;
        } else {
            elt = Utilities.element(this.doc, "group", itn);
            for (Predicate p2 : this.storedP) {
                String s = p2.args.stream().allMatch(x -> x instanceof IVar) ? this.imp.varEntities.compactOrdered((IVar[])p2.args.stream().map(x -> (IVar)x).toArray(IVar[]::new)) : Utilities.join(p2.args);
                elt.appendChild(Utilities.element(this.doc, "args", s));
            }
        }
        this.sideAttributes(elt, this.imp.ctrEntities.ctrToCtrAlone.get(firstPredicate.c));
        this.storedP.clear();
        return elt;
    }

    private List<Element> handleListOfIntension(Element parent, List<ICtr> ctrs) {
        this.saveStored(parent, true, false, true, false);
        return this.buildChilds((Predicate[])ctrs.stream().map(c -> new Predicate((ICtr.ICtrIntension)c)).toArray(Predicate[]::new), this.storedP, () -> this.buildingStoredPredicates());
    }

    private Element buildingStoredGlobals() {
        Element elt = null;
        Global g = this.storedG.get(0);
        if (this.storedG.size() == 1) {
            elt = this.buildingDef(g.def);
        } else if (this.mergeSuccessiveInstantiations && this.storedG.stream().allMatch(e -> ((Global)e).c instanceof ICtr.ICtrInstantiation)) {
            IVar[] scope = (IVar[])this.storedG.stream().map(e -> Stream.of(((Global)e).c.scope())).flatMap(j -> j).toArray(IVar[]::new);
            String list = this.storedG.stream().map(e -> (String)((Global)e).c.mapXCSP().get(ICtr.LIST)).collect(Collectors.joining(" "));
            String values = this.storedG.stream().map(e -> (String)((Global)e).c.mapXCSP().get(ICtr.VALUES)).collect(Collectors.joining(" "));
            elt = this.buildingDef(new Global(ICtr.ICtrInstantiation.buildFrom(scope, list, values)).def);
        } else {
            Utilities.control(g.recordedDiffs.length == 1 || g.recordedDiffs.length == 2, "");
            int i = g.recordedDiffs[0];
            if (g.recordedDiffs.length == 1) {
                String name = ((Global)g).def.sons.get((int)i).name;
                Element gbl = this.buildingDef(g.def, i, name.equals(ICtr.INDEX) || name.equals(ICtr.VALUE) || name.equals(ICtr.CONDITION) ? "%0" : (g.recordedSizes[0] == -1 ? VAR_ARGS : this.seqOfParameters(g.recordedSizes[0], true)));
                elt = Utilities.element(this.doc, "group", gbl, this.storedG.stream().map(gg -> Utilities.element(this.doc, "args", ((Global)gg).def.sons.get((int)i).content)));
            } else {
                int j2 = g.recordedDiffs[1];
                Element gbl = this.buildingDef(g.def, i, this.seqOfParameters(g.recordedSizes[0]), j2, this.seqOfParameters(g.recordedSizes[1], g.recordedSizes[0], true));
                elt = Utilities.element(this.doc, "group", gbl, this.storedG.stream().map(gg -> Utilities.element(this.doc, "args", ((Global)gg).def.sons.get((int)i).content + " " + ((Global)gg).def.sons.get((int)j).content)));
            }
        }
        this.sideAttributes(elt, this.imp.ctrEntities.ctrToCtrAlone.get(g.c));
        this.storedG.clear();
        return elt;
    }

    private List<Element> handleListOfGlobal(Element parent, List<ICtr> ctrs) {
        this.saveStored(parent, true, false, false, true);
        return this.buildChilds((Global[])ctrs.stream().map(c -> new Global((ICtr)c)).toArray(Global[]::new), this.storedG, () -> this.buildingStoredGlobals());
    }

    private Element buildSlide(ICtr.ICtrSlide ctr) {
        Element elt = this.doc.createElement(ICtr.SLIDE);
        Map<String, Object> map = ctr.mapXCSP();
        if (map.containsKey(CIRCULAR) && ((Boolean)map.get(CIRCULAR)).booleanValue()) {
            elt.setAttribute(CIRCULAR, "true");
        }
        IVar[][] lists = (IVar[][])map.get("lists");
        int[] offsets = (int[])map.get("offsets");
        int[] collects = (int[])map.get("collects");
        for (int i = 0; i < lists.length; ++i) {
            Element subelement = Utilities.element(this.doc, ICtr.LIST, this.imp.varEntities.compactOrdered(lists[i]));
            if (lists.length > 1 && collects[i] != 1) {
                subelement.setAttribute(COLLECT, collects[i] + "");
            }
            if (offsets[i] != 1) {
                subelement.setAttribute(OFFSET, offsets[i] + "");
            }
            elt.appendChild(subelement);
        }
        CtrEntities.CtrAlone[] cas = (CtrEntities.CtrAlone[])map.get("alones");
        ICtr c0 = cas[0].ctr;
        Utilities.control(Stream.of(cas).noneMatch(ca -> ca.ctr instanceof ICtr.ICtrSlide), "Slide cannot appear in slide");
        if (c0 instanceof ICtr.ICtrIntension) {
            elt.appendChild(Utilities.element(this.doc, ICtr.INTENSION, new Predicate((ICtr.ICtrIntension)c0, false, true).abstractTree));
        } else if (c0 instanceof ICtr.ICtrExtension && !(c0 instanceof ICtr.ICtrMdd) && !(c0 instanceof ICtr.ICtrSmart)) {
            elt.appendChild(Utilities.element(this.doc, ICtr.EXTENSION, Utilities.element(this.doc, ICtr.LIST, this.seqOfParameters(c0.scope().length)), this.buildingTuples((ICtr.ICtrExtension)c0)));
        } else {
            Global g0 = new Global(cas[0].ctr);
            Global g1 = new Global(cas[1].ctr);
            int[] diffs = g0.def.differencesWith(g1.def);
            Utilities.control(diffs.length == 1, "Bad form of slide");
            int nb = this.imp.varEntities.nVarsIn(((Global)g0).def.sons.get((int)diffs[0]).content.toString());
            elt.appendChild(this.buildingDef(g0.def, diffs[0], this.seqOfParameters(nb, true)));
        }
        this.sideAttributes(elt, this.imp.ctrEntities.ctrToCtrAlone.get(ctr));
        return elt;
    }

    private Element buildMeta(ICtr ctr) {
        Element elt = this.buildingDef(ctr.defXCSP());
        this.sideAttributes(elt, this.imp.ctrEntities.ctrToCtrAlone.get(ctr));
        return elt;
    }

    protected void handleCtr(Element parent, ICtr c) {
        if (c instanceof ICtr.ICtrSlide) {
            this.saveStored(parent, this.saveImmediatelyStored, true, true, true);
            parent.appendChild(this.buildSlide((ICtr.ICtrSlide)c));
        } else if (c instanceof ICtr.Meta) {
            this.saveStored(parent, this.saveImmediatelyStored, true, true, true);
            parent.appendChild(this.buildMeta(c));
        } else if (c instanceof ICtr.ICtrIntension) {
            this.saveStored(parent, this.saveImmediatelyStored, true, false, true);
            Predicate p = new Predicate((ICtr.ICtrIntension)c);
            this.saveStored(parent, this.storedP.size() > 0 && (!this.storedP.get(0).isSimilarTo(p) || this.ignoreAutomaticGroups), false, true, false);
            this.storedP.add(p);
        } else if (c instanceof ICtr.ICtrExtension && !(c instanceof ICtr.ICtrMdd) && !(c instanceof ICtr.ICtrSmart)) {
            this.saveStored(parent, this.saveImmediatelyStored, false, true, true);
            Relation r = new Relation((ICtr.ICtrExtension)c);
            this.saveStored(parent, this.storedR.size() > 0 && (!this.storedR.get(0).isSimilarTo(r) || this.ignoreAutomaticGroups), true, false, false);
            this.storedR.add(r);
        } else {
            this.saveStored(parent, this.saveImmediatelyStored, true, true, false);
            Global g = new Global(c);
            this.saveStored(parent, this.storedG.size() > 0 && (!this.storedG.get(0).isSimilarTo(g) || this.ignoreAutomaticGroups), false, false, true);
            this.storedG.add(g);
        }
    }

    protected List<Element> buildChilds(Element parent, List<ICtr> ctrs) {
        ICtr c0 = ctrs.get(0);
        if (c0 instanceof ICtr.ICtrSlide) {
            return ctrs.stream().map(c -> this.buildSlide((ICtr.ICtrSlide)c)).collect(Collectors.toList());
        }
        if (c0 instanceof ICtr.Meta) {
            return ctrs.stream().map(c -> this.buildMeta((ICtr)c)).collect(Collectors.toList());
        }
        if (c0 instanceof ICtr.ICtrIntension) {
            return this.handleListOfIntension(parent, ctrs);
        }
        if (c0 instanceof ICtr.ICtrExtension && !(c0 instanceof ICtr.ICtrMdd) && !(c0 instanceof ICtr.ICtrSmart)) {
            return this.handleListOfExtension(parent, ctrs);
        }
        return this.handleListOfGlobal(parent, ctrs);
    }

    protected Element constraints() {
        System.out.println("  Saving constraints");
        Element root = this.doc.createElement("constraints");
        Utilities.control(this.storedP.size() == 0 && this.storedR.size() == 0 && this.storedG.size() == 0, "Storing structures are not empty");
        Stack<Element> stackOfBlocks = new Stack<Element>();
        stackOfBlocks.push(root);
        for (CtrEntities.CtrEntity ce : this.imp.ctrEntities.allEntities) {
            if (ce instanceof ModelingEntity.TagDummy) continue;
            Element currParent = (Element)stackOfBlocks.peek();
            if (ce instanceof CtrEntities.CtrArray) {
                CtrEntities.CtrArray ctrArray = (CtrEntities.CtrArray)ce;
                Map map = Stream.of(ctrArray.ctrs).collect(Collectors.groupingBy(c -> c.getClass().getName(), LinkedHashMap::new, Collectors.toList()));
                if (map.size() == 1) {
                    this.saveStored(currParent, this.saveImmediatelyStored, true, true, true);
                    List<Element> childs = this.buildChilds(currParent, (List)map.values().iterator().next());
                    if (ctrArray.nullBasicAttributes()) {
                        childs.stream().forEach(c -> currParent.appendChild((Node)c));
                        continue;
                    }
                    if (childs.size() == 1 && ((Element)childs.get(0)).getAttributes().getLength() == 0) {
                        this.sideAttributes((Element)childs.get(0), ctrArray);
                        currParent.appendChild((Node)childs.get(0));
                        continue;
                    }
                    Element block = this.doc.createElement("block");
                    this.sideAttributes(block, ctrArray);
                    childs.stream().forEach(c -> block.appendChild((Node)c));
                    currParent.appendChild(block);
                    continue;
                }
                this.saveStored(currParent);
                if (ctrArray.nullBasicAttributes()) {
                    for (List list : map.values()) {
                        this.buildChilds(currParent, list).stream().forEach(c -> currParent.appendChild((Node)c));
                    }
                    continue;
                }
                Element block = this.doc.createElement("block");
                this.sideAttributes(block, ctrArray);
                for (List list : map.values()) {
                    this.buildChilds(block, list).stream().forEach(c -> block.appendChild((Node)c));
                }
                currParent.appendChild(block);
                continue;
            }
            ICtr c2 = ((CtrEntities.CtrAlone)ce).ctr;
            if (this.mustEraseIdsOfConstraints) {
                this.imp.ctrEntities.ctrToCtrAlone.get((Object)c2).id = null;
            }
            if (this.imp.ctrEntities.ctrToCtrArray.get(c2) != null) continue;
            this.handleCtr(currParent, c2);
        }
        assert (stackOfBlocks.size() == 1 && stackOfBlocks.peek() == root);
        this.saveStored(root);
        return root;
    }

    protected Element objectives() {
        Element root = this.doc.createElement("objectives");
        for (ObjEntities.ObjEntity obj : this.imp.objEntities.allEntities) {
            Element elt = this.buildingDef(obj.obj.defXCSP());
            this.sideAttributes(elt, obj);
            root.appendChild(elt);
        }
        return root;
    }

    protected Element annotations() {
        Element root = this.doc.createElement("annotations");
        if (this.imp.annotations.decision != null) {
            root.appendChild(Utilities.element(this.doc, "decision", this.imp.varEntities.compactOrdered(this.imp.annotations.decision)));
        }
        return root;
    }

    private static ProblemAPI usage() {
        System.out.println("\nDescription.\n  Compiler is a class that can generate XCSP3 files. You need to provide");
        System.out.println("  an MCSP3 model (Java class implementing ProblemAPI) and some effective data.");
        System.out.println("\nUsage.\n  java " + Compiler.class.getName() + " <className> [<arguments>]\n");
        System.out.println("  <className> is the name of a Java class implementing " + ProblemAPI.class.getName());
        System.out.println("  <arguments> is a possibly empty whitespace-separated list of elements among:");
        System.out.println("    -data=... ");
        System.out.println("       where ... stands for the effective data. This can be the name of a JSON");
        System.out.println("       file, a stand-alone value v or a list of values [v1,v2,...,vp]");
        System.out.println("    -dataFormat=... ");
        System.out.println("       where ... stands for the formatting instructions of data (see examples)");
        System.out.println("    -dataexport");
        System.out.println("       which allows us to save the data in a JSON file");
        System.out.println("    -model=...");
        System.out.println("       where ... stands for the name of a model variant, which allows us to write");
        System.out.println("       code like 'if (isModel(\"basic\")) { ... }'");
        System.out.println("    -ev");
        System.out.println("       which displays the exception that has been thown, in case of a crash");
        System.out.println("    -ic");
        System.out.println("       which indents and compresses, using Linux commands 'xmlindent -i 2' and 'lzma'");
        System.out.println("    -output=...");
        System.out.println("       which ... stands for the name of the output XCSP3 file (without exetnsions)");
        System.out.println("\nExamples.");
        System.out.println("  java " + Compiler.class.getName() + " " + AllInterval.class.getName() + " -data=5");
        System.out.println("    => generates the XCSP3 file AllInterval-5.xml");
        System.out.println("  java " + Compiler.class.getName() + " " + AllInterval.class.getName() + " -data=5 -dataFormat=%03d");
        System.out.println("    => generates the XCSP3 file AllInterval-005.xml");
        System.out.println("  java " + Compiler.class.getName() + " " + Bibd.class.getName() + " -data=[6,50,25,3,10]");
        System.out.println("    => generates the XCSP3 file Bibd-6-50-25-3-10.xml");
        System.out.println("  java " + Compiler.class.getName() + " " + Bibd.class.getName() + " -data=[6,50,25,3,10] -dataFormat=[%02d,%02d,%02d,%02d,%02d]");
        System.out.println("    => generates the XCSP3 file Bibd-06-50-25-03-10.xml");
        System.out.println("  java " + Compiler.class.getName() + " " + Bibd.class.getName() + " -data=[6,50,25,3,10] -dataFormat=[%02d,%02d,%02d,%02d,%02d] -dataSaving");
        System.out.println("    => generates the JSON file Bibd-06-50-25-03-10.json");
        System.out.println("    => generates the XCSP3 file Bibd-06-50-25-03-10.xml");
        System.out.println("  java " + Compiler.class.getName() + " " + Bibd.class.getName() + " -data=Bibd-06-50-25-03-10.json");
        System.out.println("    => generates the XCSP3 file Bibd-06-50-25-03-10.xml");
        System.out.println("  java " + Compiler.class.getName() + " " + Bibd.class.getName() + " -data=Bibd-06-50-25-03-10.json -ic");
        System.out.println("    => generates the indented compressed XCSP3 file Bibd-06-50-25-03-10.xml.lzma");
        System.out.println("  java " + Compiler.class.getName() + " " + AllInterval.class.getName() + " -data=5 -model=test");
        System.out.println("    => generates the XCSP3 file AllInterval-test-5.xml");
        System.out.println("       while executing any piece of code controlled by 'isModel(\"test\"))'");
        System.out.println("  java " + Compiler.class.getName() + " " + AllInterval.class.getName() + " -data=5 -output=tmp");
        System.out.println("    => generates the XCSP3 file tmp.xml");
        return null;
    }

    private static ProblemAPI buildInstanceAPI(String[] args) {
        if (args.length == 0) {
            return Compiler.usage();
        }
        try {
            Constructor<?>[] cs = Class.forName(args[0]).getDeclaredConstructors();
            if (cs.length > 1 || cs[0].getParameterTypes().length > 0) {
                System.out.println("\nProblem: It is forbidden to include constructors in a class implementing " + ProblemAPI.class.getName() + "\n");
                return null;
            }
            if (!ProblemAPI.class.isAssignableFrom(cs[0].getDeclaringClass())) {
                System.out.println("\nProblem: the specified class " + args[0] + " does not implement " + ProblemAPI.class.getName() + "\n");
                return Compiler.usage();
            }
            cs[0].setAccessible(true);
            ProblemAPI api = (ProblemAPI)cs[0].newInstance(new Object[0]);
            String[] argsForPb = (String[])Stream.of(args).skip(1L).filter(s -> !s.startsWith(VARIANT) && !s.startsWith(DATA) && !s.startsWith(OUTPUT) && !s.equals(EV) && !s.equals(IC)).toArray(String[]::new);
            ev = Stream.of(args).anyMatch(s -> s.equals(EV));
            String model = Stream.of(args).filter(s -> s.startsWith(VARIANT)).map(s -> s.substring(VARIANT.length() + 1)).findFirst().orElse("");
            String data = Stream.of(args).filter(s -> s.startsWith("-data=")).map(s -> s.substring(DATA.length() + 1)).findFirst().orElse("");
            String dataFormat = Stream.of(args).filter(s -> s.startsWith(DATA_FORMAT)).map(s -> s.substring(DATA_FORMAT.length() + 1)).findFirst().orElse("");
            boolean dataSaving = Stream.of(args).anyMatch(s -> s.equals(DATA_EXPORT));
            new ProblemIMP3(api, model, data, dataFormat, dataSaving, argsForPb);
            return api;
        }
        catch (Exception e) {
            System.out.println("It was not possible to build an instance of the specified class " + args[0]);
            if (ev) {
                e.printStackTrace();
            }
            return Compiler.usage();
        }
    }

    public static Document buildDocument(String[] args) {
        ProblemAPI api = Compiler.buildInstanceAPI(args);
        return api == null ? null : new Compiler(api).buildDocument();
    }

    public static void main(String[] args) {
        ProblemAPI api = Compiler.buildInstanceAPI(args);
        if (api == null) {
            return;
        }
        Document document = new Compiler(api).buildDocument();
        String output = Stream.of(args).filter(s -> s.startsWith(OUTPUT)).map(s -> s.substring(OUTPUT.length() + 1)).findFirst().orElse(null);
        String fileName = (output != null ? output : api.name()) + ".xml";
        ((ProblemIMP)ProblemAPI.api2imp.get(api)).save(document, fileName);
        if (Stream.of(args).anyMatch(s -> s.equals(IC))) {
            ((ProblemIMP)ProblemAPI.api2imp.get(api)).indentAndCompressXmlUnderLinux(fileName);
        }
    }

    private class Global
    extends Similarable<Global> {
        private ICtr c;
        private DefXCSP def;
        private int[] recordedDiffs;
        private int[] recordedSizes;

        private Global(ICtr c) {
            this.c = c;
            this.def = c.defXCSP();
        }

        @Override
        protected boolean isSimilarTo(Global g) {
            int[] diffs;
            Function<Object, Integer> sizeOf = v -> v instanceof Number || v instanceof Values.IntegerInterval || v instanceof Condition ? 1 : Stream.of(v.toString().trim().split("\\s+")).mapToInt(tok -> Utilities.isNumeric(tok) || Utilities.isNumericInterval(tok) ? 1 : Compiler.this.imp.varEntities.nVarsIn((String)tok)).sum();
            if (!this.haveSimilarAttributes(this.c, g.c)) {
                return false;
            }
            int[] nArray = diffs = this.def == null || g.def == null ? null : this.def.differencesWith(g.def);
            if (diffs == null) {
                return false;
            }
            if (diffs.length == 0) {
                System.out.println("WARNING : Two similar constraints");
                return false;
            }
            if (diffs.length == 1) {
                if (this.def.sons.get((int)diffs[0]).name.equals(ICtr.CONDITION)) {
                    return false;
                }
                if (Compiler.this.storedG.size() == 1) {
                    this.recordedDiffs = diffs;
                    int s1 = sizeOf.apply(this.def.sons.get((int)diffs[0]).content);
                    int s2 = sizeOf.apply(g.def.sons.get((int)diffs[0]).content);
                    this.recordedSizes = new int[]{s1 == s2 ? s1 : -1};
                    return true;
                }
                if (this.recordedSizes[0] != -1 && this.recordedSizes[0] != sizeOf.apply(g.def.sons.get((int)diffs[0]).content)) {
                    this.recordedSizes[0] = -1;
                }
                return this.recordedDiffs.length == 1 && this.recordedDiffs[0] == diffs[0];
            }
            if (Compiler.this.doubleAbstraction && diffs.length == 2 && this.def.sons.size() > 2 && !(this.c instanceof ICtr.ICtrRegular) && !(this.c instanceof ICtr.ICtrMdd)) {
                if (IntStream.of(diffs).anyMatch(i -> this.def.sons.get((int)i).name.equals(ICtr.CONDITION))) {
                    return false;
                }
                if (Compiler.this.storedG.size() == 1) {
                    int[] s1 = IntStream.of(diffs).map(i -> (Integer)sizeOf.apply(this.def.sons.get((int)i).content)).toArray();
                    int[] s2 = IntStream.of(diffs).map(i -> (Integer)sizeOf.apply(g.def.sons.get((int)i).content)).toArray();
                    if (IntStream.range(0, diffs.length).allMatch(i -> s1[i] == s2[i])) {
                        this.recordedDiffs = diffs;
                        this.recordedSizes = s1;
                        return true;
                    }
                    return false;
                }
                if (this.recordedDiffs.length != 2 || this.recordedDiffs[0] != diffs[0] || this.recordedDiffs[1] != diffs[1]) {
                    return false;
                }
                int[] s2 = IntStream.of(diffs).map(i -> (Integer)sizeOf.apply(g.def.sons.get((int)i).content)).toArray();
                return IntStream.range(0, diffs.length).allMatch(i -> this.recordedSizes[i] == s2[i]);
            }
            return false;
        }

        public String toString() {
            return this.def.toString();
        }
    }

    private class Relation
    extends Similarable<Relation> {
        private ICtr.ICtrExtension c;

        private Relation(ICtr.ICtrExtension c) {
            this.c = c;
        }

        @Override
        protected boolean isSimilarTo(Relation r) {
            return this.haveSimilarAttributes(this.c, r.c) && this.c.isSimilarTo(r.c);
        }
    }

    private class Predicate
    extends Similarable<Predicate> {
        private ICtr.ICtrIntension c;
        private XNodeParent<?> abstractTree;
        private List<Object> args;

        public Predicate(ICtr.ICtrIntension c, boolean abstractIntegers, boolean multiOccurrences) {
            this.args = new ArrayList<Object>();
            this.c = c;
            this.abstractTree = (XNodeParent)((XNodeParent)c.mapXCSP().get(ICtr.FUNCTION)).abstraction(this.args, abstractIntegers, multiOccurrences);
        }

        private Predicate(ICtr.ICtrIntension c) {
            this(c, true, true);
        }

        @Override
        protected boolean isSimilarTo(Predicate p) {
            return this.haveSimilarAttributes(this.c, p.c) && this.abstractTree.equals(p.abstractTree);
        }
    }

    private abstract class Similarable<T> {
        private Similarable() {
        }

        protected abstract boolean isSimilarTo(T var1);

        protected boolean haveSimilarAttributes(ICtr c1, ICtr c2) {
            CtrEntities.CtrAlone ca1 = Compiler.this.imp.ctrEntities.ctrToCtrAlone.get(c1);
            CtrEntities.CtrAlone ca2 = Compiler.this.imp.ctrEntities.ctrToCtrAlone.get(c2);
            if (ca1.id != null || ca2.id != null) {
                return false;
            }
            if (!Types.TypeClass.equivalent(ca1.classes, ca2.classes)) {
                return false;
            }
            if (ca1.note == null != (ca2.note == null) || ca1.note != null && !ca1.note.equals(ca2.note)) {
                return false;
            }
            if (ca1.softening == null != (ca2.softening == null)) {
                return false;
            }
            if (ca1.softening != null) {
                if (ca1.softening.getClass() != ca2.softening.getClass()) {
                    return false;
                }
                if (ca1.softening.cost != null || ca2.softening.cost != null) {
                    return false;
                }
                if (ca1.softening instanceof Softening.SofteningSimple) {
                    if (((Softening.SofteningSimple)ca1.softening).violationCost != ((Softening.SofteningSimple)ca2.softening).violationCost) {
                        return false;
                    }
                } else if (ca1.softening instanceof Softening.SofteningGlobal) {
                    if (((Softening.SofteningGlobal)ca1.softening).type != ((Softening.SofteningGlobal)ca2.softening).type) {
                        return false;
                    }
                    if (((Softening.SofteningGlobal)ca1.softening).parameters != null || ((Softening.SofteningGlobal)ca2.softening).parameters != null) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            return true;
        }
    }
}

